/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;

public class CeilFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$ceil");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$ceil");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$ceil");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        JsonNode result = null;
        JsonNode argNumber = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = CeilFunction.getArgumentCount(ctx);
        if (useContext) {
            argNumber = FunctionUtils.getContextVariable(expressionVisitor);
            if (argNumber != null && !argNumber.isNull()) {
                if (!argNumber.isNumber()) {
                    throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
                }
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount == 1) {
            if (!useContext) {
                argNumber = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            }
            if (argNumber == null) {
                return null;
            }
            if (!argNumber.isNumber()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            if (!argNumber.isIntegralNumber()) {
                double ceil = Math.ceil(argNumber.doubleValue());
                return new LongNode((long)ceil);
            }
            if (!argNumber.isLong()) return argNumber;
            double ceil = Math.ceil(argNumber.doubleValue());
            return new LongNode((long)ceil);
        }
        if (argCount != 0) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        return null;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<n-:n>";
    }
}

