/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import org.antlr.v4.runtime.ParserRuleContext;

public class AverageFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$average");
    public static final String ERR_ARG_TYPE = String.format("Argument 1 of function \"%s\" must be an array of \"number\"", "$average");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$average");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$average");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        JsonNode arg = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = AverageFunction.getArgumentCount(ctx);
        if (useContext) {
            arg = FunctionUtils.getContextVariable(expressionVisitor);
            ParserRuleContext prc = ctx.getParent();
            if (prc != null && prc instanceof MappingExpressionParser.Fct_chainContext || arg != null && !arg.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount == 1) {
            if (!useContext) {
                arg = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            }
            if (arg == null) {
                return null;
            }
            if (!useContext) {
                FunctionUtils.validateArguments(ERR_ARG_TYPE, expressionVisitor, ctx, 0, this.getSignature());
            }
            if (arg.isArray()) {
                ArrayNode arr = (ArrayNode)arg;
                if (arr.size() == 0) {
                    return null;
                }
                double sum = 0.0;
                for (JsonNode a : arr) {
                    if (a.isNumber()) {
                        sum += a.asDouble();
                        continue;
                    }
                    throw new EvaluateRuntimeException(ERR_ARG_TYPE);
                }
                Double avg = sum / (double)arr.size();
                if (avg - (double)avg.longValue() == 0.0) {
                    return new LongNode(avg.longValue());
                }
                return new DoubleNode(avg);
            }
            if (arg.isNumber()) {
                if (arg.isLong()) {
                    return arg;
                }
                Double avg = arg.asDouble();
                if (avg - (double)avg.longValue() == 0.0) {
                    return new LongNode(avg.longValue());
                }
                return new DoubleNode(avg);
            }
            throw new EvaluateRuntimeException(ERR_ARG_TYPE);
        }
        throw new EvaluateRuntimeException(argCount == 0 ? (useContext ? ERR_BAD_CONTEXT : ERR_ARG1BADTYPE) : ERR_ARG2BADTYPE);
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<a<n>:n>";
    }
}

