/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FrameOutputStream;
import net.jpountz.lz4.LZ4SafeDecompressor;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;

public class LZ4FrameInputStream
extends FilterInputStream {
    static final String PREMATURE_EOS = "Stream ended prematurely";
    static final String NOT_SUPPORTED = "Stream unsupported";
    static final String BLOCK_HASH_MISMATCH = "Block checksum mismatch";
    static final String DESCRIPTOR_HASH_MISMATCH = "Stream frame descriptor corrupted";
    static final int MAGIC_SKIPPABLE_BASE = 407710288;
    private final LZ4SafeDecompressor decompressor;
    private final XXHash32 checksum;
    private final byte[] headerArray = new byte[15];
    private final ByteBuffer headerBuffer = ByteBuffer.wrap(this.headerArray).order(ByteOrder.LITTLE_ENDIAN);
    private byte[] compressedBuffer;
    private ByteBuffer buffer = null;
    private byte[] rawBuffer = null;
    private int maxBlockSize = -1;
    private long expectedContentSize = -1L;
    private long totalContentSize = 0L;
    private LZ4FrameOutputStream.FrameInfo frameInfo = null;
    private final ByteBuffer readNumberBuff = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);

    public LZ4FrameInputStream(InputStream inputStream) throws IOException {
        this(inputStream, LZ4Factory.fastestInstance().safeDecompressor(), XXHashFactory.fastestInstance().hash32());
    }

    public LZ4FrameInputStream(InputStream inputStream, LZ4SafeDecompressor lZ4SafeDecompressor, XXHash32 xXHash32) throws IOException {
        super(inputStream);
        this.decompressor = lZ4SafeDecompressor;
        this.checksum = xXHash32;
        this.nextFrameInfo();
    }

    private boolean nextFrameInfo() throws IOException {
        while (true) {
            int n2;
            int n3 = 0;
            do {
                if ((n2 = this.in.read(this.readNumberBuff.array(), n3, 4 - n3)) >= 0) continue;
                return false;
            } while ((n3 += n2) < 4);
            n2 = this.readNumberBuff.getInt(0);
            if (n2 == 407708164) {
                this.readHeader();
                return true;
            }
            if (n2 >>> 4 != 25481893) break;
            this.skippableFrame();
        }
        throw new IOException(NOT_SUPPORTED);
    }

    private void skippableFrame() throws IOException {
        int n2;
        byte[] byArray = new byte[1024];
        for (int i10 = this.readInt(this.in); i10 > 0; i10 -= n2) {
            n2 = this.in.read(byArray, 0, Math.min(i10, byArray.length));
            if (n2 >= 0) continue;
            throw new IOException(PREMATURE_EOS);
        }
    }

    private void readHeader() throws IOException {
        this.headerBuffer.rewind();
        int n2 = this.in.read();
        if (n2 < 0) {
            throw new IOException(PREMATURE_EOS);
        }
        int n3 = this.in.read();
        if (n3 < 0) {
            throw new IOException(PREMATURE_EOS);
        }
        byte by2 = (byte)(n2 & 0xFF);
        LZ4FrameOutputStream.FLG fLG = LZ4FrameOutputStream.FLG.fromByte(by2);
        this.headerBuffer.put(by2);
        byte by3 = (byte)(n3 & 0xFF);
        LZ4FrameOutputStream.BD bD = LZ4FrameOutputStream.BD.fromByte(by3);
        this.headerBuffer.put(by3);
        this.frameInfo = new LZ4FrameOutputStream.FrameInfo(fLG, bD);
        if (fLG.isEnabled(LZ4FrameOutputStream.FLG.Bits.CONTENT_SIZE)) {
            this.expectedContentSize = this.readLong(this.in);
            this.headerBuffer.putLong(this.expectedContentSize);
        }
        this.totalContentSize = 0L;
        byte by4 = (byte)(this.checksum.hash(this.headerArray, 0, this.headerBuffer.position(), 0) >> 8 & 0xFF);
        int n4 = this.in.read();
        if (n4 < 0) {
            throw new IOException(PREMATURE_EOS);
        }
        if (by4 != (byte)(n4 & 0xFF)) {
            throw new IOException(DESCRIPTOR_HASH_MISMATCH);
        }
        this.maxBlockSize = this.frameInfo.getBD().getBlockMaximumSize();
        this.compressedBuffer = new byte[this.maxBlockSize];
        this.rawBuffer = new byte[this.maxBlockSize];
        this.buffer = ByteBuffer.wrap(this.rawBuffer);
        this.buffer.limit(0);
    }

    private long readLong(InputStream inputStream) throws IOException {
        int n2;
        int n3 = 0;
        do {
            if ((n2 = inputStream.read(this.readNumberBuff.array(), n3, 8 - n3)) >= 0) continue;
            throw new IOException(PREMATURE_EOS);
        } while ((n3 += n2) < 8);
        return this.readNumberBuff.getLong(0);
    }

    private int readInt(InputStream inputStream) throws IOException {
        int n2;
        int n3 = 0;
        do {
            if ((n2 = inputStream.read(this.readNumberBuff.array(), n3, 4 - n3)) >= 0) continue;
            throw new IOException(PREMATURE_EOS);
        } while ((n3 += n2) < 4);
        return this.readNumberBuff.getInt(0);
    }

    private void readBlock() throws IOException {
        int n2;
        boolean bl2;
        int n3 = this.readInt(this.in);
        boolean bl3 = bl2 = (n3 & Integer.MIN_VALUE) == 0;
        if ((n3 &= Integer.MAX_VALUE) == 0) {
            int n4;
            if (this.frameInfo.isEnabled(LZ4FrameOutputStream.FLG.Bits.CONTENT_CHECKSUM) && (n4 = this.readInt(this.in)) != this.frameInfo.currentStreamHash()) {
                throw new IOException("Content checksum mismatch");
            }
            if (this.frameInfo.isEnabled(LZ4FrameOutputStream.FLG.Bits.CONTENT_SIZE) && this.expectedContentSize != this.totalContentSize) {
                throw new IOException("Size check mismatch");
            }
            this.frameInfo.finish();
            return;
        }
        byte[] byArray = bl2 ? this.compressedBuffer : this.rawBuffer;
        if (n3 > this.maxBlockSize) {
            throw new IOException(String.format(Locale.ROOT, "Block size %s exceeded max: %s", n3, this.maxBlockSize));
        }
        for (int i10 = 0; i10 < n3; i10 += n2) {
            n2 = this.in.read(byArray, i10, n3 - i10);
            if (n2 >= 0) continue;
            throw new IOException(PREMATURE_EOS);
        }
        if (this.frameInfo.isEnabled(LZ4FrameOutputStream.FLG.Bits.BLOCK_CHECKSUM) && (n2 = this.readInt(this.in)) != this.checksum.hash(byArray, 0, n3, 0)) {
            throw new IOException(BLOCK_HASH_MISMATCH);
        }
        if (bl2) {
            try {
                n2 = this.decompressor.decompress(byArray, 0, n3, this.rawBuffer, 0, this.rawBuffer.length);
            }
            catch (LZ4Exception lZ4Exception) {
                throw new IOException(lZ4Exception);
            }
        } else {
            n2 = n3;
        }
        if (this.frameInfo.isEnabled(LZ4FrameOutputStream.FLG.Bits.CONTENT_CHECKSUM)) {
            this.frameInfo.updateStreamHash(this.rawBuffer, 0, n2);
        }
        this.totalContentSize += (long)n2;
        this.buffer.limit(n2);
        this.buffer.rewind();
    }

    @Override
    public int read() throws IOException {
        while (this.buffer.remaining() == 0) {
            if (this.frameInfo.isFinished() && !this.nextFrameInfo()) {
                return -1;
            }
            this.readBlock();
        }
        return this.buffer.get();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        while (this.buffer.remaining() == 0) {
            if (this.frameInfo.isFinished() && !this.nextFrameInfo()) {
                return -1;
            }
            this.readBlock();
        }
        n3 = Math.min(n3, this.buffer.remaining());
        this.buffer.get(byArray, n2, n3);
        return n3;
    }

    @Override
    public long skip(long l7) throws IOException {
        while (this.buffer.remaining() == 0) {
            if (this.frameInfo.isFinished() && !this.nextFrameInfo()) {
                return 0L;
            }
            this.readBlock();
        }
        l7 = Math.min(l7, (long)this.buffer.remaining());
        this.buffer.position(this.buffer.position() + (int)l7);
        return l7;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public synchronized void mark(int n2) {
        throw new UnsupportedOperationException("mark not supported");
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException("reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

