/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.thirdparty.ion.impl;

import com.ibm.cloud.objectstorage.thirdparty.ion.SymbolTable;
import com.ibm.cloud.objectstorage.thirdparty.ion.SymbolToken;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.LocalSymbolTable;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.LocalSymbolTableImportAdapter;
import com.ibm.cloud.objectstorage.thirdparty.ion.impl.SymbolTokenImpl;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalSymbolTableImports {
    private final SymbolTable[] myImports;
    private final int myMaxId;
    private final int[] myBaseSids;

    LocalSymbolTableImports(List<SymbolTable> importTables) {
        this.validateImports(importTables);
        int importTablesSize = importTables.size();
        this.myImports = new SymbolTable[importTablesSize];
        for (int i = 0; i < importTables.size(); ++i) {
            SymbolTable symbolTable = importTables.get(i);
            this.myImports[i] = symbolTable.isLocalTable() ? LocalSymbolTableImportAdapter.of((LocalSymbolTable)symbolTable) : symbolTable;
        }
        this.myBaseSids = new int[importTablesSize];
        this.myMaxId = LocalSymbolTableImports.prepBaseSids(this.myBaseSids, this.myImports);
    }

    private void validateImports(List<SymbolTable> importTables) {
        int sizeWithoutSystemTables = importTables.size();
        int numberOfLocalTables = 0;
        for (SymbolTable table : importTables) {
            if (table.isLocalTable()) {
                ++numberOfLocalTables;
            }
            if (!table.isSystemTable()) continue;
            --sizeWithoutSystemTables;
        }
        if (numberOfLocalTables > 0 && sizeWithoutSystemTables != 1) {
            throw new IllegalArgumentException("when importing LocalSymbolTables it needs to be the only import");
        }
    }

    LocalSymbolTableImports(SymbolTable defaultSystemSymtab, SymbolTable ... imports) {
        assert (defaultSystemSymtab.isSystemTable()) : "defaultSystemSymtab isn't a system symtab";
        if (imports != null && imports.length > 0) {
            SymbolTable systemTable;
            int offset;
            if (imports[0].isSystemTable()) {
                offset = 0;
                systemTable = imports[0];
            } else {
                offset = 1;
                systemTable = defaultSystemSymtab;
            }
            this.myImports = new SymbolTable[imports.length + offset];
            this.myImports[0] = systemTable;
            this.validateImports(Arrays.asList(imports));
            for (int i = 1 - offset; i < imports.length; ++i) {
                SymbolTable symbolTable = imports[i];
                this.myImports[i + offset] = symbolTable instanceof LocalSymbolTable ? LocalSymbolTableImportAdapter.of((LocalSymbolTable)symbolTable) : symbolTable;
            }
        } else {
            this.myImports = new SymbolTable[]{defaultSystemSymtab};
        }
        this.myBaseSids = new int[this.myImports.length];
        this.myMaxId = LocalSymbolTableImports.prepBaseSids(this.myBaseSids, this.myImports);
    }

    private static int prepBaseSids(int[] baseSids, SymbolTable[] imports) {
        SymbolTable firstImport = imports[0];
        assert (firstImport.isSystemTable()) : "first symtab must be a system symtab";
        baseSids[0] = 0;
        int total = firstImport.getMaxId();
        for (int i = 1; i < imports.length; ++i) {
            SymbolTable importedTable = imports[i];
            if (importedTable.isSystemTable()) {
                String message = "only non-system shared tables can be imported";
                throw new IllegalArgumentException(message);
            }
            baseSids[i] = total;
            total += imports[i].getMaxId();
        }
        return total;
    }

    String findKnownSymbol(int sid) {
        String name = null;
        if (sid <= this.myMaxId) {
            int baseSid;
            int i;
            int previousBaseSid = 0;
            for (i = 1; i < this.myImports.length && sid > (baseSid = this.myBaseSids[i]); ++i) {
                previousBaseSid = baseSid;
            }
            int importScopedSid = sid - previousBaseSid;
            name = this.myImports[i - 1].findKnownSymbol(importScopedSid);
        }
        return name;
    }

    int findSymbol(String name) {
        SymbolToken tok = this.find(name);
        return tok == null ? -1 : tok.getSid();
    }

    SymbolToken find(String text) {
        for (int i = 0; i < this.myImports.length; ++i) {
            SymbolTable importedTable = this.myImports[i];
            SymbolToken tok = importedTable.find(text);
            if (tok == null) continue;
            int sid = tok.getSid() + this.myBaseSids[i];
            text = tok.getText();
            assert (text != null);
            return new SymbolTokenImpl(text, sid);
        }
        return null;
    }

    int getMaxId() {
        return this.myMaxId;
    }

    SymbolTable getSystemSymbolTable() {
        assert (this.myImports[0].isSystemTable());
        return this.myImports[0];
    }

    SymbolTable[] getImportedTables() {
        int count = this.myImports.length - 1;
        SymbolTable[] imports = new SymbolTable[count];
        if (count > 0) {
            System.arraycopy(this.myImports, 1, imports, 0, count);
        }
        return imports;
    }

    SymbolTable[] getImportedTablesNoCopy() {
        return this.myImports;
    }

    public String toString() {
        return Arrays.toString(this.myImports);
    }

    boolean equalImports(LocalSymbolTableImports other) {
        return Arrays.equals(this.myImports, other.myImports);
    }
}

