/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.entity;

import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpException;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpMessage;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.ProtocolException;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.annotation.Contract;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.annotation.ThreadingBehavior;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.entity.ContentLengthStrategy;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.entity.LaxContentLengthStrategy;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

