/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3.internal;

import com.ibm.cloud.objectstorage.AmazonWebServiceResponse;
import com.ibm.cloud.objectstorage.http.HttpResponse;
import com.ibm.cloud.objectstorage.services.s3.internal.AbstractS3ResponseHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.S3AbortableInputStream;
import com.ibm.cloud.objectstorage.services.s3.internal.ServiceUtils;
import com.ibm.cloud.objectstorage.services.s3.model.ObjectMetadata;
import com.ibm.cloud.objectstorage.services.s3.model.S3Object;
import com.ibm.cloud.objectstorage.services.s3.model.S3ObjectInputStream;

public class S3ObjectResponseHandler
extends AbstractS3ResponseHandler<S3Object> {
    @Override
    public AmazonWebServiceResponse<S3Object> handle(HttpResponse response) throws Exception {
        S3Object object = new S3Object();
        AmazonWebServiceResponse<S3Object> awsResponse = this.parseResponseMetadata(response);
        if (response.getHeaders().get("x-amz-website-redirect-location") != null) {
            object.setRedirectLocation(response.getHeaders().get("x-amz-website-redirect-location"));
        }
        if (response.getHeaders().get("x-amz-request-charged") != null) {
            object.setRequesterCharged(true);
        }
        if (response.getHeaders().get("x-amz-tagging-count") != null) {
            object.setTaggingCount(Integer.parseInt(response.getHeaders().get("x-amz-tagging-count")));
        }
        if (response.getHeaders().get("retention-expiration-date") != null) {
            object.setRetentionExpirationDate(ServiceUtils.parseRfc822Date(response.getHeaders().get("retention-expiration-date")));
        }
        if (response.getHeaders().get("retention-legal-hold-count") != null) {
            object.setRetentionLegalHoldCount(Integer.parseInt(response.getHeaders().get("retention-legal-hold-count")));
        }
        if (response.getHeaders().get("retention-period") != null) {
            object.setRetentionPeriod(Long.parseLong(response.getHeaders().get("retention-period")));
        }
        ObjectMetadata metadata = object.getObjectMetadata();
        this.populateObjectMetadata(response, metadata);
        object.setObjectContent(new S3ObjectInputStream(this.abortableIs(response), response.getHttpRequest()));
        awsResponse.setResult(object);
        return awsResponse;
    }

    private S3AbortableInputStream abortableIs(HttpResponse response) {
        return new S3AbortableInputStream(response.getContent(), response.getHttpRequest(), this.getContentLength(response));
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return true;
    }

    private long getContentLength(HttpResponse response) {
        String contentLength = response.getHeader("Content-Length");
        if (contentLength == null) {
            return -1L;
        }
        return Long.parseLong(response.getHeader("Content-Length"));
    }
}

