/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.aspera.transfer.internal;

import com.ibm.cloud.objectstorage.thirdparty.jackson.databind.JsonNode;
import com.ibm.cloud.objectstorage.thirdparty.jackson.databind.ObjectMapper;
import com.ibm.cloud.objectstorage.thirdparty.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;

public class AsperaTransferManagerUtils {
    public static ThreadPoolExecutor createDefaultExecutorService() {
        ThreadFactory threadFactory = new ThreadFactory(){
            private int threadCount = 1;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("aspera-transfer-manager-worker-" + this.threadCount++);
                return thread;
            }
        };
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(10, threadFactory);
    }

    public static String getRedactedJsonString(String jsonString, String ... jsonPathsToRedact) {
        String rtn = "";
        if (jsonString != null && jsonString != "") {
            rtn = jsonString;
            try {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode rootJsonNode = mapper.readTree(jsonString);
                for (String jsonPathToRedact : jsonPathsToRedact) {
                    if (jsonPathToRedact == null || jsonPathToRedact == "") continue;
                    List<JsonNode> nodesToRedact = rootJsonNode.findParents(jsonPathToRedact);
                    for (JsonNode jsonNodeToRedact : nodesToRedact) {
                        ObjectNode writableNodeToRedact = (ObjectNode)jsonNodeToRedact;
                        if (writableNodeToRedact == null || writableNodeToRedact.isMissingNode()) continue;
                        writableNodeToRedact.put(jsonPathToRedact, "[REDACTED]");
                    }
                }
                rtn = mapper.writeValueAsString(rootJsonNode);
            }
            catch (IOException e) {
                rtn = "";
            }
        }
        return rtn;
    }
}

