/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.oauth;

import com.ibm.cloud.objectstorage.SDKGlobalConfiguration;
import com.ibm.cloud.objectstorage.http.apache.client.impl.ApacheConnectionManagerFactory;
import com.ibm.cloud.objectstorage.http.conn.ssl.SdkTLSSocketFactory;
import com.ibm.cloud.objectstorage.http.settings.HttpClientSettings;
import com.ibm.cloud.objectstorage.log.InternalLogApi;
import com.ibm.cloud.objectstorage.log.InternalLogFactory;
import com.ibm.cloud.objectstorage.oauth.DefaultTokenManager;
import com.ibm.cloud.objectstorage.oauth.OAuthServiceException;
import com.ibm.cloud.objectstorage.oauth.Token;
import com.ibm.cloud.objectstorage.oauth.TokenProvider;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpEntity;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpResponse;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.NameValuePair;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.ClientProtocolException;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.entity.UrlEncodedFormEntity;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.methods.HttpPost;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.conn.ssl.DefaultHostnameVerifier;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.client.CloseableHttpClient;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.client.HttpClientBuilder;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.message.BasicNameValuePair;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.ssl.SSLContexts;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.util.EntityUtils;
import com.ibm.cloud.objectstorage.thirdparty.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class DefaultTokenProvider
implements TokenProvider {
    protected static final InternalLogApi log = InternalLogFactory.getLog(DefaultTokenProvider.class);
    private static final String BASIC_AUTH = "Basic Yng6Yng=";
    private static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String ACCEPT = "application/json";
    private static final String GRANT_TYPE = "urn:ibm:params:oauth:grant-type:apikey";
    private static final String RESPONSE_TYPE = "cloud_iam";
    private String apiKey;
    private String iamEndpoint = SDKGlobalConfiguration.IAM_ENDPOINT;
    private HttpClientSettings httpClientSettings;

    public DefaultTokenProvider(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setIamEndpoint(String iamEndpoint) {
        this.iamEndpoint = iamEndpoint;
    }

    public void setHttpClientSettings(HttpClientSettings httpClientSettings) {
        this.httpClientSettings = httpClientSettings;
    }

    @Override
    public Token retrieveToken() {
        log.debug("DefaultTokenProvider retrieveToken()");
        try {
            SSLContext sslContext;
            if (SDKGlobalConfiguration.isCertCheckingDisabled()) {
                if (log.isWarnEnabled()) {
                    log.warn("SSL Certificate checking for endpoints has been explicitly disabled.");
                }
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{new ApacheConnectionManagerFactory.TrustingX509TrustManager()}, null);
            } else {
                sslContext = SSLContexts.createDefault();
            }
            SdkTLSSocketFactory sslsf = new SdkTLSSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier());
            HttpClientBuilder builder = HttpClientBuilder.create();
            if (this.httpClientSettings != null) {
                DefaultTokenManager.addProxyConfig(builder, this.httpClientSettings);
            }
            CloseableHttpClient client = builder.setSSLSocketFactory(sslsf).build();
            HttpPost post = new HttpPost(this.iamEndpoint);
            post.setHeader("Authorization", BASIC_AUTH);
            post.setHeader("Content-Type", CONTENT_TYPE);
            post.setHeader("Accept", ACCEPT);
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            urlParameters.add(new BasicNameValuePair("grant_type", GRANT_TYPE));
            urlParameters.add(new BasicNameValuePair("response_type", RESPONSE_TYPE));
            urlParameters.add(new BasicNameValuePair("apikey", this.apiKey));
            post.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)urlParameters));
            HttpResponse response = client.execute(post);
            if (response.getStatusLine().getStatusCode() != 200) {
                log.info("Response code= " + response.getStatusLine().getStatusCode() + ", Reason= " + response.getStatusLine().getReasonPhrase() + ".Throwing OAuthServiceException");
                OAuthServiceException exception = new OAuthServiceException("Token retrieval from IAM service failed");
                exception.setStatusCode(response.getStatusLine().getStatusCode());
                exception.setStatusMessage(response.getStatusLine().getReasonPhrase());
                throw exception;
            }
            HttpEntity entity = response.getEntity();
            String resultStr = EntityUtils.toString(entity);
            ObjectMapper mapper = new ObjectMapper();
            Token token = mapper.readValue(resultStr, Token.class);
            return token;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return null;
    }
}

