/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.http.apache.utils;

import com.ibm.cloud.objectstorage.Request;
import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.http.HttpResponse;
import com.ibm.cloud.objectstorage.http.settings.HttpClientSettings;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.Header;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpEntity;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpHost;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.auth.AuthScope;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.auth.Credentials;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.auth.NTCredentials;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.CredentialsProvider;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.config.RequestConfig;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.methods.HttpRequestBase;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.protocol.HttpClientContext;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.entity.BufferedHttpEntity;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.entity.StringEntity;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.auth.BasicScheme;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.client.BasicAuthCache;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.client.BasicCredentialsProvider;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.protocol.HttpContext;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.Log;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.LogFactory;
import com.ibm.cloud.objectstorage.util.FakeIOException;
import com.ibm.cloud.objectstorage.util.ReflectionMethodInvoker;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class ApacheUtils {
    private static final Log log = LogFactory.getLog(ApacheUtils.class);
    private static final ReflectionMethodInvoker<RequestConfig.Builder, RequestConfig.Builder> normalizeUriInvoker = new ReflectionMethodInvoker<RequestConfig.Builder, RequestConfig.Builder>(RequestConfig.Builder.class, RequestConfig.Builder.class, "setNormalizeUri", Boolean.TYPE);
    private final boolean normalizeUriMethodNotFound = false;

    public static boolean isRequestSuccessful(com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status / 100 == 2;
    }

    public static HttpResponse createResponse(Request<?> request, HttpRequestBase method, com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpResponse apacheHttpResponse, HttpContext context) throws IOException {
        HttpResponse httpResponse = new HttpResponse(request, method, context);
        if (apacheHttpResponse.getEntity() != null) {
            httpResponse.setContent(apacheHttpResponse.getEntity().getContent());
        }
        httpResponse.setStatusCode(apacheHttpResponse.getStatusLine().getStatusCode());
        httpResponse.setStatusText(apacheHttpResponse.getStatusLine().getReasonPhrase());
        for (Header header : apacheHttpResponse.getAllHeaders()) {
            httpResponse.addHeader(header.getName(), header.getValue());
        }
        return httpResponse;
    }

    public static HttpEntity newStringEntity(String s) {
        try {
            return new StringEntity(s);
        }
        catch (UnsupportedEncodingException e) {
            throw new SdkClientException("Unable to create HTTP entity: " + e.getMessage(), e);
        }
    }

    public static HttpEntity newBufferedHttpEntity(HttpEntity entity) throws FakeIOException {
        try {
            return new BufferedHttpEntity(entity);
        }
        catch (FakeIOException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SdkClientException("Unable to create HTTP entity: " + e.getMessage(), e);
        }
    }

    public static HttpClientContext newClientContext(HttpClientSettings settings, Map<String, ? extends Object> attributes) {
        HttpClientContext clientContext = new HttpClientContext();
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, ? extends Object> entry : attributes.entrySet()) {
                clientContext.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        ApacheUtils.addPreemptiveAuthenticationProxy(clientContext, settings);
        RequestConfig.Builder builder = RequestConfig.custom();
        ApacheUtils.disableNormalizeUri(builder);
        clientContext.setRequestConfig(builder.build());
        clientContext.setAttribute("com.amazonaws.disableSocketProxy", settings.disableSocketProxy());
        return clientContext;
    }

    public static void disableNormalizeUri(RequestConfig.Builder requestConfigBuilder) {
        if (normalizeUriInvoker.isInitialized()) {
            try {
                normalizeUriInvoker.invoke(requestConfigBuilder, false);
            }
            catch (NoSuchMethodException ignored) {
                ApacheUtils.noSuchMethodThrownByNormalizeUriInvoker();
            }
        }
    }

    public static CredentialsProvider newProxyCredentialsProvider(HttpClientSettings settings) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(ApacheUtils.newAuthScope(settings), ApacheUtils.newNTCredentials(settings));
        return provider;
    }

    private static Credentials newNTCredentials(HttpClientSettings settings) {
        return new NTCredentials(settings.getProxyUsername(), settings.getProxyPassword(), settings.getProxyWorkstation(), settings.getProxyDomain());
    }

    private static AuthScope newAuthScope(HttpClientSettings settings) {
        return new AuthScope(settings.getProxyHost(), settings.getProxyPort());
    }

    private static void addPreemptiveAuthenticationProxy(HttpClientContext clientContext, HttpClientSettings settings) {
        if (settings.isPreemptiveBasicProxyAuth()) {
            HttpHost targetHost = new HttpHost(settings.getProxyHost(), settings.getProxyPort());
            CredentialsProvider credsProvider = ApacheUtils.newProxyCredentialsProvider(settings);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, basicAuth);
            clientContext.setCredentialsProvider(credsProvider);
            clientContext.setAuthCache(authCache);
        }
    }

    private static void noSuchMethodThrownByNormalizeUriInvoker() {
        log.warn("NoSuchMethodException was thrown when disabling normalizeUri. This indicates you are using an old version (< 4.5.8) of Apache http client. It is recommended to use http client version >= 4.5.9 to avoid the breaking change introduced in apache client 4.5.7 and the latency in exception handling. See https://github.com/aws/aws-sdk-java/issues/1919 for more information");
    }

    static {
        try {
            normalizeUriInvoker.initialize();
        }
        catch (NoSuchMethodException ignored) {
            ApacheUtils.noSuchMethodThrownByNormalizeUriInvoker();
        }
    }
}

