/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.auth;

import com.ibm.cloud.objectstorage.oauth.IBMOAuthCredentials;
import com.ibm.cloud.objectstorage.oauth.TokenManager;
import com.ibm.cloud.objectstorage.thirdparty.jackson.core.JsonFactory;
import com.ibm.cloud.objectstorage.thirdparty.jackson.core.JsonParseException;
import com.ibm.cloud.objectstorage.thirdparty.jackson.core.JsonParser;
import com.ibm.cloud.objectstorage.thirdparty.jackson.core.JsonToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class JsonCredentials
implements IBMOAuthCredentials {
    private static final JsonFactory jsonFactory = new JsonFactory();
    private boolean hmacEnabled;
    private boolean iamEnabled;
    private String accessKey;
    private String secretAccessKey;
    private String apiKey;
    private String serviceInstanceId;
    private TokenManager tokenManager;

    public JsonCredentials(File file) throws FileNotFoundException, IOException, IllegalArgumentException {
        if (!file.exists()) {
            throw new FileNotFoundException("File doesn't exist:  " + file.getAbsolutePath());
        }
        JsonParser parser = jsonFactory.createParser(file);
        this.parse(parser);
        parser.close();
        if (!this.isNullOrEmpty(this.apiKey) && !this.isNullOrEmpty(this.serviceInstanceId)) {
            this.iamEnabled = true;
        }
        if (!this.isNullOrEmpty(this.accessKey) && !this.isNullOrEmpty(this.secretAccessKey)) {
            this.hmacEnabled = true;
        }
        if (!this.iamEnabled && !this.hmacEnabled) {
            throw new IllegalArgumentException("The specified json doesn't contain the expected properties 'apikey', 'resource_instance_id', 'access_key_id' and 'secret_access_key'.");
        }
        if (this.hmacEnabled) {
            this.apiKey = null;
            this.serviceInstanceId = null;
            this.iamEnabled = false;
        }
    }

    public JsonCredentials(InputStream stream) throws IOException {
        try {
            JsonParser parser = jsonFactory.createParser(stream);
            this.parse(parser);
            parser.close();
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
        if (!this.isNullOrEmpty(this.apiKey) && !this.isNullOrEmpty(this.serviceInstanceId)) {
            this.iamEnabled = true;
        }
        if (!this.isNullOrEmpty(this.accessKey) && !this.isNullOrEmpty(this.secretAccessKey)) {
            this.hmacEnabled = true;
        }
        if (!this.iamEnabled && !this.hmacEnabled) {
            throw new IllegalArgumentException("The specified json doesn't contain the expected properties 'apikey', 'resource_instance_id', 'access_key_id' and 'secret_access_key'.");
        }
        if (this.hmacEnabled) {
            this.apiKey = null;
            this.serviceInstanceId = null;
            this.iamEnabled = false;
        } else {
            this.accessKey = null;
            this.secretAccessKey = null;
            this.iamEnabled = true;
        }
    }

    private void parse(JsonParser parser) throws JsonParseException, IOException {
        JsonToken jt = parser.nextToken();
        while (this.continueRead() && jt != null && jt != JsonToken.END_OBJECT) {
            String token = parser.getCurrentName();
            if ("cos_hmac_keys".equals(token)) {
                while (parser.nextToken() != JsonToken.END_OBJECT) {
                    token = parser.getCurrentName();
                    if ("access_key_id".equals(token)) {
                        parser.nextToken();
                        this.accessKey = parser.getText();
                    }
                    if (!"secret_access_key".equals(token)) continue;
                    parser.nextToken();
                    this.secretAccessKey = parser.getText();
                }
                parser.nextToken();
            }
            if ("apikey".equals(token)) {
                parser.nextToken();
                this.apiKey = parser.getText();
            }
            if ("resource_instance_id".equals(token)) {
                parser.nextToken();
                this.serviceInstanceId = parser.getText();
            }
            jt = parser.nextToken();
        }
    }

    private boolean isNullOrEmpty(String attr) {
        return attr == null || attr.length() == 0;
    }

    private boolean continueRead() {
        return this.isNullOrEmpty(this.accessKey) || this.isNullOrEmpty(this.secretAccessKey) || this.isNullOrEmpty(this.apiKey) || this.isNullOrEmpty(this.serviceInstanceId);
    }

    @Override
    public String getAWSAccessKeyId() {
        return this.accessKey;
    }

    @Override
    public String getAWSSecretKey() {
        return this.secretAccessKey;
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    @Override
    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public boolean isHmacEnabled() {
        return this.hmacEnabled;
    }

    public boolean isIamEnabled() {
        return this.iamEnabled;
    }

    public void setTokenManager(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }
}

