/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.cloudant.v1.model.Attachment;
import com.ibm.cloud.cloudant.v1.model.DocumentRevisionStatus;
import com.ibm.cloud.cloudant.v1.model.ReplicationCreateTargetParameters;
import com.ibm.cloud.cloudant.v1.model.ReplicationDatabase;
import com.ibm.cloud.cloudant.v1.model.Revisions;
import com.ibm.cloud.cloudant.v1.model.UserContext;
import com.ibm.cloud.sdk.core.service.model.DynamicModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReplicationDocument
extends DynamicModel<Object> {
    @SerializedName(value="_attachments")
    protected Map<String, Attachment> attachments;
    @SerializedName(value="_conflicts")
    protected List<String> conflicts;
    @SerializedName(value="_deleted")
    protected Boolean deleted;
    @SerializedName(value="_deleted_conflicts")
    protected List<String> deletedConflicts;
    @SerializedName(value="_id")
    protected String id;
    @SerializedName(value="_local_seq")
    protected String localSeq;
    @SerializedName(value="_rev")
    protected String rev;
    @SerializedName(value="_revisions")
    protected Revisions revisions;
    @SerializedName(value="_revs_info")
    protected List<DocumentRevisionStatus> revsInfo;
    @SerializedName(value="cancel")
    protected Boolean cancel;
    @SerializedName(value="checkpoint_interval")
    protected Long checkpointInterval;
    @SerializedName(value="connection_timeout")
    protected Long connectionTimeout;
    @SerializedName(value="continuous")
    protected Boolean continuous;
    @SerializedName(value="create_target")
    protected Boolean createTarget;
    @SerializedName(value="create_target_params")
    protected ReplicationCreateTargetParameters createTargetParams;
    @SerializedName(value="doc_ids")
    protected List<String> docIds;
    @SerializedName(value="filter")
    protected String filter;
    @SerializedName(value="http_connections")
    protected Long httpConnections;
    @SerializedName(value="query_params")
    protected Map<String, String> queryParams;
    @SerializedName(value="retries_per_request")
    protected Long retriesPerRequest;
    @SerializedName(value="selector")
    protected Map<String, Object> selector;
    @SerializedName(value="since_seq")
    protected String sinceSeq;
    @SerializedName(value="socket_options")
    protected String socketOptions;
    @SerializedName(value="source")
    protected ReplicationDatabase source;
    @SerializedName(value="source_proxy")
    protected String sourceProxy;
    @SerializedName(value="target")
    protected ReplicationDatabase target;
    @SerializedName(value="target_proxy")
    protected String targetProxy;
    @SerializedName(value="use_bulk_get")
    protected Boolean useBulkGet;
    @SerializedName(value="use_checkpoints")
    protected Boolean useCheckpoints;
    @SerializedName(value="user_ctx")
    protected UserContext userCtx;
    @SerializedName(value="winning_revs_only")
    protected Boolean winningRevsOnly;
    @SerializedName(value="worker_batch_size")
    protected Long workerBatchSize;
    @SerializedName(value="worker_processes")
    protected Long workerProcesses;

    public ReplicationDocument() {
        super((TypeToken)new TypeToken<Object>(){});
    }

    protected ReplicationDocument(Builder builder) {
        super((TypeToken)new TypeToken<Object>(){});
        Validator.notNull((Object)((Object)builder.source), (String)"source cannot be null");
        Validator.notNull((Object)((Object)builder.target), (String)"target cannot be null");
        this.attachments = builder.attachments;
        this.conflicts = builder.conflicts;
        this.deleted = builder.deleted;
        this.deletedConflicts = builder.deletedConflicts;
        this.id = builder.id;
        this.localSeq = builder.localSeq;
        this.rev = builder.rev;
        this.revisions = builder.revisions;
        this.revsInfo = builder.revsInfo;
        this.cancel = builder.cancel;
        this.checkpointInterval = builder.checkpointInterval;
        this.connectionTimeout = builder.connectionTimeout;
        this.continuous = builder.continuous;
        this.createTarget = builder.createTarget;
        this.createTargetParams = builder.createTargetParams;
        this.docIds = builder.docIds;
        this.filter = builder.filter;
        this.httpConnections = builder.httpConnections;
        this.queryParams = builder.queryParams;
        this.retriesPerRequest = builder.retriesPerRequest;
        this.selector = builder.selector;
        this.sinceSeq = builder.sinceSeq;
        this.socketOptions = builder.socketOptions;
        this.source = builder.source;
        this.sourceProxy = builder.sourceProxy;
        this.target = builder.target;
        this.targetProxy = builder.targetProxy;
        this.useBulkGet = builder.useBulkGet;
        this.useCheckpoints = builder.useCheckpoints;
        this.userCtx = builder.userCtx;
        this.winningRevsOnly = builder.winningRevsOnly;
        this.workerBatchSize = builder.workerBatchSize;
        this.workerProcesses = builder.workerProcesses;
        this.setProperties(builder.dynamicProperties);
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Map<String, Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Map<String, Attachment> attachments) {
        this.attachments = attachments;
    }

    public List<String> getConflicts() {
        return this.conflicts;
    }

    public void setConflicts(List<String> conflicts) {
        this.conflicts = conflicts;
    }

    public Boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public List<String> getDeletedConflicts() {
        return this.deletedConflicts;
    }

    public void setDeletedConflicts(List<String> deletedConflicts) {
        this.deletedConflicts = deletedConflicts;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLocalSeq() {
        return this.localSeq;
    }

    public void setLocalSeq(String localSeq) {
        this.localSeq = localSeq;
    }

    public String getRev() {
        return this.rev;
    }

    public void setRev(String rev) {
        this.rev = rev;
    }

    public Revisions getRevisions() {
        return this.revisions;
    }

    public void setRevisions(Revisions revisions) {
        this.revisions = revisions;
    }

    public List<DocumentRevisionStatus> getRevsInfo() {
        return this.revsInfo;
    }

    public void setRevsInfo(List<DocumentRevisionStatus> revsInfo) {
        this.revsInfo = revsInfo;
    }

    public Boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(Boolean cancel) {
        this.cancel = cancel;
    }

    public Long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public void setCheckpointInterval(long checkpointInterval) {
        this.checkpointInterval = checkpointInterval;
    }

    public Long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Boolean isContinuous() {
        return this.continuous;
    }

    public void setContinuous(Boolean continuous) {
        this.continuous = continuous;
    }

    public Boolean isCreateTarget() {
        return this.createTarget;
    }

    public void setCreateTarget(Boolean createTarget) {
        this.createTarget = createTarget;
    }

    public ReplicationCreateTargetParameters getCreateTargetParams() {
        return this.createTargetParams;
    }

    public void setCreateTargetParams(ReplicationCreateTargetParameters createTargetParams) {
        this.createTargetParams = createTargetParams;
    }

    public List<String> getDocIds() {
        return this.docIds;
    }

    public void setDocIds(List<String> docIds) {
        this.docIds = docIds;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Long getHttpConnections() {
        return this.httpConnections;
    }

    public void setHttpConnections(long httpConnections) {
        this.httpConnections = httpConnections;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Map<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public Long getRetriesPerRequest() {
        return this.retriesPerRequest;
    }

    public void setRetriesPerRequest(long retriesPerRequest) {
        this.retriesPerRequest = retriesPerRequest;
    }

    public Map<String, Object> getSelector() {
        return this.selector;
    }

    public void setSelector(Map<String, Object> selector) {
        this.selector = selector;
    }

    public String getSinceSeq() {
        return this.sinceSeq;
    }

    public void setSinceSeq(String sinceSeq) {
        this.sinceSeq = sinceSeq;
    }

    public String getSocketOptions() {
        return this.socketOptions;
    }

    public void setSocketOptions(String socketOptions) {
        this.socketOptions = socketOptions;
    }

    public ReplicationDatabase getSource() {
        return this.source;
    }

    public void setSource(ReplicationDatabase source) {
        this.source = source;
    }

    @Deprecated
    public String getSourceProxy() {
        return this.sourceProxy;
    }

    @Deprecated
    public void setSourceProxy(String sourceProxy) {
        this.sourceProxy = sourceProxy;
    }

    public ReplicationDatabase getTarget() {
        return this.target;
    }

    public void setTarget(ReplicationDatabase target) {
        this.target = target;
    }

    @Deprecated
    public String getTargetProxy() {
        return this.targetProxy;
    }

    @Deprecated
    public void setTargetProxy(String targetProxy) {
        this.targetProxy = targetProxy;
    }

    public Boolean isUseBulkGet() {
        return this.useBulkGet;
    }

    public void setUseBulkGet(Boolean useBulkGet) {
        this.useBulkGet = useBulkGet;
    }

    public Boolean isUseCheckpoints() {
        return this.useCheckpoints;
    }

    public void setUseCheckpoints(Boolean useCheckpoints) {
        this.useCheckpoints = useCheckpoints;
    }

    public UserContext getUserCtx() {
        return this.userCtx;
    }

    public void setUserCtx(UserContext userCtx) {
        this.userCtx = userCtx;
    }

    public Boolean isWinningRevsOnly() {
        return this.winningRevsOnly;
    }

    public void setWinningRevsOnly(Boolean winningRevsOnly) {
        this.winningRevsOnly = winningRevsOnly;
    }

    public Long getWorkerBatchSize() {
        return this.workerBatchSize;
    }

    public void setWorkerBatchSize(long workerBatchSize) {
        this.workerBatchSize = workerBatchSize;
    }

    public Long getWorkerProcesses() {
        return this.workerProcesses;
    }

    public void setWorkerProcesses(long workerProcesses) {
        this.workerProcesses = workerProcesses;
    }

    public static class Builder {
        private Map<String, Attachment> attachments;
        private List<String> conflicts;
        private Boolean deleted;
        private List<String> deletedConflicts;
        private String id;
        private String localSeq;
        private String rev;
        private Revisions revisions;
        private List<DocumentRevisionStatus> revsInfo;
        private Boolean cancel;
        private Long checkpointInterval;
        private Long connectionTimeout;
        private Boolean continuous;
        private Boolean createTarget;
        private ReplicationCreateTargetParameters createTargetParams;
        private List<String> docIds;
        private String filter;
        private Long httpConnections;
        private Map<String, String> queryParams;
        private Long retriesPerRequest;
        private Map<String, Object> selector;
        private String sinceSeq;
        private String socketOptions;
        private ReplicationDatabase source;
        private String sourceProxy;
        private ReplicationDatabase target;
        private String targetProxy;
        private Boolean useBulkGet;
        private Boolean useCheckpoints;
        private UserContext userCtx;
        private Boolean winningRevsOnly;
        private Long workerBatchSize;
        private Long workerProcesses;
        private Map<String, Object> dynamicProperties;

        private Builder(ReplicationDocument replicationDocument) {
            this.attachments = replicationDocument.attachments;
            this.conflicts = replicationDocument.conflicts;
            this.deleted = replicationDocument.deleted;
            this.deletedConflicts = replicationDocument.deletedConflicts;
            this.id = replicationDocument.id;
            this.localSeq = replicationDocument.localSeq;
            this.rev = replicationDocument.rev;
            this.revisions = replicationDocument.revisions;
            this.revsInfo = replicationDocument.revsInfo;
            this.cancel = replicationDocument.cancel;
            this.checkpointInterval = replicationDocument.checkpointInterval;
            this.connectionTimeout = replicationDocument.connectionTimeout;
            this.continuous = replicationDocument.continuous;
            this.createTarget = replicationDocument.createTarget;
            this.createTargetParams = replicationDocument.createTargetParams;
            this.docIds = replicationDocument.docIds;
            this.filter = replicationDocument.filter;
            this.httpConnections = replicationDocument.httpConnections;
            this.queryParams = replicationDocument.queryParams;
            this.retriesPerRequest = replicationDocument.retriesPerRequest;
            this.selector = replicationDocument.selector;
            this.sinceSeq = replicationDocument.sinceSeq;
            this.socketOptions = replicationDocument.socketOptions;
            this.source = replicationDocument.source;
            this.sourceProxy = replicationDocument.sourceProxy;
            this.target = replicationDocument.target;
            this.targetProxy = replicationDocument.targetProxy;
            this.useBulkGet = replicationDocument.useBulkGet;
            this.useCheckpoints = replicationDocument.useCheckpoints;
            this.userCtx = replicationDocument.userCtx;
            this.winningRevsOnly = replicationDocument.winningRevsOnly;
            this.workerBatchSize = replicationDocument.workerBatchSize;
            this.workerProcesses = replicationDocument.workerProcesses;
            this.dynamicProperties = replicationDocument.getProperties();
        }

        public Builder() {
        }

        public Builder(ReplicationDatabase source, ReplicationDatabase target) {
            this.source = source;
            this.target = target;
        }

        public ReplicationDocument build() {
            return new ReplicationDocument(this);
        }

        public Builder addConflicts(String conflicts) {
            Validator.notNull((Object)conflicts, (String)"conflicts cannot be null");
            if (this.conflicts == null) {
                this.conflicts = new ArrayList<String>();
            }
            this.conflicts.add(conflicts);
            return this;
        }

        public Builder addDeletedConflicts(String deletedConflicts) {
            Validator.notNull((Object)deletedConflicts, (String)"deletedConflicts cannot be null");
            if (this.deletedConflicts == null) {
                this.deletedConflicts = new ArrayList<String>();
            }
            this.deletedConflicts.add(deletedConflicts);
            return this;
        }

        public Builder addRevsInfo(DocumentRevisionStatus revsInfo) {
            Validator.notNull((Object)((Object)revsInfo), (String)"revsInfo cannot be null");
            if (this.revsInfo == null) {
                this.revsInfo = new ArrayList<DocumentRevisionStatus>();
            }
            this.revsInfo.add(revsInfo);
            return this;
        }

        public Builder addDocIds(String docIds) {
            Validator.notNull((Object)docIds, (String)"docIds cannot be null");
            if (this.docIds == null) {
                this.docIds = new ArrayList<String>();
            }
            this.docIds.add(docIds);
            return this;
        }

        public Builder attachments(Map<String, Attachment> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder conflicts(List<String> conflicts) {
            this.conflicts = conflicts;
            return this;
        }

        public Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder deletedConflicts(List<String> deletedConflicts) {
            this.deletedConflicts = deletedConflicts;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder localSeq(String localSeq) {
            this.localSeq = localSeq;
            return this;
        }

        public Builder rev(String rev) {
            this.rev = rev;
            return this;
        }

        public Builder revisions(Revisions revisions) {
            this.revisions = revisions;
            return this;
        }

        public Builder revsInfo(List<DocumentRevisionStatus> revsInfo) {
            this.revsInfo = revsInfo;
            return this;
        }

        public Builder cancel(Boolean cancel) {
            this.cancel = cancel;
            return this;
        }

        public Builder checkpointInterval(long checkpointInterval) {
            this.checkpointInterval = checkpointInterval;
            return this;
        }

        public Builder connectionTimeout(long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder continuous(Boolean continuous) {
            this.continuous = continuous;
            return this;
        }

        public Builder createTarget(Boolean createTarget) {
            this.createTarget = createTarget;
            return this;
        }

        public Builder createTargetParams(ReplicationCreateTargetParameters createTargetParams) {
            this.createTargetParams = createTargetParams;
            return this;
        }

        public Builder docIds(List<String> docIds) {
            this.docIds = docIds;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder httpConnections(long httpConnections) {
            this.httpConnections = httpConnections;
            return this;
        }

        public Builder queryParams(Map<String, String> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public Builder retriesPerRequest(long retriesPerRequest) {
            this.retriesPerRequest = retriesPerRequest;
            return this;
        }

        public Builder selector(Map<String, Object> selector) {
            this.selector = selector;
            return this;
        }

        public Builder sinceSeq(String sinceSeq) {
            this.sinceSeq = sinceSeq;
            return this;
        }

        public Builder socketOptions(String socketOptions) {
            this.socketOptions = socketOptions;
            return this;
        }

        public Builder source(ReplicationDatabase source) {
            this.source = source;
            return this;
        }

        @Deprecated
        public Builder sourceProxy(String sourceProxy) {
            this.sourceProxy = sourceProxy;
            return this;
        }

        public Builder target(ReplicationDatabase target) {
            this.target = target;
            return this;
        }

        @Deprecated
        public Builder targetProxy(String targetProxy) {
            this.targetProxy = targetProxy;
            return this;
        }

        public Builder useBulkGet(Boolean useBulkGet) {
            this.useBulkGet = useBulkGet;
            return this;
        }

        public Builder useCheckpoints(Boolean useCheckpoints) {
            this.useCheckpoints = useCheckpoints;
            return this;
        }

        public Builder userCtx(UserContext userCtx) {
            this.userCtx = userCtx;
            return this;
        }

        public Builder winningRevsOnly(Boolean winningRevsOnly) {
            this.winningRevsOnly = winningRevsOnly;
            return this;
        }

        public Builder workerBatchSize(long workerBatchSize) {
            this.workerBatchSize = workerBatchSize;
            return this;
        }

        public Builder workerProcesses(long workerProcesses) {
            this.workerProcesses = workerProcesses;
            return this;
        }

        public Builder add(String name, Object value) {
            Validator.notNull((Object)name, (String)"name cannot be null");
            if (this.dynamicProperties == null) {
                this.dynamicProperties = new HashMap<String, Object>();
            }
            this.dynamicProperties.put(name, value);
            return this;
        }
    }
}

