/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.features.pagination;

import com.ibm.cloud.cloudant.features.pagination.AllDocsPageIterator;
import com.ibm.cloud.cloudant.features.pagination.AllDocsPartitionPageIterator;
import com.ibm.cloud.cloudant.features.pagination.BasePageIterator;
import com.ibm.cloud.cloudant.features.pagination.DesignDocsPageIterator;
import com.ibm.cloud.cloudant.features.pagination.FindPager;
import com.ibm.cloud.cloudant.features.pagination.FindPartitionPager;
import com.ibm.cloud.cloudant.features.pagination.IteratorPager;
import com.ibm.cloud.cloudant.features.pagination.OptionsHandler;
import com.ibm.cloud.cloudant.features.pagination.Pager;
import com.ibm.cloud.cloudant.features.pagination.SearchPageIterator;
import com.ibm.cloud.cloudant.features.pagination.SearchPartitionPageIterator;
import com.ibm.cloud.cloudant.features.pagination.ViewPageIterator;
import com.ibm.cloud.cloudant.features.pagination.ViewPartitionPageIterator;
import com.ibm.cloud.cloudant.v1.Cloudant;
import com.ibm.cloud.cloudant.v1.model.DocsResultRow;
import com.ibm.cloud.cloudant.v1.model.Document;
import com.ibm.cloud.cloudant.v1.model.PostAllDocsOptions;
import com.ibm.cloud.cloudant.v1.model.PostDesignDocsOptions;
import com.ibm.cloud.cloudant.v1.model.PostFindOptions;
import com.ibm.cloud.cloudant.v1.model.PostPartitionAllDocsOptions;
import com.ibm.cloud.cloudant.v1.model.PostPartitionFindOptions;
import com.ibm.cloud.cloudant.v1.model.PostPartitionSearchOptions;
import com.ibm.cloud.cloudant.v1.model.PostPartitionViewOptions;
import com.ibm.cloud.cloudant.v1.model.PostSearchOptions;
import com.ibm.cloud.cloudant.v1.model.PostViewOptions;
import com.ibm.cloud.cloudant.v1.model.SearchResultRow;
import com.ibm.cloud.cloudant.v1.model.ViewResultRow;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Pagination<O, I> {
    private final Cloudant client;
    private final O opts;
    private final BiFunction<Cloudant, O, BasePageIterator<?, O, ?, I>> iteratorCtor;
    private final Iterable<List<I>> pageIterable = new PageIterable();
    private final Iterable<I> rowIterable = new RowIterable();

    Pagination(Cloudant client, O opts, BiFunction<Cloudant, O, BasePageIterator<?, O, ?, I>> iteratorCtor) {
        this.client = client;
        this.opts = opts;
        this.iteratorCtor = iteratorCtor;
    }

    public Pager<I> pager() {
        return new IteratorPager(this.pages());
    }

    public Iterable<List<I>> pages() {
        return this.pageIterable;
    }

    public Stream<List<I>> pageStream() {
        return StreamSupport.stream(this.pages().spliterator(), false);
    }

    public Iterable<I> rows() {
        return this.rowIterable;
    }

    public Stream<I> rowStream() {
        return this.pageStream().flatMap(Collection::stream);
    }

    public static Pagination<PostAllDocsOptions, DocsResultRow> newPagination(Cloudant client, PostAllDocsOptions options) {
        OptionsHandler.POST_ALL_DOCS.validate(options);
        return new Pagination<PostAllDocsOptions, DocsResultRow>(client, OptionsHandler.duplicate(options), AllDocsPageIterator::new);
    }

    public static Pagination<PostPartitionAllDocsOptions, DocsResultRow> newPagination(Cloudant client, PostPartitionAllDocsOptions options) {
        OptionsHandler.POST_PARTITION_ALL_DOCS.validate(options);
        return new Pagination<PostPartitionAllDocsOptions, DocsResultRow>(client, OptionsHandler.duplicate(options), AllDocsPartitionPageIterator::new);
    }

    public static Pagination<PostDesignDocsOptions, DocsResultRow> newPagination(Cloudant client, PostDesignDocsOptions options) {
        OptionsHandler.POST_DESIGN_DOCS.validate(options);
        return new Pagination<PostDesignDocsOptions, DocsResultRow>(client, OptionsHandler.duplicate(options), DesignDocsPageIterator::new);
    }

    public static Pagination<PostFindOptions, Document> newPagination(Cloudant client, PostFindOptions options) {
        OptionsHandler.POST_FIND.validate(options);
        return new Pagination<PostFindOptions, Document>(client, OptionsHandler.duplicate(options), FindPager::new);
    }

    public static Pagination<PostPartitionFindOptions, Document> newPagination(Cloudant client, PostPartitionFindOptions options) {
        OptionsHandler.POST_PARTITION_FIND.validate(options);
        return new Pagination<PostPartitionFindOptions, Document>(client, OptionsHandler.duplicate(options), FindPartitionPager::new);
    }

    public static Pagination<PostSearchOptions, SearchResultRow> newPagination(Cloudant client, PostSearchOptions options) {
        OptionsHandler.POST_SEARCH.validate(options);
        return new Pagination<PostSearchOptions, SearchResultRow>(client, OptionsHandler.duplicate(options), SearchPageIterator::new);
    }

    public static Pagination<PostPartitionSearchOptions, SearchResultRow> newPagination(Cloudant client, PostPartitionSearchOptions options) {
        OptionsHandler.POST_PARTITION_SEARCH.validate(options);
        return new Pagination<PostPartitionSearchOptions, SearchResultRow>(client, OptionsHandler.duplicate(options), SearchPartitionPageIterator::new);
    }

    public static Pagination<PostViewOptions, ViewResultRow> newPagination(Cloudant client, PostViewOptions options) {
        OptionsHandler.POST_VIEW.validate(options);
        return new Pagination<PostViewOptions, ViewResultRow>(client, OptionsHandler.duplicate(options), ViewPageIterator::new);
    }

    public static Pagination<PostPartitionViewOptions, ViewResultRow> newPagination(Cloudant client, PostPartitionViewOptions options) {
        OptionsHandler.POST_PARTITION_VIEW.validate(options);
        return new Pagination<PostPartitionViewOptions, ViewResultRow>(client, OptionsHandler.duplicate(options), ViewPartitionPageIterator::new);
    }

    private final class PageIterable
    implements Iterable<List<I>> {
        private PageIterable() {
        }

        @Override
        public Iterator<List<I>> iterator() {
            return (Iterator)Pagination.this.iteratorCtor.apply(Pagination.this.client, Pagination.this.opts);
        }

        @Override
        public Spliterator<List<I>> spliterator() {
            return Spliterators.spliteratorUnknownSize(this.iterator(), 1296);
        }
    }

    private final class RowIterable
    implements Iterable<I> {
        private RowIterable() {
        }

        @Override
        public Iterator<I> iterator() {
            return Pagination.this.rowStream().iterator();
        }
    }
}

