/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PostSearchOptions
extends GenericModel {
    protected String db;
    protected String ddoc;
    protected String index;
    protected String query;
    protected String bookmark;
    protected List<String> highlightFields;
    protected Long highlightNumber;
    protected String highlightPostTag;
    protected String highlightPreTag;
    protected Long highlightSize;
    protected Boolean includeDocs;
    protected List<String> includeFields;
    protected Long limit;
    protected List<String> sort;
    protected String stale;
    protected List<String> counts;
    protected List<List<String>> drilldown;
    protected String groupField;
    protected Long groupLimit;
    protected List<String> groupSort;
    protected Map<String, Map<String, Map<String, String>>> ranges;

    protected PostSearchOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        Validator.notEmpty((String)builder.ddoc, (String)"ddoc cannot be empty");
        Validator.notEmpty((String)builder.index, (String)"index cannot be empty");
        Validator.notNull((Object)builder.query, (String)"query cannot be null");
        this.db = builder.db;
        this.ddoc = builder.ddoc;
        this.index = builder.index;
        this.query = builder.query;
        this.bookmark = builder.bookmark;
        this.highlightFields = builder.highlightFields;
        this.highlightNumber = builder.highlightNumber;
        this.highlightPostTag = builder.highlightPostTag;
        this.highlightPreTag = builder.highlightPreTag;
        this.highlightSize = builder.highlightSize;
        this.includeDocs = builder.includeDocs;
        this.includeFields = builder.includeFields;
        this.limit = builder.limit;
        this.sort = builder.sort;
        this.stale = builder.stale;
        this.counts = builder.counts;
        this.drilldown = builder.drilldown;
        this.groupField = builder.groupField;
        this.groupLimit = builder.groupLimit;
        this.groupSort = builder.groupSort;
        this.ranges = builder.ranges;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String ddoc() {
        return this.ddoc;
    }

    public String index() {
        return this.index;
    }

    public String query() {
        return this.query;
    }

    public String bookmark() {
        return this.bookmark;
    }

    public List<String> highlightFields() {
        return this.highlightFields;
    }

    public Long highlightNumber() {
        return this.highlightNumber;
    }

    public String highlightPostTag() {
        return this.highlightPostTag;
    }

    public String highlightPreTag() {
        return this.highlightPreTag;
    }

    public Long highlightSize() {
        return this.highlightSize;
    }

    public Boolean includeDocs() {
        return this.includeDocs;
    }

    public List<String> includeFields() {
        return this.includeFields;
    }

    public Long limit() {
        return this.limit;
    }

    public List<String> sort() {
        return this.sort;
    }

    public String stale() {
        return this.stale;
    }

    public List<String> counts() {
        return this.counts;
    }

    public List<List<String>> drilldown() {
        return this.drilldown;
    }

    public String groupField() {
        return this.groupField;
    }

    public Long groupLimit() {
        return this.groupLimit;
    }

    public List<String> groupSort() {
        return this.groupSort;
    }

    public Map<String, Map<String, Map<String, String>>> ranges() {
        return this.ranges;
    }

    public static class Builder {
        private String db;
        private String ddoc;
        private String index;
        private String query;
        private String bookmark;
        private List<String> highlightFields;
        private Long highlightNumber;
        private String highlightPostTag;
        private String highlightPreTag;
        private Long highlightSize;
        private Boolean includeDocs;
        private List<String> includeFields;
        private Long limit;
        private List<String> sort;
        private String stale;
        private List<String> counts;
        private List<List<String>> drilldown;
        private String groupField;
        private Long groupLimit;
        private List<String> groupSort;
        private Map<String, Map<String, Map<String, String>>> ranges;

        private Builder(PostSearchOptions postSearchOptions) {
            this.db = postSearchOptions.db;
            this.ddoc = postSearchOptions.ddoc;
            this.index = postSearchOptions.index;
            this.query = postSearchOptions.query;
            this.bookmark = postSearchOptions.bookmark;
            this.highlightFields = postSearchOptions.highlightFields;
            this.highlightNumber = postSearchOptions.highlightNumber;
            this.highlightPostTag = postSearchOptions.highlightPostTag;
            this.highlightPreTag = postSearchOptions.highlightPreTag;
            this.highlightSize = postSearchOptions.highlightSize;
            this.includeDocs = postSearchOptions.includeDocs;
            this.includeFields = postSearchOptions.includeFields;
            this.limit = postSearchOptions.limit;
            this.sort = postSearchOptions.sort;
            this.stale = postSearchOptions.stale;
            this.counts = postSearchOptions.counts;
            this.drilldown = postSearchOptions.drilldown;
            this.groupField = postSearchOptions.groupField;
            this.groupLimit = postSearchOptions.groupLimit;
            this.groupSort = postSearchOptions.groupSort;
            this.ranges = postSearchOptions.ranges;
        }

        public Builder() {
        }

        public Builder(String db, String ddoc, String index, String query) {
            this.db = db;
            this.ddoc = ddoc;
            this.index = index;
            this.query = query;
        }

        public PostSearchOptions build() {
            return new PostSearchOptions(this);
        }

        public Builder addHighlightFields(String highlightFields) {
            Validator.notNull((Object)highlightFields, (String)"highlightFields cannot be null");
            if (this.highlightFields == null) {
                this.highlightFields = new ArrayList<String>();
            }
            this.highlightFields.add(highlightFields);
            return this;
        }

        public Builder addIncludeFields(String includeFields) {
            Validator.notNull((Object)includeFields, (String)"includeFields cannot be null");
            if (this.includeFields == null) {
                this.includeFields = new ArrayList<String>();
            }
            this.includeFields.add(includeFields);
            return this;
        }

        public Builder addSort(String sort) {
            Validator.notNull((Object)sort, (String)"sort cannot be null");
            if (this.sort == null) {
                this.sort = new ArrayList<String>();
            }
            this.sort.add(sort);
            return this;
        }

        public Builder addCounts(String counts) {
            Validator.notNull((Object)counts, (String)"counts cannot be null");
            if (this.counts == null) {
                this.counts = new ArrayList<String>();
            }
            this.counts.add(counts);
            return this;
        }

        public Builder addDrilldown(List<String> drilldown) {
            Validator.notNull(drilldown, (String)"drilldown cannot be null");
            if (this.drilldown == null) {
                this.drilldown = new ArrayList<List<String>>();
            }
            this.drilldown.add(drilldown);
            return this;
        }

        public Builder addGroupSort(String groupSort) {
            Validator.notNull((Object)groupSort, (String)"groupSort cannot be null");
            if (this.groupSort == null) {
                this.groupSort = new ArrayList<String>();
            }
            this.groupSort.add(groupSort);
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder ddoc(String ddoc) {
            this.ddoc = ddoc;
            return this;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder bookmark(String bookmark) {
            this.bookmark = bookmark;
            return this;
        }

        public Builder highlightFields(List<String> highlightFields) {
            this.highlightFields = highlightFields;
            return this;
        }

        public Builder highlightNumber(long highlightNumber) {
            this.highlightNumber = highlightNumber;
            return this;
        }

        public Builder highlightPostTag(String highlightPostTag) {
            this.highlightPostTag = highlightPostTag;
            return this;
        }

        public Builder highlightPreTag(String highlightPreTag) {
            this.highlightPreTag = highlightPreTag;
            return this;
        }

        public Builder highlightSize(long highlightSize) {
            this.highlightSize = highlightSize;
            return this;
        }

        public Builder includeDocs(Boolean includeDocs) {
            this.includeDocs = includeDocs;
            return this;
        }

        public Builder includeFields(List<String> includeFields) {
            this.includeFields = includeFields;
            return this;
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public Builder stale(String stale) {
            this.stale = stale;
            return this;
        }

        public Builder counts(List<String> counts) {
            this.counts = counts;
            return this;
        }

        public Builder drilldown(List<List<String>> drilldown) {
            this.drilldown = drilldown;
            return this;
        }

        public Builder groupField(String groupField) {
            this.groupField = groupField;
            return this;
        }

        public Builder groupLimit(long groupLimit) {
            this.groupLimit = groupLimit;
            return this;
        }

        public Builder groupSort(List<String> groupSort) {
            this.groupSort = groupSort;
            return this;
        }

        public Builder ranges(Map<String, Map<String, Map<String, String>>> ranges) {
            this.ranges = ranges;
            return this;
        }
    }

    public static interface Stale {
        public static final String OK = "ok";
    }
}

