/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class PutAttachmentOptions
extends GenericModel {
    protected String db;
    protected String docId;
    protected String attachmentName;
    protected InputStream attachment;
    protected String contentType;
    protected String ifMatch;
    protected String rev;

    protected PutAttachmentOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        Validator.notEmpty((String)builder.docId, (String)"docId cannot be empty");
        Validator.notEmpty((String)builder.attachmentName, (String)"attachmentName cannot be empty");
        Validator.notNull((Object)builder.attachment, (String)"attachment cannot be null");
        Validator.notNull((Object)builder.contentType, (String)"contentType cannot be null");
        this.db = builder.db;
        this.docId = builder.docId;
        this.attachmentName = builder.attachmentName;
        this.attachment = builder.attachment;
        this.contentType = builder.contentType;
        this.ifMatch = builder.ifMatch;
        this.rev = builder.rev;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String docId() {
        return this.docId;
    }

    public String attachmentName() {
        return this.attachmentName;
    }

    public InputStream attachment() {
        return this.attachment;
    }

    public String contentType() {
        return this.contentType;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    public String rev() {
        return this.rev;
    }

    public static class Builder {
        private String db;
        private String docId;
        private String attachmentName;
        private InputStream attachment;
        private String contentType;
        private String ifMatch;
        private String rev;

        private Builder(PutAttachmentOptions putAttachmentOptions) {
            this.db = putAttachmentOptions.db;
            this.docId = putAttachmentOptions.docId;
            this.attachmentName = putAttachmentOptions.attachmentName;
            this.attachment = putAttachmentOptions.attachment;
            this.contentType = putAttachmentOptions.contentType;
            this.ifMatch = putAttachmentOptions.ifMatch;
            this.rev = putAttachmentOptions.rev;
        }

        public Builder() {
        }

        public Builder(String db, String docId, String attachmentName, InputStream attachment, String contentType) {
            this.db = db;
            this.docId = docId;
            this.attachmentName = attachmentName;
            this.attachment = attachment;
            this.contentType = contentType;
        }

        public PutAttachmentOptions build() {
            return new PutAttachmentOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder docId(String docId) {
            this.docId = docId;
            return this;
        }

        public Builder attachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
            return this;
        }

        public Builder attachment(InputStream attachment) {
            this.attachment = attachment;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder rev(String rev) {
            this.rev = rev;
            return this;
        }

        public Builder attachment(File attachment) throws FileNotFoundException {
            this.attachment = new FileInputStream(attachment);
            return this;
        }
    }
}

