/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.cloudant.v1.model.AllDocsQuery;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class PostLocalDocsQueriesOptions
extends GenericModel {
    protected String db;
    protected List<AllDocsQuery> queries;
    protected String accept;

    protected PostLocalDocsQueriesOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        Validator.notNull((Object)builder.queries, (String)"queries cannot be null");
        this.db = builder.db;
        this.queries = builder.queries;
        this.accept = builder.accept;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public List<AllDocsQuery> queries() {
        return this.queries;
    }

    public String accept() {
        return this.accept;
    }

    public static class Builder {
        private String db;
        private List<AllDocsQuery> queries;
        private String accept;

        private Builder(PostLocalDocsQueriesOptions postLocalDocsQueriesOptions) {
            this.db = postLocalDocsQueriesOptions.db;
            this.queries = postLocalDocsQueriesOptions.queries;
            this.accept = postLocalDocsQueriesOptions.accept;
        }

        public Builder() {
        }

        public Builder(String db, List<AllDocsQuery> queries) {
            this.db = db;
            this.queries = queries;
        }

        public PostLocalDocsQueriesOptions build() {
            return new PostLocalDocsQueriesOptions(this);
        }

        public Builder addQueries(AllDocsQuery queries) {
            Validator.notNull((Object)((Object)queries), (String)"queries cannot be null");
            if (this.queries == null) {
                this.queries = new ArrayList<AllDocsQuery>();
            }
            this.queries.add(queries);
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder queries(List<AllDocsQuery> queries) {
            this.queries = queries;
            return this;
        }

        public Builder accept(String accept) {
            this.accept = accept;
            return this;
        }
    }
}

