/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.cloudant.v1.model.Document;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class PostDocumentOptions
extends GenericModel {
    protected String db;
    protected Document document;
    protected InputStream body;
    protected String contentType;
    protected String batch;

    protected PostDocumentOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        this.db = builder.db;
        this.document = builder.document;
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.batch = builder.batch;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public Document document() {
        return this.document;
    }

    public InputStream body() {
        return this.body;
    }

    public String contentType() {
        return this.contentType;
    }

    public String batch() {
        return this.batch;
    }

    public static class Builder {
        private String db;
        private Document document;
        private InputStream body;
        private String contentType;
        private String batch;

        private Builder(PostDocumentOptions postDocumentOptions) {
            this.db = postDocumentOptions.db;
            this.document = postDocumentOptions.document;
            this.body = postDocumentOptions.body;
            this.contentType = postDocumentOptions.contentType;
            this.batch = postDocumentOptions.batch;
        }

        public Builder() {
        }

        public Builder(String db) {
            this.db = db;
        }

        public PostDocumentOptions build() {
            return new PostDocumentOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder document(Document document) {
            this.document = document;
            return this;
        }

        public Builder body(InputStream body) {
            this.body = body;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder batch(String batch) {
            this.batch = batch;
            return this;
        }

        public Builder body(File body) throws FileNotFoundException {
            this.body = new FileInputStream(body);
            return this;
        }
    }

    public static interface Batch {
        public static final String OK = "ok";
    }
}

