/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class DeleteDocumentOptions
extends GenericModel {
    protected String db;
    protected String docId;
    protected String ifMatch;
    protected String batch;
    protected String rev;

    protected DeleteDocumentOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        Validator.notEmpty((String)builder.docId, (String)"docId cannot be empty");
        this.db = builder.db;
        this.docId = builder.docId;
        this.ifMatch = builder.ifMatch;
        this.batch = builder.batch;
        this.rev = builder.rev;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String docId() {
        return this.docId;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    public String batch() {
        return this.batch;
    }

    public String rev() {
        return this.rev;
    }

    public static class Builder {
        private String db;
        private String docId;
        private String ifMatch;
        private String batch;
        private String rev;

        private Builder(DeleteDocumentOptions deleteDocumentOptions) {
            this.db = deleteDocumentOptions.db;
            this.docId = deleteDocumentOptions.docId;
            this.ifMatch = deleteDocumentOptions.ifMatch;
            this.batch = deleteDocumentOptions.batch;
            this.rev = deleteDocumentOptions.rev;
        }

        public Builder() {
        }

        public Builder(String db, String docId) {
            this.db = db;
            this.docId = docId;
        }

        public DeleteDocumentOptions build() {
            return new DeleteDocumentOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder docId(String docId) {
            this.docId = docId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder batch(String batch) {
            this.batch = batch;
            return this;
        }

        public Builder rev(String rev) {
            this.rev = rev;
            return this;
        }
    }

    public static interface Batch {
        public static final String OK = "ok";
    }
}

