/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.cloudant.common.SdkCommon;
import com.ibm.cloud.cloudant.internal.CloudantBaseService;
import com.ibm.cloud.cloudant.internal.DelegatingAuthenticatorFactory;
import com.ibm.cloud.cloudant.v1.model.ActiveTask;
import com.ibm.cloud.cloudant.v1.model.AllDocsQueriesResult;
import com.ibm.cloud.cloudant.v1.model.AllDocsResult;
import com.ibm.cloud.cloudant.v1.model.ApiKeysResult;
import com.ibm.cloud.cloudant.v1.model.BulkGetResult;
import com.ibm.cloud.cloudant.v1.model.ChangesResult;
import com.ibm.cloud.cloudant.v1.model.CorsConfiguration;
import com.ibm.cloud.cloudant.v1.model.DatabaseInformation;
import com.ibm.cloud.cloudant.v1.model.DbUpdates;
import com.ibm.cloud.cloudant.v1.model.DbsInfoResult;
import com.ibm.cloud.cloudant.v1.model.DeleteAttachmentOptions;
import com.ibm.cloud.cloudant.v1.model.DeleteDatabaseOptions;
import com.ibm.cloud.cloudant.v1.model.DeleteDesignDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.DeleteDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.DeleteIamSessionOptions;
import com.ibm.cloud.cloudant.v1.model.DeleteIndexOptions;
import com.ibm.cloud.cloudant.v1.model.DeleteLocalDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.DeleteReplicationDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.DesignDocument;
import com.ibm.cloud.cloudant.v1.model.DesignDocumentInformation;
import com.ibm.cloud.cloudant.v1.model.Document;
import com.ibm.cloud.cloudant.v1.model.DocumentResult;
import com.ibm.cloud.cloudant.v1.model.DocumentShardInfo;
import com.ibm.cloud.cloudant.v1.model.EnsureFullCommitInformation;
import com.ibm.cloud.cloudant.v1.model.ExplainResult;
import com.ibm.cloud.cloudant.v1.model.FindResult;
import com.ibm.cloud.cloudant.v1.model.GeoIndexInformation;
import com.ibm.cloud.cloudant.v1.model.GeoResult;
import com.ibm.cloud.cloudant.v1.model.GetActiveTasksOptions;
import com.ibm.cloud.cloudant.v1.model.GetAllDbsOptions;
import com.ibm.cloud.cloudant.v1.model.GetAttachmentOptions;
import com.ibm.cloud.cloudant.v1.model.GetCorsInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetDatabaseInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetDbUpdatesOptions;
import com.ibm.cloud.cloudant.v1.model.GetDesignDocumentInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetDesignDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.GetDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.GetDocumentShardsInfoOptions;
import com.ibm.cloud.cloudant.v1.model.GetGeoIndexInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetGeoOptions;
import com.ibm.cloud.cloudant.v1.model.GetIamSessionInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetIndexesInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetLocalDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.GetMembershipInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetPartitionInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetReplicationDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.GetSchedulerDocsOptions;
import com.ibm.cloud.cloudant.v1.model.GetSchedulerDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.GetSchedulerJobOptions;
import com.ibm.cloud.cloudant.v1.model.GetSchedulerJobsOptions;
import com.ibm.cloud.cloudant.v1.model.GetSearchInfoOptions;
import com.ibm.cloud.cloudant.v1.model.GetSecurityOptions;
import com.ibm.cloud.cloudant.v1.model.GetServerInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetSessionInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetShardsInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetUpInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetUuidsOptions;
import com.ibm.cloud.cloudant.v1.model.HeadAttachmentOptions;
import com.ibm.cloud.cloudant.v1.model.HeadDatabaseOptions;
import com.ibm.cloud.cloudant.v1.model.HeadDesignDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.HeadDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.HeadReplicationDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.HeadSchedulerJobOptions;
import com.ibm.cloud.cloudant.v1.model.IamSessionInformation;
import com.ibm.cloud.cloudant.v1.model.IndexResult;
import com.ibm.cloud.cloudant.v1.model.IndexesInformation;
import com.ibm.cloud.cloudant.v1.model.MembershipInformation;
import com.ibm.cloud.cloudant.v1.model.MissingRevsResult;
import com.ibm.cloud.cloudant.v1.model.Ok;
import com.ibm.cloud.cloudant.v1.model.PartitionInformation;
import com.ibm.cloud.cloudant.v1.model.PostAllDocsOptions;
import com.ibm.cloud.cloudant.v1.model.PostAllDocsQueriesOptions;
import com.ibm.cloud.cloudant.v1.model.PostApiKeysOptions;
import com.ibm.cloud.cloudant.v1.model.PostBulkDocsOptions;
import com.ibm.cloud.cloudant.v1.model.PostBulkGetOptions;
import com.ibm.cloud.cloudant.v1.model.PostChangesOptions;
import com.ibm.cloud.cloudant.v1.model.PostDbsInfoOptions;
import com.ibm.cloud.cloudant.v1.model.PostDesignDocsOptions;
import com.ibm.cloud.cloudant.v1.model.PostDesignDocsQueriesOptions;
import com.ibm.cloud.cloudant.v1.model.PostDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.PostEnsureFullCommitOptions;
import com.ibm.cloud.cloudant.v1.model.PostExplainOptions;
import com.ibm.cloud.cloudant.v1.model.PostFindOptions;
import com.ibm.cloud.cloudant.v1.model.PostGeoCleanupOptions;
import com.ibm.cloud.cloudant.v1.model.PostIamSessionOptions;
import com.ibm.cloud.cloudant.v1.model.PostIndexOptions;
import com.ibm.cloud.cloudant.v1.model.PostLocalDocsOptions;
import com.ibm.cloud.cloudant.v1.model.PostLocalDocsQueriesOptions;
import com.ibm.cloud.cloudant.v1.model.PostMissingRevsOptions;
import com.ibm.cloud.cloudant.v1.model.PostPartitionAllDocsOptions;
import com.ibm.cloud.cloudant.v1.model.PostPartitionFindOptions;
import com.ibm.cloud.cloudant.v1.model.PostPartitionSearchOptions;
import com.ibm.cloud.cloudant.v1.model.PostPartitionViewOptions;
import com.ibm.cloud.cloudant.v1.model.PostReplicateOptions;
import com.ibm.cloud.cloudant.v1.model.PostRevsDiffOptions;
import com.ibm.cloud.cloudant.v1.model.PostSearchAnalyzeOptions;
import com.ibm.cloud.cloudant.v1.model.PostSearchOptions;
import com.ibm.cloud.cloudant.v1.model.PostViewOptions;
import com.ibm.cloud.cloudant.v1.model.PostViewQueriesOptions;
import com.ibm.cloud.cloudant.v1.model.PutAttachmentOptions;
import com.ibm.cloud.cloudant.v1.model.PutCloudantSecurityOptions;
import com.ibm.cloud.cloudant.v1.model.PutCorsConfigurationOptions;
import com.ibm.cloud.cloudant.v1.model.PutDatabaseOptions;
import com.ibm.cloud.cloudant.v1.model.PutDesignDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.PutDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.PutLocalDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.PutReplicationDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.PutSecurityOptions;
import com.ibm.cloud.cloudant.v1.model.ReplicationDocument;
import com.ibm.cloud.cloudant.v1.model.ReplicationResult;
import com.ibm.cloud.cloudant.v1.model.RevsDiff;
import com.ibm.cloud.cloudant.v1.model.SchedulerDocsResult;
import com.ibm.cloud.cloudant.v1.model.SchedulerDocument;
import com.ibm.cloud.cloudant.v1.model.SchedulerJob;
import com.ibm.cloud.cloudant.v1.model.SchedulerJobsResult;
import com.ibm.cloud.cloudant.v1.model.SearchAnalyzeResult;
import com.ibm.cloud.cloudant.v1.model.SearchInfoResult;
import com.ibm.cloud.cloudant.v1.model.SearchResult;
import com.ibm.cloud.cloudant.v1.model.Security;
import com.ibm.cloud.cloudant.v1.model.ServerInformation;
import com.ibm.cloud.cloudant.v1.model.SessionInformation;
import com.ibm.cloud.cloudant.v1.model.ShardsInformation;
import com.ibm.cloud.cloudant.v1.model.UpInformation;
import com.ibm.cloud.cloudant.v1.model.UuidsResult;
import com.ibm.cloud.cloudant.v1.model.ViewQueriesResult;
import com.ibm.cloud.cloudant.v1.model.ViewResult;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;

public class Cloudant
extends CloudantBaseService {
    public static final String DEFAULT_SERVICE_NAME = "cloudant";
    public static final String DEFAULT_SERVICE_URL = "http://localhost:5984";

    public static Cloudant newInstance() {
        return Cloudant.newInstance(DEFAULT_SERVICE_NAME);
    }

    public static Cloudant newInstance(String serviceName) {
        Authenticator authenticator = DelegatingAuthenticatorFactory.getAuthenticator((String)serviceName);
        Cloudant service = new Cloudant(serviceName, authenticator);
        service.configureService(serviceName);
        return service;
    }

    public Cloudant(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
    }

    public ServiceCall<ServerInformation> getServerInformation(GetServerInformationOptions getServerInformationOptions) {
        String[] pathSegments = new String[]{""};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getServerInformation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ServerInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ServerInformation> getServerInformation() {
        return this.getServerInformation(null);
    }

    public ServiceCall<MembershipInformation> getMembershipInformation(GetMembershipInformationOptions getMembershipInformationOptions) {
        String[] pathSegments = new String[]{"_membership"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getMembershipInformation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<MembershipInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<MembershipInformation> getMembershipInformation() {
        return this.getMembershipInformation(null);
    }

    public ServiceCall<UuidsResult> getUuids(GetUuidsOptions getUuidsOptions) {
        if (getUuidsOptions == null) {
            getUuidsOptions = new GetUuidsOptions.Builder().build();
        }
        String[] pathSegments = new String[]{"_uuids"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getUuids");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getUuidsOptions.count() != null) {
            builder.query(new Object[]{"count", String.valueOf(getUuidsOptions.count())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<UuidsResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<UuidsResult> getUuids() {
        return this.getUuids(null);
    }

    public ServiceCall<Void> headDatabase(HeadDatabaseOptions headDatabaseOptions) {
        Validator.notNull((Object)((Object)headDatabaseOptions), (String)"headDatabaseOptions cannot be null");
        String[] pathSegments = new String[]{""};
        String[] pathParameters = new String[]{headDatabaseOptions.db()};
        RequestBuilder builder = RequestBuilder.head((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"headDatabase");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<List<String>> getAllDbs(GetAllDbsOptions getAllDbsOptions) {
        if (getAllDbsOptions == null) {
            getAllDbsOptions = new GetAllDbsOptions.Builder().build();
        }
        String[] pathSegments = new String[]{"_all_dbs"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getAllDbs");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getAllDbsOptions.descending() != null) {
            builder.query(new Object[]{"descending", String.valueOf(getAllDbsOptions.descending())});
        }
        if (getAllDbsOptions.endkey() != null) {
            builder.query(new Object[]{"endkey", getAllDbsOptions.endkey()});
        }
        if (getAllDbsOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(getAllDbsOptions.limit())});
        }
        if (getAllDbsOptions.skip() != null) {
            builder.query(new Object[]{"skip", String.valueOf(getAllDbsOptions.skip())});
        }
        if (getAllDbsOptions.startkey() != null) {
            builder.query(new Object[]{"startkey", getAllDbsOptions.startkey()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<List<String>>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<List<String>> getAllDbs() {
        return this.getAllDbs(null);
    }

    public ServiceCall<List<DbsInfoResult>> postDbsInfo(PostDbsInfoOptions postDbsInfoOptions) {
        boolean skipBody = false;
        if (postDbsInfoOptions == null) {
            postDbsInfoOptions = new PostDbsInfoOptions.Builder().build();
            skipBody = true;
        }
        String[] pathSegments = new String[]{"_dbs_info"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postDbsInfo");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (postDbsInfoOptions.keys() != null) {
                contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postDbsInfoOptions.keys()));
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<List<DbsInfoResult>>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<List<DbsInfoResult>> postDbsInfo() {
        return this.postDbsInfo(null);
    }

    public ServiceCall<Ok> deleteDatabase(DeleteDatabaseOptions deleteDatabaseOptions) {
        Validator.notNull((Object)((Object)deleteDatabaseOptions), (String)"deleteDatabaseOptions cannot be null");
        String[] pathSegments = new String[]{""};
        String[] pathParameters = new String[]{deleteDatabaseOptions.db()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteDatabase");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DatabaseInformation> getDatabaseInformation(GetDatabaseInformationOptions getDatabaseInformationOptions) {
        Validator.notNull((Object)((Object)getDatabaseInformationOptions), (String)"getDatabaseInformationOptions cannot be null");
        String[] pathSegments = new String[]{""};
        String[] pathParameters = new String[]{getDatabaseInformationOptions.db()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getDatabaseInformation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DatabaseInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Ok> putDatabase(PutDatabaseOptions putDatabaseOptions) {
        Validator.notNull((Object)((Object)putDatabaseOptions), (String)"putDatabaseOptions cannot be null");
        String[] pathSegments = new String[]{""};
        String[] pathParameters = new String[]{putDatabaseOptions.db()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"putDatabase");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (putDatabaseOptions.partitioned() != null) {
            builder.query(new Object[]{"partitioned", String.valueOf(putDatabaseOptions.partitioned())});
        }
        if (putDatabaseOptions.q() != null) {
            builder.query(new Object[]{"q", String.valueOf(putDatabaseOptions.q())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ChangesResult> postChanges(PostChangesOptions postChangesOptions) {
        Validator.notNull((Object)((Object)postChangesOptions), (String)"postChangesOptions cannot be null");
        String[] pathSegments = new String[]{"", "_changes"};
        String[] pathParameters = new String[]{postChangesOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postChanges");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (postChangesOptions.lastEventId() != null) {
            builder.header(new Object[]{"Last-Event-ID", postChangesOptions.lastEventId()});
        }
        if (postChangesOptions.attEncodingInfo() != null) {
            builder.query(new Object[]{"att_encoding_info", String.valueOf(postChangesOptions.attEncodingInfo())});
        }
        if (postChangesOptions.attachments() != null) {
            builder.query(new Object[]{"attachments", String.valueOf(postChangesOptions.attachments())});
        }
        if (postChangesOptions.conflicts() != null) {
            builder.query(new Object[]{"conflicts", String.valueOf(postChangesOptions.conflicts())});
        }
        if (postChangesOptions.descending() != null) {
            builder.query(new Object[]{"descending", String.valueOf(postChangesOptions.descending())});
        }
        if (postChangesOptions.feed() != null) {
            builder.query(new Object[]{"feed", postChangesOptions.feed()});
        }
        if (postChangesOptions.filter() != null) {
            builder.query(new Object[]{"filter", postChangesOptions.filter()});
        }
        if (postChangesOptions.heartbeat() != null) {
            builder.query(new Object[]{"heartbeat", String.valueOf(postChangesOptions.heartbeat())});
        }
        if (postChangesOptions.includeDocs() != null) {
            builder.query(new Object[]{"include_docs", String.valueOf(postChangesOptions.includeDocs())});
        }
        if (postChangesOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(postChangesOptions.limit())});
        }
        if (postChangesOptions.seqInterval() != null) {
            builder.query(new Object[]{"seq_interval", String.valueOf(postChangesOptions.seqInterval())});
        }
        if (postChangesOptions.since() != null) {
            builder.query(new Object[]{"since", postChangesOptions.since()});
        }
        if (postChangesOptions.style() != null) {
            builder.query(new Object[]{"style", postChangesOptions.style()});
        }
        if (postChangesOptions.timeout() != null) {
            builder.query(new Object[]{"timeout", String.valueOf(postChangesOptions.timeout())});
        }
        if (postChangesOptions.view() != null) {
            builder.query(new Object[]{"view", postChangesOptions.view()});
        }
        JsonObject contentJson = new JsonObject();
        if (postChangesOptions.docIds() != null) {
            contentJson.add("doc_ids", GsonSingleton.getGson().toJsonTree(postChangesOptions.docIds()));
        }
        if (postChangesOptions.selector() != null) {
            contentJson.add("selector", GsonSingleton.getGson().toJsonTree(postChangesOptions.selector()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ChangesResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postChangesAsStream(PostChangesOptions postChangesOptions) {
        Validator.notNull((Object)((Object)postChangesOptions), (String)"postChangesOptions cannot be null");
        String[] pathSegments = new String[]{"", "_changes"};
        String[] pathParameters = new String[]{postChangesOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postChangesAsStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (postChangesOptions.lastEventId() != null) {
            builder.header(new Object[]{"Last-Event-ID", postChangesOptions.lastEventId()});
        }
        if (postChangesOptions.attEncodingInfo() != null) {
            builder.query(new Object[]{"att_encoding_info", String.valueOf(postChangesOptions.attEncodingInfo())});
        }
        if (postChangesOptions.attachments() != null) {
            builder.query(new Object[]{"attachments", String.valueOf(postChangesOptions.attachments())});
        }
        if (postChangesOptions.conflicts() != null) {
            builder.query(new Object[]{"conflicts", String.valueOf(postChangesOptions.conflicts())});
        }
        if (postChangesOptions.descending() != null) {
            builder.query(new Object[]{"descending", String.valueOf(postChangesOptions.descending())});
        }
        if (postChangesOptions.feed() != null) {
            builder.query(new Object[]{"feed", postChangesOptions.feed()});
        }
        if (postChangesOptions.filter() != null) {
            builder.query(new Object[]{"filter", postChangesOptions.filter()});
        }
        if (postChangesOptions.heartbeat() != null) {
            builder.query(new Object[]{"heartbeat", String.valueOf(postChangesOptions.heartbeat())});
        }
        if (postChangesOptions.includeDocs() != null) {
            builder.query(new Object[]{"include_docs", String.valueOf(postChangesOptions.includeDocs())});
        }
        if (postChangesOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(postChangesOptions.limit())});
        }
        if (postChangesOptions.seqInterval() != null) {
            builder.query(new Object[]{"seq_interval", String.valueOf(postChangesOptions.seqInterval())});
        }
        if (postChangesOptions.since() != null) {
            builder.query(new Object[]{"since", postChangesOptions.since()});
        }
        if (postChangesOptions.style() != null) {
            builder.query(new Object[]{"style", postChangesOptions.style()});
        }
        if (postChangesOptions.timeout() != null) {
            builder.query(new Object[]{"timeout", String.valueOf(postChangesOptions.timeout())});
        }
        if (postChangesOptions.view() != null) {
            builder.query(new Object[]{"view", postChangesOptions.view()});
        }
        JsonObject contentJson = new JsonObject();
        if (postChangesOptions.docIds() != null) {
            contentJson.add("doc_ids", GsonSingleton.getGson().toJsonTree(postChangesOptions.docIds()));
        }
        if (postChangesOptions.selector() != null) {
            contentJson.add("selector", GsonSingleton.getGson().toJsonTree(postChangesOptions.selector()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> headDocument(HeadDocumentOptions headDocumentOptions) {
        Validator.notNull((Object)((Object)headDocumentOptions), (String)"headDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"", ""};
        String[] pathParameters = new String[]{headDocumentOptions.db(), headDocumentOptions.docId()};
        RequestBuilder builder = RequestBuilder.head((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"headDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (headDocumentOptions.ifNoneMatch() != null) {
            builder.header(new Object[]{"If-None-Match", headDocumentOptions.ifNoneMatch()});
        }
        if (headDocumentOptions.latest() != null) {
            builder.query(new Object[]{"latest", String.valueOf(headDocumentOptions.latest())});
        }
        if (headDocumentOptions.rev() != null) {
            builder.query(new Object[]{"rev", headDocumentOptions.rev()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> postDocument(PostDocumentOptions postDocumentOptions) {
        Validator.notNull((Object)((Object)postDocumentOptions), (String)"postDocumentOptions cannot be null");
        String[] pathSegments = new String[]{""};
        String[] pathParameters = new String[]{postDocumentOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (postDocumentOptions.contentType() != null) {
            builder.header(new Object[]{"Content-Type", postDocumentOptions.contentType()});
        }
        if (postDocumentOptions.batch() != null) {
            builder.query(new Object[]{"batch", postDocumentOptions.batch()});
        }
        String contentType = postDocumentOptions.contentType() == null ? "application/json" : postDocumentOptions.contentType();
        builder.bodyContent(contentType, (Object)postDocumentOptions.document(), null, postDocumentOptions.body());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllDocsResult> postAllDocs(PostAllDocsOptions postAllDocsOptions) {
        Validator.notNull((Object)((Object)postAllDocsOptions), (String)"postAllDocsOptions cannot be null");
        String[] pathSegments = new String[]{"", "_all_docs"};
        String[] pathParameters = new String[]{postAllDocsOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postAllDocs");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postAllDocsOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postAllDocsOptions.attEncodingInfo());
        }
        if (postAllDocsOptions.attachments() != null) {
            contentJson.addProperty("attachments", postAllDocsOptions.attachments());
        }
        if (postAllDocsOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postAllDocsOptions.conflicts());
        }
        if (postAllDocsOptions.descending() != null) {
            contentJson.addProperty("descending", postAllDocsOptions.descending());
        }
        if (postAllDocsOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postAllDocsOptions.includeDocs());
        }
        if (postAllDocsOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postAllDocsOptions.inclusiveEnd());
        }
        if (postAllDocsOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postAllDocsOptions.limit());
        }
        if (postAllDocsOptions.skip() != null) {
            contentJson.addProperty("skip", (Number)postAllDocsOptions.skip());
        }
        if (postAllDocsOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postAllDocsOptions.updateSeq());
        }
        if (postAllDocsOptions.endkey() != null) {
            contentJson.addProperty("endkey", postAllDocsOptions.endkey());
        }
        if (postAllDocsOptions.key() != null) {
            contentJson.addProperty("key", postAllDocsOptions.key());
        }
        if (postAllDocsOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postAllDocsOptions.keys()));
        }
        if (postAllDocsOptions.startkey() != null) {
            contentJson.addProperty("startkey", postAllDocsOptions.startkey());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AllDocsResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postAllDocsAsStream(PostAllDocsOptions postAllDocsOptions) {
        Validator.notNull((Object)((Object)postAllDocsOptions), (String)"postAllDocsOptions cannot be null");
        String[] pathSegments = new String[]{"", "_all_docs"};
        String[] pathParameters = new String[]{postAllDocsOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postAllDocsAsStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postAllDocsOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postAllDocsOptions.attEncodingInfo());
        }
        if (postAllDocsOptions.attachments() != null) {
            contentJson.addProperty("attachments", postAllDocsOptions.attachments());
        }
        if (postAllDocsOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postAllDocsOptions.conflicts());
        }
        if (postAllDocsOptions.descending() != null) {
            contentJson.addProperty("descending", postAllDocsOptions.descending());
        }
        if (postAllDocsOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postAllDocsOptions.includeDocs());
        }
        if (postAllDocsOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postAllDocsOptions.inclusiveEnd());
        }
        if (postAllDocsOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postAllDocsOptions.limit());
        }
        if (postAllDocsOptions.skip() != null) {
            contentJson.addProperty("skip", (Number)postAllDocsOptions.skip());
        }
        if (postAllDocsOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postAllDocsOptions.updateSeq());
        }
        if (postAllDocsOptions.endkey() != null) {
            contentJson.addProperty("endkey", postAllDocsOptions.endkey());
        }
        if (postAllDocsOptions.key() != null) {
            contentJson.addProperty("key", postAllDocsOptions.key());
        }
        if (postAllDocsOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postAllDocsOptions.keys()));
        }
        if (postAllDocsOptions.startkey() != null) {
            contentJson.addProperty("startkey", postAllDocsOptions.startkey());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllDocsQueriesResult> postAllDocsQueries(PostAllDocsQueriesOptions postAllDocsQueriesOptions) {
        Validator.notNull((Object)((Object)postAllDocsQueriesOptions), (String)"postAllDocsQueriesOptions cannot be null");
        String[] pathSegments = new String[]{"", "_all_docs/queries"};
        String[] pathParameters = new String[]{postAllDocsQueriesOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postAllDocsQueries");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postAllDocsQueriesOptions.queries() != null) {
            contentJson.add("queries", GsonSingleton.getGson().toJsonTree(postAllDocsQueriesOptions.queries()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AllDocsQueriesResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postAllDocsQueriesAsStream(PostAllDocsQueriesOptions postAllDocsQueriesOptions) {
        Validator.notNull((Object)((Object)postAllDocsQueriesOptions), (String)"postAllDocsQueriesOptions cannot be null");
        String[] pathSegments = new String[]{"", "_all_docs/queries"};
        String[] pathParameters = new String[]{postAllDocsQueriesOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postAllDocsQueriesAsStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postAllDocsQueriesOptions.queries() != null) {
            contentJson.add("queries", GsonSingleton.getGson().toJsonTree(postAllDocsQueriesOptions.queries()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<List<DocumentResult>> postBulkDocs(PostBulkDocsOptions postBulkDocsOptions) {
        Validator.notNull((Object)((Object)postBulkDocsOptions), (String)"postBulkDocsOptions cannot be null");
        String[] pathSegments = new String[]{"", "_bulk_docs"};
        String[] pathParameters = new String[]{postBulkDocsOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postBulkDocs");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.bodyContent("application/json", (Object)postBulkDocsOptions.bulkDocs(), null, postBulkDocsOptions.body());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<List<DocumentResult>>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<BulkGetResult> postBulkGet(PostBulkGetOptions postBulkGetOptions) {
        Validator.notNull((Object)((Object)postBulkGetOptions), (String)"postBulkGetOptions cannot be null");
        String[] pathSegments = new String[]{"", "_bulk_get"};
        String[] pathParameters = new String[]{postBulkGetOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postBulkGet");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (postBulkGetOptions.attachments() != null) {
            builder.query(new Object[]{"attachments", String.valueOf(postBulkGetOptions.attachments())});
        }
        if (postBulkGetOptions.attEncodingInfo() != null) {
            builder.query(new Object[]{"att_encoding_info", String.valueOf(postBulkGetOptions.attEncodingInfo())});
        }
        if (postBulkGetOptions.latest() != null) {
            builder.query(new Object[]{"latest", String.valueOf(postBulkGetOptions.latest())});
        }
        if (postBulkGetOptions.revs() != null) {
            builder.query(new Object[]{"revs", String.valueOf(postBulkGetOptions.revs())});
        }
        JsonObject contentJson = new JsonObject();
        if (postBulkGetOptions.docs() != null) {
            contentJson.add("docs", GsonSingleton.getGson().toJsonTree(postBulkGetOptions.docs()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<BulkGetResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postBulkGetAsMixed(PostBulkGetOptions postBulkGetOptions) {
        Validator.notNull((Object)((Object)postBulkGetOptions), (String)"postBulkGetOptions cannot be null");
        String[] pathSegments = new String[]{"", "_bulk_get"};
        String[] pathParameters = new String[]{postBulkGetOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postBulkGetAsMixed");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "multipart/mixed"});
        if (postBulkGetOptions.attachments() != null) {
            builder.query(new Object[]{"attachments", String.valueOf(postBulkGetOptions.attachments())});
        }
        if (postBulkGetOptions.attEncodingInfo() != null) {
            builder.query(new Object[]{"att_encoding_info", String.valueOf(postBulkGetOptions.attEncodingInfo())});
        }
        if (postBulkGetOptions.latest() != null) {
            builder.query(new Object[]{"latest", String.valueOf(postBulkGetOptions.latest())});
        }
        if (postBulkGetOptions.revs() != null) {
            builder.query(new Object[]{"revs", String.valueOf(postBulkGetOptions.revs())});
        }
        JsonObject contentJson = new JsonObject();
        if (postBulkGetOptions.docs() != null) {
            contentJson.add("docs", GsonSingleton.getGson().toJsonTree(postBulkGetOptions.docs()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postBulkGetAsRelated(PostBulkGetOptions postBulkGetOptions) {
        Validator.notNull((Object)((Object)postBulkGetOptions), (String)"postBulkGetOptions cannot be null");
        String[] pathSegments = new String[]{"", "_bulk_get"};
        String[] pathParameters = new String[]{postBulkGetOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postBulkGetAsRelated");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "multipart/related"});
        if (postBulkGetOptions.attachments() != null) {
            builder.query(new Object[]{"attachments", String.valueOf(postBulkGetOptions.attachments())});
        }
        if (postBulkGetOptions.attEncodingInfo() != null) {
            builder.query(new Object[]{"att_encoding_info", String.valueOf(postBulkGetOptions.attEncodingInfo())});
        }
        if (postBulkGetOptions.latest() != null) {
            builder.query(new Object[]{"latest", String.valueOf(postBulkGetOptions.latest())});
        }
        if (postBulkGetOptions.revs() != null) {
            builder.query(new Object[]{"revs", String.valueOf(postBulkGetOptions.revs())});
        }
        JsonObject contentJson = new JsonObject();
        if (postBulkGetOptions.docs() != null) {
            contentJson.add("docs", GsonSingleton.getGson().toJsonTree(postBulkGetOptions.docs()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postBulkGetAsStream(PostBulkGetOptions postBulkGetOptions) {
        Validator.notNull((Object)((Object)postBulkGetOptions), (String)"postBulkGetOptions cannot be null");
        String[] pathSegments = new String[]{"", "_bulk_get"};
        String[] pathParameters = new String[]{postBulkGetOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postBulkGetAsStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (postBulkGetOptions.attachments() != null) {
            builder.query(new Object[]{"attachments", String.valueOf(postBulkGetOptions.attachments())});
        }
        if (postBulkGetOptions.attEncodingInfo() != null) {
            builder.query(new Object[]{"att_encoding_info", String.valueOf(postBulkGetOptions.attEncodingInfo())});
        }
        if (postBulkGetOptions.latest() != null) {
            builder.query(new Object[]{"latest", String.valueOf(postBulkGetOptions.latest())});
        }
        if (postBulkGetOptions.revs() != null) {
            builder.query(new Object[]{"revs", String.valueOf(postBulkGetOptions.revs())});
        }
        JsonObject contentJson = new JsonObject();
        if (postBulkGetOptions.docs() != null) {
            contentJson.add("docs", GsonSingleton.getGson().toJsonTree(postBulkGetOptions.docs()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> deleteDocument(DeleteDocumentOptions deleteDocumentOptions) {
        Validator.notNull((Object)((Object)deleteDocumentOptions), (String)"deleteDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"", ""};
        String[] pathParameters = new String[]{deleteDocumentOptions.db(), deleteDocumentOptions.docId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (deleteDocumentOptions.ifMatch() != null) {
            builder.header(new Object[]{"If-Match", deleteDocumentOptions.ifMatch()});
        }
        if (deleteDocumentOptions.batch() != null) {
            builder.query(new Object[]{"batch", deleteDocumentOptions.batch()});
        }
        if (deleteDocumentOptions.rev() != null) {
            builder.query(new Object[]{"rev", deleteDocumentOptions.rev()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Document> getDocument(GetDocumentOptions getDocumentOptions) {
        Validator.notNull((Object)((Object)getDocumentOptions), (String)"getDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"", ""};
        String[] pathParameters = new String[]{getDocumentOptions.db(), getDocumentOptions.docId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getDocumentOptions.ifNoneMatch() != null) {
            builder.header(new Object[]{"If-None-Match", getDocumentOptions.ifNoneMatch()});
        }
        if (getDocumentOptions.attachments() != null) {
            builder.query(new Object[]{"attachments", String.valueOf(getDocumentOptions.attachments())});
        }
        if (getDocumentOptions.attEncodingInfo() != null) {
            builder.query(new Object[]{"att_encoding_info", String.valueOf(getDocumentOptions.attEncodingInfo())});
        }
        if (getDocumentOptions.attsSince() != null) {
            builder.query(new Object[]{"atts_since", RequestUtils.join(getDocumentOptions.attsSince(), (String)",")});
        }
        if (getDocumentOptions.conflicts() != null) {
            builder.query(new Object[]{"conflicts", String.valueOf(getDocumentOptions.conflicts())});
        }
        if (getDocumentOptions.deletedConflicts() != null) {
            builder.query(new Object[]{"deleted_conflicts", String.valueOf(getDocumentOptions.deletedConflicts())});
        }
        if (getDocumentOptions.latest() != null) {
            builder.query(new Object[]{"latest", String.valueOf(getDocumentOptions.latest())});
        }
        if (getDocumentOptions.localSeq() != null) {
            builder.query(new Object[]{"local_seq", String.valueOf(getDocumentOptions.localSeq())});
        }
        if (getDocumentOptions.meta() != null) {
            builder.query(new Object[]{"meta", String.valueOf(getDocumentOptions.meta())});
        }
        if (getDocumentOptions.openRevs() != null) {
            builder.query(new Object[]{"open_revs", RequestUtils.join(getDocumentOptions.openRevs(), (String)",")});
        }
        if (getDocumentOptions.rev() != null) {
            builder.query(new Object[]{"rev", getDocumentOptions.rev()});
        }
        if (getDocumentOptions.revs() != null) {
            builder.query(new Object[]{"revs", String.valueOf(getDocumentOptions.revs())});
        }
        if (getDocumentOptions.revsInfo() != null) {
            builder.query(new Object[]{"revs_info", String.valueOf(getDocumentOptions.revsInfo())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Document>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> getDocumentAsMixed(GetDocumentOptions getDocumentOptions) {
        Validator.notNull((Object)((Object)getDocumentOptions), (String)"getDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"", ""};
        String[] pathParameters = new String[]{getDocumentOptions.db(), getDocumentOptions.docId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getDocumentAsMixed");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "multipart/mixed"});
        if (getDocumentOptions.ifNoneMatch() != null) {
            builder.header(new Object[]{"If-None-Match", getDocumentOptions.ifNoneMatch()});
        }
        if (getDocumentOptions.attachments() != null) {
            builder.query(new Object[]{"attachments", String.valueOf(getDocumentOptions.attachments())});
        }
        if (getDocumentOptions.attEncodingInfo() != null) {
            builder.query(new Object[]{"att_encoding_info", String.valueOf(getDocumentOptions.attEncodingInfo())});
        }
        if (getDocumentOptions.attsSince() != null) {
            builder.query(new Object[]{"atts_since", RequestUtils.join(getDocumentOptions.attsSince(), (String)",")});
        }
        if (getDocumentOptions.conflicts() != null) {
            builder.query(new Object[]{"conflicts", String.valueOf(getDocumentOptions.conflicts())});
        }
        if (getDocumentOptions.deletedConflicts() != null) {
            builder.query(new Object[]{"deleted_conflicts", String.valueOf(getDocumentOptions.deletedConflicts())});
        }
        if (getDocumentOptions.latest() != null) {
            builder.query(new Object[]{"latest", String.valueOf(getDocumentOptions.latest())});
        }
        if (getDocumentOptions.localSeq() != null) {
            builder.query(new Object[]{"local_seq", String.valueOf(getDocumentOptions.localSeq())});
        }
        if (getDocumentOptions.meta() != null) {
            builder.query(new Object[]{"meta", String.valueOf(getDocumentOptions.meta())});
        }
        if (getDocumentOptions.openRevs() != null) {
            builder.query(new Object[]{"open_revs", RequestUtils.join(getDocumentOptions.openRevs(), (String)",")});
        }
        if (getDocumentOptions.rev() != null) {
            builder.query(new Object[]{"rev", getDocumentOptions.rev()});
        }
        if (getDocumentOptions.revs() != null) {
            builder.query(new Object[]{"revs", String.valueOf(getDocumentOptions.revs())});
        }
        if (getDocumentOptions.revsInfo() != null) {
            builder.query(new Object[]{"revs_info", String.valueOf(getDocumentOptions.revsInfo())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> getDocumentAsRelated(GetDocumentOptions getDocumentOptions) {
        Validator.notNull((Object)((Object)getDocumentOptions), (String)"getDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"", ""};
        String[] pathParameters = new String[]{getDocumentOptions.db(), getDocumentOptions.docId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getDocumentAsRelated");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "multipart/related"});
        if (getDocumentOptions.ifNoneMatch() != null) {
            builder.header(new Object[]{"If-None-Match", getDocumentOptions.ifNoneMatch()});
        }
        if (getDocumentOptions.attachments() != null) {
            builder.query(new Object[]{"attachments", String.valueOf(getDocumentOptions.attachments())});
        }
        if (getDocumentOptions.attEncodingInfo() != null) {
            builder.query(new Object[]{"att_encoding_info", String.valueOf(getDocumentOptions.attEncodingInfo())});
        }
        if (getDocumentOptions.attsSince() != null) {
            builder.query(new Object[]{"atts_since", RequestUtils.join(getDocumentOptions.attsSince(), (String)",")});
        }
        if (getDocumentOptions.conflicts() != null) {
            builder.query(new Object[]{"conflicts", String.valueOf(getDocumentOptions.conflicts())});
        }
        if (getDocumentOptions.deletedConflicts() != null) {
            builder.query(new Object[]{"deleted_conflicts", String.valueOf(getDocumentOptions.deletedConflicts())});
        }
        if (getDocumentOptions.latest() != null) {
            builder.query(new Object[]{"latest", String.valueOf(getDocumentOptions.latest())});
        }
        if (getDocumentOptions.localSeq() != null) {
            builder.query(new Object[]{"local_seq", String.valueOf(getDocumentOptions.localSeq())});
        }
        if (getDocumentOptions.meta() != null) {
            builder.query(new Object[]{"meta", String.valueOf(getDocumentOptions.meta())});
        }
        if (getDocumentOptions.openRevs() != null) {
            builder.query(new Object[]{"open_revs", RequestUtils.join(getDocumentOptions.openRevs(), (String)",")});
        }
        if (getDocumentOptions.rev() != null) {
            builder.query(new Object[]{"rev", getDocumentOptions.rev()});
        }
        if (getDocumentOptions.revs() != null) {
            builder.query(new Object[]{"revs", String.valueOf(getDocumentOptions.revs())});
        }
        if (getDocumentOptions.revsInfo() != null) {
            builder.query(new Object[]{"revs_info", String.valueOf(getDocumentOptions.revsInfo())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> getDocumentAsStream(GetDocumentOptions getDocumentOptions) {
        Validator.notNull((Object)((Object)getDocumentOptions), (String)"getDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"", ""};
        String[] pathParameters = new String[]{getDocumentOptions.db(), getDocumentOptions.docId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getDocumentAsStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getDocumentOptions.ifNoneMatch() != null) {
            builder.header(new Object[]{"If-None-Match", getDocumentOptions.ifNoneMatch()});
        }
        if (getDocumentOptions.attachments() != null) {
            builder.query(new Object[]{"attachments", String.valueOf(getDocumentOptions.attachments())});
        }
        if (getDocumentOptions.attEncodingInfo() != null) {
            builder.query(new Object[]{"att_encoding_info", String.valueOf(getDocumentOptions.attEncodingInfo())});
        }
        if (getDocumentOptions.attsSince() != null) {
            builder.query(new Object[]{"atts_since", RequestUtils.join(getDocumentOptions.attsSince(), (String)",")});
        }
        if (getDocumentOptions.conflicts() != null) {
            builder.query(new Object[]{"conflicts", String.valueOf(getDocumentOptions.conflicts())});
        }
        if (getDocumentOptions.deletedConflicts() != null) {
            builder.query(new Object[]{"deleted_conflicts", String.valueOf(getDocumentOptions.deletedConflicts())});
        }
        if (getDocumentOptions.latest() != null) {
            builder.query(new Object[]{"latest", String.valueOf(getDocumentOptions.latest())});
        }
        if (getDocumentOptions.localSeq() != null) {
            builder.query(new Object[]{"local_seq", String.valueOf(getDocumentOptions.localSeq())});
        }
        if (getDocumentOptions.meta() != null) {
            builder.query(new Object[]{"meta", String.valueOf(getDocumentOptions.meta())});
        }
        if (getDocumentOptions.openRevs() != null) {
            builder.query(new Object[]{"open_revs", RequestUtils.join(getDocumentOptions.openRevs(), (String)",")});
        }
        if (getDocumentOptions.rev() != null) {
            builder.query(new Object[]{"rev", getDocumentOptions.rev()});
        }
        if (getDocumentOptions.revs() != null) {
            builder.query(new Object[]{"revs", String.valueOf(getDocumentOptions.revs())});
        }
        if (getDocumentOptions.revsInfo() != null) {
            builder.query(new Object[]{"revs_info", String.valueOf(getDocumentOptions.revsInfo())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> putDocument(PutDocumentOptions putDocumentOptions) {
        Validator.notNull((Object)((Object)putDocumentOptions), (String)"putDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"", ""};
        String[] pathParameters = new String[]{putDocumentOptions.db(), putDocumentOptions.docId()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"putDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (putDocumentOptions.contentType() != null) {
            builder.header(new Object[]{"Content-Type", putDocumentOptions.contentType()});
        }
        if (putDocumentOptions.ifMatch() != null) {
            builder.header(new Object[]{"If-Match", putDocumentOptions.ifMatch()});
        }
        if (putDocumentOptions.batch() != null) {
            builder.query(new Object[]{"batch", putDocumentOptions.batch()});
        }
        if (putDocumentOptions.newEdits() != null) {
            builder.query(new Object[]{"new_edits", String.valueOf(putDocumentOptions.newEdits())});
        }
        if (putDocumentOptions.rev() != null) {
            builder.query(new Object[]{"rev", putDocumentOptions.rev()});
        }
        String contentType = putDocumentOptions.contentType() == null ? "application/json" : putDocumentOptions.contentType();
        builder.bodyContent(contentType, (Object)putDocumentOptions.document(), null, putDocumentOptions.body());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> headDesignDocument(HeadDesignDocumentOptions headDesignDocumentOptions) {
        Validator.notNull((Object)((Object)headDesignDocumentOptions), (String)"headDesignDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design"};
        String[] pathParameters = new String[]{headDesignDocumentOptions.db(), headDesignDocumentOptions.ddoc()};
        RequestBuilder builder = RequestBuilder.head((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"headDesignDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (headDesignDocumentOptions.ifNoneMatch() != null) {
            builder.header(new Object[]{"If-None-Match", headDesignDocumentOptions.ifNoneMatch()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> deleteDesignDocument(DeleteDesignDocumentOptions deleteDesignDocumentOptions) {
        Validator.notNull((Object)((Object)deleteDesignDocumentOptions), (String)"deleteDesignDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design"};
        String[] pathParameters = new String[]{deleteDesignDocumentOptions.db(), deleteDesignDocumentOptions.ddoc()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteDesignDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (deleteDesignDocumentOptions.ifMatch() != null) {
            builder.header(new Object[]{"If-Match", deleteDesignDocumentOptions.ifMatch()});
        }
        if (deleteDesignDocumentOptions.batch() != null) {
            builder.query(new Object[]{"batch", deleteDesignDocumentOptions.batch()});
        }
        if (deleteDesignDocumentOptions.rev() != null) {
            builder.query(new Object[]{"rev", deleteDesignDocumentOptions.rev()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DesignDocument> getDesignDocument(GetDesignDocumentOptions getDesignDocumentOptions) {
        Validator.notNull((Object)((Object)getDesignDocumentOptions), (String)"getDesignDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design"};
        String[] pathParameters = new String[]{getDesignDocumentOptions.db(), getDesignDocumentOptions.ddoc()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getDesignDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getDesignDocumentOptions.ifNoneMatch() != null) {
            builder.header(new Object[]{"If-None-Match", getDesignDocumentOptions.ifNoneMatch()});
        }
        if (getDesignDocumentOptions.attachments() != null) {
            builder.query(new Object[]{"attachments", String.valueOf(getDesignDocumentOptions.attachments())});
        }
        if (getDesignDocumentOptions.attEncodingInfo() != null) {
            builder.query(new Object[]{"att_encoding_info", String.valueOf(getDesignDocumentOptions.attEncodingInfo())});
        }
        if (getDesignDocumentOptions.attsSince() != null) {
            builder.query(new Object[]{"atts_since", RequestUtils.join(getDesignDocumentOptions.attsSince(), (String)",")});
        }
        if (getDesignDocumentOptions.conflicts() != null) {
            builder.query(new Object[]{"conflicts", String.valueOf(getDesignDocumentOptions.conflicts())});
        }
        if (getDesignDocumentOptions.deletedConflicts() != null) {
            builder.query(new Object[]{"deleted_conflicts", String.valueOf(getDesignDocumentOptions.deletedConflicts())});
        }
        if (getDesignDocumentOptions.latest() != null) {
            builder.query(new Object[]{"latest", String.valueOf(getDesignDocumentOptions.latest())});
        }
        if (getDesignDocumentOptions.localSeq() != null) {
            builder.query(new Object[]{"local_seq", String.valueOf(getDesignDocumentOptions.localSeq())});
        }
        if (getDesignDocumentOptions.meta() != null) {
            builder.query(new Object[]{"meta", String.valueOf(getDesignDocumentOptions.meta())});
        }
        if (getDesignDocumentOptions.openRevs() != null) {
            builder.query(new Object[]{"open_revs", RequestUtils.join(getDesignDocumentOptions.openRevs(), (String)",")});
        }
        if (getDesignDocumentOptions.rev() != null) {
            builder.query(new Object[]{"rev", getDesignDocumentOptions.rev()});
        }
        if (getDesignDocumentOptions.revs() != null) {
            builder.query(new Object[]{"revs", String.valueOf(getDesignDocumentOptions.revs())});
        }
        if (getDesignDocumentOptions.revsInfo() != null) {
            builder.query(new Object[]{"revs_info", String.valueOf(getDesignDocumentOptions.revsInfo())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DesignDocument>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> putDesignDocument(PutDesignDocumentOptions putDesignDocumentOptions) {
        Validator.notNull((Object)((Object)putDesignDocumentOptions), (String)"putDesignDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design"};
        String[] pathParameters = new String[]{putDesignDocumentOptions.db(), putDesignDocumentOptions.ddoc()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"putDesignDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (putDesignDocumentOptions.ifMatch() != null) {
            builder.header(new Object[]{"If-Match", putDesignDocumentOptions.ifMatch()});
        }
        if (putDesignDocumentOptions.batch() != null) {
            builder.query(new Object[]{"batch", putDesignDocumentOptions.batch()});
        }
        if (putDesignDocumentOptions.newEdits() != null) {
            builder.query(new Object[]{"new_edits", String.valueOf(putDesignDocumentOptions.newEdits())});
        }
        if (putDesignDocumentOptions.rev() != null) {
            builder.query(new Object[]{"rev", putDesignDocumentOptions.rev()});
        }
        if (putDesignDocumentOptions.designDocument() != null) {
            builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson((Object)putDesignDocumentOptions.designDocument()), "application/json");
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DesignDocumentInformation> getDesignDocumentInformation(GetDesignDocumentInformationOptions getDesignDocumentInformationOptions) {
        Validator.notNull((Object)((Object)getDesignDocumentInformationOptions), (String)"getDesignDocumentInformationOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design", "_info"};
        String[] pathParameters = new String[]{getDesignDocumentInformationOptions.db(), getDesignDocumentInformationOptions.ddoc()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getDesignDocumentInformation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DesignDocumentInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllDocsResult> postDesignDocs(PostDesignDocsOptions postDesignDocsOptions) {
        Validator.notNull((Object)((Object)postDesignDocsOptions), (String)"postDesignDocsOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design_docs"};
        String[] pathParameters = new String[]{postDesignDocsOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postDesignDocs");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (postDesignDocsOptions.accept() != null) {
            builder.header(new Object[]{"Accept", postDesignDocsOptions.accept()});
        }
        JsonObject contentJson = new JsonObject();
        if (postDesignDocsOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postDesignDocsOptions.attEncodingInfo());
        }
        if (postDesignDocsOptions.attachments() != null) {
            contentJson.addProperty("attachments", postDesignDocsOptions.attachments());
        }
        if (postDesignDocsOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postDesignDocsOptions.conflicts());
        }
        if (postDesignDocsOptions.descending() != null) {
            contentJson.addProperty("descending", postDesignDocsOptions.descending());
        }
        if (postDesignDocsOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postDesignDocsOptions.includeDocs());
        }
        if (postDesignDocsOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postDesignDocsOptions.inclusiveEnd());
        }
        if (postDesignDocsOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postDesignDocsOptions.limit());
        }
        if (postDesignDocsOptions.skip() != null) {
            contentJson.addProperty("skip", (Number)postDesignDocsOptions.skip());
        }
        if (postDesignDocsOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postDesignDocsOptions.updateSeq());
        }
        if (postDesignDocsOptions.endkey() != null) {
            contentJson.addProperty("endkey", postDesignDocsOptions.endkey());
        }
        if (postDesignDocsOptions.key() != null) {
            contentJson.addProperty("key", postDesignDocsOptions.key());
        }
        if (postDesignDocsOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postDesignDocsOptions.keys()));
        }
        if (postDesignDocsOptions.startkey() != null) {
            contentJson.addProperty("startkey", postDesignDocsOptions.startkey());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AllDocsResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllDocsQueriesResult> postDesignDocsQueries(PostDesignDocsQueriesOptions postDesignDocsQueriesOptions) {
        Validator.notNull((Object)((Object)postDesignDocsQueriesOptions), (String)"postDesignDocsQueriesOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design_docs/queries"};
        String[] pathParameters = new String[]{postDesignDocsQueriesOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postDesignDocsQueries");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (postDesignDocsQueriesOptions.accept() != null) {
            builder.header(new Object[]{"Accept", postDesignDocsQueriesOptions.accept()});
        }
        JsonObject contentJson = new JsonObject();
        if (postDesignDocsQueriesOptions.queries() != null) {
            contentJson.add("queries", GsonSingleton.getGson().toJsonTree(postDesignDocsQueriesOptions.queries()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AllDocsQueriesResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ViewResult> postView(PostViewOptions postViewOptions) {
        Validator.notNull((Object)((Object)postViewOptions), (String)"postViewOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design", "_view"};
        String[] pathParameters = new String[]{postViewOptions.db(), postViewOptions.ddoc(), postViewOptions.view()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postView");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postViewOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postViewOptions.attEncodingInfo());
        }
        if (postViewOptions.attachments() != null) {
            contentJson.addProperty("attachments", postViewOptions.attachments());
        }
        if (postViewOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postViewOptions.conflicts());
        }
        if (postViewOptions.descending() != null) {
            contentJson.addProperty("descending", postViewOptions.descending());
        }
        if (postViewOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postViewOptions.includeDocs());
        }
        if (postViewOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postViewOptions.inclusiveEnd());
        }
        if (postViewOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postViewOptions.limit());
        }
        if (postViewOptions.skip() != null) {
            contentJson.addProperty("skip", (Number)postViewOptions.skip());
        }
        if (postViewOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postViewOptions.updateSeq());
        }
        if (postViewOptions.endkey() != null) {
            contentJson.add("endkey", GsonSingleton.getGson().toJsonTree(postViewOptions.endkey()));
        }
        if (postViewOptions.endkeyDocid() != null) {
            contentJson.addProperty("endkey_docid", postViewOptions.endkeyDocid());
        }
        if (postViewOptions.group() != null) {
            contentJson.addProperty("group", postViewOptions.group());
        }
        if (postViewOptions.groupLevel() != null) {
            contentJson.addProperty("group_level", (Number)postViewOptions.groupLevel());
        }
        if (postViewOptions.key() != null) {
            contentJson.add("key", GsonSingleton.getGson().toJsonTree(postViewOptions.key()));
        }
        if (postViewOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postViewOptions.keys()));
        }
        if (postViewOptions.reduce() != null) {
            contentJson.addProperty("reduce", postViewOptions.reduce());
        }
        if (postViewOptions.stable() != null) {
            contentJson.addProperty("stable", postViewOptions.stable());
        }
        if (postViewOptions.startkey() != null) {
            contentJson.add("startkey", GsonSingleton.getGson().toJsonTree(postViewOptions.startkey()));
        }
        if (postViewOptions.startkeyDocid() != null) {
            contentJson.addProperty("startkey_docid", postViewOptions.startkeyDocid());
        }
        if (postViewOptions.update() != null) {
            contentJson.addProperty("update", postViewOptions.update());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ViewResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postViewAsStream(PostViewOptions postViewOptions) {
        Validator.notNull((Object)((Object)postViewOptions), (String)"postViewOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design", "_view"};
        String[] pathParameters = new String[]{postViewOptions.db(), postViewOptions.ddoc(), postViewOptions.view()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postViewAsStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postViewOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postViewOptions.attEncodingInfo());
        }
        if (postViewOptions.attachments() != null) {
            contentJson.addProperty("attachments", postViewOptions.attachments());
        }
        if (postViewOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postViewOptions.conflicts());
        }
        if (postViewOptions.descending() != null) {
            contentJson.addProperty("descending", postViewOptions.descending());
        }
        if (postViewOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postViewOptions.includeDocs());
        }
        if (postViewOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postViewOptions.inclusiveEnd());
        }
        if (postViewOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postViewOptions.limit());
        }
        if (postViewOptions.skip() != null) {
            contentJson.addProperty("skip", (Number)postViewOptions.skip());
        }
        if (postViewOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postViewOptions.updateSeq());
        }
        if (postViewOptions.endkey() != null) {
            contentJson.add("endkey", GsonSingleton.getGson().toJsonTree(postViewOptions.endkey()));
        }
        if (postViewOptions.endkeyDocid() != null) {
            contentJson.addProperty("endkey_docid", postViewOptions.endkeyDocid());
        }
        if (postViewOptions.group() != null) {
            contentJson.addProperty("group", postViewOptions.group());
        }
        if (postViewOptions.groupLevel() != null) {
            contentJson.addProperty("group_level", (Number)postViewOptions.groupLevel());
        }
        if (postViewOptions.key() != null) {
            contentJson.add("key", GsonSingleton.getGson().toJsonTree(postViewOptions.key()));
        }
        if (postViewOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postViewOptions.keys()));
        }
        if (postViewOptions.reduce() != null) {
            contentJson.addProperty("reduce", postViewOptions.reduce());
        }
        if (postViewOptions.stable() != null) {
            contentJson.addProperty("stable", postViewOptions.stable());
        }
        if (postViewOptions.startkey() != null) {
            contentJson.add("startkey", GsonSingleton.getGson().toJsonTree(postViewOptions.startkey()));
        }
        if (postViewOptions.startkeyDocid() != null) {
            contentJson.addProperty("startkey_docid", postViewOptions.startkeyDocid());
        }
        if (postViewOptions.update() != null) {
            contentJson.addProperty("update", postViewOptions.update());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ViewQueriesResult> postViewQueries(PostViewQueriesOptions postViewQueriesOptions) {
        Validator.notNull((Object)((Object)postViewQueriesOptions), (String)"postViewQueriesOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design", "_view", "queries"};
        String[] pathParameters = new String[]{postViewQueriesOptions.db(), postViewQueriesOptions.ddoc(), postViewQueriesOptions.view()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postViewQueries");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postViewQueriesOptions.queries() != null) {
            contentJson.add("queries", GsonSingleton.getGson().toJsonTree(postViewQueriesOptions.queries()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ViewQueriesResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postViewQueriesAsStream(PostViewQueriesOptions postViewQueriesOptions) {
        Validator.notNull((Object)((Object)postViewQueriesOptions), (String)"postViewQueriesOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design", "_view", "queries"};
        String[] pathParameters = new String[]{postViewQueriesOptions.db(), postViewQueriesOptions.ddoc(), postViewQueriesOptions.view()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postViewQueriesAsStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postViewQueriesOptions.queries() != null) {
            contentJson.add("queries", GsonSingleton.getGson().toJsonTree(postViewQueriesOptions.queries()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<PartitionInformation> getPartitionInformation(GetPartitionInformationOptions getPartitionInformationOptions) {
        Validator.notNull((Object)((Object)getPartitionInformationOptions), (String)"getPartitionInformationOptions cannot be null");
        String[] pathSegments = new String[]{"", "_partition"};
        String[] pathParameters = new String[]{getPartitionInformationOptions.db(), getPartitionInformationOptions.partitionKey()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getPartitionInformation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<PartitionInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllDocsResult> postPartitionAllDocs(PostPartitionAllDocsOptions postPartitionAllDocsOptions) {
        Validator.notNull((Object)((Object)postPartitionAllDocsOptions), (String)"postPartitionAllDocsOptions cannot be null");
        String[] pathSegments = new String[]{"", "_partition", "_all_docs"};
        String[] pathParameters = new String[]{postPartitionAllDocsOptions.db(), postPartitionAllDocsOptions.partitionKey()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postPartitionAllDocs");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postPartitionAllDocsOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postPartitionAllDocsOptions.attEncodingInfo());
        }
        if (postPartitionAllDocsOptions.attachments() != null) {
            contentJson.addProperty("attachments", postPartitionAllDocsOptions.attachments());
        }
        if (postPartitionAllDocsOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postPartitionAllDocsOptions.conflicts());
        }
        if (postPartitionAllDocsOptions.descending() != null) {
            contentJson.addProperty("descending", postPartitionAllDocsOptions.descending());
        }
        if (postPartitionAllDocsOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postPartitionAllDocsOptions.includeDocs());
        }
        if (postPartitionAllDocsOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postPartitionAllDocsOptions.inclusiveEnd());
        }
        if (postPartitionAllDocsOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postPartitionAllDocsOptions.limit());
        }
        if (postPartitionAllDocsOptions.skip() != null) {
            contentJson.addProperty("skip", (Number)postPartitionAllDocsOptions.skip());
        }
        if (postPartitionAllDocsOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postPartitionAllDocsOptions.updateSeq());
        }
        if (postPartitionAllDocsOptions.endkey() != null) {
            contentJson.addProperty("endkey", postPartitionAllDocsOptions.endkey());
        }
        if (postPartitionAllDocsOptions.key() != null) {
            contentJson.addProperty("key", postPartitionAllDocsOptions.key());
        }
        if (postPartitionAllDocsOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postPartitionAllDocsOptions.keys()));
        }
        if (postPartitionAllDocsOptions.startkey() != null) {
            contentJson.addProperty("startkey", postPartitionAllDocsOptions.startkey());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AllDocsResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postPartitionAllDocsAsStream(PostPartitionAllDocsOptions postPartitionAllDocsOptions) {
        Validator.notNull((Object)((Object)postPartitionAllDocsOptions), (String)"postPartitionAllDocsOptions cannot be null");
        String[] pathSegments = new String[]{"", "_partition", "_all_docs"};
        String[] pathParameters = new String[]{postPartitionAllDocsOptions.db(), postPartitionAllDocsOptions.partitionKey()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postPartitionAllDocsAsStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postPartitionAllDocsOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postPartitionAllDocsOptions.attEncodingInfo());
        }
        if (postPartitionAllDocsOptions.attachments() != null) {
            contentJson.addProperty("attachments", postPartitionAllDocsOptions.attachments());
        }
        if (postPartitionAllDocsOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postPartitionAllDocsOptions.conflicts());
        }
        if (postPartitionAllDocsOptions.descending() != null) {
            contentJson.addProperty("descending", postPartitionAllDocsOptions.descending());
        }
        if (postPartitionAllDocsOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postPartitionAllDocsOptions.includeDocs());
        }
        if (postPartitionAllDocsOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postPartitionAllDocsOptions.inclusiveEnd());
        }
        if (postPartitionAllDocsOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postPartitionAllDocsOptions.limit());
        }
        if (postPartitionAllDocsOptions.skip() != null) {
            contentJson.addProperty("skip", (Number)postPartitionAllDocsOptions.skip());
        }
        if (postPartitionAllDocsOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postPartitionAllDocsOptions.updateSeq());
        }
        if (postPartitionAllDocsOptions.endkey() != null) {
            contentJson.addProperty("endkey", postPartitionAllDocsOptions.endkey());
        }
        if (postPartitionAllDocsOptions.key() != null) {
            contentJson.addProperty("key", postPartitionAllDocsOptions.key());
        }
        if (postPartitionAllDocsOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postPartitionAllDocsOptions.keys()));
        }
        if (postPartitionAllDocsOptions.startkey() != null) {
            contentJson.addProperty("startkey", postPartitionAllDocsOptions.startkey());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SearchResult> postPartitionSearch(PostPartitionSearchOptions postPartitionSearchOptions) {
        Validator.notNull((Object)((Object)postPartitionSearchOptions), (String)"postPartitionSearchOptions cannot be null");
        String[] pathSegments = new String[]{"", "_partition", "_design", "_search"};
        String[] pathParameters = new String[]{postPartitionSearchOptions.db(), postPartitionSearchOptions.partitionKey(), postPartitionSearchOptions.ddoc(), postPartitionSearchOptions.index()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postPartitionSearch");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postPartitionSearchOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postPartitionSearchOptions.bookmark());
        }
        if (postPartitionSearchOptions.highlightFields() != null) {
            contentJson.add("highlight_fields", GsonSingleton.getGson().toJsonTree(postPartitionSearchOptions.highlightFields()));
        }
        if (postPartitionSearchOptions.highlightNumber() != null) {
            contentJson.addProperty("highlight_number", (Number)postPartitionSearchOptions.highlightNumber());
        }
        if (postPartitionSearchOptions.highlightPostTag() != null) {
            contentJson.addProperty("highlight_post_tag", postPartitionSearchOptions.highlightPostTag());
        }
        if (postPartitionSearchOptions.highlightPreTag() != null) {
            contentJson.addProperty("highlight_pre_tag", postPartitionSearchOptions.highlightPreTag());
        }
        if (postPartitionSearchOptions.highlightSize() != null) {
            contentJson.addProperty("highlight_size", (Number)postPartitionSearchOptions.highlightSize());
        }
        if (postPartitionSearchOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postPartitionSearchOptions.includeDocs());
        }
        if (postPartitionSearchOptions.includeFields() != null) {
            contentJson.add("include_fields", GsonSingleton.getGson().toJsonTree(postPartitionSearchOptions.includeFields()));
        }
        if (postPartitionSearchOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postPartitionSearchOptions.limit());
        }
        if (postPartitionSearchOptions.query() != null) {
            contentJson.addProperty("query", postPartitionSearchOptions.query());
        }
        if (postPartitionSearchOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postPartitionSearchOptions.sort()));
        }
        if (postPartitionSearchOptions.stale() != null) {
            contentJson.addProperty("stale", postPartitionSearchOptions.stale());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SearchResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postPartitionSearchAsStream(PostPartitionSearchOptions postPartitionSearchOptions) {
        Validator.notNull((Object)((Object)postPartitionSearchOptions), (String)"postPartitionSearchOptions cannot be null");
        String[] pathSegments = new String[]{"", "_partition", "_design", "_search"};
        String[] pathParameters = new String[]{postPartitionSearchOptions.db(), postPartitionSearchOptions.partitionKey(), postPartitionSearchOptions.ddoc(), postPartitionSearchOptions.index()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postPartitionSearchAsStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postPartitionSearchOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postPartitionSearchOptions.bookmark());
        }
        if (postPartitionSearchOptions.highlightFields() != null) {
            contentJson.add("highlight_fields", GsonSingleton.getGson().toJsonTree(postPartitionSearchOptions.highlightFields()));
        }
        if (postPartitionSearchOptions.highlightNumber() != null) {
            contentJson.addProperty("highlight_number", (Number)postPartitionSearchOptions.highlightNumber());
        }
        if (postPartitionSearchOptions.highlightPostTag() != null) {
            contentJson.addProperty("highlight_post_tag", postPartitionSearchOptions.highlightPostTag());
        }
        if (postPartitionSearchOptions.highlightPreTag() != null) {
            contentJson.addProperty("highlight_pre_tag", postPartitionSearchOptions.highlightPreTag());
        }
        if (postPartitionSearchOptions.highlightSize() != null) {
            contentJson.addProperty("highlight_size", (Number)postPartitionSearchOptions.highlightSize());
        }
        if (postPartitionSearchOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postPartitionSearchOptions.includeDocs());
        }
        if (postPartitionSearchOptions.includeFields() != null) {
            contentJson.add("include_fields", GsonSingleton.getGson().toJsonTree(postPartitionSearchOptions.includeFields()));
        }
        if (postPartitionSearchOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postPartitionSearchOptions.limit());
        }
        if (postPartitionSearchOptions.query() != null) {
            contentJson.addProperty("query", postPartitionSearchOptions.query());
        }
        if (postPartitionSearchOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postPartitionSearchOptions.sort()));
        }
        if (postPartitionSearchOptions.stale() != null) {
            contentJson.addProperty("stale", postPartitionSearchOptions.stale());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ViewResult> postPartitionView(PostPartitionViewOptions postPartitionViewOptions) {
        Validator.notNull((Object)((Object)postPartitionViewOptions), (String)"postPartitionViewOptions cannot be null");
        String[] pathSegments = new String[]{"", "_partition", "_design", "_view"};
        String[] pathParameters = new String[]{postPartitionViewOptions.db(), postPartitionViewOptions.partitionKey(), postPartitionViewOptions.ddoc(), postPartitionViewOptions.view()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postPartitionView");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postPartitionViewOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postPartitionViewOptions.attEncodingInfo());
        }
        if (postPartitionViewOptions.attachments() != null) {
            contentJson.addProperty("attachments", postPartitionViewOptions.attachments());
        }
        if (postPartitionViewOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postPartitionViewOptions.conflicts());
        }
        if (postPartitionViewOptions.descending() != null) {
            contentJson.addProperty("descending", postPartitionViewOptions.descending());
        }
        if (postPartitionViewOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postPartitionViewOptions.includeDocs());
        }
        if (postPartitionViewOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postPartitionViewOptions.inclusiveEnd());
        }
        if (postPartitionViewOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postPartitionViewOptions.limit());
        }
        if (postPartitionViewOptions.skip() != null) {
            contentJson.addProperty("skip", (Number)postPartitionViewOptions.skip());
        }
        if (postPartitionViewOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postPartitionViewOptions.updateSeq());
        }
        if (postPartitionViewOptions.endkey() != null) {
            contentJson.add("endkey", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.endkey()));
        }
        if (postPartitionViewOptions.endkeyDocid() != null) {
            contentJson.addProperty("endkey_docid", postPartitionViewOptions.endkeyDocid());
        }
        if (postPartitionViewOptions.group() != null) {
            contentJson.addProperty("group", postPartitionViewOptions.group());
        }
        if (postPartitionViewOptions.groupLevel() != null) {
            contentJson.addProperty("group_level", (Number)postPartitionViewOptions.groupLevel());
        }
        if (postPartitionViewOptions.key() != null) {
            contentJson.add("key", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.key()));
        }
        if (postPartitionViewOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.keys()));
        }
        if (postPartitionViewOptions.reduce() != null) {
            contentJson.addProperty("reduce", postPartitionViewOptions.reduce());
        }
        if (postPartitionViewOptions.stable() != null) {
            contentJson.addProperty("stable", postPartitionViewOptions.stable());
        }
        if (postPartitionViewOptions.startkey() != null) {
            contentJson.add("startkey", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.startkey()));
        }
        if (postPartitionViewOptions.startkeyDocid() != null) {
            contentJson.addProperty("startkey_docid", postPartitionViewOptions.startkeyDocid());
        }
        if (postPartitionViewOptions.update() != null) {
            contentJson.addProperty("update", postPartitionViewOptions.update());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ViewResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postPartitionViewAsStream(PostPartitionViewOptions postPartitionViewOptions) {
        Validator.notNull((Object)((Object)postPartitionViewOptions), (String)"postPartitionViewOptions cannot be null");
        String[] pathSegments = new String[]{"", "_partition", "_design", "_view"};
        String[] pathParameters = new String[]{postPartitionViewOptions.db(), postPartitionViewOptions.partitionKey(), postPartitionViewOptions.ddoc(), postPartitionViewOptions.view()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postPartitionViewAsStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postPartitionViewOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postPartitionViewOptions.attEncodingInfo());
        }
        if (postPartitionViewOptions.attachments() != null) {
            contentJson.addProperty("attachments", postPartitionViewOptions.attachments());
        }
        if (postPartitionViewOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postPartitionViewOptions.conflicts());
        }
        if (postPartitionViewOptions.descending() != null) {
            contentJson.addProperty("descending", postPartitionViewOptions.descending());
        }
        if (postPartitionViewOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postPartitionViewOptions.includeDocs());
        }
        if (postPartitionViewOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postPartitionViewOptions.inclusiveEnd());
        }
        if (postPartitionViewOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postPartitionViewOptions.limit());
        }
        if (postPartitionViewOptions.skip() != null) {
            contentJson.addProperty("skip", (Number)postPartitionViewOptions.skip());
        }
        if (postPartitionViewOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postPartitionViewOptions.updateSeq());
        }
        if (postPartitionViewOptions.endkey() != null) {
            contentJson.add("endkey", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.endkey()));
        }
        if (postPartitionViewOptions.endkeyDocid() != null) {
            contentJson.addProperty("endkey_docid", postPartitionViewOptions.endkeyDocid());
        }
        if (postPartitionViewOptions.group() != null) {
            contentJson.addProperty("group", postPartitionViewOptions.group());
        }
        if (postPartitionViewOptions.groupLevel() != null) {
            contentJson.addProperty("group_level", (Number)postPartitionViewOptions.groupLevel());
        }
        if (postPartitionViewOptions.key() != null) {
            contentJson.add("key", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.key()));
        }
        if (postPartitionViewOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.keys()));
        }
        if (postPartitionViewOptions.reduce() != null) {
            contentJson.addProperty("reduce", postPartitionViewOptions.reduce());
        }
        if (postPartitionViewOptions.stable() != null) {
            contentJson.addProperty("stable", postPartitionViewOptions.stable());
        }
        if (postPartitionViewOptions.startkey() != null) {
            contentJson.add("startkey", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.startkey()));
        }
        if (postPartitionViewOptions.startkeyDocid() != null) {
            contentJson.addProperty("startkey_docid", postPartitionViewOptions.startkeyDocid());
        }
        if (postPartitionViewOptions.update() != null) {
            contentJson.addProperty("update", postPartitionViewOptions.update());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<FindResult> postPartitionFind(PostPartitionFindOptions postPartitionFindOptions) {
        Validator.notNull((Object)((Object)postPartitionFindOptions), (String)"postPartitionFindOptions cannot be null");
        String[] pathSegments = new String[]{"", "_partition", "_find"};
        String[] pathParameters = new String[]{postPartitionFindOptions.db(), postPartitionFindOptions.partitionKey()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postPartitionFind");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postPartitionFindOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postPartitionFindOptions.bookmark());
        }
        if (postPartitionFindOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postPartitionFindOptions.conflicts());
        }
        if (postPartitionFindOptions.executionStats() != null) {
            contentJson.addProperty("execution_stats", postPartitionFindOptions.executionStats());
        }
        if (postPartitionFindOptions.fields() != null) {
            contentJson.add("fields", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.fields()));
        }
        if (postPartitionFindOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postPartitionFindOptions.limit());
        }
        if (postPartitionFindOptions.selector() != null) {
            contentJson.add("selector", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.selector()));
        }
        if (postPartitionFindOptions.skip() != null) {
            contentJson.addProperty("skip", (Number)postPartitionFindOptions.skip());
        }
        if (postPartitionFindOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.sort()));
        }
        if (postPartitionFindOptions.stable() != null) {
            contentJson.addProperty("stable", postPartitionFindOptions.stable());
        }
        if (postPartitionFindOptions.update() != null) {
            contentJson.addProperty("update", postPartitionFindOptions.update());
        }
        if (postPartitionFindOptions.useIndex() != null) {
            contentJson.add("use_index", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.useIndex()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<FindResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postPartitionFindAsStream(PostPartitionFindOptions postPartitionFindOptions) {
        Validator.notNull((Object)((Object)postPartitionFindOptions), (String)"postPartitionFindOptions cannot be null");
        String[] pathSegments = new String[]{"", "_partition", "_find"};
        String[] pathParameters = new String[]{postPartitionFindOptions.db(), postPartitionFindOptions.partitionKey()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postPartitionFindAsStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postPartitionFindOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postPartitionFindOptions.bookmark());
        }
        if (postPartitionFindOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postPartitionFindOptions.conflicts());
        }
        if (postPartitionFindOptions.executionStats() != null) {
            contentJson.addProperty("execution_stats", postPartitionFindOptions.executionStats());
        }
        if (postPartitionFindOptions.fields() != null) {
            contentJson.add("fields", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.fields()));
        }
        if (postPartitionFindOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postPartitionFindOptions.limit());
        }
        if (postPartitionFindOptions.selector() != null) {
            contentJson.add("selector", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.selector()));
        }
        if (postPartitionFindOptions.skip() != null) {
            contentJson.addProperty("skip", (Number)postPartitionFindOptions.skip());
        }
        if (postPartitionFindOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.sort()));
        }
        if (postPartitionFindOptions.stable() != null) {
            contentJson.addProperty("stable", postPartitionFindOptions.stable());
        }
        if (postPartitionFindOptions.update() != null) {
            contentJson.addProperty("update", postPartitionFindOptions.update());
        }
        if (postPartitionFindOptions.useIndex() != null) {
            contentJson.add("use_index", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.useIndex()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ExplainResult> postExplain(PostExplainOptions postExplainOptions) {
        Validator.notNull((Object)((Object)postExplainOptions), (String)"postExplainOptions cannot be null");
        String[] pathSegments = new String[]{"", "_explain"};
        String[] pathParameters = new String[]{postExplainOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postExplain");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postExplainOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postExplainOptions.bookmark());
        }
        if (postExplainOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postExplainOptions.conflicts());
        }
        if (postExplainOptions.executionStats() != null) {
            contentJson.addProperty("execution_stats", postExplainOptions.executionStats());
        }
        if (postExplainOptions.fields() != null) {
            contentJson.add("fields", GsonSingleton.getGson().toJsonTree(postExplainOptions.fields()));
        }
        if (postExplainOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postExplainOptions.limit());
        }
        if (postExplainOptions.selector() != null) {
            contentJson.add("selector", GsonSingleton.getGson().toJsonTree(postExplainOptions.selector()));
        }
        if (postExplainOptions.skip() != null) {
            contentJson.addProperty("skip", (Number)postExplainOptions.skip());
        }
        if (postExplainOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postExplainOptions.sort()));
        }
        if (postExplainOptions.stable() != null) {
            contentJson.addProperty("stable", postExplainOptions.stable());
        }
        if (postExplainOptions.update() != null) {
            contentJson.addProperty("update", postExplainOptions.update());
        }
        if (postExplainOptions.useIndex() != null) {
            contentJson.add("use_index", GsonSingleton.getGson().toJsonTree(postExplainOptions.useIndex()));
        }
        if (postExplainOptions.r() != null) {
            contentJson.addProperty("r", (Number)postExplainOptions.r());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ExplainResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<FindResult> postFind(PostFindOptions postFindOptions) {
        Validator.notNull((Object)((Object)postFindOptions), (String)"postFindOptions cannot be null");
        String[] pathSegments = new String[]{"", "_find"};
        String[] pathParameters = new String[]{postFindOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postFind");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postFindOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postFindOptions.bookmark());
        }
        if (postFindOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postFindOptions.conflicts());
        }
        if (postFindOptions.executionStats() != null) {
            contentJson.addProperty("execution_stats", postFindOptions.executionStats());
        }
        if (postFindOptions.fields() != null) {
            contentJson.add("fields", GsonSingleton.getGson().toJsonTree(postFindOptions.fields()));
        }
        if (postFindOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postFindOptions.limit());
        }
        if (postFindOptions.selector() != null) {
            contentJson.add("selector", GsonSingleton.getGson().toJsonTree(postFindOptions.selector()));
        }
        if (postFindOptions.skip() != null) {
            contentJson.addProperty("skip", (Number)postFindOptions.skip());
        }
        if (postFindOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postFindOptions.sort()));
        }
        if (postFindOptions.stable() != null) {
            contentJson.addProperty("stable", postFindOptions.stable());
        }
        if (postFindOptions.update() != null) {
            contentJson.addProperty("update", postFindOptions.update());
        }
        if (postFindOptions.useIndex() != null) {
            contentJson.add("use_index", GsonSingleton.getGson().toJsonTree(postFindOptions.useIndex()));
        }
        if (postFindOptions.r() != null) {
            contentJson.addProperty("r", (Number)postFindOptions.r());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<FindResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postFindAsStream(PostFindOptions postFindOptions) {
        Validator.notNull((Object)((Object)postFindOptions), (String)"postFindOptions cannot be null");
        String[] pathSegments = new String[]{"", "_find"};
        String[] pathParameters = new String[]{postFindOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postFindAsStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postFindOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postFindOptions.bookmark());
        }
        if (postFindOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postFindOptions.conflicts());
        }
        if (postFindOptions.executionStats() != null) {
            contentJson.addProperty("execution_stats", postFindOptions.executionStats());
        }
        if (postFindOptions.fields() != null) {
            contentJson.add("fields", GsonSingleton.getGson().toJsonTree(postFindOptions.fields()));
        }
        if (postFindOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postFindOptions.limit());
        }
        if (postFindOptions.selector() != null) {
            contentJson.add("selector", GsonSingleton.getGson().toJsonTree(postFindOptions.selector()));
        }
        if (postFindOptions.skip() != null) {
            contentJson.addProperty("skip", (Number)postFindOptions.skip());
        }
        if (postFindOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postFindOptions.sort()));
        }
        if (postFindOptions.stable() != null) {
            contentJson.addProperty("stable", postFindOptions.stable());
        }
        if (postFindOptions.update() != null) {
            contentJson.addProperty("update", postFindOptions.update());
        }
        if (postFindOptions.useIndex() != null) {
            contentJson.add("use_index", GsonSingleton.getGson().toJsonTree(postFindOptions.useIndex()));
        }
        if (postFindOptions.r() != null) {
            contentJson.addProperty("r", (Number)postFindOptions.r());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<IndexesInformation> getIndexesInformation(GetIndexesInformationOptions getIndexesInformationOptions) {
        Validator.notNull((Object)((Object)getIndexesInformationOptions), (String)"getIndexesInformationOptions cannot be null");
        String[] pathSegments = new String[]{"", "_index"};
        String[] pathParameters = new String[]{getIndexesInformationOptions.db()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getIndexesInformation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<IndexesInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<IndexResult> postIndex(PostIndexOptions postIndexOptions) {
        Validator.notNull((Object)((Object)postIndexOptions), (String)"postIndexOptions cannot be null");
        String[] pathSegments = new String[]{"", "_index"};
        String[] pathParameters = new String[]{postIndexOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postIndex");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postIndexOptions.ddoc() != null) {
            contentJson.addProperty("ddoc", postIndexOptions.ddoc());
        }
        if (postIndexOptions.def() != null) {
            contentJson.add("def", GsonSingleton.getGson().toJsonTree((Object)postIndexOptions.def()));
        }
        if (postIndexOptions.index() != null) {
            contentJson.add("index", GsonSingleton.getGson().toJsonTree((Object)postIndexOptions.index()));
        }
        if (postIndexOptions.name() != null) {
            contentJson.addProperty("name", postIndexOptions.name());
        }
        if (postIndexOptions.partialFilterSelector() != null) {
            contentJson.add("partial_filter_selector", GsonSingleton.getGson().toJsonTree(postIndexOptions.partialFilterSelector()));
        }
        if (postIndexOptions.partitioned() != null) {
            contentJson.addProperty("partitioned", postIndexOptions.partitioned());
        }
        if (postIndexOptions.type() != null) {
            contentJson.addProperty("type", postIndexOptions.type());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<IndexResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Ok> deleteIndex(DeleteIndexOptions deleteIndexOptions) {
        Validator.notNull((Object)((Object)deleteIndexOptions), (String)"deleteIndexOptions cannot be null");
        String[] pathSegments = new String[]{"", "_index/_design", "", ""};
        String[] pathParameters = new String[]{deleteIndexOptions.db(), deleteIndexOptions.ddoc(), deleteIndexOptions.type(), deleteIndexOptions.index()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteIndex");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SearchAnalyzeResult> postSearchAnalyze(PostSearchAnalyzeOptions postSearchAnalyzeOptions) {
        boolean skipBody = false;
        if (postSearchAnalyzeOptions == null) {
            postSearchAnalyzeOptions = new PostSearchAnalyzeOptions.Builder().build();
            skipBody = true;
        }
        String[] pathSegments = new String[]{"_search_analyze"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postSearchAnalyze");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (postSearchAnalyzeOptions.analyzer() != null) {
                contentJson.addProperty("analyzer", postSearchAnalyzeOptions.analyzer());
            }
            if (postSearchAnalyzeOptions.text() != null) {
                contentJson.addProperty("text", postSearchAnalyzeOptions.text());
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SearchAnalyzeResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SearchAnalyzeResult> postSearchAnalyze() {
        return this.postSearchAnalyze(null);
    }

    public ServiceCall<SearchResult> postSearch(PostSearchOptions postSearchOptions) {
        Validator.notNull((Object)((Object)postSearchOptions), (String)"postSearchOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design", "_search"};
        String[] pathParameters = new String[]{postSearchOptions.db(), postSearchOptions.ddoc(), postSearchOptions.index()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postSearch");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postSearchOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postSearchOptions.bookmark());
        }
        if (postSearchOptions.highlightFields() != null) {
            contentJson.add("highlight_fields", GsonSingleton.getGson().toJsonTree(postSearchOptions.highlightFields()));
        }
        if (postSearchOptions.highlightNumber() != null) {
            contentJson.addProperty("highlight_number", (Number)postSearchOptions.highlightNumber());
        }
        if (postSearchOptions.highlightPostTag() != null) {
            contentJson.addProperty("highlight_post_tag", postSearchOptions.highlightPostTag());
        }
        if (postSearchOptions.highlightPreTag() != null) {
            contentJson.addProperty("highlight_pre_tag", postSearchOptions.highlightPreTag());
        }
        if (postSearchOptions.highlightSize() != null) {
            contentJson.addProperty("highlight_size", (Number)postSearchOptions.highlightSize());
        }
        if (postSearchOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postSearchOptions.includeDocs());
        }
        if (postSearchOptions.includeFields() != null) {
            contentJson.add("include_fields", GsonSingleton.getGson().toJsonTree(postSearchOptions.includeFields()));
        }
        if (postSearchOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postSearchOptions.limit());
        }
        if (postSearchOptions.query() != null) {
            contentJson.addProperty("query", postSearchOptions.query());
        }
        if (postSearchOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postSearchOptions.sort()));
        }
        if (postSearchOptions.stale() != null) {
            contentJson.addProperty("stale", postSearchOptions.stale());
        }
        if (postSearchOptions.counts() != null) {
            contentJson.add("counts", GsonSingleton.getGson().toJsonTree(postSearchOptions.counts()));
        }
        if (postSearchOptions.drilldown() != null) {
            contentJson.add("drilldown", GsonSingleton.getGson().toJsonTree(postSearchOptions.drilldown()));
        }
        if (postSearchOptions.groupField() != null) {
            contentJson.addProperty("group_field", postSearchOptions.groupField());
        }
        if (postSearchOptions.groupLimit() != null) {
            contentJson.addProperty("group_limit", (Number)postSearchOptions.groupLimit());
        }
        if (postSearchOptions.groupSort() != null) {
            contentJson.add("group_sort", GsonSingleton.getGson().toJsonTree(postSearchOptions.groupSort()));
        }
        if (postSearchOptions.ranges() != null) {
            contentJson.add("ranges", GsonSingleton.getGson().toJsonTree(postSearchOptions.ranges()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SearchResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postSearchAsStream(PostSearchOptions postSearchOptions) {
        Validator.notNull((Object)((Object)postSearchOptions), (String)"postSearchOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design", "_search"};
        String[] pathParameters = new String[]{postSearchOptions.db(), postSearchOptions.ddoc(), postSearchOptions.index()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postSearchAsStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (postSearchOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postSearchOptions.bookmark());
        }
        if (postSearchOptions.highlightFields() != null) {
            contentJson.add("highlight_fields", GsonSingleton.getGson().toJsonTree(postSearchOptions.highlightFields()));
        }
        if (postSearchOptions.highlightNumber() != null) {
            contentJson.addProperty("highlight_number", (Number)postSearchOptions.highlightNumber());
        }
        if (postSearchOptions.highlightPostTag() != null) {
            contentJson.addProperty("highlight_post_tag", postSearchOptions.highlightPostTag());
        }
        if (postSearchOptions.highlightPreTag() != null) {
            contentJson.addProperty("highlight_pre_tag", postSearchOptions.highlightPreTag());
        }
        if (postSearchOptions.highlightSize() != null) {
            contentJson.addProperty("highlight_size", (Number)postSearchOptions.highlightSize());
        }
        if (postSearchOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postSearchOptions.includeDocs());
        }
        if (postSearchOptions.includeFields() != null) {
            contentJson.add("include_fields", GsonSingleton.getGson().toJsonTree(postSearchOptions.includeFields()));
        }
        if (postSearchOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postSearchOptions.limit());
        }
        if (postSearchOptions.query() != null) {
            contentJson.addProperty("query", postSearchOptions.query());
        }
        if (postSearchOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postSearchOptions.sort()));
        }
        if (postSearchOptions.stale() != null) {
            contentJson.addProperty("stale", postSearchOptions.stale());
        }
        if (postSearchOptions.counts() != null) {
            contentJson.add("counts", GsonSingleton.getGson().toJsonTree(postSearchOptions.counts()));
        }
        if (postSearchOptions.drilldown() != null) {
            contentJson.add("drilldown", GsonSingleton.getGson().toJsonTree(postSearchOptions.drilldown()));
        }
        if (postSearchOptions.groupField() != null) {
            contentJson.addProperty("group_field", postSearchOptions.groupField());
        }
        if (postSearchOptions.groupLimit() != null) {
            contentJson.addProperty("group_limit", (Number)postSearchOptions.groupLimit());
        }
        if (postSearchOptions.groupSort() != null) {
            contentJson.add("group_sort", GsonSingleton.getGson().toJsonTree(postSearchOptions.groupSort()));
        }
        if (postSearchOptions.ranges() != null) {
            contentJson.add("ranges", GsonSingleton.getGson().toJsonTree(postSearchOptions.ranges()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SearchInfoResult> getSearchInfo(GetSearchInfoOptions getSearchInfoOptions) {
        Validator.notNull((Object)((Object)getSearchInfoOptions), (String)"getSearchInfoOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design", "_search_info"};
        String[] pathParameters = new String[]{getSearchInfoOptions.db(), getSearchInfoOptions.ddoc(), getSearchInfoOptions.index()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getSearchInfo");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SearchInfoResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<GeoResult> getGeo(GetGeoOptions getGeoOptions) {
        Validator.notNull((Object)((Object)getGeoOptions), (String)"getGeoOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design", "_geo"};
        String[] pathParameters = new String[]{getGeoOptions.db(), getGeoOptions.ddoc(), getGeoOptions.index()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getGeo");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getGeoOptions.bbox() != null) {
            builder.query(new Object[]{"bbox", getGeoOptions.bbox()});
        }
        if (getGeoOptions.bookmark() != null) {
            builder.query(new Object[]{"bookmark", getGeoOptions.bookmark()});
        }
        if (getGeoOptions.format() != null) {
            builder.query(new Object[]{"format", getGeoOptions.format()});
        }
        if (getGeoOptions.g() != null) {
            builder.query(new Object[]{"g", getGeoOptions.g()});
        }
        if (getGeoOptions.includeDocs() != null) {
            builder.query(new Object[]{"include_docs", String.valueOf(getGeoOptions.includeDocs())});
        }
        if (getGeoOptions.lat() != null) {
            builder.query(new Object[]{"lat", String.valueOf(getGeoOptions.lat())});
        }
        if (getGeoOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(getGeoOptions.limit())});
        }
        if (getGeoOptions.lon() != null) {
            builder.query(new Object[]{"lon", String.valueOf(getGeoOptions.lon())});
        }
        if (getGeoOptions.nearest() != null) {
            builder.query(new Object[]{"nearest", String.valueOf(getGeoOptions.nearest())});
        }
        if (getGeoOptions.radius() != null) {
            builder.query(new Object[]{"radius", String.valueOf(getGeoOptions.radius())});
        }
        if (getGeoOptions.rangex() != null) {
            builder.query(new Object[]{"rangex", String.valueOf(getGeoOptions.rangex())});
        }
        if (getGeoOptions.rangey() != null) {
            builder.query(new Object[]{"rangey", String.valueOf(getGeoOptions.rangey())});
        }
        if (getGeoOptions.relation() != null) {
            builder.query(new Object[]{"relation", getGeoOptions.relation()});
        }
        if (getGeoOptions.skip() != null) {
            builder.query(new Object[]{"skip", String.valueOf(getGeoOptions.skip())});
        }
        if (getGeoOptions.stale() != null) {
            builder.query(new Object[]{"stale", getGeoOptions.stale()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<GeoResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> getGeoAsStream(GetGeoOptions getGeoOptions) {
        Validator.notNull((Object)((Object)getGeoOptions), (String)"getGeoOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design", "_geo"};
        String[] pathParameters = new String[]{getGeoOptions.db(), getGeoOptions.ddoc(), getGeoOptions.index()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getGeoAsStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getGeoOptions.bbox() != null) {
            builder.query(new Object[]{"bbox", getGeoOptions.bbox()});
        }
        if (getGeoOptions.bookmark() != null) {
            builder.query(new Object[]{"bookmark", getGeoOptions.bookmark()});
        }
        if (getGeoOptions.format() != null) {
            builder.query(new Object[]{"format", getGeoOptions.format()});
        }
        if (getGeoOptions.g() != null) {
            builder.query(new Object[]{"g", getGeoOptions.g()});
        }
        if (getGeoOptions.includeDocs() != null) {
            builder.query(new Object[]{"include_docs", String.valueOf(getGeoOptions.includeDocs())});
        }
        if (getGeoOptions.lat() != null) {
            builder.query(new Object[]{"lat", String.valueOf(getGeoOptions.lat())});
        }
        if (getGeoOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(getGeoOptions.limit())});
        }
        if (getGeoOptions.lon() != null) {
            builder.query(new Object[]{"lon", String.valueOf(getGeoOptions.lon())});
        }
        if (getGeoOptions.nearest() != null) {
            builder.query(new Object[]{"nearest", String.valueOf(getGeoOptions.nearest())});
        }
        if (getGeoOptions.radius() != null) {
            builder.query(new Object[]{"radius", String.valueOf(getGeoOptions.radius())});
        }
        if (getGeoOptions.rangex() != null) {
            builder.query(new Object[]{"rangex", String.valueOf(getGeoOptions.rangex())});
        }
        if (getGeoOptions.rangey() != null) {
            builder.query(new Object[]{"rangey", String.valueOf(getGeoOptions.rangey())});
        }
        if (getGeoOptions.relation() != null) {
            builder.query(new Object[]{"relation", getGeoOptions.relation()});
        }
        if (getGeoOptions.skip() != null) {
            builder.query(new Object[]{"skip", String.valueOf(getGeoOptions.skip())});
        }
        if (getGeoOptions.stale() != null) {
            builder.query(new Object[]{"stale", getGeoOptions.stale()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Ok> postGeoCleanup(PostGeoCleanupOptions postGeoCleanupOptions) {
        Validator.notNull((Object)((Object)postGeoCleanupOptions), (String)"postGeoCleanupOptions cannot be null");
        String[] pathSegments = new String[]{"", "_geo_cleanup"};
        String[] pathParameters = new String[]{postGeoCleanupOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postGeoCleanup");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<GeoIndexInformation> getGeoIndexInformation(GetGeoIndexInformationOptions getGeoIndexInformationOptions) {
        Validator.notNull((Object)((Object)getGeoIndexInformationOptions), (String)"getGeoIndexInformationOptions cannot be null");
        String[] pathSegments = new String[]{"", "_design", "_geo_info"};
        String[] pathParameters = new String[]{getGeoIndexInformationOptions.db(), getGeoIndexInformationOptions.ddoc(), getGeoIndexInformationOptions.index()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getGeoIndexInformation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<GeoIndexInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DbUpdates> getDbUpdates(GetDbUpdatesOptions getDbUpdatesOptions) {
        if (getDbUpdatesOptions == null) {
            getDbUpdatesOptions = new GetDbUpdatesOptions.Builder().build();
        }
        String[] pathSegments = new String[]{"_db_updates"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getDbUpdates");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getDbUpdatesOptions.feed() != null) {
            builder.query(new Object[]{"feed", getDbUpdatesOptions.feed()});
        }
        if (getDbUpdatesOptions.heartbeat() != null) {
            builder.query(new Object[]{"heartbeat", String.valueOf(getDbUpdatesOptions.heartbeat())});
        }
        if (getDbUpdatesOptions.timeout() != null) {
            builder.query(new Object[]{"timeout", String.valueOf(getDbUpdatesOptions.timeout())});
        }
        if (getDbUpdatesOptions.since() != null) {
            builder.query(new Object[]{"since", getDbUpdatesOptions.since()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DbUpdates>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DbUpdates> getDbUpdates() {
        return this.getDbUpdates(null);
    }

    public ServiceCall<Void> headReplicationDocument(HeadReplicationDocumentOptions headReplicationDocumentOptions) {
        Validator.notNull((Object)((Object)headReplicationDocumentOptions), (String)"headReplicationDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"_replicator"};
        String[] pathParameters = new String[]{headReplicationDocumentOptions.docId()};
        RequestBuilder builder = RequestBuilder.head((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"headReplicationDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (headReplicationDocumentOptions.ifNoneMatch() != null) {
            builder.header(new Object[]{"If-None-Match", headReplicationDocumentOptions.ifNoneMatch()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> headSchedulerJob(HeadSchedulerJobOptions headSchedulerJobOptions) {
        Validator.notNull((Object)((Object)headSchedulerJobOptions), (String)"headSchedulerJobOptions cannot be null");
        String[] pathSegments = new String[]{"_scheduler/jobs"};
        String[] pathParameters = new String[]{headSchedulerJobOptions.jobId()};
        RequestBuilder builder = RequestBuilder.head((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"headSchedulerJob");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ReplicationResult> postReplicate(PostReplicateOptions postReplicateOptions) {
        if (postReplicateOptions == null) {
            postReplicateOptions = new PostReplicateOptions.Builder().build();
        }
        String[] pathSegments = new String[]{"_replicate"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postReplicate");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (postReplicateOptions.replicationDocument() != null) {
            builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson((Object)postReplicateOptions.replicationDocument()), "application/json");
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ReplicationResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ReplicationResult> postReplicate() {
        return this.postReplicate(null);
    }

    public ServiceCall<DocumentResult> deleteReplicationDocument(DeleteReplicationDocumentOptions deleteReplicationDocumentOptions) {
        Validator.notNull((Object)((Object)deleteReplicationDocumentOptions), (String)"deleteReplicationDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"_replicator"};
        String[] pathParameters = new String[]{deleteReplicationDocumentOptions.docId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteReplicationDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (deleteReplicationDocumentOptions.ifMatch() != null) {
            builder.header(new Object[]{"If-Match", deleteReplicationDocumentOptions.ifMatch()});
        }
        if (deleteReplicationDocumentOptions.batch() != null) {
            builder.query(new Object[]{"batch", deleteReplicationDocumentOptions.batch()});
        }
        if (deleteReplicationDocumentOptions.rev() != null) {
            builder.query(new Object[]{"rev", deleteReplicationDocumentOptions.rev()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ReplicationDocument> getReplicationDocument(GetReplicationDocumentOptions getReplicationDocumentOptions) {
        Validator.notNull((Object)((Object)getReplicationDocumentOptions), (String)"getReplicationDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"_replicator"};
        String[] pathParameters = new String[]{getReplicationDocumentOptions.docId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getReplicationDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getReplicationDocumentOptions.ifNoneMatch() != null) {
            builder.header(new Object[]{"If-None-Match", getReplicationDocumentOptions.ifNoneMatch()});
        }
        if (getReplicationDocumentOptions.attachments() != null) {
            builder.query(new Object[]{"attachments", String.valueOf(getReplicationDocumentOptions.attachments())});
        }
        if (getReplicationDocumentOptions.attEncodingInfo() != null) {
            builder.query(new Object[]{"att_encoding_info", String.valueOf(getReplicationDocumentOptions.attEncodingInfo())});
        }
        if (getReplicationDocumentOptions.attsSince() != null) {
            builder.query(new Object[]{"atts_since", RequestUtils.join(getReplicationDocumentOptions.attsSince(), (String)",")});
        }
        if (getReplicationDocumentOptions.conflicts() != null) {
            builder.query(new Object[]{"conflicts", String.valueOf(getReplicationDocumentOptions.conflicts())});
        }
        if (getReplicationDocumentOptions.deletedConflicts() != null) {
            builder.query(new Object[]{"deleted_conflicts", String.valueOf(getReplicationDocumentOptions.deletedConflicts())});
        }
        if (getReplicationDocumentOptions.latest() != null) {
            builder.query(new Object[]{"latest", String.valueOf(getReplicationDocumentOptions.latest())});
        }
        if (getReplicationDocumentOptions.localSeq() != null) {
            builder.query(new Object[]{"local_seq", String.valueOf(getReplicationDocumentOptions.localSeq())});
        }
        if (getReplicationDocumentOptions.meta() != null) {
            builder.query(new Object[]{"meta", String.valueOf(getReplicationDocumentOptions.meta())});
        }
        if (getReplicationDocumentOptions.openRevs() != null) {
            builder.query(new Object[]{"open_revs", RequestUtils.join(getReplicationDocumentOptions.openRevs(), (String)",")});
        }
        if (getReplicationDocumentOptions.rev() != null) {
            builder.query(new Object[]{"rev", getReplicationDocumentOptions.rev()});
        }
        if (getReplicationDocumentOptions.revs() != null) {
            builder.query(new Object[]{"revs", String.valueOf(getReplicationDocumentOptions.revs())});
        }
        if (getReplicationDocumentOptions.revsInfo() != null) {
            builder.query(new Object[]{"revs_info", String.valueOf(getReplicationDocumentOptions.revsInfo())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ReplicationDocument>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> putReplicationDocument(PutReplicationDocumentOptions putReplicationDocumentOptions) {
        Validator.notNull((Object)((Object)putReplicationDocumentOptions), (String)"putReplicationDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"_replicator"};
        String[] pathParameters = new String[]{putReplicationDocumentOptions.docId()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"putReplicationDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (putReplicationDocumentOptions.ifMatch() != null) {
            builder.header(new Object[]{"If-Match", putReplicationDocumentOptions.ifMatch()});
        }
        if (putReplicationDocumentOptions.batch() != null) {
            builder.query(new Object[]{"batch", putReplicationDocumentOptions.batch()});
        }
        if (putReplicationDocumentOptions.newEdits() != null) {
            builder.query(new Object[]{"new_edits", String.valueOf(putReplicationDocumentOptions.newEdits())});
        }
        if (putReplicationDocumentOptions.rev() != null) {
            builder.query(new Object[]{"rev", putReplicationDocumentOptions.rev()});
        }
        if (putReplicationDocumentOptions.replicationDocument() != null) {
            builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson((Object)putReplicationDocumentOptions.replicationDocument()), "application/json");
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SchedulerDocsResult> getSchedulerDocs(GetSchedulerDocsOptions getSchedulerDocsOptions) {
        if (getSchedulerDocsOptions == null) {
            getSchedulerDocsOptions = new GetSchedulerDocsOptions.Builder().build();
        }
        String[] pathSegments = new String[]{"_scheduler/docs"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getSchedulerDocs");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getSchedulerDocsOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(getSchedulerDocsOptions.limit())});
        }
        if (getSchedulerDocsOptions.skip() != null) {
            builder.query(new Object[]{"skip", String.valueOf(getSchedulerDocsOptions.skip())});
        }
        if (getSchedulerDocsOptions.states() != null) {
            builder.query(new Object[]{"states", RequestUtils.join(getSchedulerDocsOptions.states(), (String)",")});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SchedulerDocsResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SchedulerDocsResult> getSchedulerDocs() {
        return this.getSchedulerDocs(null);
    }

    public ServiceCall<SchedulerDocument> getSchedulerDocument(GetSchedulerDocumentOptions getSchedulerDocumentOptions) {
        Validator.notNull((Object)((Object)getSchedulerDocumentOptions), (String)"getSchedulerDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"_scheduler/docs/_replicator"};
        String[] pathParameters = new String[]{getSchedulerDocumentOptions.docId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getSchedulerDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SchedulerDocument>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SchedulerJobsResult> getSchedulerJobs(GetSchedulerJobsOptions getSchedulerJobsOptions) {
        if (getSchedulerJobsOptions == null) {
            getSchedulerJobsOptions = new GetSchedulerJobsOptions.Builder().build();
        }
        String[] pathSegments = new String[]{"_scheduler/jobs"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getSchedulerJobs");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getSchedulerJobsOptions.limit() != null) {
            builder.query(new Object[]{"limit", String.valueOf(getSchedulerJobsOptions.limit())});
        }
        if (getSchedulerJobsOptions.skip() != null) {
            builder.query(new Object[]{"skip", String.valueOf(getSchedulerJobsOptions.skip())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SchedulerJobsResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SchedulerJobsResult> getSchedulerJobs() {
        return this.getSchedulerJobs(null);
    }

    public ServiceCall<SchedulerJob> getSchedulerJob(GetSchedulerJobOptions getSchedulerJobOptions) {
        Validator.notNull((Object)((Object)getSchedulerJobOptions), (String)"getSchedulerJobOptions cannot be null");
        String[] pathSegments = new String[]{"_scheduler/jobs"};
        String[] pathParameters = new String[]{getSchedulerJobOptions.jobId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getSchedulerJob");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SchedulerJob>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SessionInformation> getSessionInformation(GetSessionInformationOptions getSessionInformationOptions) {
        String[] pathSegments = new String[]{"_session"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getSessionInformation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SessionInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SessionInformation> getSessionInformation() {
        return this.getSessionInformation(null);
    }

    public ServiceCall<Ok> deleteIamSession(DeleteIamSessionOptions deleteIamSessionOptions) {
        String[] pathSegments = new String[]{"_iam_session"};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteIamSession");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Ok> deleteIamSession() {
        return this.deleteIamSession(null);
    }

    public ServiceCall<IamSessionInformation> getIamSessionInformation(GetIamSessionInformationOptions getIamSessionInformationOptions) {
        String[] pathSegments = new String[]{"_iam_session"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getIamSessionInformation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<IamSessionInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<IamSessionInformation> getIamSessionInformation() {
        return this.getIamSessionInformation(null);
    }

    public ServiceCall<Ok> postIamSession(PostIamSessionOptions postIamSessionOptions) {
        boolean skipBody = false;
        if (postIamSessionOptions == null) {
            postIamSessionOptions = new PostIamSessionOptions.Builder().build();
            skipBody = true;
        }
        String[] pathSegments = new String[]{"_iam_session"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postIamSession");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (postIamSessionOptions.accessToken() != null) {
                contentJson.addProperty("access_token", postIamSessionOptions.accessToken());
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Ok> postIamSession() {
        return this.postIamSession(null);
    }

    public ServiceCall<Security> getSecurity(GetSecurityOptions getSecurityOptions) {
        Validator.notNull((Object)((Object)getSecurityOptions), (String)"getSecurityOptions cannot be null");
        String[] pathSegments = new String[]{"", "_security"};
        String[] pathParameters = new String[]{getSecurityOptions.db()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getSecurity");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Security>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Ok> putSecurity(PutSecurityOptions putSecurityOptions) {
        Validator.notNull((Object)((Object)putSecurityOptions), (String)"putSecurityOptions cannot be null");
        String[] pathSegments = new String[]{"", "_security"};
        String[] pathParameters = new String[]{putSecurityOptions.db()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"putSecurity");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (putSecurityOptions.admins() != null) {
            contentJson.add("admins", GsonSingleton.getGson().toJsonTree((Object)putSecurityOptions.admins()));
        }
        if (putSecurityOptions.members() != null) {
            contentJson.add("members", GsonSingleton.getGson().toJsonTree((Object)putSecurityOptions.members()));
        }
        if (putSecurityOptions.cloudant() != null) {
            contentJson.add(DEFAULT_SERVICE_NAME, GsonSingleton.getGson().toJsonTree(putSecurityOptions.cloudant()));
        }
        if (putSecurityOptions.couchdbAuthOnly() != null) {
            contentJson.addProperty("couchdb_auth_only", putSecurityOptions.couchdbAuthOnly());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ApiKeysResult> postApiKeys(PostApiKeysOptions postApiKeysOptions) {
        String[] pathSegments = new String[]{"_api/v2/api_keys"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postApiKeys");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ApiKeysResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ApiKeysResult> postApiKeys() {
        return this.postApiKeys(null);
    }

    public ServiceCall<Ok> putCloudantSecurity(PutCloudantSecurityOptions putCloudantSecurityOptions) {
        Validator.notNull((Object)((Object)putCloudantSecurityOptions), (String)"putCloudantSecurityOptions cannot be null");
        String[] pathSegments = new String[]{"_api/v2/db", "_security"};
        String[] pathParameters = new String[]{putCloudantSecurityOptions.db()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"putCloudantSecurity");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (putCloudantSecurityOptions.cloudant() != null) {
            contentJson.add(DEFAULT_SERVICE_NAME, GsonSingleton.getGson().toJsonTree(putCloudantSecurityOptions.cloudant()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CorsConfiguration> getCorsInformation(GetCorsInformationOptions getCorsInformationOptions) {
        String[] pathSegments = new String[]{"_api/v2/user/config/cors"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getCorsInformation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CorsConfiguration>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CorsConfiguration> getCorsInformation() {
        return this.getCorsInformation(null);
    }

    public ServiceCall<Ok> putCorsConfiguration(PutCorsConfigurationOptions putCorsConfigurationOptions) {
        boolean skipBody = false;
        if (putCorsConfigurationOptions == null) {
            putCorsConfigurationOptions = new PutCorsConfigurationOptions.Builder().build();
            skipBody = true;
        }
        String[] pathSegments = new String[]{"_api/v2/user/config/cors"};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"putCorsConfiguration");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (putCorsConfigurationOptions.allowCredentials() != null) {
                contentJson.addProperty("allow_credentials", putCorsConfigurationOptions.allowCredentials());
            }
            if (putCorsConfigurationOptions.enableCors() != null) {
                contentJson.addProperty("enable_cors", putCorsConfigurationOptions.enableCors());
            }
            if (putCorsConfigurationOptions.origins() != null) {
                contentJson.add("origins", GsonSingleton.getGson().toJsonTree(putCorsConfigurationOptions.origins()));
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Ok> putCorsConfiguration() {
        return this.putCorsConfiguration(null);
    }

    public ServiceCall<Void> headAttachment(HeadAttachmentOptions headAttachmentOptions) {
        Validator.notNull((Object)((Object)headAttachmentOptions), (String)"headAttachmentOptions cannot be null");
        String[] pathSegments = new String[]{"", "", ""};
        String[] pathParameters = new String[]{headAttachmentOptions.db(), headAttachmentOptions.docId(), headAttachmentOptions.attachmentName()};
        RequestBuilder builder = RequestBuilder.head((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"headAttachment");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (headAttachmentOptions.ifMatch() != null) {
            builder.header(new Object[]{"If-Match", headAttachmentOptions.ifMatch()});
        }
        if (headAttachmentOptions.ifNoneMatch() != null) {
            builder.header(new Object[]{"If-None-Match", headAttachmentOptions.ifNoneMatch()});
        }
        if (headAttachmentOptions.rev() != null) {
            builder.query(new Object[]{"rev", headAttachmentOptions.rev()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> deleteAttachment(DeleteAttachmentOptions deleteAttachmentOptions) {
        Validator.notNull((Object)((Object)deleteAttachmentOptions), (String)"deleteAttachmentOptions cannot be null");
        String[] pathSegments = new String[]{"", "", ""};
        String[] pathParameters = new String[]{deleteAttachmentOptions.db(), deleteAttachmentOptions.docId(), deleteAttachmentOptions.attachmentName()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteAttachment");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (deleteAttachmentOptions.ifMatch() != null) {
            builder.header(new Object[]{"If-Match", deleteAttachmentOptions.ifMatch()});
        }
        if (deleteAttachmentOptions.rev() != null) {
            builder.query(new Object[]{"rev", deleteAttachmentOptions.rev()});
        }
        if (deleteAttachmentOptions.batch() != null) {
            builder.query(new Object[]{"batch", deleteAttachmentOptions.batch()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> getAttachment(GetAttachmentOptions getAttachmentOptions) {
        Validator.notNull((Object)((Object)getAttachmentOptions), (String)"getAttachmentOptions cannot be null");
        String[] pathSegments = new String[]{"", "", ""};
        String[] pathParameters = new String[]{getAttachmentOptions.db(), getAttachmentOptions.docId(), getAttachmentOptions.attachmentName()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getAttachment");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (getAttachmentOptions.accept() != null) {
            builder.header(new Object[]{"Accept", getAttachmentOptions.accept()});
        }
        if (getAttachmentOptions.ifMatch() != null) {
            builder.header(new Object[]{"If-Match", getAttachmentOptions.ifMatch()});
        }
        if (getAttachmentOptions.ifNoneMatch() != null) {
            builder.header(new Object[]{"If-None-Match", getAttachmentOptions.ifNoneMatch()});
        }
        if (getAttachmentOptions.range() != null) {
            builder.header(new Object[]{"Range", getAttachmentOptions.range()});
        }
        if (getAttachmentOptions.rev() != null) {
            builder.query(new Object[]{"rev", getAttachmentOptions.rev()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> putAttachment(PutAttachmentOptions putAttachmentOptions) {
        Validator.notNull((Object)((Object)putAttachmentOptions), (String)"putAttachmentOptions cannot be null");
        String[] pathSegments = new String[]{"", "", ""};
        String[] pathParameters = new String[]{putAttachmentOptions.db(), putAttachmentOptions.docId(), putAttachmentOptions.attachmentName()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"putAttachment");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.header(new Object[]{"Content-Type", putAttachmentOptions.contentType()});
        if (putAttachmentOptions.ifMatch() != null) {
            builder.header(new Object[]{"If-Match", putAttachmentOptions.ifMatch()});
        }
        if (putAttachmentOptions.rev() != null) {
            builder.query(new Object[]{"rev", putAttachmentOptions.rev()});
        }
        builder.bodyContent(putAttachmentOptions.contentType(), null, null, putAttachmentOptions.attachment());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> deleteLocalDocument(DeleteLocalDocumentOptions deleteLocalDocumentOptions) {
        Validator.notNull((Object)((Object)deleteLocalDocumentOptions), (String)"deleteLocalDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"", "_local"};
        String[] pathParameters = new String[]{deleteLocalDocumentOptions.db(), deleteLocalDocumentOptions.docId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteLocalDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (deleteLocalDocumentOptions.batch() != null) {
            builder.query(new Object[]{"batch", deleteLocalDocumentOptions.batch()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Document> getLocalDocument(GetLocalDocumentOptions getLocalDocumentOptions) {
        Validator.notNull((Object)((Object)getLocalDocumentOptions), (String)"getLocalDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"", "_local"};
        String[] pathParameters = new String[]{getLocalDocumentOptions.db(), getLocalDocumentOptions.docId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getLocalDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (getLocalDocumentOptions.accept() != null) {
            builder.header(new Object[]{"Accept", getLocalDocumentOptions.accept()});
        }
        if (getLocalDocumentOptions.ifNoneMatch() != null) {
            builder.header(new Object[]{"If-None-Match", getLocalDocumentOptions.ifNoneMatch()});
        }
        if (getLocalDocumentOptions.attachments() != null) {
            builder.query(new Object[]{"attachments", String.valueOf(getLocalDocumentOptions.attachments())});
        }
        if (getLocalDocumentOptions.attEncodingInfo() != null) {
            builder.query(new Object[]{"att_encoding_info", String.valueOf(getLocalDocumentOptions.attEncodingInfo())});
        }
        if (getLocalDocumentOptions.attsSince() != null) {
            builder.query(new Object[]{"atts_since", RequestUtils.join(getLocalDocumentOptions.attsSince(), (String)",")});
        }
        if (getLocalDocumentOptions.localSeq() != null) {
            builder.query(new Object[]{"local_seq", String.valueOf(getLocalDocumentOptions.localSeq())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Document>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> putLocalDocument(PutLocalDocumentOptions putLocalDocumentOptions) {
        Validator.notNull((Object)((Object)putLocalDocumentOptions), (String)"putLocalDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"", "_local"};
        String[] pathParameters = new String[]{putLocalDocumentOptions.db(), putLocalDocumentOptions.docId()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"putLocalDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (putLocalDocumentOptions.contentType() != null) {
            builder.header(new Object[]{"Content-Type", putLocalDocumentOptions.contentType()});
        }
        if (putLocalDocumentOptions.batch() != null) {
            builder.query(new Object[]{"batch", putLocalDocumentOptions.batch()});
        }
        builder.bodyContent(putLocalDocumentOptions.contentType(), (Object)putLocalDocumentOptions.document(), null, putLocalDocumentOptions.body());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllDocsResult> postLocalDocs(PostLocalDocsOptions postLocalDocsOptions) {
        Validator.notNull((Object)((Object)postLocalDocsOptions), (String)"postLocalDocsOptions cannot be null");
        String[] pathSegments = new String[]{"", "_local_docs"};
        String[] pathParameters = new String[]{postLocalDocsOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postLocalDocs");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (postLocalDocsOptions.accept() != null) {
            builder.header(new Object[]{"Accept", postLocalDocsOptions.accept()});
        }
        JsonObject contentJson = new JsonObject();
        if (postLocalDocsOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postLocalDocsOptions.attEncodingInfo());
        }
        if (postLocalDocsOptions.attachments() != null) {
            contentJson.addProperty("attachments", postLocalDocsOptions.attachments());
        }
        if (postLocalDocsOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postLocalDocsOptions.conflicts());
        }
        if (postLocalDocsOptions.descending() != null) {
            contentJson.addProperty("descending", postLocalDocsOptions.descending());
        }
        if (postLocalDocsOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postLocalDocsOptions.includeDocs());
        }
        if (postLocalDocsOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postLocalDocsOptions.inclusiveEnd());
        }
        if (postLocalDocsOptions.limit() != null) {
            contentJson.addProperty("limit", (Number)postLocalDocsOptions.limit());
        }
        if (postLocalDocsOptions.skip() != null) {
            contentJson.addProperty("skip", (Number)postLocalDocsOptions.skip());
        }
        if (postLocalDocsOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postLocalDocsOptions.updateSeq());
        }
        if (postLocalDocsOptions.endkey() != null) {
            contentJson.addProperty("endkey", postLocalDocsOptions.endkey());
        }
        if (postLocalDocsOptions.key() != null) {
            contentJson.addProperty("key", postLocalDocsOptions.key());
        }
        if (postLocalDocsOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postLocalDocsOptions.keys()));
        }
        if (postLocalDocsOptions.startkey() != null) {
            contentJson.addProperty("startkey", postLocalDocsOptions.startkey());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AllDocsResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllDocsQueriesResult> postLocalDocsQueries(PostLocalDocsQueriesOptions postLocalDocsQueriesOptions) {
        Validator.notNull((Object)((Object)postLocalDocsQueriesOptions), (String)"postLocalDocsQueriesOptions cannot be null");
        String[] pathSegments = new String[]{"", "_local_docs/queries"};
        String[] pathParameters = new String[]{postLocalDocsQueriesOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postLocalDocsQueries");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (postLocalDocsQueriesOptions.accept() != null) {
            builder.header(new Object[]{"Accept", postLocalDocsQueriesOptions.accept()});
        }
        JsonObject contentJson = new JsonObject();
        if (postLocalDocsQueriesOptions.queries() != null) {
            contentJson.add("queries", GsonSingleton.getGson().toJsonTree(postLocalDocsQueriesOptions.queries()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AllDocsQueriesResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<EnsureFullCommitInformation> postEnsureFullCommit(PostEnsureFullCommitOptions postEnsureFullCommitOptions) {
        Validator.notNull((Object)((Object)postEnsureFullCommitOptions), (String)"postEnsureFullCommitOptions cannot be null");
        String[] pathSegments = new String[]{"", "_ensure_full_commit"};
        String[] pathParameters = new String[]{postEnsureFullCommitOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postEnsureFullCommit");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<EnsureFullCommitInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<MissingRevsResult> postMissingRevs(PostMissingRevsOptions postMissingRevsOptions) {
        Validator.notNull((Object)((Object)postMissingRevsOptions), (String)"postMissingRevsOptions cannot be null");
        String[] pathSegments = new String[]{"", "_missing_revs"};
        String[] pathParameters = new String[]{postMissingRevsOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postMissingRevs");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (postMissingRevsOptions.missingRevs() != null) {
            builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson(postMissingRevsOptions.missingRevs()), "application/json");
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<MissingRevsResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Map<String, RevsDiff>> postRevsDiff(PostRevsDiffOptions postRevsDiffOptions) {
        Validator.notNull((Object)((Object)postRevsDiffOptions), (String)"postRevsDiffOptions cannot be null");
        String[] pathSegments = new String[]{"", "_revs_diff"};
        String[] pathParameters = new String[]{postRevsDiffOptions.db()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"postRevsDiff");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (postRevsDiffOptions.revsDiffRequest() != null) {
            builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson(postRevsDiffOptions.revsDiffRequest()), "application/json");
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Map<String, RevsDiff>>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ShardsInformation> getShardsInformation(GetShardsInformationOptions getShardsInformationOptions) {
        Validator.notNull((Object)((Object)getShardsInformationOptions), (String)"getShardsInformationOptions cannot be null");
        String[] pathSegments = new String[]{"", "_shards"};
        String[] pathParameters = new String[]{getShardsInformationOptions.db()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getShardsInformation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ShardsInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentShardInfo> getDocumentShardsInfo(GetDocumentShardsInfoOptions getDocumentShardsInfoOptions) {
        Validator.notNull((Object)((Object)getDocumentShardsInfoOptions), (String)"getDocumentShardsInfoOptions cannot be null");
        String[] pathSegments = new String[]{"", "_shards"};
        String[] pathParameters = new String[]{getDocumentShardsInfoOptions.db(), getDocumentShardsInfoOptions.docId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getDocumentShardsInfo");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentShardInfo>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<List<ActiveTask>> getActiveTasks(GetActiveTasksOptions getActiveTasksOptions) {
        String[] pathSegments = new String[]{"_active_tasks"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getActiveTasks");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<List<ActiveTask>>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<List<ActiveTask>> getActiveTasks() {
        return this.getActiveTasks(null);
    }

    public ServiceCall<UpInformation> getUpInformation(GetUpInformationOptions getUpInformationOptions) {
        String[] pathSegments = new String[]{"_up"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getUpInformation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<UpInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<UpInformation> getUpInformation() {
        return this.getUpInformation(null);
    }
}

