/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SdkCommon {
    private static final Logger LOG = Logger.getLogger(SdkCommon.class.getName());
    private static String userAgent;
    private static String projectName;
    private static String version;
    private static String parentArtifactId;

    private SdkCommon() {
    }

    public static String getVersion() {
        return version;
    }

    public static String getProjectName() {
        return projectName;
    }

    protected static void readBuildProperties() {
        Properties buildProps = new Properties();
        try (InputStream is = SdkCommon.class.getResourceAsStream("/" + parentArtifactId + ".properties");){
            buildProps.load(is);
            version = buildProps.getProperty("version", "unknown");
            projectName = buildProps.getProperty("title", "unknown");
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, String.format("Could not load %s.properties", parentArtifactId), e);
            version = "unknown";
            projectName = "unknown";
        }
    }

    private static synchronized String getUserAgent() {
        if (userAgent == null) {
            String lang = "java";
            String langVersion = System.getProperty("java.version");
            String langVendor = System.getProperty("java.vendor");
            String osName = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            String osArch = System.getProperty("os.arch");
            userAgent = String.format("%s/%s (%s.version=%s; %s.vendor=%s; os.name=%s; os.version=%s; os.arch=%s; lang=%s;)", projectName, version, lang, langVersion, lang, langVendor, osName, osVersion, osArch, lang);
        }
        return userAgent;
    }

    public static Map<String, String> getSdkHeaders(String serviceName, String serviceVersion, String operationId) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String sdkAnalyticsHeaderValue = String.format("service_name=%s;service_version=%s;operation_id=%s", serviceName, serviceVersion, operationId);
        headers.put("X-IBMCloud-SDK-Analytics", sdkAnalyticsHeaderValue);
        headers.put("User-Agent", SdkCommon.getUserAgent());
        return headers;
    }

    public static Map<String, String> getSdkHeaders(String operationId) {
        return SdkCommon.getSdkHeaders(projectName, version, operationId);
    }

    static {
        parentArtifactId = "cloudant-parent";
        SdkCommon.readBuildProperties();
    }
}

