/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.internal;

import com.ibm.cloud.cloudant.security.CouchDbSessionAuthenticator;
import com.ibm.cloud.sdk.core.http.HttpConfigOptions;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.service.BaseService;
import java.util.Map;
import java.util.function.Consumer;
import okhttp3.CookieJar;
import okhttp3.OkHttpClient;

public abstract class CloudantBaseService
extends BaseService {
    public CloudantBaseService(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
    }

    protected OkHttpClient configureHttpClient() {
        OkHttpClient.Builder builder = super.configureHttpClient().newBuilder();
        this.customizeAuthenticator(a -> builder.cookieJar((CookieJar)a.getCookieJar()));
        return builder.build();
    }

    public void setServiceUrl(String serviceUrl) {
        super.setServiceUrl(serviceUrl);
        this.customizeAuthenticator(a -> {
            a.setSessionUrl(this.getServiceUrl());
            a.invalidateToken();
        });
    }

    public void configureClient(HttpConfigOptions options) {
        super.configureClient(options);
        this.customizeAuthenticator(a -> a.setHttpConfigOptions(options));
    }

    public void setDefaultHeaders(Map<String, String> headers) {
        super.setDefaultHeaders(headers);
        this.customizeAuthenticator(a -> a.setHeaders(headers));
    }

    private void customizeAuthenticator(Consumer<CouchDbSessionAuthenticator> consumer) {
        Authenticator authenticator = this.getAuthenticator();
        if (authenticator instanceof CouchDbSessionAuthenticator) {
            consumer.accept((CouchDbSessionAuthenticator)authenticator);
        }
    }
}

