/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.transaction.impl;

import com.ibm.batch.container.exception.TransactionManagementException;
import com.ibm.batch.container.services.TransactionManagerAdatper;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class JTAUserTransactionAdapter
implements TransactionManagerAdatper {
    private static final String CLASSNAME = JTAUserTransactionAdapter.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    protected UserTransaction userTran = null;

    public JTAUserTransactionAdapter(String jndiLookup) {
        logger.entering(CLASSNAME, "init", jndiLookup);
        try {
            InitialContext ctxt = new InitialContext();
            this.userTran = (UserTransaction)ctxt.lookup(jndiLookup);
            logger.fine("JNDI user transaction manager found");
        }
        catch (NamingException ne) {
            throw new TransactionManagementException(ne);
        }
        logger.exiting(CLASSNAME, "init");
    }

    @Override
    public void begin() throws TransactionManagementException {
        logger.entering(CLASSNAME, "begin");
        try {
            this.userTran.begin();
            logger.log(Level.FINE, "javax.transaction.Status: {0}", this.userTran.getStatus());
        }
        catch (NotSupportedException e) {
            throw new TransactionManagementException(e);
        }
        catch (SystemException e) {
            throw new TransactionManagementException(e);
        }
        logger.exiting(CLASSNAME, "begin");
    }

    @Override
    public void commit() throws TransactionManagementException {
        logger.entering(CLASSNAME, "commit");
        try {
            this.userTran.commit();
            logger.log(Level.FINE, "javax.transaction.Status: {0}", this.userTran.getStatus());
        }
        catch (SecurityException e) {
            throw new TransactionManagementException(e);
        }
        catch (IllegalStateException e) {
            throw new TransactionManagementException(e);
        }
        catch (RollbackException e) {
            throw new TransactionManagementException(e);
        }
        catch (HeuristicMixedException e) {
            throw new TransactionManagementException(e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionManagementException(e);
        }
        catch (SystemException e) {
            throw new TransactionManagementException(e);
        }
        logger.exiting(CLASSNAME, "commit");
    }

    @Override
    public void rollback() throws TransactionManagementException {
        logger.entering(CLASSNAME, "rollback");
        try {
            this.userTran.rollback();
            logger.log(Level.FINE, "javax.transaction.Status: {0}", this.userTran.getStatus());
        }
        catch (IllegalStateException e) {
            throw new TransactionManagementException(e);
        }
        catch (SecurityException e) {
            throw new TransactionManagementException(e);
        }
        catch (SystemException e) {
            throw new TransactionManagementException(e);
        }
        logger.exiting(CLASSNAME, "rollback");
    }

    @Override
    public int getStatus() throws TransactionManagementException {
        logger.entering(CLASSNAME, "getStatus");
        int status = 0;
        try {
            status = this.userTran.getStatus();
            logger.log(Level.FINE, "javax.transaction.Status: {0}", status);
        }
        catch (SystemException e) {
            throw new TransactionManagementException(e);
        }
        logger.exiting(CLASSNAME, "getStatus", status);
        return status;
    }

    @Override
    public void setRollbackOnly() throws TransactionManagementException {
        logger.entering(CLASSNAME, "setRollbackOnly");
        try {
            this.userTran.setRollbackOnly();
            logger.log(Level.FINE, "javax.transaction.Status: {0}", this.userTran.getStatus());
        }
        catch (IllegalStateException e) {
            throw new TransactionManagementException(e);
        }
        catch (SystemException e) {
            throw new TransactionManagementException(e);
        }
        logger.exiting(CLASSNAME, "setRollbackOnly");
    }

    @Override
    public void setTransactionTimeout(int seconds) throws TransactionManagementException {
        logger.entering(CLASSNAME, "setTransactionTimeout", seconds);
        try {
            this.userTran.setTransactionTimeout(seconds);
        }
        catch (SystemException e) {
            throw new TransactionManagementException(e);
        }
        logger.exiting(CLASSNAME, "setTransactionTimeout");
    }
}

