/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services.impl;

import com.ibm.batch.container.config.IBatchConfig;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.exception.TransactionManagementException;
import com.ibm.batch.container.services.ITransactionManagementService;
import com.ibm.batch.container.services.TransactionManagerAdatper;
import com.ibm.batch.container.transaction.impl.DefaultNonTransactionalManager;
import com.ibm.batch.container.transaction.impl.JTAUserTransactionAdapter;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.context.StepContext;

public class BatchTransactionServiceImpl
implements ITransactionManagementService {
    private static final String CLASSNAME = BatchTransactionServiceImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private static final int DEFAULT_TRAN_TIMEOUT = 180;
    private IBatchConfig batchConfig = null;

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        logger.entering(CLASSNAME, "init", batchConfig);
        this.batchConfig = batchConfig;
        logger.exiting(CLASSNAME, "init");
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
        logger.entering(CLASSNAME, "shutdown");
        logger.fine("do nothing");
        logger.exiting(CLASSNAME, "shutdown");
    }

    @Override
    public TransactionManagerAdatper getTransactionManager(StepContext<?, ?> stepContext) throws TransactionManagementException {
        logger.entering(CLASSNAME, "getTransactionManager", stepContext);
        TransactionManagerAdatper transactionManager = null;
        if (!this.batchConfig.isJ2seMode()) {
            logger.fine("getting transaction object from JNDI java:comp/UserTransaction");
            transactionManager = new JTAUserTransactionAdapter("java:comp/UserTransaction");
        } else if (this.batchConfig.isJ2seMode()) {
            logger.fine("J2SE mode non-transactional manager");
            transactionManager = new DefaultNonTransactionalManager();
        }
        int timeout = this.getTransactionTimeout(stepContext);
        logger.log(Level.FINE, "transaction timeout {0}", timeout);
        try {
            transactionManager.setTransactionTimeout(timeout);
        }
        catch (Exception e) {
            throw new TransactionManagementException(e);
        }
        logger.exiting(CLASSNAME, "getTransactionManager", transactionManager);
        return transactionManager;
    }

    private int getTransactionTimeout(StepContext<?, ?> stepContext) {
        logger.entering(CLASSNAME, "getTransactionTimeout", stepContext);
        Properties p = stepContext.getProperties();
        int timeout = 180;
        if (p != null && !p.isEmpty()) {
            String timeOut = p.getProperty("javax.transaction.global.timeout");
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "javax.transaction.global.timeout = {0}", timeOut);
            }
            if (timeOut != null && !timeOut.isEmpty()) {
                timeout = Integer.parseInt(timeOut, 10);
            }
        }
        logger.exiting(CLASSNAME, "getTransactionTimeout", timeout);
        return timeout;
    }
}

