/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.BatchletProxy;
import com.ibm.batch.container.artifact.proxy.CheckpointAlgorithmProxy;
import com.ibm.batch.container.artifact.proxy.DeciderProxy;
import com.ibm.batch.container.artifact.proxy.InjectionReferences;
import com.ibm.batch.container.artifact.proxy.ItemProcessorProxy;
import com.ibm.batch.container.artifact.proxy.ItemReaderProxy;
import com.ibm.batch.container.artifact.proxy.ItemWriterProxy;
import com.ibm.batch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.batch.container.artifact.proxy.PartitionCollectorProxy;
import com.ibm.batch.container.artifact.proxy.PartitionMapperProxy;
import com.ibm.batch.container.artifact.proxy.PartitionReducerProxy;
import com.ibm.batch.container.services.IBatchArtifactFactory;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.validation.ArtifactValidationException;
import javax.batch.api.Batchlet;
import javax.batch.api.CheckpointAlgorithm;
import javax.batch.api.Decider;
import javax.batch.api.ItemProcessor;
import javax.batch.api.ItemReader;
import javax.batch.api.ItemWriter;
import javax.batch.api.PartitionAnalyzer;
import javax.batch.api.PartitionCollector;
import javax.batch.api.PartitionMapper;
import javax.batch.api.PartitionReducer;

public class ProxyFactory {
    protected static ServicesManager servicesManager = ServicesManager.getInstance();
    private static ThreadLocal<InjectionReferences> injectionContext = new ThreadLocal();
    protected static IBatchArtifactFactory batchArtifactFactory = (IBatchArtifactFactory)servicesManager.getService(ServicesManager.ServiceType.DELEGATING_ARTIFACT_FACTORY_SERVICE);

    protected static Object loadArtifact(String id, InjectionReferences injectionReferences) {
        injectionContext.set(injectionReferences);
        Object loadedArtifact = null;
        try {
            loadedArtifact = batchArtifactFactory.load(id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return loadedArtifact;
    }

    public static InjectionReferences getInjectionReferences() {
        return injectionContext.get();
    }

    public static DeciderProxy createDeciderProxy(String id, InjectionReferences injectionRefs) throws ArtifactValidationException {
        Decider loadedArtifact = (Decider)ProxyFactory.loadArtifact(id, injectionRefs);
        DeciderProxy proxy = new DeciderProxy(loadedArtifact);
        return proxy;
    }

    public static BatchletProxy createBatchletProxy(String id, InjectionReferences injectionRefs) throws ArtifactValidationException {
        Batchlet loadedArtifact = (Batchlet)ProxyFactory.loadArtifact(id, injectionRefs);
        BatchletProxy proxy = new BatchletProxy(loadedArtifact);
        return proxy;
    }

    public static CheckpointAlgorithmProxy createCheckpointAlgorithmProxy(String id, InjectionReferences injectionRefs) throws ArtifactValidationException {
        CheckpointAlgorithm loadedArtifact = (CheckpointAlgorithm)ProxyFactory.loadArtifact(id, injectionRefs);
        CheckpointAlgorithmProxy proxy = new CheckpointAlgorithmProxy(loadedArtifact);
        return proxy;
    }

    public static ItemReaderProxy createItemReaderProxy(String id, InjectionReferences injectionRefs) throws ArtifactValidationException {
        ItemReader loadedArtifact = (ItemReader)ProxyFactory.loadArtifact(id, injectionRefs);
        ItemReaderProxy proxy = new ItemReaderProxy(loadedArtifact);
        return proxy;
    }

    public static ItemProcessorProxy createItemProcessorProxy(String id, InjectionReferences injectionRefs) throws ArtifactValidationException {
        ItemProcessor loadedArtifact = (ItemProcessor)ProxyFactory.loadArtifact(id, injectionRefs);
        ItemProcessorProxy proxy = new ItemProcessorProxy(loadedArtifact);
        return proxy;
    }

    public static ItemWriterProxy createItemWriterProxy(String id, InjectionReferences injectionRefs) throws ArtifactValidationException {
        ItemWriter loadedArtifact = (ItemWriter)ProxyFactory.loadArtifact(id, injectionRefs);
        return new ItemWriterProxy(loadedArtifact);
    }

    public static PartitionReducerProxy createPartitionReducerProxy(String id, InjectionReferences injectionRefs) throws ArtifactValidationException {
        PartitionReducer loadedArtifact = (PartitionReducer)ProxyFactory.loadArtifact(id, injectionRefs);
        PartitionReducerProxy proxy = new PartitionReducerProxy(loadedArtifact);
        return proxy;
    }

    public static PartitionMapperProxy createPartitionMapperProxy(String id, InjectionReferences injectionRefs) throws ArtifactValidationException {
        PartitionMapper loadedArtifact = (PartitionMapper)ProxyFactory.loadArtifact(id, injectionRefs);
        PartitionMapperProxy proxy = new PartitionMapperProxy(loadedArtifact);
        return proxy;
    }

    public static PartitionAnalyzerProxy createPartitionAnalyzerProxy(String id, InjectionReferences injectionRefs) throws ArtifactValidationException {
        PartitionAnalyzer loadedArtifact = (PartitionAnalyzer)ProxyFactory.loadArtifact(id, injectionRefs);
        PartitionAnalyzerProxy proxy = new PartitionAnalyzerProxy(loadedArtifact);
        return proxy;
    }

    public static PartitionCollectorProxy createPartitionCollectorProxy(String id, InjectionReferences injectionRefs) throws ArtifactValidationException {
        PartitionCollector loadedArtifact = (PartitionCollector)ProxyFactory.loadArtifact(id, injectionRefs);
        PartitionCollectorProxy proxy = new PartitionCollectorProxy(loadedArtifact);
        return proxy;
    }
}

