/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import com.ibm.batch.container.persistence.ItemCheckpointAlgorithm;
import com.ibm.batch.container.persistence.TimeCheckpointAlgorithm;
import javax.batch.api.CheckpointAlgorithm;

public class CheckpointAlgorithmProxy
extends AbstractProxy<CheckpointAlgorithm>
implements CheckpointAlgorithm {
    private String checkpointType = null;
    private String checkpointName = null;

    public CheckpointAlgorithmProxy(CheckpointAlgorithm delegate) {
        super(delegate);
        if (delegate instanceof ItemCheckpointAlgorithm) {
            this.checkpointType = "item";
            this.checkpointName = ItemCheckpointAlgorithm.class.getName();
        } else if (delegate instanceof TimeCheckpointAlgorithm) {
            this.checkpointType = "time";
            this.checkpointName = TimeCheckpointAlgorithm.class.getName();
        } else {
            this.checkpointType = "custom";
            this.checkpointName = delegate.getClass().getName();
        }
    }

    public String getCheckpointType() {
        return this.checkpointType;
    }

    public String getCheckpointAlgorithmClassName() {
        return this.checkpointName;
    }

    public void beginCheckpoint() {
        try {
            ((CheckpointAlgorithm)this.delegate).beginCheckpoint();
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException(e);
        }
    }

    public int checkpointTimeout(int timeout) {
        try {
            return ((CheckpointAlgorithm)this.delegate).checkpointTimeout(timeout);
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException(e);
        }
    }

    public void endCheckpoint() {
        try {
            ((CheckpointAlgorithm)this.delegate).endCheckpoint();
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException(e);
        }
    }

    public boolean isReadyToCheckpoint() {
        try {
            return ((CheckpointAlgorithm)this.delegate).isReadyToCheckpoint();
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException(e);
        }
    }
}

