/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.services.impl;

import com.ibm.batch.container.config.IBatchConfig;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.services.IJobXMLLoaderService;
import com.ibm.batch.container.services.impl.DelegatingBatchArtifactFactoryImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Logger;

public class DirectoryJobXMLLoaderServiceImpl
implements IJobXMLLoaderService {
    private static final Logger logger = Logger.getLogger(DelegatingBatchArtifactFactoryImpl.class.getName());
    private static final String CLASSNAME = DirectoryJobXMLLoaderServiceImpl.class.getName();
    public static final String JOB_XML_DIR_PROP = "javax.batch.jobs.dir";
    public static final String JOB_XML_PATH = System.getProperty("javax.batch.jobs.dir");

    @Override
    public String loadJob(String id) {
        String jobXML = DirectoryJobXMLLoaderServiceImpl.loadJobFromDirectory(JOB_XML_PATH, id);
        return jobXML;
    }

    private static String loadJobFromDirectory(String dir, String id) {
        File jobXMLFile = new File(JOB_XML_PATH, id + ".xml");
        String xmlString = DirectoryJobXMLLoaderServiceImpl.readJobXML(jobXMLFile);
        return xmlString;
    }

    @Override
    public String loadStep(String id) {
        return null;
    }

    @Override
    public String loadXJCL(String id) {
        return null;
    }

    private static String readJobXML(File fileWithPath) {
        StringBuffer xmlBuffer = fileWithPath == null ? null : new StringBuffer();
        try {
            if (fileWithPath != null) {
                BufferedReader in = new BufferedReader(new FileReader(fileWithPath));
                String input = in.readLine();
                do {
                    if (input == null) continue;
                    xmlBuffer.append(input);
                    input = in.readLine();
                } while (input != null);
            }
        }
        catch (FileNotFoundException e) {
            throw new BatchContainerServiceException("Could not find file " + fileWithPath);
        }
        catch (IOException e) {
            throw new BatchContainerServiceException(e);
        }
        return xmlBuffer == null ? null : xmlBuffer.toString();
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }
}

