/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.AbortedBeforeStartException;
import com.ibm.batch.container.IExecutionElementController;
import com.ibm.batch.container.context.impl.StepContextImpl;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import com.ibm.batch.container.impl.BatchKernelImpl;
import com.ibm.batch.container.impl.PartitionedStepBuilder;
import com.ibm.batch.container.jobinstance.ParallelJobExecution;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.util.PartitionDataWrapper;
import java.io.Externalizable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;
import jsr352.batch.jsl.Flow;
import jsr352.batch.jsl.JSLJob;
import jsr352.batch.jsl.Split;

public class SplitControllerImpl
implements IExecutionElementController {
    private static final String sourceClass = SplitControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private final RuntimeJobExecutionImpl jobExecutionImpl;
    private volatile List<ParallelJobExecution> parallelJobExecs;
    private final ServicesManager servicesManager;
    private final BatchKernelImpl batchKernel;
    final List<JSLJob> subJobs = new ArrayList<JSLJob>();
    protected Split split;

    public SplitControllerImpl(RuntimeJobExecutionImpl jobExecutionImpl, Split split) {
        this.jobExecutionImpl = jobExecutionImpl;
        this.split = split;
        this.servicesManager = ServicesManager.getInstance();
        this.batchKernel = (BatchKernelImpl)this.servicesManager.getService(ServicesManager.ServiceType.BATCH_KERNEL_SERVICE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            if (this.parallelJobExecs != null) {
                for (ParallelJobExecution subJob : this.parallelJobExecs) {
                    try {
                        this.batchKernel.stopJob(subJob.getJobExecution().getInstanceId());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute() throws AbortedBeforeStartException {
        String sourceMethod = "execute";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, sourceMethod);
        }
        List<Flow> flows = this.split.getFlow();
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            for (Flow flow : flows) {
                this.subJobs.add(PartitionedStepBuilder.buildSubJob(this.jobExecutionImpl.getExecutionId(), this.split, flow, null));
            }
            this.parallelJobExecs = this.batchKernel.startParallelJobs(this.subJobs, null, null);
        }
        for (ParallelJobExecution subJob : this.parallelJobExecs) {
            subJob.waitForResult();
        }
        for (ParallelJobExecution subJob : this.parallelJobExecs) {
            JobOperator.BatchStatus batchStatus = subJob.getJobExecution().getJobContext().getBatchStatus();
            if (batchStatus.equals((Object)JobOperator.BatchStatus.FAILED)) {
                if (!logger.isLoggable(Level.FINE)) break;
                logger.fine("Subjob " + subJob.getJobExecution().getExecutionId() + "ended with status '" + batchStatus + "'");
                logger.fine("Starting logical transaction rollback.");
                break;
            }
            if (!batchStatus.equals((Object)JobOperator.BatchStatus.STOPPED)) continue;
            if (!logger.isLoggable(Level.FINE)) break;
            logger.fine("Subjob " + subJob.getJobExecution().getExecutionId() + "ended with status '" + batchStatus + "'");
            logger.fine("Starting logical transaction rollback.");
            break;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceMethod, sourceMethod);
        }
        return "SPLIT_CONTROLLER_RETURN_VALUE";
    }

    public void setStepContext(StepContextImpl<?, ? extends Externalizable> stepContext) {
        throw new BatchContainerRuntimeException("Incorrect usage: step context is not in scope within a flow.");
    }

    @Override
    public void setAnalyzerQueue(LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue) {
    }

    public List<ParallelJobExecution> getParallelJobExecs() {
        return this.parallelJobExecs;
    }
}

