/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.config.IBatchConfig;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.impl.JobControllerImpl;
import com.ibm.batch.container.jobinstance.JobExecutionHelper;
import com.ibm.batch.container.jobinstance.ParallelJobExecution;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.services.IBatchKernelService;
import com.ibm.batch.container.services.IBatchThreadPoolService;
import com.ibm.batch.container.services.IJobIdManagementService;
import com.ibm.batch.container.services.IPersistenceManagerService;
import com.ibm.batch.container.services.ParallelTaskResult;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.tck.bridge.IJobEndCallbackService;
import com.ibm.batch.container.util.BatchWorkUnit;
import com.ibm.batch.container.util.PartitionDataWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.exception.JobExecutionNotRunningException;
import javax.batch.operations.exception.JobRestartException;
import javax.batch.operations.exception.JobStartException;
import javax.batch.operations.exception.NoSuchJobExecutionException;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import jsr352.batch.jsl.JSLJob;

public class BatchKernelImpl
implements IBatchKernelService {
    private static final String sourceClass = BatchKernelImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static IJobIdManagementService _jobIdManagementService = null;
    private Map<Long, JobControllerImpl> instanceId2jobControllerMap = new ConcurrentHashMap<Long, JobControllerImpl>();
    private Map<Long, RuntimeJobExecutionImpl> jobExecutionInstancesMap = new ConcurrentHashMap<Long, RuntimeJobExecutionImpl>();
    ServicesManager servicesManager = ServicesManager.getInstance();
    private IBatchThreadPoolService executorService = null;
    private IJobEndCallbackService callbackService = null;
    private IPersistenceManagerService persistenceService = null;
    public static final int THREAD_POOL_SIZE = 5;

    public BatchKernelImpl() {
        _jobIdManagementService = (IJobIdManagementService)this.servicesManager.getService(ServicesManager.ServiceType.JOB_ID_MANAGEMENT_SERVICE);
        this.executorService = (IBatchThreadPoolService)this.servicesManager.getService(ServicesManager.ServiceType.BATCH_THREADPOOL_SERVICE);
        this.callbackService = (IJobEndCallbackService)this.servicesManager.getService(ServicesManager.ServiceType.CALLBACK_SERVICE);
        this.persistenceService = (IPersistenceManagerService)this.servicesManager.getService(ServicesManager.ServiceType.PERSISTENCE_MANAGEMENT_SERVICE);
    }

    @Override
    public void init(IBatchConfig pgcConfig) throws BatchContainerServiceException {
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }

    @Override
    public JobExecution startJob(String jobXML) throws JobStartException {
        return this.startJob(jobXML, null);
    }

    @Override
    public JobExecution startJob(String jobXML, Properties jobParameters) throws JobStartException {
        String method = "startJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, new Object[]{jobXML, jobParameters});
        }
        RuntimeJobExecutionImpl jobExecution = JobExecutionHelper.startJob(jobXML, jobParameters);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution constructed: " + jobExecution);
        }
        BatchWorkUnit batchWork = new BatchWorkUnit(this, jobExecution);
        this.instanceId2jobControllerMap.put(jobExecution.getInstanceId(), batchWork.getController());
        this.executorService.executeTask(batchWork, null);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, jobExecution);
        }
        return jobExecution.getJobOperatorJobExecution();
    }

    @Override
    public void stopJob(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        long jobInstanceId = this.persistenceService.jobOperatorQueryJobExecutionJobInstanceId(executionId);
        JobControllerImpl controller = this.instanceId2jobControllerMap.get(jobInstanceId);
        if (controller == null) {
            String msg = "JobExecution with execution id of " + jobInstanceId + "is not running.";
            throw new JobExecutionNotRunningException(null, msg);
        }
        controller.stop();
    }

    @Override
    public JobExecution restartJob(long executionId) throws JobRestartException {
        String method = "restartJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        Properties dummyPropObj = new Properties();
        return this.restartJob(executionId, dummyPropObj);
    }

    @Override
    public JobExecution restartJob(long executionId, Properties jobOverrideProps) throws JobRestartException {
        String method = "restartJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        RuntimeJobExecutionImpl jobExecution = JobExecutionHelper.restartJob(executionId, jobOverrideProps, false);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution constructed: " + jobExecution);
        }
        BatchWorkUnit batchWork = new BatchWorkUnit(this, jobExecution);
        this.instanceId2jobControllerMap.put(jobExecution.getInstanceId(), batchWork.getController());
        this.executorService.executeTask(batchWork, null);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, jobExecution);
        }
        return jobExecution.getJobOperatorJobExecution();
    }

    @Override
    public void jobExecutionDone(RuntimeJobExecutionImpl jobExecution) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution done, getting ready to invoke callbacks for JobExecution: " + jobExecution.getExecutionId());
        }
        this.callbackService.done(jobExecution.getExecutionId());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Done invoking callbacks for JobExecution: " + jobExecution.getExecutionId());
        }
        this.instanceId2jobControllerMap.remove(jobExecution.getInstanceId());
    }

    @Override
    public JobExecution getJobExecution(long executionId) {
        String method = "getJobExecution";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, executionId);
        }
        JobExecution retVal = null;
        retVal = JobExecutionHelper.getPersistedJobOperatorJobExecution(executionId);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, retVal);
        }
        return retVal;
    }

    @Override
    public List<StepExecution> getStepExecutions(long executionId) {
        return JobExecutionHelper.getstepExecutionIDInfoList(executionId);
    }

    @Override
    public StepExecution getStepExecution(long stepExecutionId) {
        return JobExecutionHelper.getStepExecutionIDInfo(stepExecutionId);
    }

    private String getJobStepExecId(long jobExecutionId, long stepExecutionId) {
        return String.valueOf(jobExecutionId) + ':' + String.valueOf(stepExecutionId);
    }

    private ParallelJobExecution startGeneratedJob(JSLJob jobModel, Properties partitionProps, LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue) {
        String method = "startGeneratedJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, new Object[]{jobModel, partitionProps});
        }
        RuntimeJobExecutionImpl jobExecution = JobExecutionHelper.startJob(jobModel, partitionProps, true);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution constructed: " + jobExecution);
        }
        BatchWorkUnit batchWork = new BatchWorkUnit(this, jobExecution, analyzerQueue, false);
        this.instanceId2jobControllerMap.put(jobExecution.getInstanceId(), batchWork.getController());
        this.jobExecutionInstancesMap.put(jobExecution.getExecutionId(), jobExecution);
        ParallelTaskResult result = this.executorService.executeParallelTask(batchWork, null);
        ParallelJobExecution parallelJobExec = new ParallelJobExecution(jobExecution, result);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, jobExecution);
        }
        return parallelJobExec;
    }

    public List<ParallelJobExecution> startParallelJobs(List<JSLJob> jobModels, Properties[] partitionProperties, LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue) {
        ArrayList<ParallelJobExecution> parallelJobExecs = new ArrayList<ParallelJobExecution>(jobModels.size());
        int instance = 0;
        for (JSLJob parallelJob : jobModels) {
            Properties partitionProps = partitionProperties == null ? null : partitionProperties[instance];
            ParallelJobExecution parallelJobExec = this.startGeneratedJob(parallelJob, partitionProps, analyzerQueue);
            parallelJobExecs.add(parallelJobExec);
            ++instance;
        }
        return parallelJobExecs;
    }

    @Override
    public List<Long> getExecutionIds(long jobInstance) {
        return null;
    }

    @Override
    public int getJobInstanceCount(String jobName) {
        return 0;
    }

    @Override
    public JobInstance getJobInstance(long instanceId) {
        return JobExecutionHelper.getJobInstance(instanceId);
    }

    public List<ParallelJobExecution> restartParallelJobs(List<JSLJob> jobModels, Properties[] partitionProperties, LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue) throws JobRestartException {
        ArrayList<ParallelJobExecution> parallelJobExecs = new ArrayList<ParallelJobExecution>(jobModels.size());
        int instance = 0;
        for (JSLJob parallelJob : jobModels) {
            Properties partitionProps = partitionProperties == null ? null : partitionProperties[instance];
            ParallelJobExecution parallelJobExec = this.restartGeneratedJob(parallelJob, partitionProps, analyzerQueue);
            parallelJobExecs.add(parallelJobExec);
            ++instance;
        }
        return parallelJobExecs;
    }

    private ParallelJobExecution restartGeneratedJob(JSLJob jobModel, Properties partitionProps, LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue) throws JobRestartException {
        String method = "restartGeneratedJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, new Object[]{jobModel, partitionProps});
        }
        List<Long> instanceIds = this.persistenceService.jobOperatorgetJobInstanceIds(jobModel.getId(), 0, 2);
        assert (instanceIds.size() == 1);
        List<JobExecution> partitionExecs = this.persistenceService.jobOperatorGetJobExecutions(instanceIds.get(0));
        Long execId = Long.MIN_VALUE;
        for (JobExecution partitionExec : partitionExecs) {
            if (partitionExec.getExecutionId() <= execId) continue;
            execId = partitionExec.getExecutionId();
        }
        RuntimeJobExecutionImpl jobExecution = JobExecutionHelper.restartJob(execId, partitionProps, true);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution constructed: " + jobExecution);
        }
        BatchWorkUnit batchWork = new BatchWorkUnit(this, jobExecution, analyzerQueue, false);
        this.instanceId2jobControllerMap.put(jobExecution.getInstanceId(), batchWork.getController());
        this.jobExecutionInstancesMap.put(jobExecution.getExecutionId(), jobExecution);
        ParallelTaskResult result = this.executorService.executeParallelTask(batchWork, null);
        ParallelJobExecution parallelJobExec = new ParallelJobExecution(jobExecution, result);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, jobExecution);
        }
        return parallelJobExec;
    }
}

