/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.lang.reflect.Method;
import java.util.List;
import javax.batch.annotation.AfterProcess;
import javax.batch.annotation.BeforeProcess;
import javax.batch.annotation.OnProcessError;
import jsr352.batch.jsl.Property;

public class ItemProcessListenerProxy
extends AbstractProxy {
    private Method beforeProcessMethod = null;
    private Method afterProcessMethod = null;
    private Method onProcessorErrorMethod = null;

    ItemProcessListenerProxy(Object delegate, List<Property> props) {
        super(delegate, props);
        for (Method method : delegate.getClass().getDeclaredMethods()) {
            OnProcessError onProcessorError;
            AfterProcess afterProcess;
            BeforeProcess beforeProcess = method.getAnnotation(BeforeProcess.class);
            if (beforeProcess != null) {
                this.beforeProcessMethod = method;
            }
            if ((afterProcess = method.getAnnotation(AfterProcess.class)) != null) {
                this.afterProcessMethod = method;
            }
            if ((onProcessorError = method.getAnnotation(OnProcessError.class)) == null) continue;
            this.onProcessorErrorMethod = method;
        }
    }

    public void beforeProcess() {
        if (this.beforeProcessMethod != null) {
            try {
                this.beforeProcessMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void onProcessorError() {
        if (this.onProcessorErrorMethod != null) {
            try {
                this.onProcessorErrorMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void afterProcess() {
        if (this.afterProcessMethod != null) {
            try {
                this.afterProcessMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }
}

