/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.batch.container.checkpoint;

import com.ibm.ws.batch.container.checkpoint.CheckpointAlgorithm;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.annotation.BeginCheckpoint;
import javax.batch.annotation.EndCheckpoint;

public class TimeCheckpointAlgorithm
implements CheckpointAlgorithm {
    private static Logger logger = Logger.getLogger(TimeCheckpointAlgorithm.class.getPackage().getName());
    private static final String className = TimeCheckpointAlgorithm.class.getName();
    boolean inCheckpoint = false;
    int interval = 10;
    int timeout = 60;
    long ts = 0L;
    Date date = new Date();
    long numTimes = 0L;

    public TimeCheckpointAlgorithm() {
        this.ts = this.date.getTime();
        logger.finer("TIME: in ctor, ts = " + this.ts);
    }

    @BeginCheckpoint
    public void beginCheckpoint() throws Exception {
        String method = "startCheckpoint";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, method);
        }
        this.inCheckpoint = true;
        this.date = new Date();
        this.ts = this.date.getTime();
        logger.finer("TIME: in beginCHKPT, ts = " + this.ts);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, method);
        }
    }

    @EndCheckpoint
    public void endCheckpoint() throws Exception {
        String method = "stopCheckpoint";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, method);
        }
        this.inCheckpoint = false;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, method);
        }
    }

    public int getCheckpointTimeOut(int timeOut) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getRecommendedTimeOutValue " + this.timeout);
        }
        return this.timeout;
    }

    @Override
    public boolean isReadyToCheckpoint() throws Exception {
        String method = "isReadyToCheckpoint";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, method);
        }
        boolean ready = false;
        ++this.numTimes;
        Date curDate = new Date();
        long curts = curDate.getTime();
        long curdiff = curts - this.ts;
        int diff = (int)curdiff / 1000;
        if (diff >= this.interval) {
            ready = true;
            if (logger.isLoggable(Level.FINER)) {
                logger.fine("Num of requests=" + this.numTimes + " at a rate=" + this.numTimes / (long)diff + " req/sec");
            }
            this.numTimes = 0L;
            this.date = new Date();
            this.ts = this.date.getTime();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, method, ready);
        }
        return ready;
    }

    @Override
    public void setThreshold(int INthreshHold) {
        this.interval = INthreshHold;
    }

    @Override
    public void setThresholds(int itemthreshold, int timethreshold) {
    }
}

