/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.lang.reflect.Method;
import java.util.List;
import javax.batch.annotation.AfterCheckpoint;
import javax.batch.annotation.BeforeCheckpoint;
import jsr352.batch.jsl.Property;

public class CheckpointListenerProxy
extends AbstractProxy {
    private Method beforeCheckpointMethod = null;
    private Method afterCheckpointMethod = null;

    CheckpointListenerProxy(Object delegate, List<Property> props) {
        super(delegate, props);
        for (Method method : this.delegate.getClass().getDeclaredMethods()) {
            AfterCheckpoint closeReader;
            BeforeCheckpoint openReader = method.getAnnotation(BeforeCheckpoint.class);
            if (openReader != null) {
                this.beforeCheckpointMethod = method;
            }
            if ((closeReader = method.getAnnotation(AfterCheckpoint.class)) == null) continue;
            this.afterCheckpointMethod = method;
        }
    }

    public void beforeCheckpoint() {
        if (this.beforeCheckpointMethod != null) {
            try {
                this.beforeCheckpointMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void afterCheckpoint() {
        if (this.afterCheckpointMethod != null) {
            try {
                this.afterCheckpointMethod.invoke(this.delegate, (Object[])null);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }
}

