/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.artifact.proxy;

import com.ibm.batch.container.artifact.proxy.AbstractProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import java.lang.reflect.Method;
import java.util.List;
import javax.batch.annotation.OnRetryProcessException;
import javax.batch.annotation.OnRetryProcessItem;
import javax.batch.annotation.OnRetryReadException;
import javax.batch.annotation.OnRetryReadItem;
import javax.batch.annotation.OnRetryWriteException;
import javax.batch.annotation.OnRetryWriteItem;
import jsr352.batch.jsl.Property;

public class RetryListenerProxy
extends AbstractProxy {
    private Method onRetryReadExceptionMethod = null;
    private Method onRetryReadItemMethod = null;
    private Method onRetryProcessExceptionMethod = null;
    private Method onRetryProcessItemMethod = null;
    private Method onRetryWriteExceptionMethod = null;
    private Method onRetryWriteItemMethod = null;

    RetryListenerProxy(Object delegate, List<Property> props) {
        super(delegate, props);
        for (Method method : this.delegate.getClass().getDeclaredMethods()) {
            OnRetryWriteItem onRetryWriteItem;
            OnRetryWriteException onRetryWriteException;
            OnRetryProcessItem onRetryProcessItem;
            OnRetryProcessException onRetryProcessException;
            OnRetryReadItem onRetryReadItem;
            OnRetryReadException onRetryReadException = method.getAnnotation(OnRetryReadException.class);
            if (onRetryReadException != null) {
                this.onRetryReadExceptionMethod = method;
            }
            if ((onRetryReadItem = method.getAnnotation(OnRetryReadItem.class)) != null) {
                this.onRetryReadItemMethod = method;
            }
            if ((onRetryProcessException = method.getAnnotation(OnRetryProcessException.class)) != null) {
                this.onRetryProcessExceptionMethod = method;
            }
            if ((onRetryProcessItem = method.getAnnotation(OnRetryProcessItem.class)) != null) {
                this.onRetryProcessItemMethod = method;
            }
            if ((onRetryWriteException = method.getAnnotation(OnRetryWriteException.class)) != null) {
                this.onRetryWriteExceptionMethod = method;
            }
            if ((onRetryWriteItem = method.getAnnotation(OnRetryWriteItem.class)) == null) continue;
            this.onRetryWriteItemMethod = method;
        }
    }

    public void onRetryReadException(Exception ex) {
        if (this.onRetryReadExceptionMethod != null) {
            try {
                this.onRetryReadExceptionMethod.invoke(this.delegate, ex);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void onRetryReadItem(Exception ex) {
        if (this.onRetryReadItemMethod != null) {
            try {
                this.onRetryReadItemMethod.invoke(this.delegate, ex);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void onRetryProcessException(Exception ex, Object item) {
        if (this.onRetryProcessExceptionMethod != null) {
            try {
                this.onRetryProcessExceptionMethod.invoke(this.delegate, ex, item);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void onRetryProcessItem(Exception ex, Object item) {
        if (this.onRetryProcessItemMethod != null) {
            try {
                this.onRetryProcessItemMethod.invoke(this.delegate, ex, item);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void onRetryWriteException(Exception ex, List<Object> items) {
        if (this.onRetryWriteExceptionMethod != null) {
            try {
                this.onRetryWriteExceptionMethod.invoke(this.delegate, ex, items);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public void onRetryWriteItem(Exception ex, Object item) {
        if (this.onRetryWriteItemMethod != null) {
            try {
                this.onRetryWriteItemMethod.invoke(this.delegate, ex, item);
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }
}

