/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appconfiguration.android.lib.core;

import com.ibm.appconfiguration.android.lib.core.BaseRequest;
import com.ibm.appconfiguration.android.lib.core.Logger;
import com.ibm.appconfiguration.android.lib.core.Response;
import com.ibm.appconfiguration.android.lib.core.ResponseImpl;
import com.ibm.appconfiguration.android.lib.core.ResponseListener;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 12\u00020\u0001:\u00011B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u001c\u0010\u001b\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001d\u0018\u00010\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010#\u001a\u00020\u0006H\u0016J\n\u0010$\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020!H\u0016J\u001a\u0010'\u001a\u00020\u00182\b\u0010)\u001a\u0004\u0018\u00010\u00032\u0006\u0010(\u001a\u00020!H\u0016J\u0018\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001fH\u0014J\u001a\u0010.\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\b\u0010)\u001a\u0004\u0018\u00010/H\u0002J\u0010\u00100\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u0014\u0010\t\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/ibm/appconfiguration/android/lib/core/BaseRequest;", "", "url", "", "method", "timeout", "", "autoRetries", "(Ljava/lang/String;Ljava/lang/String;II)V", "CONTENT_TYPE", "getCONTENT_TYPE", "()Ljava/lang/String;", "TEXT_PLAIN_CONTENT_TYPE", "getTEXT_PLAIN_CONTENT_TYPE", "headers", "Lokhttp3/Headers$Builder;", "httpClient", "Lokhttp3/OkHttpClient$Builder;", "numberOfRetries", "getNumberOfRetries", "()I", "setNumberOfRetries", "(I)V", "addHeader", "", "name", "value", "getAllHeaders", "", "", "getCallback", "Lokhttp3/Callback;", "responseListener", "Lcom/ibm/appconfiguration/android/lib/core/ResponseListener;", "getMethod", "getTimeout", "getUrl", "isValidMethod", "", "send", "listener", "requestBody", "sendOKHttpRequest", "request", "Lokhttp3/Request;", "callback", "sendRequest", "Lokhttp3/RequestBody;", "setTimeout", "Companion", "lib_release"})
public class BaseRequest {
    @NotNull
    private final String CONTENT_TYPE;
    @NotNull
    private final String TEXT_PLAIN_CONTENT_TYPE;
    private int numberOfRetries;
    private String url;
    private String method;
    private int timeout;
    private Headers.Builder headers;
    private final OkHttpClient.Builder httpClient;
    @NotNull
    private static final String GET;
    @NotNull
    private static final String POST;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getCONTENT_TYPE() {
        return this.CONTENT_TYPE;
    }

    @NotNull
    public final String getTEXT_PLAIN_CONTENT_TYPE() {
        return this.TEXT_PLAIN_CONTENT_TYPE;
    }

    protected final int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    protected final void setNumberOfRetries(int n) {
        this.numberOfRetries = n;
    }

    private final void setTimeout(int timeout) {
        this.timeout = timeout;
        this.httpClient.connectTimeout((long)timeout, TimeUnit.MILLISECONDS);
        this.httpClient.readTimeout((long)timeout, TimeUnit.MILLISECONDS);
        this.httpClient.writeTimeout((long)timeout, TimeUnit.MILLISECONDS);
    }

    public void addHeader(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.headers.add(name, value);
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getMethod() {
        return this.method;
    }

    @Nullable
    public Map<String, List<String>> getAllHeaders() {
        return this.headers.build().toMultimap();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void send(@NotNull ResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.send("", listener);
    }

    public void send(@Nullable String requestBody, @NotNull ResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        String contentType = this.headers.get(this.CONTENT_TYPE);
        if (contentType == null) {
            contentType = this.TEXT_PLAIN_CONTENT_TYPE;
        }
        RequestBody body = null;
        if (requestBody != null) {
            CharSequence charSequence = requestBody;
            boolean bl = false;
            if (charSequence.length() > 0) {
                body = RequestBody.Companion.create(requestBody, MediaType.Companion.parse(contentType));
            }
        }
        this.sendRequest(listener, body);
    }

    private final void sendRequest(ResponseListener responseListener, RequestBody requestBody) {
        if (!this.isValidMethod(this.method)) {
            responseListener.onFailure(null, new IllegalArgumentException("Method is not valid: " + this.method), null);
            return;
        }
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.headers(this.headers.build());
        try {
            requestBuilder.url(this.url);
        }
        catch (Exception e) {
            responseListener.onFailure(null, e, null);
            return;
        }
        if (StringsKt.equals((String)this.method, (String)GET, (boolean)true)) {
            requestBuilder.get();
        } else {
            requestBuilder.method(this.method, requestBody);
        }
        Request request = requestBuilder.build();
        this.sendOKHttpRequest(request, this.getCallback(responseListener));
    }

    protected void sendOKHttpRequest(@NotNull Request request, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        OkHttpClient client = this.httpClient.build();
        client.newCall(request).enqueue(callback);
    }

    private final Callback getCallback(ResponseListener responseListener) {
        return new Callback(this, responseListener){
            final /* synthetic */ BaseRequest this$0;
            final /* synthetic */ ResponseListener $responseListener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.this$0.getNumberOfRetries() > 0) {
                    BaseRequest baseRequest = this.this$0;
                    int n = baseRequest.getNumberOfRetries();
                    baseRequest.setNumberOfRetries(n + -1);
                    Logger.Companion.debug("Resending " + call.request().method() + " request to " + call.request().toString());
                    this.this$0.sendOKHttpRequest(call.request(), BaseRequest.access$getCallback(this.this$0, this.$responseListener));
                } else {
                    this.$responseListener.onFailure(null, e, null);
                }
            }

            public void onResponse(@NotNull Call call, @NotNull okhttp3.Response response) throws IOException {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (response.isSuccessful() || response.isRedirect()) {
                    Response bmsResponse = new ResponseImpl(response);
                    this.$responseListener.onSuccess(bmsResponse);
                } else {
                    this.$responseListener.onFailure(new ResponseImpl(response), null, null);
                }
                ResponseBody responseBody = response.body();
                Intrinsics.checkNotNull((Object)responseBody);
                responseBody.close();
            }
            {
                this.this$0 = this$0;
                this.$responseListener = $captured_local_variable$1;
            }
        };
    }

    private final boolean isValidMethod(String method) {
        return StringsKt.equals((String)method, (String)POST, (boolean)true) || StringsKt.equals((String)method, (String)GET, (boolean)true);
    }

    public BaseRequest(@NotNull String url, @NotNull String method, int timeout, int autoRetries) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.CONTENT_TYPE = "Content-Type";
        this.TEXT_PLAIN_CONTENT_TYPE = "text/plain";
        this.url = "";
        this.headers = new Headers.Builder();
        this.httpClient = Companion.getUnsafeOkHttpClient();
        this.url = url;
        this.method = method;
        this.numberOfRetries = autoRetries;
        this.setTimeout(timeout);
    }

    public /* synthetic */ BaseRequest(String string, String string2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 5000;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(string, string2, n, n2);
    }

    static {
        Companion = new Companion(null);
        GET = "GET";
        POST = "POST";
    }

    public static final /* synthetic */ Callback access$getCallback(BaseRequest $this, ResponseListener responseListener) {
        return $this.getCallback(responseListener);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/ibm/appconfiguration/android/lib/core/BaseRequest$Companion;", "", "()V", "GET", "", "getGET", "()Ljava/lang/String;", "POST", "getPOST", "getUnsafeOkHttpClient", "Lokhttp3/OkHttpClient$Builder;", "lib_release"})
    public static final class Companion {
        @NotNull
        public final String getGET() {
            return GET;
        }

        @NotNull
        public final String getPOST() {
            return POST;
        }

        @NotNull
        public final OkHttpClient.Builder getUnsafeOkHttpClient() {
            try {
                TrustManager[] trustAllCerts2 = new TrustManager[]{new X509TrustManager(){

                    public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
                        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
                    }

                    public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
                        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
                    }

                    @NotNull
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts2, new SecureRandom());
                SSLContext sSLContext = sslContext;
                Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"sslContext");
                SSLSocketFactory sslSocketFactory = sSLContext.getSocketFactory();
                OkHttpClient.Builder builder = new OkHttpClient.Builder();
                SSLSocketFactory sSLSocketFactory = sslSocketFactory;
                Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"sslSocketFactory");
                TrustManager trustManager = trustAllCerts2[0];
                if (trustManager == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
                }
                builder.sslSocketFactory(sSLSocketFactory, (X509TrustManager)trustManager);
                builder.hostnameVerifier((HostnameVerifier)getUnsafeOkHttpClient.1.INSTANCE);
                return builder;
            }
            catch (Exception e) {
                throw (Throwable)new RuntimeException(e);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

