/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.beetl.core.ErrorHandler;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.ResourceLoader;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.exception.ErrorInfo;

public class ConsoleErrorHandler
implements ErrorHandler {
    @Override
    public void processException(BeetlException ex, GroupTemplate groupTemplate, Writer writer) {
        ErrorInfo error = new ErrorInfo(ex);
        if (error.errorCode.equals("CLIENT_IO_ERROR_ERROR") && !groupTemplate.conf.isIgnoreClientIOError) {
            this.println(writer, "\u5ba2\u6237\u7aefIO\u5f02\u5e38:" + this.getResourceName(ex.resource.id) + ":" + error.msg);
            if (ex.getCause() != null) {
                this.printThrowable(writer, ex.getCause());
            }
            return;
        }
        int line = error.errorTokenLine;
        StringBuilder sb = new StringBuilder(">>").append(this.getDateTime()).append(":").append(error.type).append(":").append(error.errorTokenText).append(" \u4f4d\u4e8e").append(line != 0 ? line + "\u884c" : "").append(" \u8d44\u6e90:").append(this.getResourceName(ex.resource.id));
        if (error.errorCode.equals("TEMPLATE_LOAD_ERROR")) {
            if (error.msg != null) {
                sb.append(error.msg);
            }
            this.println(writer, sb.toString());
            this.println(writer, groupTemplate.getResourceLoader().getInfo());
            return;
        }
        this.println(writer, sb.toString());
        if (ex.getMessage() != null) {
            this.println(writer, ex.getMessage());
        }
        ResourceLoader resLoader = groupTemplate.getResourceLoader();
        String content = null;
        try {
            Resource res = ex.resource;
            int[] range = this.getRange(line);
            content = res.getContent(range[0], range[1]);
            if (content != null) {
                String[] strs = content.split(ex.cr);
                int lineNumber = range[0];
                for (String str : strs) {
                    this.print(writer, "" + lineNumber);
                    this.print(writer, "|");
                    this.println(writer, str);
                    ++lineNumber;
                }
            }
        }
        catch (IOException res) {
            // empty catch block
        }
        if (error.hasCallStack()) {
            this.println(writer, "  ========================");
            this.println(writer, "  \u8c03\u7528\u6808:");
            for (int i = 0; i < error.resourceCallStack.size(); ++i) {
                this.println(writer, "  " + error.resourceCallStack.get(i) + " \u884c\uff1a" + error.tokenCallStack.get((int)i).line);
            }
        }
        this.printCause(error, writer);
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void printCause(ErrorInfo error, Writer writer) {
        Throwable t = error.cause;
        if (t != null) {
            this.printThrowable(writer, t);
        }
    }

    protected Object getResourceName(Object resourceId) {
        return resourceId;
    }

    protected void println(Writer w, String msg) {
        System.out.println(msg);
    }

    protected void print(Writer w, String msg) {
        System.out.print(msg);
    }

    protected void printThrowable(Writer w, Throwable t) {
        t.printStackTrace();
    }

    protected int[] getRange(int line) {
        int startLine = 0;
        int endLine = 0;
        startLine = line > 3 ? line - 3 : 1;
        endLine = startLine + 6;
        return new int[]{startLine, endLine};
    }

    protected String getDateTime() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm:ss");
        return sdf.format(date);
    }
}

