/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.spring;

import java.util.Collections;
import java.util.UUID;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.beetl.core.Context;
import org.beetl.core.Function;
import org.beetl.ext.web.WebVariable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;

public class AccessExpressionIfFunction
implements Function {
    private static final FilterChain DUMMY_CHAIN = new FilterChain(){

        public void doFilter(ServletRequest request, ServletResponse response) {
            throw new UnsupportedOperationException();
        }
    };
    @Autowired
    private SecurityExpressionHandler<FilterInvocation> expressionHandler = null;

    @Override
    public Object call(Object[] paras, Context ctx) {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext == null) {
            return true;
        }
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            authentication = new AnonymousAuthenticationToken(UUID.randomUUID().toString(), (Object)"anonymous", Collections.singletonList(new SimpleGrantedAuthority("ROLE_ANONYMOUS")));
        }
        if (paras.length == 0 || paras[0] == null || !(paras[0] instanceof String)) {
            return true;
        }
        String access = (String)paras[0];
        WebVariable servlet = (WebVariable)ctx.getGlobal("servlet");
        Expression accessExpression = this.expressionHandler.getExpressionParser().parseExpression(access);
        return ExpressionUtils.evaluateAsBoolean((Expression)accessExpression, (EvaluationContext)this.expressionHandler.createEvaluationContext(authentication, (Object)new FilterInvocation((ServletRequest)servlet.getRequest(), (ServletResponse)servlet.getResponse(), DUMMY_CHAIN)));
    }
}

