/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.misc.ALU;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.IVarIndex;

public class IncDecExpression
extends Expression
implements IVarIndex {
    boolean isInc;
    boolean returnOrginal;
    int index;

    public IncDecExpression(boolean isInc, boolean returnOrginal, GrammarToken token) {
        super(token);
        this.isInc = isInc;
        this.returnOrginal = returnOrginal;
    }

    @Override
    public final Object evaluate(Context ctx) {
        Object c = ctx.vars[this.index];
        Object newValue = this.isInc ? ALU.plusOne(c, this) : ALU.minusOne(c, this);
        newValue = this.isInc ? ALU.plusOne(c, this) : ALU.minusOne(c, this);
        ctx.vars[this.index] = newValue;
        return this.returnOrginal ? c : newValue;
    }

    @Override
    public void infer(InferContext inferCtx) {
        this.type = inferCtx.types[this.index];
    }

    @Override
    public void setVarIndex(int index) {
        this.index = index;
    }

    @Override
    public int getVarIndex() {
        return this.index;
    }
}

