/*
 * Decompiled with CFR 0.152.
 */
package internal.com.getkeepsafe.relinker.elf;

import internal.com.getkeepsafe.relinker.elf.Elf;
import internal.com.getkeepsafe.relinker.elf.Elf32Header;
import internal.com.getkeepsafe.relinker.elf.Elf64Header;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ElfParser
implements Elf,
Closeable {
    private final int MAGIC = 1179403647;
    private final FileChannel channel;

    public ElfParser(File file) throws FileNotFoundException {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("File is null or does not exist");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.channel = fileInputStream.getChannel();
    }

    public Elf.Header parseHeader() throws IOException {
        boolean bl;
        this.channel.position(0L);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (this.readWord(byteBuffer, 0L) != 1179403647L) {
            throw new IllegalArgumentException("Invalid ELF Magic!");
        }
        short s = this.readByte(byteBuffer, 4L);
        boolean bl2 = bl = this.readByte(byteBuffer, 5L) == 2;
        if (s == 1) {
            return new Elf32Header(bl, this);
        }
        if (s == 2) {
            return new Elf64Header(bl, this);
        }
        throw new IllegalStateException("Invalid class type!");
    }

    public List<String> parseNeededDependencies() throws IOException {
        Elf.DynamicStructure dynamicStructure;
        this.channel.position(0L);
        ArrayList<String> arrayList = new ArrayList<String>();
        Elf.Header header = this.parseHeader();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(header.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        long l = header.phnum;
        if (l == 65535L) {
            Elf.SectionHeader sectionHeader = header.getSectionHeader(0);
            l = sectionHeader.info;
        }
        long l2 = 0L;
        for (long k = 0L; k < l; ++k) {
            Elf.ProgramHeader programHeader = header.getProgramHeader(k);
            if (programHeader.type != 2L) continue;
            l2 = programHeader.offset;
            break;
        }
        if (l2 == 0L) {
            return Collections.unmodifiableList(arrayList);
        }
        int n = 0;
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        long l3 = 0L;
        do {
            dynamicStructure = header.getDynamicStructure(l2, n);
            if (dynamicStructure.tag == 1L) {
                arrayList2.add(dynamicStructure.val);
            } else if (dynamicStructure.tag == 5L) {
                l3 = dynamicStructure.val;
            }
            ++n;
        } while (dynamicStructure.tag != 0L);
        if (l3 == 0L) {
            throw new IllegalStateException("String table offset not found!");
        }
        long l4 = this.offsetFromVma(header, l, l3);
        for (Long l5 : arrayList2) {
            arrayList.add(this.readString(byteBuffer, l4 + l5));
        }
        return arrayList;
    }

    private long offsetFromVma(Elf.Header header, long l, long l2) throws IOException {
        for (long k = 0L; k < l; ++k) {
            Elf.ProgramHeader programHeader = header.getProgramHeader(k);
            if (programHeader.type != 1L || programHeader.vaddr > l2 || l2 > programHeader.vaddr + programHeader.memsz) continue;
            return l2 - programHeader.vaddr + programHeader.offset;
        }
        throw new IllegalStateException("Could not map vma to file offset!");
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    protected String readString(ByteBuffer byteBuffer, long l) throws IOException {
        short s;
        StringBuilder stringBuilder = new StringBuilder();
        while ((s = this.readByte(byteBuffer, l++)) != 0) {
            stringBuilder.append((char)s);
        }
        return stringBuilder.toString();
    }

    protected long readLong(ByteBuffer byteBuffer, long l) throws IOException {
        this.read(byteBuffer, l, 8);
        return byteBuffer.getLong();
    }

    protected long readWord(ByteBuffer byteBuffer, long l) throws IOException {
        this.read(byteBuffer, l, 4);
        return (long)byteBuffer.getInt() & 0xFFFFFFFFL;
    }

    protected int readHalf(ByteBuffer byteBuffer, long l) throws IOException {
        this.read(byteBuffer, l, 2);
        return byteBuffer.getShort() & 0xFFFF;
    }

    protected short readByte(ByteBuffer byteBuffer, long l) throws IOException {
        this.read(byteBuffer, l, 1);
        return (short)(byteBuffer.get() & 0xFF);
    }

    protected void read(ByteBuffer byteBuffer, long l, int n) throws IOException {
        int n2;
        byteBuffer.position(0);
        byteBuffer.limit(n);
        for (long k = 0L; k < (long)n; k += (long)n2) {
            n2 = this.channel.read(byteBuffer, l + k);
            if (n2 != -1) continue;
            throw new EOFException();
        }
        byteBuffer.position(0);
    }
}

