/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.sound;

public class EMSoundEffect {
    static EMSoundEffect inst;

    public static EMSoundEffect getInstance() {
        if (inst == null) {
            inst = new EMSoundEffect();
        }
        return inst;
    }

    private EMSoundEffect() {
    }

    public boolean startPlayoutEffect(EffectConfigure effectConfigure) {
        if (effectConfigure.pitch <= 0.0f) {
            effectConfigure.pitch = 0.5f;
        }
        this.nativeNewInstance();
        this.nativeSetPitch(effectConfigure.pitch);
        int n = this.nativeStart();
        return n == 0;
    }

    public boolean stopPlayoutEffect() {
        int n = this.nativeStop();
        return n == 0;
    }

    public int updatePlayoutPitch(float f2) {
        if (f2 <= 0.0f) {
            f2 = 0.5f;
        }
        return this.nativeSetPitch(f2);
    }

    private native int nativeNewInstance();

    private native int nativeSetPitch(float var1);

    private native int nativeStart();

    private native int nativeStop();

    static {
        try {
            System.loadLibrary("emsoundeffect");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        inst = null;
    }

    public static class EffectConfigure {
        public float pitch = 1.0f;
    }
}

