/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.externalaudio;

import android.content.Context;
import android.util.Log;
import com.superrtc.externalaudio.IAudioSource;
import com.superrtc.mediamanager.EMediaManager;
import com.superrtc.wav.WavFileHeader;
import com.superrtc.wav.WavFileReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.concurrent.LinkedBlockingDeque;

public class WavSource
implements IAudioSource {
    private static final String TAG = "WavSource";
    private static final int CACHED_BUFFER_SIZE = 6;
    private static IAudioSource.LogListener sLogListener = (n, string) -> Log.i((String)TAG, (String)string);
    private Context mContext;
    private String targetFilename;
    private int targetLoopTimes;
    private boolean targetSendMix;
    private int channelCount;
    private int sampleRate;
    private Thread decodeThread;
    private HttpURLConnection httpURLConnection;
    private WavFileReader wavFileReader;
    private int _10msLength = 0;
    private byte[] _10msBytes;
    private final ByteBuffer[] currentBuffer = new ByteBuffer[2];
    private final ArrayDeque<ByteBuffer>[] decodedDataCachedQueue = new ArrayDeque[2];
    private final LinkedBlockingDeque<Integer> decodeNotifier = new LinkedBlockingDeque(6);

    public WavSource() {
        this.mContext = EMediaManager.getContext();
    }

    public static void registerLogListener(IAudioSource.LogListener logListener) {
        if (logListener != null) {
            sLogListener = logListener;
        }
    }

    @Override
    public boolean canDecode(String string) {
        return string.endsWith(".wav");
    }

    @Override
    public void create(String string, int n, boolean bl) {
        int n2;
        InputStream inputStream;
        sLogListener.onLog(6, "[WavSource] Try to create wav source: " + string + ", loop times: " + n);
        this.targetFilename = string;
        this.targetLoopTimes = n;
        this.targetSendMix = bl;
        boolean bl2 = string.startsWith("/assets/");
        boolean bl3 = string.toLowerCase().startsWith("http");
        if (bl2) {
            if (this.mContext == null) {
                sLogListener.onLog(6, "[WavSource] mContext is null, return.");
                return;
            }
            string = string.substring("/assets/".length());
            try {
                inputStream = this.mContext.getAssets().open(string);
            }
            catch (IOException iOException) {
                sLogListener.onLog(6, "[WavSource] Error when creating wav file reader from assets: " + iOException.getMessage());
                iOException.printStackTrace();
                return;
            }
        }
        if (bl3) {
            try {
                HttpURLConnection.setFollowRedirects(false);
                this.httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
                this.httpURLConnection.setConnectTimeout(3000);
                this.httpURLConnection.setReadTimeout(3000);
                this.httpURLConnection.setDoInput(true);
                this.httpURLConnection.connect();
                if (this.httpURLConnection.getResponseCode() != 200) {
                    sLogListener.onLog(6, "[WavSource] Connect to URL : " + string + " return response " + this.httpURLConnection.getResponseCode());
                    return;
                }
                inputStream = this.httpURLConnection.getInputStream();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                sLogListener.onLog(6, "[WavSource] Connect timeout on URL : " + string);
                return;
            }
            catch (IOException iOException) {
                sLogListener.onLog(6, "[WavSource] Connect IOException on URL : " + string);
                return;
            }
        }
        try {
            inputStream = new FileInputStream(string);
        }
        catch (IOException iOException) {
            sLogListener.onLog(6, "[WavSource] Error when creating wav file reader from sdcard: " + iOException.getMessage());
            iOException.printStackTrace();
            return;
        }
        this.wavFileReader = new WavFileReader();
        try {
            this.wavFileReader.openInputStream(inputStream);
        }
        catch (IOException iOException) {
            sLogListener.onLog(6, "[WavSource] Error when wav reader open input stream: " + iOException.getMessage());
            iOException.printStackTrace();
        }
        WavFileHeader wavFileHeader = this.wavFileReader.getWavFileHeader();
        this.channelCount = wavFileHeader.mNumChannel;
        this.sampleRate = wavFileHeader.mSampleRate;
        int n3 = wavFileHeader.mBitsPerSample / 8;
        this._10msLength = this.sampleRate / 100 * n3 * this.channelCount;
        this._10msBytes = new byte[this._10msLength];
        int n4 = 1;
        if (this.targetSendMix) {
            n4 = 2;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            this.decodedDataCachedQueue[n2] = new ArrayDeque(6);
        }
        for (n2 = 0; n2 < 6; ++n2) {
            this.decodeNotifier.offerLast(0);
        }
        sLogListener.onLog(6, "[WavSource] WavSource header: " + wavFileHeader.toString() + ", 10ms buffer size: " + this._10msLength);
        this.startDecodeFrameInThread();
    }

    @Override
    public void release() {
        int n;
        if (this.decodeThread != null) {
            this.decodeThread.interrupt();
            this.decodeThread = null;
        }
        if (this.httpURLConnection != null) {
            this.httpURLConnection.disconnect();
            this.httpURLConnection = null;
        }
        if (this.wavFileReader != null) {
            try {
                this.wavFileReader.closeFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.wavFileReader = null;
        }
        this.channelCount = 0;
        this.sampleRate = 0;
        this.targetFilename = null;
        this.targetLoopTimes = 0;
        this.decodeNotifier.clear();
        for (n = 0; n < this.decodedDataCachedQueue.length; ++n) {
            if (this.decodedDataCachedQueue[n] == null) continue;
            this.decodedDataCachedQueue[n].clear();
            this.decodedDataCachedQueue[n] = null;
        }
        for (n = 0; n < this.currentBuffer.length; ++n) {
            if (this.currentBuffer[n] == null) continue;
            this.currentBuffer[n].clear();
            this.currentBuffer[n] = null;
        }
        this._10msBytes = null;
        sLogListener.onLog(6, "[WavSource] WavSource released.");
    }

    @Override
    public int getChannelCount() {
        return this.channelCount;
    }

    @Override
    public int getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public ByteBuffer getDataForPlayout() {
        return this.pollFirstFromCachedQueue(0);
    }

    @Override
    public ByteBuffer getDataForSend() {
        return this.pollFirstFromCachedQueue(1);
    }

    private void startDecodeFrameInThread() {
        sLogListener.onLog(6, "[WavSource] Start audio frame decode thread.");
        if (this.decodeThread != null) {
            sLogListener.onLog(6, "[WavSource] Audio frame decode thread already started, return.");
            return;
        }
        this.decodeThread = new Thread(() -> {
            while (true) {
                try {
                    this.decodeNotifier.takeFirst();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                try {
                    this.decodeFrame();
                }
                catch (Exception exception) {
                    sLogListener.onLog(6, "[WavSource] Error when decoding audio file stream: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }, "PcmReadThread");
        this.decodeThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeFrame() {
        if (this.wavFileReader != null) {
            int n = this.wavFileReader.readData(this._10msBytes, 0, this._10msBytes.length);
            if (n == 0) {
                if (this.targetLoopTimes-- != 0) {
                    sLogListener.onLog(6, "[WavSource] decodeFrame, need to rewind WavSource");
                    this.rewind();
                } else {
                    sLogListener.onLog(6, "[WavSource] decodeFrame, need to release WavSource");
                    this.release();
                }
            }
            for (int k = 0; k < this.decodedDataCachedQueue.length; ++k) {
                if (this.decodedDataCachedQueue[k] == null) continue;
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this._10msBytes.length);
                byteBuffer.put(this._10msBytes);
                byteBuffer.position(0);
                ArrayDeque<ByteBuffer> arrayDeque = this.decodedDataCachedQueue[k];
                synchronized (arrayDeque) {
                    this.decodedDataCachedQueue[k].offerLast(byteBuffer);
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer pollFirstFromCachedQueue(int n) {
        ByteBuffer byteBuffer;
        if (this.decodedDataCachedQueue[n] == null) {
            return null;
        }
        boolean bl = true;
        ArrayDeque<ByteBuffer> arrayDeque = this.decodedDataCachedQueue[n];
        synchronized (arrayDeque) {
            byteBuffer = this.decodedDataCachedQueue[n].pollFirst();
        }
        for (int k = 0; k < this.decodedDataCachedQueue.length; ++k) {
            if (k == n || this.decodedDataCachedQueue[k] == null) continue;
            ArrayDeque<ByteBuffer> arrayDeque2 = this.decodedDataCachedQueue[k];
            synchronized (arrayDeque2) {
                int n2 = this.decodedDataCachedQueue[k].size();
                bl = n2 < 6;
            }
            if (!bl) break;
        }
        if (bl) {
            this.decodeNotifier.offerLast(0);
        }
        return byteBuffer;
    }

    private void rewind() {
        try {
            this.wavFileReader.rewind();
            sLogListener.onLog(6, "[WavSource] Source restarted by rewind.");
        }
        catch (Exception exception) {
            String string = this.targetFilename;
            int n = this.targetLoopTimes;
            boolean bl = this.targetSendMix;
            this.release();
            this.create(string, n, bl);
            sLogListener.onLog(6, "[WavSource] Source restarted by recreate.");
        }
    }
}

