/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.ViewGroup;
import com.superrtc.EglBase;
import com.superrtc.EglRenderer;
import com.superrtc.GlRectDrawer;
import com.superrtc.Logging;
import com.superrtc.RendererCommon;
import com.superrtc.SurfaceEglRenderer;
import com.superrtc.ThreadUtils;
import com.superrtc.VideoFrame;
import com.superrtc.VideoSink;

public class SurfaceViewRenderer
extends SurfaceView
implements SurfaceHolder.Callback,
RendererCommon.RendererEvents,
VideoSink {
    private static final String TAG = "SurfaceViewRenderer";
    private final String resourceName;
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
    private final SurfaceEglRenderer eglRenderer;
    private RendererCommon.RendererEvents rendererEvents;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private boolean enableFixedSize;
    private int surfaceWidth;
    private int surfaceHeight;
    private RendererCommon.ScalingType scalingType = RendererCommon.ScalingType.SCALE_ASPECT_FIT;

    public SurfaceViewRenderer(Context context) {
        super(context);
        this.resourceName = this.getResourceName();
        this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().addCallback((SurfaceHolder.Callback)this.eglRenderer);
    }

    public SurfaceViewRenderer(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.resourceName = this.getResourceName();
        this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().addCallback((SurfaceHolder.Callback)this.eglRenderer);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        boolean bl;
        super.onSizeChanged(n, n2, n3, n4);
        boolean bl2 = bl = n == 0 && n2 == 0;
        if (bl && this.getVisibility() != 4) {
            this.setVisibility(4);
            return;
        }
        if (this.getVisibility() != 0) {
            this.setVisibility(0);
        }
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents) {
        this.init(context, rendererEvents, EglBase.CONFIG_PLAIN, new GlRectDrawer());
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        this.rendererEvents = rendererEvents;
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.eglRenderer.init(context, this, nArray, glDrawer);
    }

    public int getFrameReceived() {
        return this.eglRenderer.getFramesReceived();
    }

    public void release() {
        this.eglRenderer.release();
    }

    public void addFrameListener(EglRenderer.FrameListener frameListener, float f2, RendererCommon.GlDrawer glDrawer) {
        this.eglRenderer.addFrameListener(frameListener, f2, glDrawer);
    }

    public void addFrameListener(EglRenderer.FrameListener frameListener, float f2) {
        this.eglRenderer.addFrameListener(frameListener, f2);
    }

    public void removeFrameListener(EglRenderer.FrameListener frameListener) {
        this.eglRenderer.removeFrameListener(frameListener);
    }

    public void setEnableHardwareScaler(boolean bl) {
        ThreadUtils.checkIsOnMainThread();
        this.enableFixedSize = bl;
        this.updateSurfaceSize();
    }

    public void setMirror(boolean bl) {
        this.eglRenderer.setMirror(bl);
    }

    public RendererCommon.ScalingType getScalingType() {
        return this.scalingType;
    }

    public void setScalingType(RendererCommon.ScalingType scalingType) {
        ThreadUtils.checkIsOnMainThread();
        this.scalingType = scalingType;
        this.videoLayoutMeasure.setScalingType(scalingType);
        this.requestLayout();
    }

    public void setScalingType(RendererCommon.ScalingType scalingType, RendererCommon.ScalingType scalingType2) {
        ThreadUtils.checkIsOnMainThread();
        this.scalingType = scalingType;
        this.videoLayoutMeasure.setScalingType(scalingType, scalingType2);
        this.requestLayout();
    }

    public void setFpsReduction(float f2) {
        this.eglRenderer.setFpsReduction(f2);
    }

    public void disableFpsReduction() {
        this.eglRenderer.disableFpsReduction();
    }

    public void pauseVideo() {
        this.eglRenderer.pauseVideo();
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        Logging.d(TAG, "onFrame");
        this.eglRenderer.onFrame(videoFrame);
    }

    protected void onMeasure(int n, int n2) {
        ThreadUtils.checkIsOnMainThread();
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        boolean bl = layoutParams.width > 0;
        boolean bl2 = layoutParams.height > 0;
        Point point = this.videoLayoutMeasure.measure(n, n2, this.rotatedFrameWidth, this.rotatedFrameHeight, bl, bl2);
        this.setMeasuredDimension(point.x, point.y);
        this.logD("onMeasure(). New size: " + point.x + "x" + point.y);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.setLayoutAspectRatio((float)(n3 - n) / (float)(n4 - n2));
        this.updateSurfaceSize();
    }

    private void updateSurfaceSize() {
        ThreadUtils.checkIsOnMainThread();
        if (this.enableFixedSize && this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
            int n;
            int n2;
            float f2 = (float)this.rotatedFrameWidth / (float)this.rotatedFrameHeight;
            float f3 = (float)this.getWidth() / (float)this.getHeight();
            if (f2 > f3) {
                n2 = (int)((float)this.rotatedFrameHeight * f3);
                n = this.rotatedFrameHeight;
            } else {
                n2 = this.rotatedFrameWidth;
                n = (int)((float)this.rotatedFrameWidth / f3);
            }
            int n3 = Math.min(this.getWidth(), n2);
            int n4 = Math.min(this.getHeight(), n);
            this.logD("updateSurfaceSize. Layout size: " + this.getWidth() + "x" + this.getHeight() + ", frame size: " + this.rotatedFrameWidth + "x" + this.rotatedFrameHeight + ", requested surface size: " + n3 + "x" + n4 + ", old surface size: " + this.surfaceWidth + "x" + this.surfaceHeight);
            if (n3 != this.surfaceWidth || n4 != this.surfaceHeight) {
                this.surfaceWidth = n3;
                this.surfaceHeight = n4;
                this.getHolder().setFixedSize(n3, n4);
            }
        } else {
            this.surfaceHeight = 0;
            this.surfaceWidth = 0;
            this.getHolder().setSizeFromLayout();
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        ThreadUtils.checkIsOnMainThread();
        this.surfaceHeight = 0;
        this.surfaceWidth = 0;
        this.updateSurfaceSize();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
    }

    private String getResourceName() {
        try {
            return this.getResources().getResourceEntryName(this.getId());
        }
        catch (Resources.NotFoundException notFoundException) {
            return "";
        }
    }

    public void clearImage() {
        this.eglRenderer.clearImage();
    }

    @Override
    public void onFirstFrameRendered() {
        Logging.e(TAG, "onFirstFrameRendered");
        if (this.rendererEvents != null) {
            this.rendererEvents.onFirstFrameRendered();
        }
    }

    @Override
    public void onFrameResolutionChanged(int n, int n2, int n3) {
        if (this.rendererEvents != null) {
            this.rendererEvents.onFrameResolutionChanged(n, n2, n3);
        }
        int n4 = n3 == 0 || n3 == 180 ? n : n2;
        int n5 = n3 == 0 || n3 == 180 ? n2 : n;
        this.postOrRun(() -> {
            this.rotatedFrameWidth = n4;
            this.rotatedFrameHeight = n5;
            this.updateSurfaceSize();
            this.requestLayout();
        });
    }

    private void postOrRun(Runnable runnable) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            this.post(runnable);
        }
    }

    private void logD(String string) {
        Logging.d(TAG, this.resourceName + ": " + string);
    }
}

