/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.CalledByNative;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class MediaConstraints {
    public final List<KeyValuePair> mandatory = new ArrayList<KeyValuePair>();
    public final List<KeyValuePair> optional = new ArrayList<KeyValuePair>();

    private static String stringifyKeyValuePairList(List<KeyValuePair> list) {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (KeyValuePair keyValuePair : list) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(keyValuePair.toString());
        }
        return stringBuilder.append("]").toString();
    }

    public String toString() {
        return "mandatory: " + MediaConstraints.stringifyKeyValuePairList(this.mandatory) + ", optional: " + MediaConstraints.stringifyKeyValuePairList(this.optional);
    }

    @CalledByNative
    List<KeyValuePair> getMandatory() {
        return this.mandatory;
    }

    @CalledByNative
    List<KeyValuePair> getOptional() {
        return this.optional;
    }

    public static class KeyValuePair {
        private final String key;
        private final String value;

        public KeyValuePair(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        @CalledByNative(value="KeyValuePair")
        public String getKey() {
            return this.key;
        }

        @CalledByNative(value="KeyValuePair")
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.key + ": " + this.value;
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            KeyValuePair keyValuePair = (KeyValuePair)object;
            return this.key.equals(keyValuePair.key) && this.value.equals(keyValuePair.value);
        }

        public int hashCode() {
            return this.key.hashCode() + this.value.hashCode();
        }
    }
}

