/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.annotation.TargetApi;
import android.graphics.Matrix;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.view.Surface;
import com.superrtc.CalledByNative;
import com.superrtc.CalledByNativeUnchecked;
import com.superrtc.DefaultVideoEncoderFactory;
import com.superrtc.EglBase;
import com.superrtc.EglBase14;
import com.superrtc.GlRectDrawer;
import com.superrtc.H264Utils;
import com.superrtc.Logging;
import com.superrtc.MediaCodecVideoDecoder;
import com.superrtc.PeerConnectionFactory;
import com.superrtc.ThreadUtils;
import com.superrtc.VideoCodecInfo;
import com.superrtc.VideoEncoder;
import com.superrtc.VideoEncoderFactory;
import com.superrtc.VideoFrame;
import com.superrtc.VideoFrameDrawer;
import com.superrtc.WrappedNativeVideoEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@Deprecated
@TargetApi(value=19)
public class MediaCodecVideoEncoder {
    private static final String TAG = "MediaCodecVideoEncoder";
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_TIMEOUT = 0;
    private static final int BITRATE_ADJUSTMENT_FPS = 30;
    private static final int MAXIMUM_INITIAL_FPS = 30;
    private static final double BITRATE_CORRECTION_SEC = 3.0;
    private static final double BITRATE_CORRECTION_MAX_SCALE = 4.0;
    private static final int BITRATE_CORRECTION_STEPS = 20;
    private static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000L;
    private static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000L;
    private static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000L;
    @Nullable
    private static MediaCodecVideoEncoder runningInstance;
    @Nullable
    private static MediaCodecVideoEncoderErrorCallback errorCallback;
    private static int codecErrors;
    private static Set<String> hwEncoderDisabledTypes;
    @Nullable
    private static EglBase staticEglBase;
    @Nullable
    private Thread mediaCodecThread;
    @Nullable
    private MediaCodec mediaCodec;
    private ByteBuffer[] outputBuffers;
    @Nullable
    private EglBase14 eglBase;
    private int profile;
    private int width;
    private int height;
    @Nullable
    private Surface inputSurface;
    @Nullable
    private GlRectDrawer drawer;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final int VIDEO_AVCProfileHigh = 8;
    private static final int VIDEO_AVCLevel3 = 256;
    private static final MediaCodecProperties qcomVp8HwProperties;
    private static final MediaCodecProperties exynosVp8HwProperties;
    private static final MediaCodecProperties intelVp8HwProperties;
    private static final MediaCodecProperties qcomVp9HwProperties;
    private static final MediaCodecProperties exynosVp9HwProperties;
    private static final MediaCodecProperties[] vp9HwList;
    private static final MediaCodecProperties qcomH264HwProperties;
    private static final MediaCodecProperties exynosH264HwProperties;
    private static final MediaCodecProperties mediatekH264HwProperties;
    private static final MediaCodecProperties exynosH264HighProfileHwProperties;
    private static final MediaCodecProperties[] h264HighProfileHwList;
    private static final String[] H264_HW_EXCEPTION_MODELS;
    private static final int VIDEO_ControlRateConstant = 2;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int[] supportedColorList;
    private static final int[] supportedSurfaceColorList;
    private VideoCodecType type;
    private int colorFormat;
    private BitrateAdjustmentType bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
    private double bitrateAccumulator;
    private double bitrateAccumulatorMax;
    private double bitrateObservationTimeMs;
    private int bitrateAdjustmentScaleExp;
    private int targetBitrateBps;
    private int targetFps;
    private long forcedKeyFrameMs;
    private long lastKeyFrameMs;
    @Nullable
    private ByteBuffer configData;

    public static VideoEncoderFactory createFactory() {
        return new DefaultVideoEncoderFactory(new HwEncoderFactory());
    }

    public static void setEglContext(EglBase.Context context) {
        if (staticEglBase != null) {
            Logging.w(TAG, "Egl context already set.");
            staticEglBase.release();
        }
        staticEglBase = EglBase.create(context);
    }

    public static void disposeEglContext() {
        if (staticEglBase != null) {
            staticEglBase.release();
            staticEglBase = null;
        }
    }

    @Nullable
    static EglBase.Context getEglContext() {
        return staticEglBase == null ? null : staticEglBase.getEglBaseContext();
    }

    private static MediaCodecProperties[] vp8HwList() {
        ArrayList<MediaCodecProperties> arrayList = new ArrayList<MediaCodecProperties>();
        arrayList.add(qcomVp8HwProperties);
        arrayList.add(exynosVp8HwProperties);
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-IntelVP8").equals("Enabled")) {
            arrayList.add(intelVp8HwProperties);
        }
        return arrayList.toArray(new MediaCodecProperties[arrayList.size()]);
    }

    private static final MediaCodecProperties[] h264HwList() {
        ArrayList<MediaCodecProperties> arrayList = new ArrayList<MediaCodecProperties>();
        arrayList.add(qcomH264HwProperties);
        arrayList.add(exynosH264HwProperties);
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekH264").equals("Enabled")) {
            arrayList.add(mediatekH264HwProperties);
        }
        return arrayList.toArray(new MediaCodecProperties[arrayList.size()]);
    }

    public static void setErrorCallback(MediaCodecVideoEncoderErrorCallback mediaCodecVideoEncoderErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = mediaCodecVideoEncoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, MediaCodecVideoEncoder.vp8HwList(), supportedColorList) != null;
    }

    @Nullable
    public static EncoderProperties vp8HwEncoderProperties() {
        if (hwEncoderDisabledTypes.contains(VP8_MIME_TYPE)) {
            return null;
        }
        return MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, MediaCodecVideoEncoder.vp8HwList(), supportedColorList);
    }

    public static boolean isVp9HwSupported() {
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, vp9HwList, supportedColorList) != null;
    }

    public static boolean isH264HwSupported() {
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, MediaCodecVideoEncoder.h264HwList(), supportedColorList) != null;
    }

    public static boolean isH264HighProfileHwSupported() {
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, h264HighProfileHwList, supportedColorList) != null;
    }

    public static boolean isVp8HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, MediaCodecVideoEncoder.vp8HwList(), supportedSurfaceColorList) != null;
    }

    public static boolean isVp9HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, vp9HwList, supportedSurfaceColorList) != null;
    }

    public static boolean isH264HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, MediaCodecVideoEncoder.h264HwList(), supportedSurfaceColorList) != null;
    }

    @Nullable
    private static EncoderProperties findHwEncoder(String string, MediaCodecProperties[] codecCapabilities, int[] nArray) {
        List<String> list;
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        if (string.equals(H264_MIME_TYPE) && (list = Arrays.asList(H264_HW_EXCEPTION_MODELS)).contains(Build.MODEL)) {
            Logging.w(TAG, "Model: " + Build.MODEL + " has black listed H.264 encoder.");
            return null;
        }
        for (int k = 0; k < MediaCodecList.getCodecCount(); ++k) {
            MediaCodecInfo.CodecCapabilities codecCapabilities2;
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)k);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || !mediaCodecInfo.isEncoder()) continue;
            String string2 = null;
            for (String string3 : mediaCodecInfo.getSupportedTypes()) {
                if (!string3.equals(string)) continue;
                string2 = mediaCodecInfo.getName();
                break;
            }
            if (string2 == null) continue;
            Logging.v(TAG, "Found candidate encoder " + string2);
            boolean bl = false;
            BitrateAdjustmentType bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
            for (MediaCodecProperties mediaCodecProperties : codecCapabilities) {
                if (!string2.startsWith(mediaCodecProperties.codecPrefix)) continue;
                if (Build.VERSION.SDK_INT < mediaCodecProperties.minSdk) {
                    Logging.w(TAG, "Codec " + string2 + " is disabled due to SDK version " + Build.VERSION.SDK_INT);
                    continue;
                }
                if (mediaCodecProperties.bitrateAdjustmentType != BitrateAdjustmentType.NO_ADJUSTMENT) {
                    bitrateAdjustmentType = mediaCodecProperties.bitrateAdjustmentType;
                    Logging.w(TAG, "Codec " + string2 + " requires bitrate adjustment: " + (Object)((Object)bitrateAdjustmentType));
                }
                bl = true;
                break;
            }
            if (!bl) continue;
            try {
                codecCapabilities2 = mediaCodecInfo.getCapabilitiesForType(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve encoder capabilities", illegalArgumentException);
                continue;
            }
            for (int n : codecCapabilities2.colorFormats) {
                Logging.v(TAG, "   Color: 0x" + Integer.toHexString(n));
            }
            for (int n : nArray) {
                for (int n2 : codecCapabilities2.colorFormats) {
                    if (n2 != n) continue;
                    Logging.d(TAG, "Found target encoder for mime " + string + " : " + string2 + ". Color: 0x" + Integer.toHexString(n2) + ". Bitrate adjustment: " + (Object)((Object)bitrateAdjustmentType));
                    return new EncoderProperties(string2, n2, bitrateAdjustmentType);
                }
            }
        }
        return null;
    }

    @CalledByNative
    MediaCodecVideoEncoder() {
    }

    private void checkOnMediaCodecThread() {
        if (this.mediaCodecThread.getId() != Thread.currentThread().getId()) {
            throw new RuntimeException("MediaCodecVideoEncoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
        }
    }

    public static void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        if (runningInstance != null && MediaCodecVideoEncoder.runningInstance.mediaCodecThread != null && (stackTraceElementArray = MediaCodecVideoEncoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "MediaCodecVideoEncoder stacks trace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Logging.d(TAG, stackTraceElement.toString());
            }
        }
    }

    @Nullable
    static MediaCodec createByCodecName(String string) {
        try {
            return MediaCodec.createByCodecName((String)string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @CalledByNativeUnchecked
    boolean initEncode(VideoCodecType videoCodecType, int n, int n2, int n3, int n4, int n5, boolean bl) {
        EncoderProperties encoderProperties;
        Logging.d(TAG, "Java initEncode: " + (Object)((Object)videoCodecType) + ". Profile: " + n + " : " + n2 + " x " + n3 + ". @ " + n4 + " kbps. Fps: " + n5 + ". Encode from texture : " + bl);
        this.profile = n;
        this.width = n2;
        this.height = n3;
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("Forgot to release()?");
        }
        EncoderProperties encoderProperties2 = null;
        String string = null;
        int n6 = 0;
        boolean bl2 = false;
        if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP8) {
            string = VP8_MIME_TYPE;
            encoderProperties2 = MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, MediaCodecVideoEncoder.vp8HwList(), bl ? supportedSurfaceColorList : supportedColorList);
            n6 = 100;
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP9) {
            string = VP9_MIME_TYPE;
            encoderProperties2 = MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, vp9HwList, bl ? supportedSurfaceColorList : supportedColorList);
            n6 = 100;
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_H264) {
            string = H264_MIME_TYPE;
            encoderProperties2 = MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, MediaCodecVideoEncoder.h264HwList(), bl ? supportedSurfaceColorList : supportedColorList);
            if (n == H264Profile.CONSTRAINED_HIGH.getValue()) {
                encoderProperties = MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, h264HighProfileHwList, bl ? supportedSurfaceColorList : supportedColorList);
                if (encoderProperties != null) {
                    Logging.d(TAG, "High profile H.264 encoder supported.");
                    bl2 = true;
                } else {
                    Logging.d(TAG, "High profile H.264 encoder requested, but not supported. Use baseline.");
                }
            }
            n6 = 20;
        } else {
            throw new RuntimeException("initEncode: Non-supported codec " + (Object)((Object)videoCodecType));
        }
        if (encoderProperties2 == null) {
            throw new RuntimeException("Can not find HW encoder for " + (Object)((Object)videoCodecType));
        }
        runningInstance = this;
        this.colorFormat = encoderProperties2.colorFormat;
        this.bitrateAdjustmentType = encoderProperties2.bitrateAdjustmentType;
        n5 = this.bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT ? 30 : Math.min(n5, 30);
        this.forcedKeyFrameMs = 0L;
        this.lastKeyFrameMs = -1L;
        if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP8 && encoderProperties2.codecName.startsWith(MediaCodecVideoEncoder.qcomVp8HwProperties.codecPrefix)) {
            if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
                this.forcedKeyFrameMs = 15000L;
            } else if (Build.VERSION.SDK_INT == 23) {
                this.forcedKeyFrameMs = 20000L;
            } else if (Build.VERSION.SDK_INT > 23) {
                this.forcedKeyFrameMs = 15000L;
            }
        }
        Logging.d(TAG, "Color format: " + this.colorFormat + ". Bitrate adjustment: " + (Object)((Object)this.bitrateAdjustmentType) + ". Key frame interval: " + this.forcedKeyFrameMs + " . Initial fps: " + n5);
        this.targetBitrateBps = 1000 * n4;
        this.targetFps = n5;
        this.bitrateAccumulatorMax = (double)this.targetBitrateBps / 8.0;
        this.bitrateAccumulator = 0.0;
        this.bitrateObservationTimeMs = 0.0;
        this.bitrateAdjustmentScaleExp = 0;
        this.mediaCodecThread = Thread.currentThread();
        try {
            encoderProperties = MediaFormat.createVideoFormat((String)string, (int)n2, (int)n3);
            encoderProperties.setInteger("bitrate", this.targetBitrateBps);
            encoderProperties.setInteger("bitrate-mode", 2);
            encoderProperties.setInteger("color-format", encoderProperties2.colorFormat);
            encoderProperties.setInteger("frame-rate", this.targetFps);
            encoderProperties.setInteger("i-frame-interval", n6);
            if (bl2) {
                encoderProperties.setInteger("profile", 8);
                encoderProperties.setInteger("level", 256);
            }
            Logging.d(TAG, "  Format: " + encoderProperties);
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(encoderProperties2.codecName);
            this.type = videoCodecType;
            if (this.mediaCodec == null) {
                Logging.e(TAG, "Can not create media encoder");
                this.release();
                return false;
            }
            this.mediaCodec.configure((MediaFormat)encoderProperties, null, null, 1);
            if (bl) {
                this.eglBase = new EglBase14((EglBase14.Context)MediaCodecVideoEncoder.getEglContext(), EglBase.CONFIG_RECORDABLE);
                this.inputSurface = this.mediaCodec.createInputSurface();
                this.eglBase.createSurface(this.inputSurface);
                this.drawer = new GlRectDrawer();
            }
            this.mediaCodec.start();
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            Logging.d(TAG, "Output buffers: " + this.outputBuffers.length);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initEncode failed", illegalStateException);
            this.release();
            return false;
        }
        return true;
    }

    @CalledByNativeUnchecked
    ByteBuffer[] getInputBuffers() {
        ByteBuffer[] byteBufferArray = this.mediaCodec.getInputBuffers();
        Logging.d(TAG, "Input buffers: " + byteBufferArray.length);
        return byteBufferArray;
    }

    void checkKeyFrameRequired(boolean bl, long l) {
        long l2 = (l + 500L) / 1000L;
        if (this.lastKeyFrameMs < 0L) {
            this.lastKeyFrameMs = l2;
        }
        boolean bl2 = false;
        if (!bl && this.forcedKeyFrameMs > 0L && l2 > this.lastKeyFrameMs + this.forcedKeyFrameMs) {
            bl2 = true;
        }
        if (bl || bl2) {
            if (bl) {
                Logging.d(TAG, "Sync frame request");
            } else {
                Logging.d(TAG, "Sync frame forced");
            }
            Bundle bundle = new Bundle();
            bundle.putInt("request-sync", 0);
            this.mediaCodec.setParameters(bundle);
            this.lastKeyFrameMs = l2;
        }
    }

    @CalledByNativeUnchecked
    boolean encodeBuffer(boolean bl, int n, int n2, long l) {
        this.checkOnMediaCodecThread();
        try {
            this.checkKeyFrameRequired(bl, l);
            this.mediaCodec.queueInputBuffer(n, 0, n2, l, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "encodeBuffer failed", illegalStateException);
            return false;
        }
    }

    @CalledByNativeUnchecked
    boolean encodeFrame(long l, boolean bl, VideoFrame videoFrame, int n, long l2) {
        this.checkOnMediaCodecThread();
        try {
            this.checkKeyFrameRequired(bl, l2);
            VideoFrame.Buffer buffer = videoFrame.getBuffer();
            if (buffer instanceof VideoFrame.TextureBuffer) {
                VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)buffer;
                this.eglBase.makeCurrent();
                GLES20.glClear((int)16384);
                VideoFrameDrawer.drawTexture(this.drawer, textureBuffer, new Matrix(), this.width, this.height, 0, 0, this.width, this.height);
                this.eglBase.swapBuffers(TimeUnit.MICROSECONDS.toNanos(l2));
            } else {
                VideoFrame.I420Buffer i420Buffer = buffer.toI420();
                int n2 = (this.height + 1) / 2;
                ByteBuffer byteBuffer = i420Buffer.getDataY();
                ByteBuffer byteBuffer2 = i420Buffer.getDataU();
                ByteBuffer byteBuffer3 = i420Buffer.getDataV();
                int n3 = i420Buffer.getStrideY();
                int n4 = i420Buffer.getStrideU();
                int n5 = i420Buffer.getStrideV();
                if (byteBuffer.capacity() < n3 * this.height) {
                    throw new RuntimeException("Y-plane buffer size too small.");
                }
                if (byteBuffer2.capacity() < n4 * n2) {
                    throw new RuntimeException("U-plane buffer size too small.");
                }
                if (byteBuffer3.capacity() < n5 * n2) {
                    throw new RuntimeException("V-plane buffer size too small.");
                }
                MediaCodecVideoEncoder.nativeFillInputBuffer(l, n, byteBuffer, n3, byteBuffer2, n4, byteBuffer3, n5);
                i420Buffer.release();
                int n6 = this.width * this.height * 3 / 2;
                this.mediaCodec.queueInputBuffer(n, 0, n6, l2, 0);
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "encodeFrame failed", runtimeException);
            return false;
        }
    }

    @CalledByNativeUnchecked
    void release() {
        Object object;
        Logging.d(TAG, "Java releaseEncoder");
        this.checkOnMediaCodecThread();
        class CaughtException {
            Exception e;

            CaughtException() {
            }
        }
        final CaughtException caughtException = new CaughtException();
        boolean bl = false;
        if (this.mediaCodec != null) {
            object = new CountDownLatch(1);
            Runnable runnable = new Runnable((CountDownLatch)object){
                final /* synthetic */ CountDownLatch val$releaseDone;
                {
                    this.val$releaseDone = countDownLatch;
                }

                @Override
                public void run() {
                    Logging.d(MediaCodecVideoEncoder.TAG, "Java releaseEncoder on release thread");
                    try {
                        MediaCodecVideoEncoder.this.mediaCodec.stop();
                    }
                    catch (Exception exception) {
                        Logging.e(MediaCodecVideoEncoder.TAG, "Media encoder stop failed", exception);
                    }
                    try {
                        MediaCodecVideoEncoder.this.mediaCodec.release();
                    }
                    catch (Exception exception) {
                        Logging.e(MediaCodecVideoEncoder.TAG, "Media encoder release failed", exception);
                        caughtException.e = exception;
                    }
                    Logging.d(MediaCodecVideoEncoder.TAG, "Java releaseEncoder on release thread done");
                    this.val$releaseDone.countDown();
                }
            };
            new Thread(runnable).start();
            if (!ThreadUtils.awaitUninterruptibly((CountDownLatch)object, 5000L)) {
                Logging.e(TAG, "Media encoder release timeout");
                bl = true;
            }
            this.mediaCodec = null;
        }
        this.mediaCodecThread = null;
        if (this.drawer != null) {
            this.drawer.release();
            this.drawer = null;
        }
        if (this.eglBase != null) {
            this.eglBase.release();
            this.eglBase = null;
        }
        if (this.inputSurface != null) {
            this.inputSurface.release();
            this.inputSurface = null;
        }
        runningInstance = null;
        if (bl) {
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoEncoderCriticalError(codecErrors);
            }
            throw new RuntimeException("Media encoder release timeout.");
        }
        if (caughtException.e != null) {
            object = new RuntimeException(caughtException.e);
            ((Throwable)object).setStackTrace(ThreadUtils.concatStackTraces(caughtException.e.getStackTrace(), ((Throwable)object).getStackTrace()));
            throw object;
        }
        Logging.d(TAG, "Java releaseEncoder done");
    }

    @CalledByNativeUnchecked
    private boolean setRates(int n, int n2) {
        this.checkOnMediaCodecThread();
        int n3 = 1000 * n;
        if (this.bitrateAdjustmentType == BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            this.bitrateAccumulatorMax = (double)n3 / 8.0;
            if (this.targetBitrateBps > 0 && n3 < this.targetBitrateBps) {
                this.bitrateAccumulator = this.bitrateAccumulator * (double)n3 / (double)this.targetBitrateBps;
            }
        }
        this.targetBitrateBps = n3;
        this.targetFps = n2;
        if (this.bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT && this.targetFps > 0) {
            n3 = 30 * this.targetBitrateBps / this.targetFps;
            Logging.v(TAG, "setRates: " + n + " -> " + n3 / 1000 + " kbps. Fps: " + this.targetFps);
        } else if (this.bitrateAdjustmentType == BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            Logging.v(TAG, "setRates: " + n + " kbps. Fps: " + this.targetFps + ". ExpScale: " + this.bitrateAdjustmentScaleExp);
            if (this.bitrateAdjustmentScaleExp != 0) {
                n3 = (int)((double)n3 * this.getBitrateScale(this.bitrateAdjustmentScaleExp));
            }
        } else {
            Logging.v(TAG, "setRates: " + n + " kbps. Fps: " + this.targetFps);
        }
        try {
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", n3);
            this.mediaCodec.setParameters(bundle);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "setRates failed", illegalStateException);
            return false;
        }
    }

    @CalledByNativeUnchecked
    int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            return this.mediaCodec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    @Nullable
    @CalledByNativeUnchecked
    OutputBufferInfo dequeueOutputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int n = this.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
            if (n >= 0) {
                boolean bl;
                boolean bl2 = bl = (bufferInfo.flags & 2) != 0;
                if (bl) {
                    Logging.d(TAG, "Config frame generated. Offset: " + bufferInfo.offset + ". Size: " + bufferInfo.size);
                    this.configData = ByteBuffer.allocateDirect(bufferInfo.size);
                    this.outputBuffers[n].position(bufferInfo.offset);
                    this.outputBuffers[n].limit(bufferInfo.offset + bufferInfo.size);
                    this.configData.put(this.outputBuffers[n]);
                    String string = "";
                    for (int k = 0; k < (bufferInfo.size < 8 ? bufferInfo.size : 8); ++k) {
                        string = string + Integer.toHexString(this.configData.get(k) & 0xFF) + " ";
                    }
                    Logging.d(TAG, string);
                    this.mediaCodec.releaseOutputBuffer(n, false);
                    n = this.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
                }
            }
            if (n >= 0) {
                boolean bl;
                ByteBuffer byteBuffer = this.outputBuffers[n].duplicate();
                byteBuffer.position(bufferInfo.offset);
                byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
                this.reportEncodedFrame(bufferInfo.size);
                boolean bl3 = bl = (bufferInfo.flags & 1) != 0;
                if (bl) {
                    Logging.d(TAG, "Sync frame generated");
                }
                if (bl && this.type == VideoCodecType.VIDEO_CODEC_H264) {
                    Logging.d(TAG, "Appending config frame of size " + this.configData.capacity() + " to output buffer with offset " + bufferInfo.offset + ", size " + bufferInfo.size);
                    ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.configData.capacity() + bufferInfo.size);
                    this.configData.rewind();
                    byteBuffer2.put(this.configData);
                    byteBuffer2.put(byteBuffer);
                    byteBuffer2.position(0);
                    return new OutputBufferInfo(n, byteBuffer2, bl, bufferInfo.presentationTimeUs);
                }
                return new OutputBufferInfo(n, byteBuffer.slice(), bl, bufferInfo.presentationTimeUs);
            }
            if (n == -3) {
                this.outputBuffers = this.mediaCodec.getOutputBuffers();
                return this.dequeueOutputBuffer();
            }
            if (n == -2) {
                return this.dequeueOutputBuffer();
            }
            if (n == -1) {
                return null;
            }
            throw new RuntimeException("dequeueOutputBuffer: " + n);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueOutputBuffer failed", illegalStateException);
            return new OutputBufferInfo(-1, null, false, -1L);
        }
    }

    private double getBitrateScale(int n) {
        return Math.pow(4.0, (double)n / 20.0);
    }

    private void reportEncodedFrame(int n) {
        if (this.targetFps == 0 || this.bitrateAdjustmentType != BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            return;
        }
        double d2 = (double)this.targetBitrateBps / (8.0 * (double)this.targetFps);
        this.bitrateAccumulator += (double)n - d2;
        this.bitrateObservationTimeMs += 1000.0 / (double)this.targetFps;
        double d3 = 3.0 * this.bitrateAccumulatorMax;
        this.bitrateAccumulator = Math.min(this.bitrateAccumulator, d3);
        this.bitrateAccumulator = Math.max(this.bitrateAccumulator, -d3);
        if (this.bitrateObservationTimeMs > 3000.0) {
            Logging.d(TAG, "Acc: " + (int)this.bitrateAccumulator + ". Max: " + (int)this.bitrateAccumulatorMax + ". ExpScale: " + this.bitrateAdjustmentScaleExp);
            boolean bl = false;
            if (this.bitrateAccumulator > this.bitrateAccumulatorMax) {
                int n2 = (int)(this.bitrateAccumulator / this.bitrateAccumulatorMax + 0.5);
                this.bitrateAdjustmentScaleExp -= n2;
                this.bitrateAccumulator = this.bitrateAccumulatorMax;
                bl = true;
            } else if (this.bitrateAccumulator < -this.bitrateAccumulatorMax) {
                int n3 = (int)(-this.bitrateAccumulator / this.bitrateAccumulatorMax + 0.5);
                this.bitrateAdjustmentScaleExp += n3;
                this.bitrateAccumulator = -this.bitrateAccumulatorMax;
                bl = true;
            }
            if (bl) {
                this.bitrateAdjustmentScaleExp = Math.min(this.bitrateAdjustmentScaleExp, 20);
                this.bitrateAdjustmentScaleExp = Math.max(this.bitrateAdjustmentScaleExp, -20);
                Logging.d(TAG, "Adjusting bitrate scale to " + this.bitrateAdjustmentScaleExp + ". Value: " + this.getBitrateScale(this.bitrateAdjustmentScaleExp));
                this.setRates(this.targetBitrateBps / 1000, this.targetFps);
            }
            this.bitrateObservationTimeMs = 0.0;
        }
    }

    @CalledByNativeUnchecked
    boolean releaseOutputBuffer(int n) {
        this.checkOnMediaCodecThread();
        try {
            this.mediaCodec.releaseOutputBuffer(n, false);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "releaseOutputBuffer failed", illegalStateException);
            return false;
        }
    }

    @CalledByNative
    int getColorFormat() {
        return this.colorFormat;
    }

    @CalledByNative
    static boolean isTextureBuffer(VideoFrame.Buffer buffer) {
        return buffer instanceof VideoFrame.TextureBuffer;
    }

    private static native void nativeFillInputBuffer(long var0, int var2, ByteBuffer var3, int var4, ByteBuffer var5, int var6, ByteBuffer var7, int var8);

    private static native long nativeCreateEncoder(VideoCodecInfo var0, boolean var1);

    static {
        hwEncoderDisabledTypes = new HashSet<String>();
        qcomVp8HwProperties = new MediaCodecProperties("OMX.qcom.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
        exynosVp8HwProperties = new MediaCodecProperties("OMX.Exynos.", 23, BitrateAdjustmentType.DYNAMIC_ADJUSTMENT);
        intelVp8HwProperties = new MediaCodecProperties("OMX.Intel.", 21, BitrateAdjustmentType.NO_ADJUSTMENT);
        qcomVp9HwProperties = new MediaCodecProperties("OMX.qcom.", 24, BitrateAdjustmentType.NO_ADJUSTMENT);
        exynosVp9HwProperties = new MediaCodecProperties("OMX.Exynos.", 24, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT);
        vp9HwList = new MediaCodecProperties[]{qcomVp9HwProperties, exynosVp9HwProperties};
        qcomH264HwProperties = new MediaCodecProperties("OMX.qcom.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
        exynosH264HwProperties = new MediaCodecProperties("OMX.Exynos.", 21, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT);
        mediatekH264HwProperties = new MediaCodecProperties("OMX.MTK.", 27, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT);
        exynosH264HighProfileHwProperties = new MediaCodecProperties("OMX.Exynos.", 23, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT);
        h264HighProfileHwList = new MediaCodecProperties[]{exynosH264HighProfileHwProperties};
        H264_HW_EXCEPTION_MODELS = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4"};
        supportedColorList = new int[]{19, 21, 2141391872, 2141391876};
        supportedSurfaceColorList = new int[]{2130708361};
    }

    static class OutputBufferInfo {
        public final int index;
        public final ByteBuffer buffer;
        public final boolean isKeyFrame;
        public final long presentationTimestampUs;

        public OutputBufferInfo(int n, ByteBuffer byteBuffer, boolean bl, long l) {
            this.index = n;
            this.buffer = byteBuffer;
            this.isKeyFrame = bl;
            this.presentationTimestampUs = l;
        }

        @CalledByNative(value="OutputBufferInfo")
        int getIndex() {
            return this.index;
        }

        @CalledByNative(value="OutputBufferInfo")
        ByteBuffer getBuffer() {
            return this.buffer;
        }

        @CalledByNative(value="OutputBufferInfo")
        boolean isKeyFrame() {
            return this.isKeyFrame;
        }

        @CalledByNative(value="OutputBufferInfo")
        long getPresentationTimestampUs() {
            return this.presentationTimestampUs;
        }
    }

    public static class EncoderProperties {
        public final String codecName;
        public final int colorFormat;
        public final BitrateAdjustmentType bitrateAdjustmentType;

        public EncoderProperties(String string, int n, BitrateAdjustmentType bitrateAdjustmentType) {
            this.codecName = string;
            this.colorFormat = n;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
        }
    }

    public static interface MediaCodecVideoEncoderErrorCallback {
        public void onMediaCodecVideoEncoderCriticalError(int var1);
    }

    private static class MediaCodecProperties {
        public final String codecPrefix;
        public final int minSdk;
        public final BitrateAdjustmentType bitrateAdjustmentType;

        MediaCodecProperties(String string, int n, BitrateAdjustmentType bitrateAdjustmentType) {
            this.codecPrefix = string;
            this.minSdk = n;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
        }
    }

    public static enum H264Profile {
        CONSTRAINED_BASELINE(0),
        BASELINE(1),
        MAIN(2),
        CONSTRAINED_HIGH(3),
        HIGH(4);

        private final int value;

        private H264Profile(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum BitrateAdjustmentType {
        NO_ADJUSTMENT,
        FRAMERATE_ADJUSTMENT,
        DYNAMIC_ADJUSTMENT;

    }

    public static enum VideoCodecType {
        VIDEO_CODEC_UNKNOWN,
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;


        @CalledByNative(value="VideoCodecType")
        static VideoCodecType fromNativeIndex(int n) {
            return VideoCodecType.values()[n];
        }
    }

    static class HwEncoderFactory
    implements VideoEncoderFactory {
        private final VideoCodecInfo[] supportedHardwareCodecs = HwEncoderFactory.getSupportedHardwareCodecs();

        HwEncoderFactory() {
        }

        private static boolean isSameCodec(VideoCodecInfo videoCodecInfo, VideoCodecInfo videoCodecInfo2) {
            if (!videoCodecInfo.name.equalsIgnoreCase(videoCodecInfo2.name)) {
                return false;
            }
            return videoCodecInfo.name.equalsIgnoreCase("H264") ? H264Utils.isSameH264Profile(videoCodecInfo.params, videoCodecInfo2.params) : true;
        }

        private static boolean isCodecSupported(VideoCodecInfo[] videoCodecInfoArray, VideoCodecInfo videoCodecInfo) {
            for (VideoCodecInfo videoCodecInfo2 : videoCodecInfoArray) {
                if (!HwEncoderFactory.isSameCodec(videoCodecInfo2, videoCodecInfo)) continue;
                return true;
            }
            return false;
        }

        private static VideoCodecInfo[] getSupportedHardwareCodecs() {
            ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
            if (MediaCodecVideoEncoder.isVp8HwSupported()) {
                Logging.d(MediaCodecVideoEncoder.TAG, "VP8 HW Encoder supported.");
                arrayList.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
            }
            if (MediaCodecVideoEncoder.isVp9HwSupported()) {
                Logging.d(MediaCodecVideoEncoder.TAG, "VP9 HW Encoder supported.");
                arrayList.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
            }
            if (MediaCodecVideoDecoder.isH264HighProfileHwSupported()) {
                Logging.d(MediaCodecVideoEncoder.TAG, "H.264 High Profile HW Encoder supported.");
                arrayList.add(H264Utils.DEFAULT_H264_HIGH_PROFILE_CODEC);
            }
            if (MediaCodecVideoEncoder.isH264HwSupported()) {
                Logging.d(MediaCodecVideoEncoder.TAG, "H.264 HW Encoder supported.");
                arrayList.add(H264Utils.DEFAULT_H264_BASELINE_PROFILE_CODEC);
            }
            return arrayList.toArray(new VideoCodecInfo[arrayList.size()]);
        }

        @Override
        public VideoCodecInfo[] getSupportedCodecs() {
            return this.supportedHardwareCodecs;
        }

        @Override
        @Nullable
        public VideoEncoder createEncoder(final VideoCodecInfo videoCodecInfo) {
            if (!HwEncoderFactory.isCodecSupported(this.supportedHardwareCodecs, videoCodecInfo)) {
                Logging.d(MediaCodecVideoEncoder.TAG, "No HW video encoder for codec " + videoCodecInfo.name);
                return null;
            }
            Logging.d(MediaCodecVideoEncoder.TAG, "Create HW video encoder for " + videoCodecInfo.name);
            return new WrappedNativeVideoEncoder(){

                @Override
                public long createNativeVideoEncoder() {
                    return MediaCodecVideoEncoder.nativeCreateEncoder(videoCodecInfo, staticEglBase instanceof EglBase14);
                }

                @Override
                public boolean isHardwareEncoder() {
                    return true;
                }
            };
        }
    }
}

