/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.Loggable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class Logging {
    private static final Logger fallbackLogger = Logging.createFallbackLogger();
    private static volatile boolean loggingEnabled;
    @Nullable
    private static Loggable loggable;
    private static Severity loggableSeverity;

    private static Logger createFallbackLogger() {
        Logger logger = Logger.getLogger("com.superrtc.Logging");
        logger.setLevel(Level.ALL);
        return logger;
    }

    static void injectLoggable(Loggable loggable, Severity severity) {
        if (loggable != null) {
            Logging.loggable = loggable;
            loggableSeverity = severity;
        }
    }

    static void deleteInjectedLoggable() {
        loggable = null;
    }

    public static void enableLogThreads() {
        Logging.nativeEnableLogThreads();
    }

    public static void enableLogTimeStamps() {
        Logging.nativeEnableLogTimeStamps();
    }

    @Deprecated
    public static void enableTracing(String string, EnumSet<TraceLevel> enumSet) {
    }

    public static synchronized void enableLogToDebugOutput(Severity severity) {
        if (loggable != null) {
            throw new IllegalStateException("Logging to native debug output not supported while Loggable is injected. Delete the Loggable before calling this method.");
        }
        Logging.nativeEnableLogToDebugOutput(severity.ordinal());
        loggingEnabled = true;
    }

    public static void log(Severity severity, String string, String string2) {
        Level level;
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Logging tag or message may not be null.");
        }
        if (loggable != null) {
            if (severity.ordinal() < loggableSeverity.ordinal()) {
                return;
            }
            loggable.onLogMessage(string2, severity, string);
            return;
        }
        if (loggingEnabled) {
            Logging.nativeLog(severity.ordinal(), string, string2);
            return;
        }
        switch (severity) {
            case LS_ERROR: {
                level = Level.SEVERE;
                break;
            }
            case LS_WARNING: {
                level = Level.WARNING;
                break;
            }
            case LS_INFO: {
                level = Level.INFO;
                break;
            }
            default: {
                level = Level.FINE;
            }
        }
        fallbackLogger.log(level, string + ": " + string2);
    }

    public static void d(String string, String string2) {
        Logging.log(Severity.LS_INFO, string, string2);
    }

    public static void e(String string, String string2) {
        Logging.log(Severity.LS_ERROR, string, string2);
    }

    public static void w(String string, String string2) {
        Logging.log(Severity.LS_WARNING, string, string2);
    }

    public static void e(String string, String string2, Throwable throwable) {
        Logging.log(Severity.LS_ERROR, string, string2);
        Logging.log(Severity.LS_ERROR, string, throwable.toString());
        Logging.log(Severity.LS_ERROR, string, Logging.getStackTraceString(throwable));
    }

    public static void w(String string, String string2, Throwable throwable) {
        Logging.log(Severity.LS_WARNING, string, string2);
        Logging.log(Severity.LS_WARNING, string, throwable.toString());
        Logging.log(Severity.LS_WARNING, string, Logging.getStackTraceString(throwable));
    }

    public static void v(String string, String string2) {
        Logging.log(Severity.LS_VERBOSE, string, string2);
    }

    private static String getStackTraceString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private static native void nativeEnableLogToDebugOutput(int var0);

    private static native void nativeEnableLogThreads();

    private static native void nativeEnableLogTimeStamps();

    private static native void nativeLog(int var0, String var1, String var2);

    public static enum Severity {
        LS_SENSITIVE,
        LS_VERBOSE,
        LS_INFO,
        LS_WARNING,
        LS_ERROR,
        LS_NONE;

    }

    @Deprecated
    public static enum TraceLevel {
        TRACE_NONE(0),
        TRACE_STATEINFO(1),
        TRACE_WARNING(2),
        TRACE_ERROR(4),
        TRACE_CRITICAL(8),
        TRACE_APICALL(16),
        TRACE_DEFAULT(255),
        TRACE_MODULECALL(32),
        TRACE_MEMORY(256),
        TRACE_TIMER(512),
        TRACE_STREAM(1024),
        TRACE_DEBUG(2048),
        TRACE_INFO(4096),
        TRACE_TERSEINFO(8192),
        TRACE_ALL(65535);

        public final int level;

        private TraceLevel(int n2) {
            this.level = n2;
        }
    }
}

