/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.EglBase;
import com.superrtc.HardwareVideoDecoderFactory;
import com.superrtc.PlatformSoftwareVideoDecoderFactory;
import com.superrtc.SoftwareVideoDecoderFactory;
import com.superrtc.VideoCodecInfo;
import com.superrtc.VideoDecoder;
import com.superrtc.VideoDecoderFactory;
import com.superrtc.VideoDecoderFallback;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;

public class DefaultVideoDecoderFactory
implements VideoDecoderFactory {
    private final VideoDecoderFactory hardwareVideoDecoderFactory;
    private final VideoDecoderFactory softwareVideoDecoderFactory = new SoftwareVideoDecoderFactory();
    @Nullable
    private final VideoDecoderFactory platformSoftwareVideoDecoderFactory;

    public DefaultVideoDecoderFactory(@Nullable EglBase.Context context) {
        this.hardwareVideoDecoderFactory = new HardwareVideoDecoderFactory(context);
        this.platformSoftwareVideoDecoderFactory = new PlatformSoftwareVideoDecoderFactory(context);
    }

    DefaultVideoDecoderFactory(VideoDecoderFactory videoDecoderFactory) {
        this.hardwareVideoDecoderFactory = videoDecoderFactory;
        this.platformSoftwareVideoDecoderFactory = null;
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo videoCodecInfo) {
        VideoDecoder videoDecoder = this.softwareVideoDecoderFactory.createDecoder(videoCodecInfo);
        VideoDecoder videoDecoder2 = this.hardwareVideoDecoderFactory.createDecoder(videoCodecInfo);
        if (videoDecoder == null && this.platformSoftwareVideoDecoderFactory != null) {
            videoDecoder = this.platformSoftwareVideoDecoderFactory.createDecoder(videoCodecInfo);
        }
        if (videoDecoder2 != null && videoDecoder != null) {
            return new VideoDecoderFallback(videoDecoder, videoDecoder2);
        }
        return videoDecoder2 != null ? videoDecoder2 : videoDecoder;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        LinkedHashSet<VideoCodecInfo> linkedHashSet = new LinkedHashSet<VideoCodecInfo>();
        linkedHashSet.addAll(Arrays.asList(this.softwareVideoDecoderFactory.getSupportedCodecs()));
        linkedHashSet.addAll(Arrays.asList(this.hardwareVideoDecoderFactory.getSupportedCodecs()));
        if (this.platformSoftwareVideoDecoderFactory != null) {
            linkedHashSet.addAll(Arrays.asList(this.platformSoftwareVideoDecoderFactory.getSupportedCodecs()));
        }
        return linkedHashSet.toArray(new VideoCodecInfo[linkedHashSet.size()]);
    }
}

