/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.superrtc.CameraEnumerator;
import com.superrtc.CameraSession;
import com.superrtc.CameraVideoCapturer;
import com.superrtc.CapturerObserver;
import com.superrtc.ICameraInterface;
import com.superrtc.Logging;
import com.superrtc.RendererCommon;
import com.superrtc.SurfaceTextureHelper;
import com.superrtc.VideoFrame;
import java.util.Arrays;
import javax.annotation.Nullable;

abstract class CameraCapturer
implements CameraVideoCapturer,
ICameraInterface {
    private static final String TAG = "CameraCapturer";
    private static final int MAX_OPEN_CAMERA_ATTEMPTS = 3;
    private static final int OPEN_CAMERA_DELAY_MS = 500;
    private static final int OPEN_CAMERA_TIMEOUT = 10000;
    private final CameraEnumerator cameraEnumerator;
    @Nullable
    private final CameraVideoCapturer.CameraEventsHandler eventsHandler;
    private final Handler uiThreadHandler;
    private int frameRotation = 0;
    @Nullable
    private final CameraSession.CreateSessionCallback createSessionCallback = new CameraSession.CreateSessionCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDone(CameraSession cameraSession) {
            CameraCapturer.this.checkIsOnCameraThread();
            Logging.d(CameraCapturer.TAG, "Create session done. Switch state: " + (Object)((Object)CameraCapturer.this.switchState));
            CameraCapturer.this.uiThreadHandler.removeCallbacks(CameraCapturer.this.openCameraTimeoutRunnable);
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.capturerObserver.onCapturerStarted(true);
                CameraCapturer.this.sessionOpening = false;
                CameraCapturer.this.currentSession = cameraSession;
                CameraCapturer.this.cameraStatistics = new CameraVideoCapturer.CameraStatistics(CameraCapturer.this.surfaceHelper, CameraCapturer.this.eventsHandler);
                CameraCapturer.this.firstFrameObserved = false;
                CameraCapturer.this.stateLock.notifyAll();
                if (CameraCapturer.this.switchState == SwitchState.IN_PROGRESS) {
                    CameraCapturer.this.switchState = SwitchState.IDLE;
                    if (CameraCapturer.this.switchEventsHandler != null) {
                        CameraCapturer.this.switchEventsHandler.onCameraSwitchDone(CameraCapturer.this.cameraEnumerator.isFrontFacing(CameraCapturer.this.cameraName));
                        CameraCapturer.this.switchEventsHandler = null;
                    }
                } else if (CameraCapturer.this.switchState == SwitchState.PENDING) {
                    CameraCapturer.this.switchState = SwitchState.IDLE;
                    CameraCapturer.this.switchCameraInternal(CameraCapturer.this.switchEventsHandler);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(CameraSession.FailureType failureType, String string) {
            CameraCapturer.this.checkIsOnCameraThread();
            CameraCapturer.this.uiThreadHandler.removeCallbacks(CameraCapturer.this.openCameraTimeoutRunnable);
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.capturerObserver.onCapturerStarted(false);
                CameraCapturer.this.openAttemptsRemaining--;
                if (CameraCapturer.this.openAttemptsRemaining <= 0) {
                    Logging.w(CameraCapturer.TAG, "Opening camera failed, passing: " + string);
                    CameraCapturer.this.sessionOpening = false;
                    CameraCapturer.this.stateLock.notifyAll();
                    if (CameraCapturer.this.switchState != SwitchState.IDLE) {
                        if (CameraCapturer.this.switchEventsHandler != null) {
                            CameraCapturer.this.switchEventsHandler.onCameraSwitchError(string);
                            CameraCapturer.this.switchEventsHandler = null;
                        }
                        CameraCapturer.this.switchState = SwitchState.IDLE;
                    }
                    if (failureType == CameraSession.FailureType.DISCONNECTED) {
                        CameraCapturer.this.eventsHandler.onCameraDisconnected();
                    } else {
                        CameraCapturer.this.eventsHandler.onCameraError(string);
                    }
                } else {
                    Logging.w(CameraCapturer.TAG, "Opening camera failed, retry: " + string);
                    CameraCapturer.this.createSessionInternal(500);
                }
            }
        }
    };
    @Nullable
    private final CameraSession.Events cameraSessionEventsHandler = new CameraSession.Events(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraOpening() {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (CameraCapturer.this.currentSession != null) {
                    Logging.w(CameraCapturer.TAG, "onCameraOpening while session was open.");
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraOpening(CameraCapturer.this.cameraName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraError(CameraSession cameraSession, String string) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (cameraSession != CameraCapturer.this.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onCameraError from another session: " + string);
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraError(string);
                CameraCapturer.this.stopCapture();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraDisconnected(CameraSession cameraSession) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (cameraSession != CameraCapturer.this.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onCameraDisconnected from another session.");
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraDisconnected();
                CameraCapturer.this.stopCapture();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraClosed(CameraSession cameraSession) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (cameraSession != CameraCapturer.this.currentSession && CameraCapturer.this.currentSession != null) {
                    Logging.d(CameraCapturer.TAG, "onCameraClosed from another session.");
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraClosed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrameCaptured(CameraSession cameraSession, VideoFrame videoFrame) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (cameraSession != CameraCapturer.this.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onFrameCaptured from another session.");
                    return;
                }
                if (!CameraCapturer.this.firstFrameObserved) {
                    CameraCapturer.this.eventsHandler.onFirstFrameAvailable();
                    CameraCapturer.this.firstFrameObserved = true;
                }
                CameraCapturer.this.cameraStatistics.addFrame();
                if (CameraCapturer.this.frameRotation != 0) {
                    videoFrame.setRotation(CameraCapturer.this.frameRotation);
                }
                CameraCapturer.this.capturerObserver.onFrameCaptured(videoFrame);
            }
        }
    };
    private final Runnable openCameraTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            CameraCapturer.this.eventsHandler.onCameraError("Camera failed to start within timeout.");
        }
    };
    @Nullable
    Handler cameraThreadHandler;
    private Context applicationContext;
    private CapturerObserver capturerObserver;
    @Nullable
    private SurfaceTextureHelper surfaceHelper;
    private final Object stateLock = new Object();
    private boolean sessionOpening;
    @Nullable
    CameraSession currentSession;
    private String cameraName;
    private int width;
    private int height;
    private int framerate;
    private int openAttemptsRemaining;
    private SwitchState switchState = SwitchState.IDLE;
    @Nullable
    private CameraVideoCapturer.CameraSwitchHandler switchEventsHandler;
    @Nullable
    private CameraVideoCapturer.CameraStatistics cameraStatistics;
    private boolean firstFrameObserved;

    @Override
    public synchronized void takeCameraPicture(ICameraInterface.ITakeCallback iTakeCallback) {
        if (this.currentSession == null) {
            if (iTakeCallback != null) {
                iTakeCallback.onError(100, "open camera failed");
            }
            return;
        }
        this.currentSession.takeCameraPicture(iTakeCallback);
    }

    @Override
    public void handleZoom(Float f2) {
        if (this.currentSession == null) {
            return;
        }
        this.currentSession.handleZoom(f2);
    }

    @Override
    public void handleFocusMetering(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.currentSession == null) {
            return;
        }
        this.currentSession.handleFocusMetering(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void handleManualFocus(int n, int n2, int n3, int n4, int n5, int n6, RendererCommon.ScalingType scalingType) {
        if (this.currentSession == null) {
            return;
        }
        this.currentSession.handleManualFocus(n, n2, n3, n4, n5, n6, scalingType);
    }

    @Override
    public void handleManualZoom(boolean bl, int n) {
        if (this.currentSession == null) {
            return;
        }
        this.currentSession.handleManualZoom(bl, n);
    }

    @Override
    public void handleFlashLight(boolean bl) {
        if (this.currentSession == null) {
            return;
        }
        this.currentSession.handleFlashLight(bl);
    }

    public CameraCapturer(String string, @Nullable CameraVideoCapturer.CameraEventsHandler cameraEventsHandler, CameraEnumerator cameraEnumerator) {
        if (cameraEventsHandler == null) {
            cameraEventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

                @Override
                public void onCameraError(String string) {
                }

                @Override
                public void onCameraDisconnected() {
                }

                @Override
                public void onCameraFreezed(String string) {
                }

                @Override
                public void onCameraOpening(String string) {
                    Logging.e(CameraCapturer.TAG, "onCameraOpenning");
                }

                @Override
                public void onFirstFrameAvailable() {
                }

                @Override
                public void onCameraClosed() {
                }
            };
        }
        this.eventsHandler = cameraEventsHandler;
        this.cameraEnumerator = cameraEnumerator;
        this.cameraName = string;
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        String[] stringArray = cameraEnumerator.getDeviceNames();
        if (stringArray.length == 0) {
            throw new RuntimeException("No cameras attached.");
        }
        if (!Arrays.asList(stringArray).contains(this.cameraName)) {
            throw new IllegalArgumentException("Camera name " + this.cameraName + " does not match any known camera device.");
        }
    }

    @Override
    public void initialize(@Nullable SurfaceTextureHelper surfaceTextureHelper, Context context, CapturerObserver capturerObserver) {
        this.applicationContext = context;
        this.capturerObserver = capturerObserver;
        this.surfaceHelper = surfaceTextureHelper;
        this.cameraThreadHandler = surfaceTextureHelper == null ? null : surfaceTextureHelper.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCapture(int n, int n2, int n3) {
        Logging.d(TAG, "startCapture: " + n + "x" + n2 + "@" + n3);
        if (this.applicationContext == null) {
            throw new RuntimeException("CameraCapturer must be initialized before calling startCapture.");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.sessionOpening || this.currentSession != null) {
                Logging.w(TAG, "Session already open");
                return;
            }
            this.width = n;
            this.height = n2;
            this.framerate = n3;
            this.sessionOpening = true;
            this.openAttemptsRemaining = 3;
            this.createSessionInternal(0);
        }
    }

    private void createSessionInternal(int n) {
        this.uiThreadHandler.postDelayed(this.openCameraTimeoutRunnable, (long)(n + 10000));
        this.cameraThreadHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CameraCapturer.this.createCameraSession(CameraCapturer.this.createSessionCallback, CameraCapturer.this.cameraSessionEventsHandler, CameraCapturer.this.applicationContext, CameraCapturer.this.surfaceHelper, CameraCapturer.this.cameraName, CameraCapturer.this.width, CameraCapturer.this.height, CameraCapturer.this.framerate);
            }
        }, (long)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopCapture() {
        Logging.d(TAG, "Stop capture");
        Object object = this.stateLock;
        synchronized (object) {
            while (this.sessionOpening) {
                Logging.d(TAG, "Stop capture: Waiting for session to open");
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Logging.w(TAG, "Stop capture interrupted while waiting for the session to open.");
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (this.currentSession != null) {
                Logging.d(TAG, "Stop capture: Nulling session");
                this.cameraStatistics.release();
                this.cameraStatistics = null;
                final CameraSession cameraSession = this.currentSession;
                this.cameraThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        cameraSession.stop();
                    }
                });
                this.currentSession = null;
                this.capturerObserver.onCapturerStopped();
            } else {
                Logging.d(TAG, "Stop capture: No session open");
            }
        }
        Logging.d(TAG, "Stop capture done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeCaptureFormat(int n, int n2, int n3) {
        Logging.d(TAG, "changeCaptureFormat: " + n + "x" + n2 + "@" + n3);
        Object object = this.stateLock;
        synchronized (object) {
            this.stopCapture();
            this.startCapture(n, n2, n3);
        }
    }

    @Override
    public void dispose() {
        Logging.d(TAG, "dispose");
        this.stopCapture();
    }

    @Override
    public void switchCamera(final CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        Logging.d(TAG, "switchCamera");
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                CameraCapturer.this.switchCameraInternal(cameraSwitchHandler);
            }
        });
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    @Override
    public void setRotation(int n) {
        this.frameRotation = n;
    }

    public void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        Thread thread = null;
        if (this.cameraThreadHandler != null) {
            thread = this.cameraThreadHandler.getLooper().getThread();
        }
        if (thread != null && (stackTraceElementArray = thread.getStackTrace()).length > 0) {
            Logging.d(TAG, "CameraCapturer stack trace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Logging.d(TAG, stackTraceElement.toString());
            }
        }
    }

    private void reportCameraSwitchError(String string, @Nullable CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        Logging.e(TAG, string);
        if (cameraSwitchHandler != null) {
            cameraSwitchHandler.onCameraSwitchError(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchCameraInternal(@Nullable CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        Logging.d(TAG, "switchCamera internal");
        String[] stringArray = this.cameraEnumerator.getDeviceNames();
        if (stringArray.length < 2) {
            if (cameraSwitchHandler != null) {
                cameraSwitchHandler.onCameraSwitchError("No camera to switch to.");
            }
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.switchState != SwitchState.IDLE) {
                this.reportCameraSwitchError("Camera switch already in progress.", cameraSwitchHandler);
                return;
            }
            if (!this.sessionOpening && this.currentSession == null) {
                this.reportCameraSwitchError("switchCamera: camera is not running.", cameraSwitchHandler);
                return;
            }
            this.switchEventsHandler = cameraSwitchHandler;
            if (this.sessionOpening) {
                this.switchState = SwitchState.PENDING;
                return;
            }
            this.switchState = SwitchState.IN_PROGRESS;
            Logging.d(TAG, "switchCamera: Stopping session");
            this.cameraStatistics.release();
            this.cameraStatistics = null;
            final CameraSession cameraSession = this.currentSession;
            this.cameraThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    cameraSession.stop();
                }
            });
            this.currentSession = null;
            int n = Arrays.asList(stringArray).indexOf(this.cameraName);
            this.cameraName = stringArray[(n + 1) % stringArray.length];
            this.sessionOpening = true;
            this.openAttemptsRemaining = 1;
            this.createSessionInternal(0);
        }
        Logging.d(TAG, "switchCamera done");
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            Logging.e(TAG, "Check is on camera thread failed.");
            throw new RuntimeException("Not on camera thread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCameraName() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.cameraName;
        }
    }

    protected abstract void createCameraSession(CameraSession.CreateSessionCallback var1, CameraSession.Events var2, Context var3, SurfaceTextureHelper var4, String var5, int var6, int var7, int var8);

    static enum SwitchState {
        IDLE,
        PENDING,
        IN_PROGRESS;

    }
}

