package com.hyphenate.push.platform.fcm;

import android.content.Context;
import android.text.TextUtils;

import com.hyphenate.EMError;
import com.hyphenate.push.EMPushConfig;
import com.hyphenate.push.EMPushHelper;
import com.hyphenate.push.EMPushType;
import com.hyphenate.push.common.PushUtil;
import com.hyphenate.push.platform.IPush;

public class EMFCMPush extends IPush {
    private static final String TAG = "EMFCMPush";

    @Override
    public EMPushType getPushType() {
        return EMPushType.FCM;
    }

    @Override
    public void onRegister(Context context, EMPushConfig config) {
        boolean support = PushUtil.isGooglePlayServicesAvailable(context);
        if (!support) {
            EMPushHelper.getInstance().onErrorResponse(getPushType(), EMError.PUSH_NOT_SUPPORT);
        } else { // fcm推送为自动初始化，如果初始化后获取token成功的时候环信账号还没有登录成功，则会把token存储到本地。
            String storedToken = EMPushHelper.getInstance().getFCMPushToken();
            if (!TextUtils.isEmpty(storedToken)) {
                EMPushHelper.getInstance().onReceiveToken(getPushType(), storedToken);
            }
        }
    }

    @Override
    public void onUnregister(Context context) {
    }

    @Override
    public String onGetNotifierName(EMPushConfig config) {
        return config.getFcmSenderId();
    }
}
