/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.voice;

import android.content.Context;
import android.media.AudioRecord;
import android.os.Process;
import com.superrtc.call.Logging;
import com.superrtc.voice.WebRtcAudioEffects;
import com.superrtc.voice.WebRtcAudioManager;
import com.superrtc.voice.WebRtcAudioUtils;
import java.nio.ByteBuffer;

public class WebRtcAudioRecord {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioRecord";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private final long nativeAudioRecord;
    private final Context context;
    private WebRtcAudioEffects effects = null;
    private ByteBuffer byteBuffer;
    private AudioRecord audioRecord = null;
    private AudioRecordThread audioThread = null;
    private static volatile boolean microphoneMute = false;
    private byte[] emptyBytes;

    WebRtcAudioRecord(Context context, long l) {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.context = context;
        this.nativeAudioRecord = l;
        this.effects = WebRtcAudioEffects.create();
    }

    private boolean enableBuiltInAEC(boolean bl) {
        Logging.d(TAG, "enableBuiltInAEC(" + bl + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in AEC is not supported on this platform");
            return false;
        }
        return this.effects.setAEC(bl);
    }

    private boolean enableBuiltInAGC(boolean bl) {
        Logging.d(TAG, "enableBuiltInAGC(" + bl + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in AGC is not supported on this platform");
            return false;
        }
        return this.effects.setAGC(bl);
    }

    private boolean enableBuiltInNS(boolean bl) {
        Logging.d(TAG, "enableBuiltInNS(" + bl + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in NS is not supported on this platform");
            return false;
        }
        return this.effects.setNS(bl);
    }

    private int initRecording(int n, int n2) {
        Logging.d(TAG, "initRecording(sampleRate=" + n + ", channels=" + n2 + ")");
        if (!WebRtcAudioUtils.hasPermission(this.context, "android.permission.RECORD_AUDIO")) {
            Logging.e(TAG, "RECORD_AUDIO permission is missing");
            return -1;
        }
        if (this.audioRecord != null) {
            this.stopRecording();
        }
        int n3 = n2 * 2;
        int n4 = n / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(n3 * n4);
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioRecord);
        int n5 = AudioRecord.getMinBufferSize((int)n, (int)16, (int)2);
        if (n5 == -1 || n5 == -2) {
            Logging.e(TAG, "AudioRecord.getMinBufferSize failed: " + n5);
            return -1;
        }
        Logging.d(TAG, "AudioRecord.getMinBufferSize: " + n5);
        int n6 = Math.max(2 * n5, this.byteBuffer.capacity());
        Logging.d(TAG, "bufferSizeInBytes: " + n6);
        try {
            int n7 = WebRtcAudioManager.getCallAudioSource();
            if (n7 < 0 || n7 > 9) {
                n7 = 7;
            }
            this.audioRecord = new AudioRecord(n7, n, 16, 2, n6);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.e(TAG, illegalArgumentException.getMessage());
            return -1;
        }
        if (this.audioRecord == null || this.audioRecord.getState() != 1) {
            Logging.e(TAG, "Failed to create a new AudioRecord instance");
            return -1;
        }
        Logging.d(TAG, "AudioRecord session ID: " + this.audioRecord.getAudioSessionId() + ", audio format: " + this.audioRecord.getAudioFormat() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate());
        if (this.effects != null) {
            this.effects.enable(this.audioRecord.getAudioSessionId());
        }
        return n4;
    }

    private boolean startRecording() {
        Logging.d(TAG, "startRecording");
        WebRtcAudioRecord.assertTrue(this.audioRecord != null);
        WebRtcAudioRecord.assertTrue(this.audioThread == null);
        try {
            this.audioRecord.startRecording();
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "AudioRecord.startRecording failed: " + illegalStateException.getMessage());
            return false;
        }
        if (this.audioRecord.getRecordingState() != 3) {
            Logging.e(TAG, "AudioRecord.startRecording failed");
            return false;
        }
        this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        if (this.audioThread != null) {
            this.audioThread.joinThread();
            this.audioThread = null;
        }
        if (this.effects != null) {
            this.effects.release();
        }
        this.audioRecord.release();
        this.audioRecord = null;
        return true;
    }

    private static void assertTrue(boolean bl) {
        if (!bl) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2);

    public static void setMicrophoneMute(boolean bl) {
        Logging.w(TAG, "setMicrophoneMute API will be deprecated soon.");
        microphoneMute = bl;
    }

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String string) {
            super(string);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioRecord.TAG, "AudioRecordThread" + WebRtcAudioUtils.getThreadInfo());
            WebRtcAudioRecord.assertTrue(WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3);
            long l = System.nanoTime();
            while (this.keepAlive) {
                int n = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                if (n == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                    if (microphoneMute) {
                        WebRtcAudioRecord.this.byteBuffer.clear();
                        WebRtcAudioRecord.this.byteBuffer.put(WebRtcAudioRecord.this.emptyBytes);
                    }
                    WebRtcAudioRecord.this.nativeDataIsRecorded(n, WebRtcAudioRecord.this.nativeAudioRecord);
                    continue;
                }
                Logging.e(WebRtcAudioRecord.TAG, "AudioRecord.read failed: " + n);
                if (n != -3) continue;
                this.keepAlive = false;
            }
            try {
                WebRtcAudioRecord.this.audioRecord.stop();
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(WebRtcAudioRecord.TAG, "AudioRecord.stop failed: " + illegalStateException.getMessage());
            }
        }

        public void joinThread() {
            this.keepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

