/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.util;

import android.util.Log;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Scanner;

public class CpuMonitor {
    private static final int SAMPLE_SAVE_NUMBER = 10;
    private int[] percentVec = new int[10];
    private int sum3 = 0;
    private int sum10 = 0;
    private static final String TAG = "CpuMonitor";
    private long[] cpuFreq;
    private int cpusPresent;
    private double lastPercentFreq = -1.0;
    private int cpuCurrent;
    private int cpuAvg3;
    private int cpuAvgAll;
    private boolean initialized = false;
    private String[] maxPath;
    private String[] curPath;
    ProcStat lastProcStat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        try (FileReader fileReader = new FileReader("/sys/devices/system/cpu/present");){
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            Scanner scanner = new Scanner(bufferedReader).useDelimiter("[-\n]");
            scanner.nextInt();
            this.cpusPresent = 1 + scanner.nextInt();
            scanner.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)TAG, (String)"Cannot do CPU stats since /sys/devices/system/cpu/present is missing");
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)"Error closing file");
        }
        this.cpuFreq = new long[this.cpusPresent];
        this.maxPath = new String[this.cpusPresent];
        this.curPath = new String[this.cpusPresent];
        for (int k = 0; k < this.cpusPresent; ++k) {
            this.cpuFreq[k] = 0L;
            this.maxPath[k] = "/sys/devices/system/cpu/cpu" + k + "/cpufreq/cpuinfo_max_freq";
            this.curPath[k] = "/sys/devices/system/cpu/cpu" + k + "/cpufreq/scaling_cur_freq";
        }
        this.lastProcStat = new ProcStat(0L, 0L);
        this.initialized = true;
    }

    public boolean sampleCpuUtilization() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        if (!this.initialized) {
            this.init();
        }
        for (int k = 0; k < this.cpusPresent; ++k) {
            long l4;
            if (this.cpuFreq[k] == 0L) {
                l4 = this.readFreqFromFile(this.maxPath[k]);
                if (l4 > 0L) {
                    l = l4;
                    this.cpuFreq[k] = l4;
                    this.maxPath[k] = null;
                }
            } else {
                l = this.cpuFreq[k];
            }
            l4 = this.readFreqFromFile(this.curPath[k]);
            l2 += l4;
            l3 += l;
        }
        if (l3 == 0L) {
            Log.e((String)TAG, (String)"Could not read max frequency for any CPU");
            return false;
        }
        double d2 = 100.0 * (double)l2 / (double)l3;
        double d3 = this.lastPercentFreq > 0.0 ? (this.lastPercentFreq + d2) * 0.5 : d2;
        this.lastPercentFreq = d2;
        ProcStat procStat = this.readIdleAndRunTime();
        if (procStat == null) {
            return false;
        }
        long l5 = procStat.runTime - this.lastProcStat.runTime;
        long l6 = procStat.idleTime - this.lastProcStat.idleTime;
        this.lastProcStat = procStat;
        long l7 = l5 + l6;
        int n = l7 == 0L ? 0 : (int)Math.round(d3 * (double)l5 / (double)l7);
        n = Math.max(0, Math.min(n, 100));
        this.sum3 += n - this.percentVec[2];
        this.sum10 += n - this.percentVec[9];
        for (int k = 9; k > 0; --k) {
            this.percentVec[k] = this.percentVec[k - 1];
        }
        this.percentVec[0] = n;
        this.cpuCurrent = n;
        this.cpuAvg3 = this.sum3 / 3;
        this.cpuAvgAll = this.sum10 / 10;
        return true;
    }

    public int getCpuCurrent() {
        return this.cpuCurrent;
    }

    public int getCpuAvg3() {
        return this.cpuAvg3;
    }

    public int getCpuAvgAll() {
        return this.cpuAvgAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readFreqFromFile(String string) {
        long l = 0L;
        try (FileReader fileReader = new FileReader(string);){
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            Scanner scanner = new Scanner(bufferedReader);
            l = scanner.nextLong();
            scanner.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)"Error closing file");
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcStat readIdleAndRunTime() {
        long l = 0L;
        long l2 = 0L;
        FileReader fileReader = new FileReader("/proc/stat");
        try {
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            Scanner scanner = new Scanner(bufferedReader);
            scanner.next();
            long l3 = scanner.nextLong();
            long l4 = scanner.nextLong();
            long l5 = scanner.nextLong();
            l = l3 + l4 + l5;
            l2 = scanner.nextLong();
            scanner.close();
        }
        catch (Exception exception) {
            ProcStat procStat;
            try {
                Log.e((String)TAG, (String)"Problems parsing /proc/stat");
                procStat = null;
            }
            catch (Throwable throwable) {
                try {
                    fileReader.close();
                    throw throwable;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.e((String)TAG, (String)"Cannot open /proc/stat for reading");
                    return null;
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)"Problems reading /proc/stat");
                    return null;
                }
            }
            fileReader.close();
            return procStat;
        }
        fileReader.close();
        return new ProcStat(l, l2);
    }

    private class ProcStat {
        final long runTime;
        final long idleTime;

        ProcStat(long l, long l2) {
            this.runTime = l;
            this.idleTime = l2;
        }
    }
}

