/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.Camera;
import android.opengl.EGLContext;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.superrtc.call.AudioSource;
import com.superrtc.call.AudioTrack;
import com.superrtc.call.CameraEnumerationAndroid;
import com.superrtc.call.DataChannel;
import com.superrtc.call.EglBase;
import com.superrtc.call.IceCandidate;
import com.superrtc.call.Logging;
import com.superrtc.call.MediaCodecVideoEncoder;
import com.superrtc.call.MediaConstraints;
import com.superrtc.call.MediaStream;
import com.superrtc.call.MediaStreamTrack;
import com.superrtc.call.PeerConnection;
import com.superrtc.call.PeerConnectionFactory;
import com.superrtc.call.RendererCommon;
import com.superrtc.call.SdpObserver;
import com.superrtc.call.SessionDescription;
import com.superrtc.call.StatsObserver;
import com.superrtc.call.StatsReport;
import com.superrtc.call.VideoCapturerAndroid;
import com.superrtc.call.VideoRenderer;
import com.superrtc.call.VideoRendererGui2;
import com.superrtc.call.VideoSource;
import com.superrtc.call.VideoTrack;
import com.superrtc.sdk.ALog;
import com.superrtc.sdk.Bandwidth;
import com.superrtc.sdk.Packetslostrate;
import com.superrtc.sdk.SDPSsrcChanger;
import com.superrtc.sdk.VideoViewRenderer;
import com.superrtc.util.AppRTCAudioManager;
import com.superrtc.util.CpuMonitor;
import com.superrtc.util.LooperExecutor;
import com.superrtc.util.RTCCallback;
import com.superrtc.voice.WebRtcAudioManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

@SuppressLint(value={"DefaultLocale"})
public class RtcConnection {
    private static final String TAG = "RtcConn";
    private static Context sContext;
    private static LooperExecutor executor;
    private static PeerConnectionFactory factory;
    private boolean enableOpenCamera = false;
    private boolean autoAddVideo = true;
    private Listener listener;
    private boolean isStopCapture = false;
    public String name = "RTC0";
    private Parameters peerConnectionParameters;
    private boolean localRendererAdded = false;
    private boolean remoteRendererAdded = false;
    private static Logging.Severity medialoglevel;
    private static boolean disableResize;
    private static int configfps;
    private static final int DEFAULT_CONFIG_FPS = 20;
    private static int configminkbps;
    private static int DEFAULT_CONFIG_MINKBPS;
    private static boolean useVideoCodecHw;
    private static boolean iscreateConnectionFactory;
    private EglBase.Context sharedeglContext = null;
    private String connectType = "disconn";
    private boolean isconnected = false;
    private Packetslostrate packetslostrate = new Packetslostrate();
    private Packetslostrate recvpacketslostrate = new Packetslostrate();
    private PeerConnection.IceConnectionState iceConnectionState;
    public static final String RtcKVCaptureVideoBoolean = "capVideo";
    public static final String RtcKVRecvVideoBoolean = "recvVideo";
    public static final String RtcKVCaptureAudioBoolean = "capAudio";
    public static final String RtcKVRecvAudioBoolean = "recvAudio";
    public static final String RtcKVRelayOnlyBoolean = "relayOnly";
    public static final String RtcKVVideoResolutionLevelLong = "vresL";
    public static final String RtcKVMaxVideoKbpsLong = "maxVKbps";
    public static final String RtcKVRelayVideoKbpsLong = "relayVKbps";
    public static final String RtcKVMaxAudioKbpsLong = "maxAKbps";
    public static final String RtcKVRelayAudioKbpsLong = "relayAKbps";
    public static final String RtcvideofpsLong = "videofps";
    public static final String RtcvideowidthLong = "width";
    public static final String RtcvideoheigthLong = "heigth";
    public static final String RtcKVPreferVCodecString = "prefVC";
    public static final String RtcKVPreferACodecString = "prefAC";
    public static final String RtcKVIceServersArray = "iceServers";
    public static final String RtcKVDisablePranswerBoolean = "disablePranswer";
    public static final String RtcKVLoopbackBoolean = "loopback";
    public static final String RtcKVAecDumpFileString = "aecdumpFile";
    public static final String RtcConstStringVP8 = "VP8";
    public static final String RtcConstStringVP9 = "VP9";
    public static final String RtcConstStringH264 = "H264";
    public static final String RtcConstStringOPUS = "OPUS";
    public static final String RtcConstStringG722 = "G722";
    public static final String RtcConstStringURL = "url";
    public static final String RtcConstStringUserName = "username";
    public static final String RtcConstStringCredential = "credential";
    public static final String RtcHDVideoEncoderBoolean = "hdencoder";
    public static final String RtcHDVideoDecoderBoolean = "hddecoder";
    private boolean ishangup = false;
    private String lusevcodectype = "VP8";
    private String luseacodectype = "OPUS";
    private String rusevcodectype = "VP8";
    private String ruseacodectype = "OPUS";
    private int framesReceived = 0;
    private boolean enableHWEncoder = false;
    private boolean enableHWDecoder = false;
    private static int cameraid;
    private static boolean enableLocalViewMirror;
    private RtcCameraDataProcessor processor;
    private boolean enableExternalVideoData;
    private RtcGlTextureProcessor glprocessor;
    private int configRotation = 0;
    private boolean isconfigRotation = false;
    private static String globalVideoCodec;
    public VideoViewRenderer localViewRender;
    public VideoViewRenderer remoteViewRender;
    VideoRendererGui2 localGui;
    VideoRendererGui2 remoteGui;
    RenderRect localRect;
    RenderRect remoteRect;
    private long localSeq = 0L;
    SDPSsrcChanger ssrcChanger = new SDPSsrcChanger("ARDAMS");
    private LinkedList<SessionDescription> pendingSdp = new LinkedList();
    private List<IceCandidate> pendingCandidates = new ArrayList<IceCandidate>();
    LocalSDPObserver localSDPObserver = new LocalSDPObserver();
    RemoteSDPObserver remoteSDPObserver = new RemoteSDPObserver();
    MediaStream remoteStream;
    boolean isPranswerState = false;
    private final CpuMonitor cpuMonitor = new CpuMonitor();
    public static int loglevel;
    private static LogListener sLogListenerInternal;
    public static LogListener sLogListener;
    private static final String STAT_KEY_CONNECTION = "connection";
    private Bandwidth remoteVideoBW = new Bandwidth();
    private Bandwidth remoteAudioBW = new Bandwidth();
    private Bandwidth localVideoBW = new Bandwidth();
    private Bandwidth localAudioBW = new Bandwidth();
    private RendererCommon.ScalingType LocalscalingType = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
    private RendererCommon.ScalingType RemotescalingType = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
    public static final String VIDEO_TRACK_ID = "ARDAMSv0";
    public static final String AUDIO_TRACK_ID = "ARDAMSa0";
    private static final String FIELD_TRIAL_VP9 = "WebRTC-SupportVP9/Enabled/";
    private static final String VIDEO_CODEC_VP8 = "VP8";
    private static final String VIDEO_CODEC_VP9 = "VP9";
    private static final String VIDEO_CODEC_H264 = "H264";
    private static final String AUDIO_CODEC_OPUS = "opus";
    private static final String AUDIO_CODEC_ISAC = "ISAC";
    private static final String VIDEO_CODEC_PARAM_START_BITRATE = "x-google-start-bitrate";
    private static final String AUDIO_CODEC_PARAM_BITRATE = "maxaveragebitrate";
    private static final String AUDIO_ECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    private static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    private static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    private static final String MAX_VIDEO_WIDTH_CONSTRAINT = "maxWidth";
    private static final String MIN_VIDEO_WIDTH_CONSTRAINT = "minWidth";
    private static final String MAX_VIDEO_HEIGHT_CONSTRAINT = "maxHeight";
    private static final String MIN_VIDEO_HEIGHT_CONSTRAINT = "minHeight";
    private static final String MAX_VIDEO_FPS_CONSTRAINT = "maxFrameRate";
    private static final String MIN_VIDEO_FPS_CONSTRAINT = "minFrameRate";
    private static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";
    private static final int HD_VIDEO_WIDTH = 1920;
    private static final int HD_VIDEO_HEIGHT = 1080;
    private static final int MAX_VIDEO_WIDTH = 1920;
    private static final int MAX_VIDEO_HEIGHT = 1920;
    private static final int MAX_VIDEO_FPS = 30;
    private static final String RTC_DEFAULT_VIDEO_CODEC = "VP8";
    private static final int RTC_DEFAULT_VIDEO_WIDTH = 640;
    private static final int RTC_DEFAULT_VIDEO_HEIGH = 480;
    private static final String RTC_DEFAULT_AUDIO_CODEC = "OPUS";
    private int videolastsendpackets = 0;
    private int videocursendpackets = 0;
    private int audiolastsendpackets = 0;
    private int audiocursendpackets = 0;
    private int videosendbytes = 0;
    private int videorecvbytes = 0;
    private int audiosendbytes = 0;
    private int audiorecvbytes = 0;
    private int videolastsendpacketsLost = 0;
    private int videocursendpacketsLost = 0;
    private int audiolastsendpacketsLost = 0;
    private int audiocursendpacketsLost = 0;
    private int videolastrecvpackets = 0;
    private int videocurrecvpackets = 0;
    private int audiolastrecvpackets = 0;
    private int audiocurrecvpackets = 0;
    private int videolastrecvpacketsLost = 0;
    private int videocurrecvpacketsLost = 0;
    private int audiolastrecvpacketsLost = 0;
    private int audiocurrecvpacketsLost = 0;
    private final PCObserver pcObserver = new PCObserver();
    private PeerConnection peerConnection;
    PeerConnectionFactory.Options options = null;
    private VideoSource videoSource;
    private AudioSource audioSource;
    private boolean videoCallEnabled = true;
    private boolean videoreceiveEnabled = true;
    private boolean disablePranswer = false;
    private boolean loopbackEnable = false;
    private String aecDumpFilename = null;
    private String videoCodec = globalVideoCodec;
    private int videoWidth = 0;
    private int videoHeigth = 0;
    private int videoFramerate = 15;
    private int videoMaxrate = 0;
    private int relayvideoMaxrate = 0;
    private boolean audioCallEnabled = true;
    private boolean audioreceiveEnabled = true;
    private String audioCodec;
    private int audioMaxrate = 24;
    private int relayaudioMaxrate = 24;
    private boolean enableRelay = false;
    private boolean preferIsac;
    private boolean preferH264 = true;
    private boolean videoSourceStopped;
    private Timer statsTimer;
    private VideoRenderer.Callbacks localRender;
    private VideoRenderer.Callbacks remoteRender;
    private VideoRenderer localvideorender;
    private VideoRenderer remotevideorender;
    private List<PeerConnection.IceServer> iceServers = new ArrayList<PeerConnection.IceServer>();
    private MediaConstraints pcConstraints;
    private MediaConstraints videoConstraints;
    private MediaConstraints audioConstraints;
    private MediaConstraints sdpMediaConstraints;
    private boolean isInitiator;
    private SessionDescription localSdp;
    private MediaStream mediaStream;
    private int numberOfCameras;
    private VideoCapturerAndroid videoCapturer;
    private boolean renderVideo;
    private VideoTrack localVideoTrack;
    private AudioTrack localAudioTrack;
    private VideoTrack remoteVideoTrack;
    private boolean enableaudio = true;
    private boolean enableaec = true;
    private boolean enableagc = true;
    private boolean enablens = true;
    private AppRTCAudioManager audioManager = null;
    ParcelFileDescriptor aecDumpFileDescriptor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLogListener(LogListener logListener) {
        Log.i((String)TAG, (String)"[rapi]++ registerLogListener");
        Class<RtcConnection> clazz = RtcConnection.class;
        synchronized (RtcConnection.class) {
            Log.i((String)TAG, (String)"[rapi]-- registerLogListener");
            sLogListener = logListener;
            sLogListener = logListener != null ? logListener : sLogListenerInternal;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void callbackLog(int n, String string) {
        Class<RtcConnection> clazz = RtcConnection.class;
        synchronized (RtcConnection.class) {
            sLogListener.onLog(n, string);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static int getKbpsByVideoSize(int n, int n2) {
        if (n == 320 && n2 == 240 || n == 240 && n2 == 320) {
            return 300;
        }
        if (n == 640 && n2 == 480 || n == 480 && n2 == 640) {
            return 800;
        }
        if (n == 1280 && n2 == 720 || n == 720 && n2 == 1280) {
            return 2500;
        }
        if (n == 1920 && n2 == 1080 || n == 1080 && n2 == 1920) {
            return 10000;
        }
        return 300;
    }

    public void interestAt(int n, int n2, int n3, int n4, boolean bl) {
        this.handleFocus(n, n2, n3, n4);
    }

    public void zoomWithFactor(Float f2) {
        this.handleZoom(f2);
    }

    public void handleZoom(final Float f2) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.ishangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip handleZoom because of conn is already hangup!");
                    return;
                }
                if (RtcConnection.this.videoCapturer != null) {
                    RtcConnection.this.videoCapturer.handleZoom(f2);
                }
            }
        });
    }

    public void handleFocus(final int n, final int n2, final int n3, final int n4) {
        if (this.localGui == null) {
            return;
        }
        final int n5 = this.localGui.getScreenWidth();
        final int n6 = this.localGui.getScreenHeight();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.ishangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip handleFocus because of conn is already hangup!");
                    return;
                }
                if (RtcConnection.this.videoCapturer != null) {
                    RtcConnection.this.videoCapturer.handleFocusMetering(n, n2, n5, n6, n3, n4);
                }
            }
        });
    }

    public void setRotation(int n) {
        this.isconfigRotation = true;
        this.configRotation = n;
        this.checkVideoCapturerConfigRotation();
    }

    public static void setAudioSampleRate(int n) {
        if (n > 0) {
            WebRtcAudioManager.setAudioSampleRate(n);
        }
    }

    public void setEnableExternalVideoData(boolean bl) {
        this.enableExternalVideoData = bl;
    }

    public void setCallAudioSource(int n) {
        WebRtcAudioManager.setCallAudioSource(n);
    }

    public void setRtcCameraDataProcessor(RtcCameraDataProcessor rtcCameraDataProcessor) {
        this.processor = rtcCameraDataProcessor;
        this.checkVideoCapturerDataProcessor();
    }

    public void setRtcGlTextureProcessor(RtcGlTextureProcessor rtcGlTextureProcessor) {
        this.glprocessor = rtcGlTextureProcessor;
        this.checkGlTextureProcessor();
    }

    public void enableFixedVideoResolution(boolean bl) {
        disableResize = bl;
        this.checkdisableResize(bl);
    }

    public static void setMinVideoKbps(int n) {
        configminkbps = n > 0 ? n : DEFAULT_CONFIG_MINKBPS;
    }

    public static void setCameraFacing(int n) {
        if (cameraid != n) {
            cameraid = n;
            if (cameraid == 0) {
                enableLocalViewMirror = false;
            } else if (cameraid == 1) {
                enableLocalViewMirror = true;
            }
        }
    }

    public int getCameraFacing() {
        if (this.videoCapturer == null) {
            sLogListener.onLog(loglevel, this.name + "::: videoCapturer is null,Failed to getCameraFacing.");
            return -1;
        }
        return this.videoCapturer.getCurrentCameraId();
    }

    public static void setGlobalVideoCodec(String string) {
        globalVideoCodec = string;
    }

    public static void initGlobal(Context context) throws Exception {
        RtcConnection.initGlobal(context, false, null);
    }

    public static void initGlobal(Context context, LooperExecutor looperExecutor) throws Exception {
        RtcConnection.initGlobal(context, false, looperExecutor);
    }

    public static void setMediaLogLevel(Medialogmod medialogmod) {
        switch (medialogmod) {
            case M_SENSITIVE: {
                medialoglevel = Logging.Severity.LS_SENSITIVE;
                break;
            }
            case M_VERBOSE: {
                medialoglevel = Logging.Severity.LS_VERBOSE;
                break;
            }
            case M_INFO: {
                medialoglevel = Logging.Severity.LS_INFO;
                break;
            }
            case M_WARNING: {
                medialoglevel = Logging.Severity.LS_WARNING;
                break;
            }
            case M_ERROR: {
                medialoglevel = Logging.Severity.LS_ERROR;
            }
        }
    }

    public static void initGlobal(final Context context, final boolean bl, LooperExecutor looperExecutor) throws Exception {
        sLogListener.onLog(loglevel, "[rapi]++ initGlobal, useVideoCodecHw=" + bl);
        sContext = context;
        if (looperExecutor == null) {
            executor = new LooperExecutor();
            executor.requestStart();
        } else {
            executor = looperExecutor;
        }
        useVideoCodecHw = bl;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, "[rapi]-- initGlobal, useVideoCodecHw=" + bl);
                PeerConnectionFactory.setconfigframerate(20);
                try {
                    RtcConnection.createConnectionFactoryInternal(context, null, bl);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Logging.enableTracing("logcat:", EnumSet.of(Logging.TraceLevel.TRACE_DEFAULT), medialoglevel);
            }
        });
    }

    private static void createConnectionFactoryInternal(Context context, EGLContext eGLContext, boolean bl) throws Exception {
        PeerConnectionFactory.initializeFieldTrials(null);
        if (!PeerConnectionFactory.initializeAndroidGlobals(context, true, true, bl)) {
            throw RtcConnection.newException("Failed to initializeAndroid");
        }
        factory = new PeerConnectionFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReportString() throws JSONException {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ getReportString");
        JSONObject jSONObject = new JSONObject();
        Class<RtcConnection> clazz = RtcConnection.class;
        synchronized (RtcConnection.class) {
            jSONObject.put("conn", (Object)this.connectType);
            jSONObject.put("lvcodec", (Object)this.lusevcodectype);
            jSONObject.put("lacodec", (Object)this.luseacodectype);
            jSONObject.put("rvcodec", (Object)this.rusevcodectype);
            jSONObject.put("racodec", (Object)this.ruseacodectype);
            jSONObject.put("sentVB", this.videosendbytes);
            jSONObject.put("sentAB", this.audiosendbytes);
            jSONObject.put("recvVB", this.videorecvbytes);
            jSONObject.put("recvAB", this.audiorecvbytes);
            jSONObject.put("sentVP", this.videolastsendpackets);
            jSONObject.put("sentAP", this.audiolastsendpackets);
            jSONObject.put("recvVP", this.videolastrecvpackets);
            jSONObject.put("recvAP", this.audiolastrecvpackets);
            jSONObject.put("os", (Object)"a");
            if (this.remoteGui != null) {
                this.framesReceived = this.remoteGui.getframesReceived();
            }
            jSONObject.put("rvfrm", this.framesReceived);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- getReportString");
            return jSONObject.toString();
        }
    }

    private Parameters getDefaultParameters() {
        boolean bl = true;
        boolean bl2 = false;
        return new Parameters(bl, this.loopbackEnable, this.videoWidth, this.videoHeigth, this.videoFramerate, this.videoMaxrate, this.videoCodec, false, 0, this.audioCodec, bl2, true);
    }

    public RtcConnection(final String string) {
        this.name = string;
        this.ishangup = false;
        sLogListener.onLog(loglevel, string + "::: [rapi]++ create RtcConnection");
        this.statsTimer = new Timer();
        this.setStatsEnable(true);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, "create RtcConnection start -0- name: " + string);
                if (RtcConnection.this.ishangup) {
                    sLogListener.onLog(loglevel, string + "::: skip createConnectionFactory because of conn is already hangup!");
                    return;
                }
                sLogListener.onLog(loglevel, string + "::: [rapi]-- create RtcConnection");
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public void setListener(final Listener listener) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setListener");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.ishangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip setListener because of conn is already hangup!");
                    return;
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setListener");
                RtcConnection.this.listener = listener;
            }
        });
    }

    public void clearIceServer() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ clearIceServer");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- clearIceServer");
                RtcConnection.this.iceServers.clear();
            }
        });
    }

    public void addIceServer(final String string, final String string2, final String string3) {
        sLogListener.onLog(loglevel, "[rapi]++ addIceServer");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- addIceServer");
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: add ice server: " + string);
                RtcConnection.this.iceServers.add(new PeerConnection.IceServer(string, string2, string3));
            }
        });
    }

    public void makeblack(boolean bl) {
        sLogListener.onLog(loglevel, this.name + "::: makeblack :" + bl);
        if (this.remoteGui != null) {
            this.remoteGui.makeblack(bl);
        }
        if (this.localGui != null) {
            this.localGui.makeblack(bl);
        }
    }

    public void setViews(VideoViewRenderer videoViewRenderer, VideoViewRenderer videoViewRenderer2) {
        String string = "";
        if (videoViewRenderer != null) {
            string = string + " localView_ ";
        }
        if (videoViewRenderer2 != null) {
            string = string + " remoteView_ ";
        }
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setViews" + string);
        this.stopRenderer(this.localViewRender, this.remoteViewRender);
        this.addRenderer(videoViewRenderer, videoViewRenderer2);
    }

    public void switchTorchOn(boolean bl) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.ishangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip switchTorchOn because of conn is already hangup!");
                    return;
                }
                if (!RtcConnection.this.enableOpenCamera || RtcConnection.this.videoCapturer == null) {
                    sLogListener.onLog(loglevel, "Failed to switchTorchOn. OpenCamera:" + RtcConnection.this.enableOpenCamera);
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- switchTorchOn");
                    return;
                }
            }
        });
    }

    private boolean isLocalViewReady() {
        return this.localViewRender != null && this.localViewRender.isViewReady();
    }

    private boolean isRemoteViewReady() {
        return this.remoteViewRender != null && this.remoteViewRender.isViewReady();
    }

    public void switchVideo(final boolean bl) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.ishangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip switchVideo because of conn is already hangup!");
                    return;
                }
                if (RtcConnection.this.peerConnectionParameters != null) {
                    ((RtcConnection)RtcConnection.this).peerConnectionParameters.captureVideo = bl;
                    RtcConnection.this.checkMediaTracksInternal();
                }
            }
        });
    }

    public void switchAudio(final boolean bl) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.ishangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip switchAudio because of conn is already hangup!");
                    return;
                }
                ((RtcConnection)RtcConnection.this).peerConnectionParameters.captureAudio = bl;
                RtcConnection.this.checkMediaTracksInternal();
            }
        });
    }

    private static String appendStatString(String string, String string2) {
        if (string == null || string.equals("")) {
            return string2;
        }
        return string + "," + string2;
    }

    private static void addState(Map<String, String> map, String string, String string2) {
        map.put(string, RtcConnection.appendStatString(map.get(string), string2));
    }

    private static String makeStatLine(Map<String, String> map, String string, String string2) {
        if (map.get(string) != null) {
            return string2 + string + ": " + map.get(string) + "\r\n";
        }
        return "";
    }

    private static Map<String, String> convertStatMap(StatsReport.Value[] valueArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (StatsReport.Value value : valueArray) {
            hashMap.put(value.name, value.value);
        }
        return hashMap;
    }

    private void getStats() {
        if (this.peerConnection == null | this.ishangup) {
            return;
        }
        boolean bl = this.peerConnection.getStats(new StatsObserver(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void onComplete(StatsReport[] statsReportArray) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                HashMap<String, String> hashMap3 = new HashMap<String, String>();
                HashMap<String, String> hashMap4 = new HashMap<String, String>();
                HashMap<String, String> hashMap5 = new HashMap<String, String>();
                RtcStatistics rtcStatistics = new RtcStatistics();
                for (StatsReport statsReport : statsReportArray) {
                    String string;
                    String string2;
                    Map map = RtcConnection.convertStatMap(statsReport.values);
                    if (statsReport.type.equals("googCandidatePair")) {
                        if (!((String)map.get("googActiveConnection")).equals("true")) continue;
                        string2 = (String)map.get("googLocalCandidateType");
                        string = (String)map.get("googRemoteCandidateType");
                        if (string2 != null && string2.equals("relay") || string != null && string.equals("relay")) {
                            RtcConnection.addState(hashMap, RtcConnection.STAT_KEY_CONNECTION, "relay");
                            RtcConnection.this.connectType = "relay";
                            rtcStatistics.connectionType = RtcConnection.this.connectType;
                            continue;
                        }
                        RtcConnection.addState(hashMap, RtcConnection.STAT_KEY_CONNECTION, "direct");
                        RtcConnection.this.connectType = "direct";
                        rtcStatistics.connectionType = RtcConnection.this.connectType;
                        continue;
                    }
                    if (statsReport.type.equals("ssrc")) {
                        int n;
                        int n2;
                        string2 = (String)map.get("googCodecName");
                        if (map.get("googFrameWidthReceived") != null) {
                            RtcConnection.this.rusevcodectype = string2;
                            string = (String)map.get("googFrameWidthReceived");
                            String string3 = (String)map.get("googFrameHeightReceived");
                            hashMap3.put("vcodec", string2);
                            hashMap3.put("vsize", string + "x" + string3);
                            hashMap3.put("vfps", (String)map.get("googFrameRateDecoded"));
                            hashMap3.put("vlost", (String)map.get("packetsLost"));
                            hashMap3.put("vbytes", (String)map.get("bytesReceived"));
                            RtcConnection.this.remoteVideoBW.update((String)map.get("bytesReceived"));
                            RtcConnection.this.videorecvbytes = Integer.parseInt((String)map.get("bytesReceived"));
                            RtcConnection.this.videocurrecvpackets = Integer.parseInt((String)map.get("packetsReceived"));
                            n2 = RtcConnection.this.videocurrecvpackets - RtcConnection.this.videolastrecvpackets;
                            RtcConnection.this.videolastrecvpackets = RtcConnection.this.videocurrecvpackets;
                            RtcConnection.this.videocurrecvpacketsLost = Integer.parseInt((String)map.get("packetsLost"));
                            n = RtcConnection.this.videocurrecvpacketsLost - RtcConnection.this.videolastrecvpacketsLost;
                            RtcConnection.this.videolastrecvpacketsLost = RtcConnection.this.videocurrecvpacketsLost;
                            RtcConnection.this.recvpacketslostrate.addvideopackslost(n2, n);
                            rtcStatistics.remoteVideoPacketsLostrate = RtcConnection.this.recvpacketslostrate.getvideopackslostrate();
                            hashMap5.put("vsize", string + "x" + string3);
                            hashMap5.put("vfps", (String)map.get("googFrameRateReceived"));
                            hashMap5.put("vlost", (String)map.get("packetsLost"));
                            rtcStatistics.remoteWidth = Integer.parseInt((String)map.get("googFrameWidthReceived"));
                            rtcStatistics.remoteHeight = Integer.parseInt((String)map.get("googFrameHeightReceived"));
                            rtcStatistics.remoteFps = Integer.parseInt((String)map.get("googFrameRateReceived"));
                            rtcStatistics.remoteVideoPacketsLost = Integer.parseInt((String)map.get("packetsLost"));
                            continue;
                        }
                        if (map.get("googFrameWidthSent") != null) {
                            string = (String)map.get("googFrameWidthSent");
                            String string4 = (String)map.get("googFrameHeightSent");
                            RtcConnection.this.lusevcodectype = string2;
                            hashMap2.put("vlcodec", string2);
                            hashMap2.put("vinsize", (String)map.get("googFrameWidthInput") + "x" + (String)map.get("googFrameHeightInput"));
                            hashMap2.put("vsize", string + "x" + string4);
                            hashMap2.put("vfps", (String)map.get("googFrameRateInput") + "/" + (String)map.get("googFrameRateSent"));
                            hashMap2.put("vlost", (String)map.get("packetsLost"));
                            hashMap2.put("vrtt", (String)map.get("googRtt"));
                            hashMap2.put("vbytes", (String)map.get("bytesSent"));
                            RtcConnection.this.localVideoBW.update((String)map.get("bytesSent"));
                            RtcConnection.this.videosendbytes = Integer.parseInt((String)map.get("bytesSent"));
                            RtcConnection.this.videocursendpackets = Integer.parseInt((String)map.get("packetsSent"));
                            n2 = RtcConnection.this.videocursendpackets - RtcConnection.this.videolastsendpackets;
                            RtcConnection.this.videolastsendpackets = RtcConnection.this.videocursendpackets;
                            RtcConnection.this.videocursendpacketsLost = Integer.parseInt((String)map.get("packetsLost"));
                            n = RtcConnection.this.videocursendpacketsLost - RtcConnection.this.videolastsendpacketsLost;
                            RtcConnection.this.videolastsendpacketsLost = RtcConnection.this.videocursendpacketsLost;
                            RtcConnection.this.packetslostrate.addvideopackslost(n2, n);
                            rtcStatistics.localVideoPacketsLostrate = RtcConnection.this.packetslostrate.getvideopackslostrate();
                            hashMap4.put("vsize", string + "x" + string4);
                            hashMap4.put("vfps", (String)map.get("googFrameRateInput") + "/" + (String)map.get("googFrameRateSent"));
                            hashMap4.put("vlost", (String)map.get("packetsLost"));
                            hashMap4.put("vrtt", (String)map.get("googRtt"));
                            rtcStatistics.localCaptureWidth = Integer.parseInt((String)map.get("googFrameWidthInput"));
                            rtcStatistics.localCaptureHeight = Integer.parseInt((String)map.get("googFrameHeightInput"));
                            rtcStatistics.localEncodedWidth = Integer.parseInt((String)map.get("googFrameWidthSent"));
                            rtcStatistics.localEncodedHeight = Integer.parseInt((String)map.get("googFrameHeightSent"));
                            rtcStatistics.localCaptureFps = Integer.parseInt((String)map.get("googFrameRateInput"));
                            rtcStatistics.localEncodedFps = Integer.parseInt((String)map.get("googFrameRateSent"));
                            rtcStatistics.localVideoPacketsLost = Integer.parseInt((String)map.get("packetsLost"));
                            rtcStatistics.localVideoRtt = Integer.parseInt((String)map.get("googRtt"));
                            continue;
                        }
                        if (map.get("bytesReceived") != null) {
                            RtcConnection.this.ruseacodectype = string2;
                            hashMap3.put("acodec", string2);
                            hashMap3.put("alost", (String)map.get("packetsLost"));
                            hashMap3.put("abytes", (String)map.get("bytesReceived"));
                            RtcConnection.this.remoteAudioBW.update((String)map.get("bytesReceived"));
                            RtcConnection.this.audiorecvbytes = Integer.parseInt((String)map.get("bytesReceived"));
                            RtcConnection.this.audiocurrecvpackets = Integer.parseInt((String)map.get("packetsReceived"));
                            int n3 = RtcConnection.this.audiocurrecvpackets - RtcConnection.this.audiolastrecvpackets;
                            RtcConnection.this.audiolastrecvpackets = RtcConnection.this.audiocurrecvpackets;
                            RtcConnection.this.audiocurrecvpacketsLost = Integer.parseInt((String)map.get("packetsLost"));
                            int n4 = RtcConnection.this.audiocurrecvpacketsLost - RtcConnection.this.audiolastrecvpacketsLost;
                            RtcConnection.this.audiolastrecvpacketsLost = RtcConnection.this.audiocurrecvpacketsLost;
                            RtcConnection.this.recvpacketslostrate.addaudiopackslost(n3, n4);
                            rtcStatistics.remoteAudioPacketsLostrate = RtcConnection.this.recvpacketslostrate.getaudiopackslostrate();
                            hashMap5.put("alost", (String)map.get("packetsLost"));
                            hashMap5.put("artt", (String)map.get("googRtt"));
                            rtcStatistics.remoteAudioPacketsLost = Integer.parseInt((String)map.get("packetsLost"));
                            continue;
                        }
                        if (map.get("bytesSent") == null) continue;
                        RtcConnection.this.luseacodectype = string2;
                        hashMap2.put("acodec", string2);
                        hashMap2.put("alost", (String)map.get("packetsLost"));
                        hashMap2.put("abytes", (String)map.get("bytesSent"));
                        RtcConnection.this.localAudioBW.update((String)map.get("bytesSent"));
                        hashMap4.put("alost", (String)map.get("packetsLost"));
                        hashMap4.put("abytes", (String)map.get("bytesSent"));
                        hashMap4.put("artt", (String)map.get("googRtt"));
                        RtcConnection.this.audiosendbytes = Integer.parseInt((String)map.get("bytesSent"));
                        RtcConnection.this.audiocursendpackets = Integer.parseInt((String)map.get("packetsSent"));
                        int n5 = RtcConnection.this.audiocursendpackets - RtcConnection.this.audiolastsendpackets;
                        RtcConnection.this.audiolastsendpackets = RtcConnection.this.audiocursendpackets;
                        RtcConnection.this.audiocursendpacketsLost = Integer.parseInt((String)map.get("packetsLost"));
                        int n6 = RtcConnection.this.audiocursendpacketsLost - RtcConnection.this.audiolastsendpacketsLost;
                        RtcConnection.this.audiolastsendpacketsLost = RtcConnection.this.audiocursendpacketsLost;
                        RtcConnection.this.packetslostrate.addaudiopackslost(n5, n6);
                        rtcStatistics.localAudioPacketsLostrate = RtcConnection.this.packetslostrate.getaudiopackslostrate();
                        rtcStatistics.localAudioRtt = Integer.parseInt((String)map.get("googRtt"));
                        rtcStatistics.localAudioPacketsLost = Integer.parseInt((String)map.get("packetsLost"));
                        continue;
                    }
                    if (!statsReport.type.equals("VideoBwe")) continue;
                    hashMap2.put("vbr", (String)map.get("googActualEncBitrate") + "/" + (String)map.get("googTargetEncBitrate"));
                    hashMap4.put("vbr", Integer.parseInt((String)map.get("googActualEncBitrate")) / 1000 + "/" + Integer.parseInt((String)map.get("googTargetEncBitrate")) / 1000);
                    rtcStatistics.localVideoActualBps = Integer.parseInt((String)map.get("googActualEncBitrate")) / 1000;
                    rtcStatistics.localVideoTargetBps = Integer.parseInt((String)map.get("googTargetEncBitrate")) / 1000;
                }
                if (hashMap.get(RtcConnection.STAT_KEY_CONNECTION) == null) {
                    hashMap.put(RtcConnection.STAT_KEY_CONNECTION, "disconnect");
                }
                String string = "";
                String string5 = "";
                String string6 = string + RtcConnection.makeStatLine(hashMap, RtcConnection.STAT_KEY_CONNECTION, "");
                string5 = string5 + RtcConnection.makeStatLine(hashMap, RtcConnection.STAT_KEY_CONNECTION, "");
                if (RtcConnection.this.cpuMonitor.sampleCpuUtilization()) {
                    String string7 = string6 + "CPU%: " + RtcConnection.this.cpuMonitor.getCpuCurrent() + "/" + RtcConnection.this.cpuMonitor.getCpuAvg3() + "/" + RtcConnection.this.cpuMonitor.getCpuAvgAll();
                }
                if (hashMap2.size() > 0) {
                    void var8_12;
                    hashMap2.put("vbps", String.valueOf(RtcConnection.this.localVideoBW.getBitrateString()));
                    hashMap2.put("abps", String.valueOf(RtcConnection.this.localAudioBW.getBitrateString()));
                    hashMap4.put("abps", String.valueOf(RtcConnection.this.localAudioBW.getBitrateString()));
                    rtcStatistics.localAudioBps = Integer.parseInt(RtcConnection.this.localAudioBW.getBitrateString());
                    String string21 = (String)var8_12 + "\r\n";
                    string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vlcodec", "");
                    string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vinsize", "");
                    string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vsize", "");
                    string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vfps", "");
                    string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vrtt", "");
                    string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vlost", "");
                    string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vbytes", "");
                    string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vbps", "");
                    string21 = string21 + RtcConnection.makeStatLine(hashMap2, "vbr", "");
                    string21 = string21 + RtcConnection.makeStatLine(hashMap2, "acodec", "");
                    string21 = string21 + RtcConnection.makeStatLine(hashMap2, "alost", "");
                    string21 = string21 + RtcConnection.makeStatLine(hashMap2, "abytes", "");
                    string21 = string21 + RtcConnection.makeStatLine(hashMap2, "abps", "");
                    string5 = string5 + RtcConnection.makeStatLine(hashMap2, "vlcodec", "");
                    string5 = string5 + RtcConnection.makeStatLine(hashMap4, "vsize", "");
                    string5 = string5 + RtcConnection.makeStatLine(hashMap4, "vfps", "");
                    string5 = string5 + RtcConnection.makeStatLine(hashMap4, "vrtt", "");
                    string5 = string5 + RtcConnection.makeStatLine(hashMap4, "vlost", "");
                    string5 = string5 + "vlostrate: " + rtcStatistics.localVideoPacketsLostrate + "\r\n";
                    string5 = string5 + RtcConnection.makeStatLine(hashMap4, "vbr", "");
                    string5 = string5 + RtcConnection.makeStatLine(hashMap4, "alost", "");
                    string5 = string5 + "alostrate: " + rtcStatistics.localAudioPacketsLostrate + "\r\n";
                    string5 = string5 + RtcConnection.makeStatLine(hashMap4, "artt", "");
                    string5 = string5 + RtcConnection.makeStatLine(hashMap4, "abps", "");
                }
                if (hashMap3.size() > 0) {
                    void var8_27;
                    hashMap3.put("vbps", String.valueOf(RtcConnection.this.remoteVideoBW.getBitrateString()));
                    hashMap3.put("abps", String.valueOf(RtcConnection.this.remoteAudioBW.getBitrateString()));
                    hashMap5.put("vbps", String.valueOf(RtcConnection.this.remoteVideoBW.getBitrateString()));
                    hashMap5.put("abps", String.valueOf(RtcConnection.this.remoteAudioBW.getBitrateString()));
                    rtcStatistics.remoteVideoBps = Integer.parseInt(RtcConnection.this.remoteVideoBW.getBitrateString());
                    rtcStatistics.remoteAudioBps = Integer.parseInt(RtcConnection.this.remoteAudioBW.getBitrateString());
                    String string33 = (String)var8_27 + "\r\n";
                    string33 = string33 + "remote:\r\n";
                    string33 = string33 + RtcConnection.makeStatLine(hashMap3, "vcodec", "");
                    string33 = string33 + RtcConnection.makeStatLine(hashMap3, "vsize", "");
                    string33 = string33 + RtcConnection.makeStatLine(hashMap3, "vfps", "");
                    string33 = string33 + RtcConnection.makeStatLine(hashMap3, "vlost", "");
                    string33 = string33 + RtcConnection.makeStatLine(hashMap3, "vbytes", "");
                    string33 = string33 + RtcConnection.makeStatLine(hashMap3, "vbps", "");
                    string33 = string33 + RtcConnection.makeStatLine(hashMap3, "acodec", "");
                    string33 = string33 + RtcConnection.makeStatLine(hashMap3, "alost", "");
                    string33 = string33 + RtcConnection.makeStatLine(hashMap3, "abytes", "");
                    string33 = string33 + RtcConnection.makeStatLine(hashMap3, "abps", "");
                    string5 = string5 + RtcConnection.makeStatLine(hashMap5, "vcodec", "");
                    string5 = string5 + RtcConnection.makeStatLine(hashMap5, "vsize", "");
                    string5 = string5 + RtcConnection.makeStatLine(hashMap5, "vfps", "");
                    string5 = string5 + RtcConnection.makeStatLine(hashMap5, "vlost", "");
                    string5 = string5 + "vlostrate: " + rtcStatistics.remoteVideoPacketsLostrate + "\r\n";
                    string5 = string5 + RtcConnection.makeStatLine(hashMap5, "vbps", "");
                    string5 = string5 + RtcConnection.makeStatLine(hashMap5, "alost", "");
                    string5 = string5 + "alostrate: " + rtcStatistics.remoteAudioPacketsLostrate + "\r\n";
                    string5 = string5 + RtcConnection.makeStatLine(hashMap5, "abps", "");
                }
                rtcStatistics.fullStatsString = string5;
                if (!RtcConnection.this.ishangup) {
                    RtcConnection.this.listener.onStats(RtcConnection.this, rtcStatistics);
                }
            }
        }, null);
        if (!bl) {
            sLogListener.onLog(loglevel, this.name + "::: getStats() returns false!");
        }
    }

    public void setStatsEnable(boolean bl) {
        if (bl) {
            try {
                this.statsTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                RtcConnection.this.getStats();
                            }
                        });
                    }
                }, 0L, 1000L);
            }
            catch (Exception exception) {
                sLogListener.onLog(loglevel, this.name + "::: Can not schedule statistics timer " + exception);
            }
        } else {
            this.statsTimer.cancel();
        }
    }

    public void stopRenderer(final VideoViewRenderer videoViewRenderer, final VideoViewRenderer videoViewRenderer2) {
        if (!this.isconnected) {
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnection.this.makeblack(true);
                if (videoViewRenderer2 != null && RtcConnection.this.remoteViewRender == videoViewRenderer2 && RtcConnection.this.remoteVideoTrack != null && RtcConnection.this.remoteRendererAdded && RtcConnection.this.remotevideorender != null) {
                    RtcConnection.this.remoteRendererAdded = false;
                    RtcConnection.this.remoteVideoTrack.removeRenderer(RtcConnection.this.remotevideorender);
                    RtcConnection.this.remoteRect = null;
                    RtcConnection.this.remotevideorender = null;
                    if (RtcConnection.this.remoteGui != null) {
                        RtcConnection.this.remoteGui.remove(RtcConnection.this.remoteRender);
                        RtcConnection.this.remoteRender = null;
                        RtcConnection.this.remoteGui = null;
                    }
                    RtcConnection.this.remoteViewRender = null;
                }
                if (videoViewRenderer != null && RtcConnection.this.localViewRender == videoViewRenderer && RtcConnection.this.localVideoTrack != null && RtcConnection.this.localRendererAdded && RtcConnection.this.localvideorender != null) {
                    RtcConnection.this.localRendererAdded = false;
                    RtcConnection.this.localVideoTrack.removeRenderer(RtcConnection.this.localvideorender);
                    RtcConnection.this.localRect = null;
                    RtcConnection.this.localvideorender = null;
                    RtcConnection.this.localViewRender = null;
                    if (RtcConnection.this.localGui != null) {
                        RtcConnection.this.localGui.remove(RtcConnection.this.localRender);
                        RtcConnection.this.localRender = null;
                        RtcConnection.this.localGui = null;
                    }
                }
            }
        });
    }

    public void addRenderer(final VideoViewRenderer videoViewRenderer, final VideoViewRenderer videoViewRenderer2) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, "Add renderer start -0- name: " + RtcConnection.this.name);
                if (RtcConnection.this.ishangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip addRenderer because of conn is already hangup!");
                    return;
                }
                RtcConnection.this.remoteViewRender = videoViewRenderer2;
                RtcConnection.this.localViewRender = videoViewRenderer;
                if (videoViewRenderer2 != null) {
                    RtcConnection.this.remoteGui = videoViewRenderer2.getGuiImpl();
                }
                if (videoViewRenderer != null) {
                    RtcConnection.this.localGui = videoViewRenderer.getGuiImpl();
                }
                if (RtcConnection.this.remoteRect == null && RtcConnection.this.remoteViewRender != null) {
                    RtcConnection.this.remoteRect = new RenderRect(0, 0, 100, 100);
                }
                if (RtcConnection.this.localRect == null && RtcConnection.this.localViewRender != null) {
                    RtcConnection.this.localRect = videoViewRenderer != videoViewRenderer2 ? new RenderRect(0, 0, 100, 100) : new RenderRect(72, 72, 25, 25);
                }
                RtcConnection.this.checkAddRenddererInternal();
                RtcConnection.this.makeblack(false);
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setViews");
            }
        });
    }

    public void changeRenderer(VideoViewRenderer videoViewRenderer, VideoViewRenderer videoViewRenderer2) {
        this.stopRenderer(this.localViewRender, this.remoteViewRender);
        this.addRenderer(videoViewRenderer, videoViewRenderer2);
    }

    public void setAspectMode(final AspectMode aspectMode, final AspectMode aspectMode2) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setAspectMode Localaspectmode::" + (Object)((Object)aspectMode) + ",Remoteaspectmode::" + (Object)((Object)aspectMode2));
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (aspectMode == AspectMode.AspectFill) {
                    RtcConnection.this.LocalscalingType = RendererCommon.ScalingType.SCALE_ASPECT_FILL;
                } else if (aspectMode == AspectMode.AspectFit) {
                    RtcConnection.this.LocalscalingType = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
                }
                if (aspectMode2 == AspectMode.AspectFill) {
                    RtcConnection.this.RemotescalingType = RendererCommon.ScalingType.SCALE_ASPECT_FILL;
                } else if (aspectMode2 == AspectMode.AspectFit) {
                    RtcConnection.this.RemotescalingType = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
                }
                RtcConnection.this.updateVideoViewInternal();
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setAspectMode");
            }
        });
    }

    private void checkAddRenddererInternal() {
        sLogListener.onLog(loglevel, this.name + "::: checkAddRenddererInternal: => local=[" + this.localRender + ", " + this.localVideoTrack + "], remote=[" + this.remoteRender + ", " + this.remoteVideoTrack + "]");
        if (this.isRemoteViewReady()) {
            if (this.remoteRender == null) {
                sLogListener.onLog(loglevel, this.name + "::: create remote renderer");
                this.remoteRender = this.remoteGui.create(this.remoteRect.x, this.remoteRect.y, this.remoteRect.width, this.remoteRect.height, this.RemotescalingType, false);
            }
            if (this.remoteVideoTrack != null && !this.remoteRendererAdded && this.remoteRender != null) {
                this.remoteRendererAdded = true;
                sLogListener.onLog(loglevel, this.name + "::: add remote renderer");
                this.remotevideorender = new VideoRenderer(this.remoteRender);
                this.remoteVideoTrack.addRenderer(this.remotevideorender);
            }
        }
        if (this.isLocalViewReady()) {
            if (this.localRender == null) {
                sLogListener.onLog(loglevel, this.name + "::: create local renderer. Mirror::" + enableLocalViewMirror);
                this.localRender = this.localGui.create(this.localRect.x, this.localRect.y, this.localRect.width, this.localRect.height, this.LocalscalingType, enableLocalViewMirror);
            }
            if (this.localVideoTrack != null && !this.localRendererAdded && this.localRender != null) {
                this.localRendererAdded = true;
                sLogListener.onLog(loglevel, this.name + "::: add local renderer");
                this.localvideorender = new VideoRenderer(this.localRender);
                this.localVideoTrack.addRenderer(this.localvideorender);
            }
        }
    }

    private void updateVideoViewInternal() {
        if (this.remoteRender != null) {
            sLogListener.onLog(loglevel, this.name + "::: update remote renderer,RemotescalingType::" + (Object)((Object)this.RemotescalingType));
            if (this.remoteGui != null) {
                this.remoteGui.update(this.remoteRender, this.remoteRect.x, this.remoteRect.y, this.remoteRect.width, this.remoteRect.height, this.RemotescalingType, false);
            }
        }
        if (this.localRender != null && this.localGui != null) {
            sLogListener.onLog(loglevel, this.name + "::: update local renderer,LocalscalingType::" + (Object)((Object)this.LocalscalingType));
            this.localGui.update(this.localRender, this.localRect.x, this.localRect.y, this.localRect.width, this.localRect.height, this.LocalscalingType, enableLocalViewMirror);
        }
    }

    private void updateVideoViewmirror(boolean bl) {
        if (this.localRender != null && this.localGui != null) {
            sLogListener.onLog(loglevel, this.name + "::: update local renderer,LocalscalingType::" + (Object)((Object)this.LocalscalingType) + " mirror:" + bl);
            this.localGui.update(this.localRender, this.localRect.x, this.localRect.y, this.localRect.width, this.localRect.height, this.LocalscalingType, bl);
        }
    }

    public void setIceServer(final String string, final String string2, final String string3) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setIceServer");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put(RtcConnection.RtcConstStringURL, (Object)string);
                    jSONObject.put(RtcConnection.RtcConstStringUserName, (Object)string2);
                    jSONObject.put(RtcConnection.RtcConstStringCredential, (Object)string3);
                    JSONArray jSONArray = new JSONArray();
                    jSONArray.put((Object)jSONObject);
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put(RtcConnection.RtcKVIceServersArray, (Object)jSONArray);
                    RtcConnection.this.setConfigureInternal(jSONObject2.toString());
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: excpetion:" + jSONException.getMessage());
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setIceServer");
            }
        });
    }

    public void setConfigure(final String string) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setConfigure");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, "set Configure start -0- name: " + RtcConnection.this.name);
                RtcConnection.this.setConfigureInternal(string);
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setConfigure");
            }
        });
    }

    private void setConfigureInternal(String string) {
        try {
            Object object;
            sLogListener.onLog(loglevel, this.name + "::: start setConfigure: config=" + string);
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.has(RtcKVCaptureVideoBoolean)) {
                object = jSONObject.get(RtcKVCaptureVideoBoolean);
                if (Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object)) {
                    this.videoCallEnabled = true;
                } else {
                    this.autoAddVideo = false;
                    this.videoCallEnabled = false;
                }
            }
            if (jSONObject.has(RtcKVRecvVideoBoolean)) {
                object = jSONObject.get(RtcKVRecvVideoBoolean);
                this.videoreceiveEnabled = Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object);
            }
            if (jSONObject.has(RtcKVPreferVCodecString)) {
                this.videoCodec = jSONObject.getString(RtcKVPreferVCodecString);
            }
            if (jSONObject.has(RtcvideowidthLong)) {
                this.videoWidth = jSONObject.getInt(RtcvideowidthLong);
                if (this.isconnected && jSONObject.has(RtcvideoheigthLong)) {
                    this.videoHeigth = jSONObject.getInt(RtcvideoheigthLong);
                    if (this.videoWidth != 0 && this.videoHeigth != 0) {
                        this.changeVideoResolution(this.videoWidth, this.videoHeigth);
                    }
                }
            }
            if (jSONObject.has(RtcvideoheigthLong)) {
                this.videoHeigth = jSONObject.getInt(RtcvideoheigthLong);
            }
            if (jSONObject.has(RtcvideofpsLong)) {
                this.videoFramerate = jSONObject.getInt(RtcvideofpsLong);
            }
            if (jSONObject.has(RtcKVMaxVideoKbpsLong)) {
                this.videoMaxrate = jSONObject.getInt(RtcKVMaxVideoKbpsLong);
                if (this.videoMaxrate < 0) {
                    this.videoMaxrate = 0;
                }
            }
            if (jSONObject.has(RtcKVRelayVideoKbpsLong)) {
                this.relayvideoMaxrate = jSONObject.getInt(RtcKVRelayVideoKbpsLong);
            }
            if (jSONObject.has(RtcKVCaptureAudioBoolean)) {
                object = jSONObject.get(RtcKVCaptureAudioBoolean);
                this.audioCallEnabled = Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object);
            }
            if (jSONObject.has(RtcKVRecvAudioBoolean)) {
                object = jSONObject.get(RtcKVRecvAudioBoolean);
                this.audioreceiveEnabled = Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object);
            }
            if (jSONObject.has(RtcKVPreferACodecString)) {
                this.audioCodec = jSONObject.getString(RtcKVPreferACodecString);
            }
            if (jSONObject.has(RtcKVMaxAudioKbpsLong)) {
                this.audioMaxrate = jSONObject.getInt(RtcKVMaxAudioKbpsLong);
            }
            if (jSONObject.has(RtcKVRelayAudioKbpsLong)) {
                this.relayaudioMaxrate = jSONObject.getInt(RtcKVRelayAudioKbpsLong);
            }
            if (jSONObject.has(RtcKVDisablePranswerBoolean)) {
                object = jSONObject.get(RtcKVDisablePranswerBoolean);
                this.disablePranswer = Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object);
            }
            if (jSONObject.has(RtcKVLoopbackBoolean)) {
                object = jSONObject.get(RtcKVLoopbackBoolean);
                this.loopbackEnable = Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object);
            }
            if (jSONObject.has(RtcKVAecDumpFileString)) {
                this.aecDumpFilename = jSONObject.getString(RtcKVAecDumpFileString);
            }
            if (jSONObject.has(RtcKVRelayOnlyBoolean)) {
                object = jSONObject.get(RtcKVRelayOnlyBoolean);
                this.enableRelay = Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object);
            }
            if (jSONObject.has(RtcHDVideoEncoderBoolean)) {
                object = jSONObject.get(RtcHDVideoEncoderBoolean);
                this.enableHWEncoder = Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object);
            }
            if (jSONObject.has(RtcHDVideoDecoderBoolean)) {
                object = jSONObject.get(RtcHDVideoDecoderBoolean);
                this.enableHWDecoder = Boolean.TRUE.equals(object) || Integer.valueOf(1).equals(object);
            }
            if ((object = jSONObject.optJSONArray(RtcKVIceServersArray)) != null) {
                this.iceServers.clear();
                for (int k = 0; k < object.length(); ++k) {
                    JSONObject jSONObject2 = object.getJSONObject(k);
                    this.iceServers.add(new PeerConnection.IceServer(jSONObject2.optString(RtcConstStringURL), jSONObject2.optString(RtcConstStringUserName), jSONObject2.optString(RtcConstStringCredential)));
                }
            }
            sLogListener.onLog(loglevel, this.name + "::: finish setConfigure");
        }
        catch (JSONException jSONException) {
            sLogListener.onLog(loglevel, this.name + "::: setConfigure failed");
            jSONException.printStackTrace();
        }
    }

    public void createOffer() {
        this.createOffer(null);
    }

    public void capturePicture(String string) {
    }

    public void startRecord(String string) {
    }

    public String stopRecord() {
        return null;
    }

    public void createOffer(Parameters parameters) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ createOffer");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.ishangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip createOffer because of conn is already hangup!");
                    return;
                }
                RtcConnection.this.createConnectionInternal(true);
                RtcConnection.this.peerConnection.createOffer(RtcConnection.this.localSDPObserver, RtcConnection.this.sdpMediaConstraints);
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- createOffer");
            }
        });
    }

    private void checkdisableResize(final boolean bl) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.peerConnection != null) {
                    RtcConnection.this.peerConnection.setdisableResize(bl);
                }
            }
        });
    }

    public void changeVideoResolution(int n, int n2) {
        if (!this.videoCallEnabled || this.videoCapturer == null) {
            Log.e((String)TAG, (String)("Failed to change capture format. Video: " + this.videoCallEnabled + ". Error : "));
            return;
        }
        this.videoCapturer.onOutputFormatRequest(n, n2, 15);
        this.videoCapturer.changeCaptureFormat(n, n2, 15);
    }

    private boolean isNeedChangeVideoResolution(int n, int n2) {
        if (!this.videoCallEnabled || this.videoCapturer == null) {
            Log.e((String)TAG, (String)("Failed to change capture format. Video: " + this.videoCallEnabled + ". Error : "));
            return false;
        }
        CameraEnumerationAndroid.CaptureFormat captureFormat = this.videoCapturer.getCaptureFormat();
        return n > captureFormat.width || n2 > captureFormat.height;
    }

    public void SetVideoResolution(final int n, final int n2, final boolean bl) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ SetVideoResolution " + n + "*height enable:" + bl);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.ishangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip SetVideoResolution because of conn is already hangup!");
                    return;
                }
                if (RtcConnection.this.peerConnection != null) {
                    RtcConnection.this.peerConnection.SetVideoResolution(n, n2, bl);
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- SetVideoResolution");
            }
        });
    }

    public void SetMaxSendBandwidth(final int n) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ SetMaxSendBandwidth::" + n);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.ishangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip SetMaxSendBandwidth because of conn is already hangup!");
                    return;
                }
                if (RtcConnection.this.peerConnection != null) {
                    RtcConnection.this.peerConnection.SetMaxSendBandwidth(n * 1000);
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- SetMaxSendBandwidth");
            }
        });
    }

    public void setMaxVideoFrameRate(final int n) {
        configfps = n;
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ SetMaxSendBandwidth fps:" + n);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.ishangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip setMaxVideoFrameRate because of conn is already hangup!");
                    return;
                }
                if (n > 0) {
                    PeerConnectionFactory.setconfigframerate(n);
                } else {
                    PeerConnectionFactory.setconfigframerate(20);
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- SetMaxSendBandwidth");
            }
        });
    }

    public void answer() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ answer");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ answer start -0-");
                if (!RtcConnection.this.isPranswerState && !RtcConnection.this.disablePranswer) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: accpet: NOT pranswer state");
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- answer");
                    return;
                }
                RtcConnection.this.isPranswerState = false;
                RtcConnection.this.checkMediaTracksInternal();
                RtcConnection.this.peerConnection.createAnswer(RtcConnection.this.localSDPObserver, RtcConnection.this.sdpMediaConstraints);
                if (RtcConnection.this.iceConnectionState != PeerConnection.IceConnectionState.CONNECTED || RtcConnection.this.connectType == "direct") {
                    // empty if block
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- answer");
            }
        });
    }

    private void createConnectionInternal(boolean bl) {
        this.isInitiator = bl;
        sLogListener.onLog(loglevel, this.name + "::: isInitiator => " + this.isInitiator);
        if (this.peerConnectionParameters == null) {
            this.peerConnectionParameters = this.getDefaultParameters();
            if (this.autoAddVideo) {
                this.peerConnectionParameters.captureVideo = this.autoAddVideo;
                this.peerConnectionParameters.receiveVideo = this.autoAddVideo;
            } else {
                this.peerConnectionParameters.captureVideo = this.videoCallEnabled;
                this.peerConnectionParameters.receiveVideo = this.videoreceiveEnabled;
            }
            this.peerConnectionParameters.captureAudio = this.audioCallEnabled;
            this.peerConnectionParameters.receiveAudio = this.audioreceiveEnabled;
            this.peerConnectionParameters.videoCallEnabled = this.videoCallEnabled;
            if (this.videoCodec == null) {
                this.videoCodec = "VP8";
                sLogListener.onLog(loglevel, this.name + "::: use default video codec " + this.videoCodec);
            }
            this.peerConnectionParameters.videoCodec = this.videoCodec;
            if (this.videoWidth == 0 || this.videoHeigth == 0) {
                this.videoWidth = 640;
                this.videoHeigth = 480;
                sLogListener.onLog(loglevel, this.name + "::: use default video size " + this.videoWidth + "x" + this.videoHeigth);
            }
            this.peerConnectionParameters.videoWidth = this.videoWidth;
            this.peerConnectionParameters.videoHeight = this.videoHeigth;
            if (this.videoMaxrate == 0) {
                this.videoMaxrate = RtcConnection.getKbpsByVideoSize(this.videoWidth, this.videoHeigth);
                sLogListener.onLog(loglevel, this.name + "::: use default maxVideoKbps " + this.videoMaxrate);
            }
            if (this.relayvideoMaxrate == 0) {
                this.relayvideoMaxrate = RtcConnection.getKbpsByVideoSize(this.videoWidth, this.videoHeigth);
            }
            this.peerConnectionParameters.videoFps = this.videoFramerate;
            if (this.audioCodec == null) {
                this.audioCodec = "OPUS";
                sLogListener.onLog(loglevel, this.name + "::: use default audio codec " + this.audioCodec);
            }
            this.peerConnectionParameters.audioCodec = this.audioCodec;
        }
        this.renderVideo = this.videoCallEnabled && this.peerConnectionParameters.renderLocal;
        this.renderVideo = true;
        this.createMediaConstraintsInternal();
        this.createPeerConnectionInternal();
    }

    private static SessionDescription content2Sdp(RtcContent rtcContent) {
        if (rtcContent.type.equalsIgnoreCase(RtcContent.TYPE_OFFER) || rtcContent.type.equalsIgnoreCase(RtcContent.TYPE_ANSWER) || rtcContent.type.equalsIgnoreCase(RtcContent.TYPE_PRANSWER)) {
            SessionDescription sessionDescription = new SessionDescription(SessionDescription.Type.valueOf(rtcContent.type.toUpperCase()), rtcContent.sdp);
            return sessionDescription;
        }
        return null;
    }

    private IceCandidate content2Candidatee(RtcContent rtcContent) {
        if (rtcContent.type.equalsIgnoreCase("candidate")) {
            IceCandidate iceCandidate = new IceCandidate("audio", rtcContent.mlineindex, rtcContent.candidate);
            return iceCandidate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingSdp(SessionDescription sessionDescription) {
        LinkedList<SessionDescription> linkedList = this.pendingSdp;
        synchronized (linkedList) {
            sLogListener.onLog(loglevel, this.name + "::: add pending sdp");
            this.pendingSdp.addLast(sessionDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionDescription removePendingSdp() {
        LinkedList<SessionDescription> linkedList = this.pendingSdp;
        synchronized (linkedList) {
            if (this.pendingSdp.isEmpty()) {
                return null;
            }
            return this.pendingSdp.removeFirst();
        }
    }

    private void processPendingSdpInternal() {
        SessionDescription sessionDescription;
        while ((sessionDescription = this.removePendingSdp()) != null) {
            if (sessionDescription.type == SessionDescription.Type.OFFER) {
                if (this.isInitiator) {
                    sLogListener.onLog(loglevel, this.name + "::: got offer but isInitiator, drop it");
                    continue;
                }
                if (this.peerConnection == null) {
                    this.createConnectionInternal(false);
                }
                if (this.peerConnection.signalingState() == PeerConnection.SignalingState.STABLE) {
                    if (this.peerConnection.getRemoteDescription() == null) {
                        this.isPranswerState = true;
                        this.setRemoteSdpInternal(sessionDescription);
                        sLogListener.onLog(loglevel, this.name + "::: create PRANSWER : sdpMediaConstraints=" + this.sdpMediaConstraints);
                        this.peerConnection.createAnswer(this.localSDPObserver, this.sdpMediaConstraints);
                        continue;
                    }
                    this.isPranswerState = false;
                    this.setRemoteSdpInternal(sessionDescription);
                    sLogListener.onLog(loglevel, this.name + "::: create ANSWER : sdpMediaConstraints=" + this.sdpMediaConstraints);
                    this.peerConnection.createAnswer(this.localSDPObserver, this.sdpMediaConstraints);
                    continue;
                }
                sLogListener.onLog(loglevel, this.name + "::: got offer at wrong state " + (Object)((Object)this.peerConnection.signalingState()));
                continue;
            }
            if (sessionDescription.type == SessionDescription.Type.PRANSWER || sessionDescription.type == SessionDescription.Type.ANSWER) {
                if (!this.isInitiator) {
                    sLogListener.onLog(loglevel, this.name + "::: got " + (Object)((Object)sessionDescription.type) + " but NOT isInitiator, drop it " + this.isInitiator);
                    continue;
                }
                if (this.peerConnection == null) {
                    sLogListener.onLog(loglevel, this.name + "::: got " + (Object)((Object)sessionDescription.type) + " but NOT pc null, drop it");
                    continue;
                }
                if (this.iceConnectionState != PeerConnection.IceConnectionState.CONNECTED || this.connectType == "direct") {
                    // empty if block
                }
                if (this.peerConnection.signalingState() == PeerConnection.SignalingState.HAVE_LOCAL_OFFER || this.peerConnection.signalingState() == PeerConnection.SignalingState.HAVE_REMOTE_PRANSWER) {
                    this.setRemoteSdpInternal(sessionDescription);
                    continue;
                }
                sLogListener.onLog(loglevel, this.name + "::: got " + (Object)((Object)sessionDescription.type) + " at wrong state " + (Object)((Object)this.peerConnection.signalingState()));
                continue;
            }
            sLogListener.onLog(loglevel, this.name + "::: unknown sdp type " + (Object)((Object)sessionDescription.type));
        }
    }

    public String setRemoteJson(String string) throws Exception {
        sLogListener.onLog(loglevel, this.name + "::: remote json: " + string);
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setRemoteJson");
        RtcContent rtcContent = RtcContent.fromJson(string);
        SessionDescription sessionDescription = RtcConnection.content2Sdp(rtcContent);
        if (sessionDescription != null) {
            this.addPendingSdp(sessionDescription);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    sLogListener.onLog(loglevel, "setRemoteJson start -0- name: " + RtcConnection.this.name);
                    if (RtcConnection.this.ishangup) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip setRemoteJson because of conn is already hangup!");
                        return;
                    }
                    RtcConnection.this.processPendingSdpInternal();
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setRemoteJson remote sdp");
                }
            });
            return rtcContent.type;
        }
        final IceCandidate iceCandidate = this.content2Candidatee(rtcContent);
        if (iceCandidate != null) {
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    sLogListener.onLog(loglevel, "setRemoteJson remote candidate start -0- name: " + RtcConnection.this.name);
                    if (RtcConnection.this.peerConnection != null) {
                        RtcConnection.this.peerConnection.addIceCandidate(iceCandidate);
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setRemoteJson remote candidate");
                        return;
                    }
                    List list = RtcConnection.this.pendingCandidates;
                    synchronized (list) {
                        RtcConnection.this.pendingCandidates.add(iceCandidate);
                    }
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setRemoteJson remote candidate");
                }
            });
            return rtcContent.type;
        }
        throw new Exception("unknown type " + rtcContent.type);
    }

    public String setRemoteCandidate(String string) throws Exception {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setRemoteCandidate");
        RtcContent rtcContent = RtcContent.fromJson(string);
        final IceCandidate iceCandidate = this.content2Candidatee(rtcContent);
        if (iceCandidate != null) {
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (RtcConnection.this.peerConnection != null) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: add remoteCandidate:: " + iceCandidate.toString());
                        RtcConnection.this.peerConnection.addIceCandidate(iceCandidate);
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setRemoteCandidate");
                        return;
                    }
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: add pending candidate");
                    List list = RtcConnection.this.pendingCandidates;
                    synchronized (list) {
                        RtcConnection.this.pendingCandidates.add(iceCandidate);
                    }
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setRemoteCandidate");
                }
            });
            return rtcContent.type;
        }
        throw new Exception("unknown type " + rtcContent.type);
    }

    public String setRemoteSdp(String string) throws Exception {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setRemoteSdp");
        sLogListener.onLog(loglevel, this.name + "::: setRemoteSdp: " + string);
        RtcContent rtcContent = RtcContent.fromJson(string);
        SessionDescription sessionDescription = RtcConnection.content2Sdp(rtcContent);
        if (sessionDescription != null) {
            this.addPendingSdp(sessionDescription);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    RtcConnection.this.processPendingSdpInternal();
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setRemoteSdp");
                }
            });
            return rtcContent.type;
        }
        throw new Exception("unknown type " + rtcContent.type);
    }

    public String inverseSdpJson(String string) throws Exception {
        RtcContent rtcContent = RtcContent.fromJson(string);
        if (rtcContent.type.equalsIgnoreCase(RtcContent.TYPE_OFFER)) {
            SessionDescription sessionDescription = new SessionDescription(SessionDescription.Type.valueOf(RtcContent.TYPE_ANSWER.toUpperCase()), rtcContent.sdp);
            return RtcContent.SDP2Json(sessionDescription, this.getLocalSeq(), "connectionId");
        }
        if (rtcContent.type.equalsIgnoreCase(RtcContent.TYPE_ANSWER)) {
            SessionDescription sessionDescription = new SessionDescription(SessionDescription.Type.valueOf(RtcContent.TYPE_OFFER.toUpperCase()), rtcContent.sdp);
            return RtcContent.SDP2Json(sessionDescription, this.getLocalSeq(), "connectionId");
        }
        return string;
    }

    private void printRemoteStream(String string) {
        if (this.remoteStream == null) {
            return;
        }
        if (this.remoteStream.videoTracks != null) {
            sLogListener.onLog(loglevel, this.name + "::: " + string + " remote stream video tracks = " + this.remoteStream.videoTracks.size());
            if (this.remoteStream.videoTracks.size() > 0) {
                sLogListener.onLog(loglevel, this.name + "::: " + string + " remote stream video track[0] state = " + (Object)((Object)this.remoteStream.videoTracks.get(0).state()));
            }
        } else {
            sLogListener.onLog(loglevel, this.name + "::: " + string + " remote stream video tracks is null");
        }
    }

    private void setRemoteSdpInternal(SessionDescription sessionDescription) {
        if (this.peerConnection == null) {
            return;
        }
        String string = sessionDescription.description;
        if (this.enableRelay) {
            string = string.replaceAll("a=mid:audio\r", "a=mid:audio\r\nb=AS:" + this.relayaudioMaxrate + "\r");
            string = string.replaceAll("a=mid:video\r", "a=mid:video\r\nb=AS:" + this.relayvideoMaxrate + "\r");
        } else {
            string = string.replaceAll("a=mid:audio\r", "a=mid:audio\r\nb=AS:" + this.audioMaxrate + "\r");
            string = string.replaceAll("a=mid:video\r", "a=mid:video\r\nb=AS:" + this.videoMaxrate + "\r");
        }
        SessionDescription sessionDescription2 = new SessionDescription(sessionDescription.type, string);
        sLogListener.onLog(loglevel, this.name + "::: Set remote SDP => " + (Object)((Object)sessionDescription2.type));
        try {
            this.peerConnection.setRemoteDescription(this.remoteSDPObserver, sessionDescription2);
            if (this.remoteStream != null) {
                this.printRemoteStream("p1");
                if (this.remoteVideoTrack != null && this.remoteVideoTrack.state() == MediaStreamTrack.State.ENDED) {
                    sLogListener.onLog(loglevel, this.name + "::: remote remote video track");
                    this.printRemoteStream("p2");
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            sLogListener.onLog(loglevel, this.name + "::: Set remote SDP exception " + throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainCandidatesInteranl() {
        if (this.peerConnection != null) {
            List<IceCandidate> list = this.pendingCandidates;
            synchronized (list) {
                for (IceCandidate iceCandidate : this.pendingCandidates) {
                    this.peerConnection.addIceCandidate(iceCandidate);
                }
                this.pendingCandidates.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLocalSeq() {
        RtcConnection rtcConnection = this;
        synchronized (rtcConnection) {
            ++this.localSeq;
            return this.localSeq;
        }
    }

    private void reportError(final String string) {
        sLogListener.onLog(loglevel, this.name + "::: rtc reportError: " + string);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!RtcConnection.this.ishangup) {
                    RtcConnection.this.listener.onError(RtcConnection.this, string);
                }
            }
        });
    }

    private static Exception newException(String string) {
        ALog.i(TAG, string);
        return new Exception(string);
    }

    private static void slog(String string) {
        ALog.i(TAG, string);
    }

    private static void slogw(String string) {
        ALog.i(TAG, string);
    }

    private static void sloge(String string) {
        ALog.i(TAG, string);
    }

    private void log(String string) {
        ALog.i(TAG, "<D><" + this.name + "> " + string);
    }

    private void logw(String string) {
        ALog.i(TAG, "<W><" + this.name + "> " + string);
    }

    private void loge(String string) {
        ALog.e(TAG, "<E><" + this.name + "> " + string);
    }

    public void setenableaec(final boolean bl) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setenableaec:" + bl);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setenableaec");
                RtcConnection.this.enableaec = bl;
            }
        });
    }

    public void setenableagc(final boolean bl) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setenableagc:" + bl);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setenableagc");
                RtcConnection.this.enableagc = bl;
            }
        });
    }

    public void setenablens(final boolean bl) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setenablens:" + bl);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setenablens");
                RtcConnection.this.enablens = bl;
            }
        });
    }

    private void createMediaConstraintsInternal() {
        this.pcConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.loopback) {
            sLogListener.onLog(loglevel, this.name + "::: loopback: set DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT false ");
            this.pcConstraints.optional.add(new MediaConstraints.KeyValuePair(DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT, "false"));
        } else {
            this.pcConstraints.optional.add(new MediaConstraints.KeyValuePair(DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT, "true"));
        }
        this.numberOfCameras = CameraEnumerationAndroid.getDeviceCount();
        if (this.numberOfCameras == 0) {
            sLogListener.onLog(loglevel, this.name + "::: No camera on device. Switch to audio only call.");
            this.videoCallEnabled = false;
        }
        if (this.peerConnectionParameters.captureVideo) {
            int n;
            this.videoConstraints = new MediaConstraints();
            int n2 = this.peerConnectionParameters.videoWidth;
            int n3 = this.peerConnectionParameters.videoHeight;
            if ((n2 == 0 || n3 == 0) && this.peerConnectionParameters.videoCodecHwAcceleration && MediaCodecVideoEncoder.isVp8HwSupported()) {
                n2 = 1920;
                n3 = 1080;
            }
            if (n2 > 0 && n3 > 0) {
                n2 = Math.min(n2, 1920);
                n3 = Math.min(n3, 1920);
                this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair(MIN_VIDEO_WIDTH_CONSTRAINT, Integer.toString(n2)));
                this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair(MAX_VIDEO_WIDTH_CONSTRAINT, Integer.toString(1920)));
                this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair(MIN_VIDEO_HEIGHT_CONSTRAINT, Integer.toString(n3)));
                this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair(MAX_VIDEO_HEIGHT_CONSTRAINT, Integer.toString(1920)));
            }
            if ((n = this.peerConnectionParameters.videoFps) > 0) {
                n = Math.min(n, 30);
                this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair(MIN_VIDEO_FPS_CONSTRAINT, Integer.toString(n)));
                this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair(MAX_VIDEO_FPS_CONSTRAINT, Integer.toString(n)));
            }
        }
        this.audioConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.noAudioProcessing) {
            sLogListener.onLog(loglevel, this.name + "::: Disabling audio processing");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_ECHO_CANCELLATION_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_HIGH_PASS_FILTER_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
        }
        if (!this.enableaec) {
            sLogListener.onLog(loglevel, this.name + "::: Disabling audio AEC");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_ECHO_CANCELLATION_CONSTRAINT, "false"));
        }
        if (!this.enableagc) {
            sLogListener.onLog(loglevel, this.name + "::: Disabling audio AGC");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT, "false"));
        }
        if (!this.enablens) {
            sLogListener.onLog(loglevel, this.name + "::: Disabling audio NS");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
        }
        this.sdpMediaConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.loopback || this.peerConnectionParameters.receiveAudio) {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        } else {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "false"));
            sLogListener.onLog(loglevel, this.name + "::: set OfferToReceiveAudio false");
        }
        if (this.peerConnectionParameters.loopback || this.peerConnectionParameters.receiveVideo || this.peerConnectionParameters.captureVideo) {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "true"));
            sLogListener.onLog(loglevel, this.name + "::: OfferToReceiveVideo true");
        } else {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "false"));
        }
    }

    private void initAudio() {
        sLogListener.onLog(loglevel, this.name + "::: initAudio");
        if (this.audioManager == null) {
            this.audioManager = AppRTCAudioManager.create(sContext, new Runnable(){

                @Override
                public void run() {
                }
            });
            sLogListener.onLog(loglevel, this.name + "::: Initializing the audio manager...");
            this.audioManager.init();
        }
    }

    private void createPeerConnectionInternal() {
        if (factory == null) {
            sLogListener.onLog(loglevel, this.name + "::: Peerconnection factory is not created");
            return;
        }
        sLogListener.onLog(loglevel, this.name + "::: Create peer connection");
        sLogListener.onLog(loglevel, this.name + "::: PCConstraints: " + this.pcConstraints.toString());
        if (this.videoConstraints != null) {
            sLogListener.onLog(loglevel, this.name + "::: VideoConstraints: " + this.videoConstraints.toString());
        }
        PeerConnection.RTCConfiguration rTCConfiguration = new PeerConnection.RTCConfiguration(this.iceServers);
        rTCConfiguration.tcpCandidatePolicy = PeerConnection.TcpCandidatePolicy.DISABLED;
        rTCConfiguration.bundlePolicy = PeerConnection.BundlePolicy.MAXBUNDLE;
        rTCConfiguration.rtcpMuxPolicy = PeerConnection.RtcpMuxPolicy.REQUIRE;
        if (this.enableRelay) {
            rTCConfiguration.iceTransportsType = PeerConnection.IceTransportsType.RELAY;
        }
        this.peerConnection = factory.createPeerConnection(rTCConfiguration, this.pcConstraints, (PeerConnection.Observer)this.pcObserver);
        if (this.peerConnection != null) {
            if (disableResize) {
                this.peerConnection.setdisableResize(disableResize);
            }
            if (configfps != 0) {
                PeerConnectionFactory.setconfigframerate(configfps);
            }
            if (configminkbps <= 0) {
                configminkbps = DEFAULT_CONFIG_MINKBPS;
                this.peerConnection.setconfigminbitrate(configminkbps);
            } else {
                this.peerConnection.setconfigminbitrate(configminkbps);
            }
        }
        this.mediaStream = factory.createLocalMediaStream("ARDAMS");
        if (this.isInitiator) {
            this.checkMediaTracksInternal();
        }
        this.peerConnection.addStream(this.mediaStream);
        this.startAecDump();
    }

    private void checkRenegoInternal() {
    }

    private void checkRenegoInternal0() {
        if (this.peerConnection == null) {
            return;
        }
        if (this.peerConnection.signalingState() != PeerConnection.SignalingState.STABLE && this.peerConnection.signalingState() != PeerConnection.SignalingState.HAVE_LOCAL_PRANSWER && this.peerConnection.signalingState() != PeerConnection.SignalingState.HAVE_REMOTE_PRANSWER) {
            sLogListener.onLog(loglevel, this.name + "::: skip re-nego because of state " + (Object)((Object)this.peerConnection.signalingState()));
            return;
        }
        if (this.peerConnection.getLocalDescription() == null) {
            sLogListener.onLog(loglevel, this.name + "::: skip re-nego because of no local sdp ");
            return;
        }
        if (this.isInitiator) {
            sLogListener.onLog(loglevel, this.name + "::: re-create OFFER : sdpMediaConstraints=" + this.sdpMediaConstraints);
            this.peerConnection.createOffer(this.localSDPObserver, this.sdpMediaConstraints);
        } else {
            sLogListener.onLog(loglevel, this.name + "::: re-create ANSWER : sdpMediaConstraints=" + this.sdpMediaConstraints);
            this.peerConnection.createAnswer(this.localSDPObserver, this.sdpMediaConstraints);
        }
    }

    private void checkVideoCapturerConfigRotation() {
        if (this.videoCapturer != null && this.isconfigRotation) {
            this.videoCapturer.setRotation(this.configRotation);
        }
    }

    private void checkVideoCapturerDataProcessor() {
        if (this.processor != null) {
            if (this.videoCapturer != null) {
                this.videoCapturer.setCameraDataProcessor(new VideoCapturerAndroid.VideoCapturerDataProcessor(){

                    @Override
                    public void onProcessData(byte[] byArray, Camera camera, int n, int n2, int n3) {
                        RtcConnection.this.processor.onProcessData(byArray, camera, n, n2, n3);
                    }

                    @Override
                    public void setResolution(int n, int n2) {
                        RtcConnection.this.processor.setResolution(n, n2);
                    }
                });
            }
        } else if (this.videoCapturer != null) {
            this.videoCapturer.setCameraDataProcessor(null);
        }
    }

    private void checkGlTextureProcessor() {
        if (this.glprocessor != null) {
            if (this.videoCapturer != null) {
                this.videoCapturer.setGlTextureProcessor(new VideoCapturerAndroid.GlTextureProcessor(){

                    @Override
                    public void onDrawFrame(int n, int n2, int n3, float[] fArray, int n4) {
                        RtcConnection.this.glprocessor.onDrawFrame(n, n2, n3, fArray, n4);
                    }
                });
            }
        } else if (this.videoCapturer != null) {
            this.videoCapturer.setGlTextureProcessor(null);
        }
    }

    public void inputExternalVideoData(byte[] byArray, int n, int n2, int n3) {
        if (this.videoCapturer != null) {
            this.videoCapturer.inputExternalVideoData(byArray, n, n2, n3);
        }
    }

    private void checkMediaTracksInternal() {
        if (this.peerConnection == null) {
            return;
        }
        if (this.mediaStream == null) {
            return;
        }
        if (this.peerConnectionParameters.captureVideo && this.localVideoTrack == null) {
            boolean bl = false;
            String string = CameraEnumerationAndroid.getDeviceName(0);
            bl = true;
            String string2 = CameraEnumerationAndroid.getNameOfFrontFacingDevice();
            if (this.numberOfCameras > 1 && string2 != null) {
                string = string2;
                bl = false;
            }
            if (cameraid >= 0 && cameraid < this.numberOfCameras) {
                string = CameraEnumerationAndroid.getDeviceName(cameraid);
                if (cameraid == 0) {
                    bl = true;
                }
            }
            enableLocalViewMirror = !bl;
            this.updateVideoViewmirror(enableLocalViewMirror);
            sLogListener.onLog(loglevel, this.name + "::: Opening camera: " + string + " Mirror::" + enableLocalViewMirror);
            boolean bl2 = this.enableOpenCamera = this.peerConnectionParameters.videoCallEnabled && !this.isStopCapture;
            if (this.glprocessor != null) {
                if (this.localGui != null) {
                    this.sharedeglContext = this.localGui.getEglBaseContext();
                }
                this.videoCapturer = VideoCapturerAndroid.create(string, null, this.sharedeglContext);
            } else {
                this.videoCapturer = VideoCapturerAndroid.create(string, null);
            }
            if (this.videoCapturer == null) {
                this.reportError("Failed to open camera");
            } else {
                this.checkVideoCapturerConfigRotation();
                this.videoCapturer.setEnableExternalVideoData(this.enableExternalVideoData);
                this.checkVideoCapturerDataProcessor();
                this.checkGlTextureProcessor();
                if (this.peerConnectionParameters.videoCallEnabled) {
                    if (this.isStopCapture) {
                        this.videoCapturer.setEnableCamera(false);
                        this.videoCapturer.setEnableCameragetsuppoted(false);
                    } else {
                        this.videoCapturer.setEnableCamera(true);
                        this.videoCapturer.setEnableCameragetsuppoted(false);
                    }
                } else if (this.autoAddVideo) {
                    this.videoCapturer.setEnableCamera(false);
                    this.videoCapturer.setEnableCameragetsuppoted(false);
                }
                this.videoSource = factory.createVideoSource(this.videoCapturer, this.videoConstraints);
                this.localVideoTrack = factory.createVideoTrack(VIDEO_TRACK_ID, this.videoSource);
                this.localVideoTrack.setEnabled(this.renderVideo);
                this.mediaStream.addTrack(this.localVideoTrack);
            }
            this.checkAddRenddererInternal();
            this.checkRenegoInternal();
        } else if (!this.peerConnectionParameters.captureVideo && this.localVideoTrack != null) {
            sLogListener.onLog(loglevel, this.name + "::: remove video track");
            if (this.localVideoTrack != null) {
                this.mediaStream.removeTrack(this.localVideoTrack);
                this.localVideoTrack.setEnabled(false);
                this.localVideoTrack.dispose();
                this.localVideoTrack = null;
                if (this.localRendererAdded) {
                    this.localRendererAdded = false;
                }
            }
            if (this.videoSource != null) {
                this.videoSource.stop();
                this.videoSource.dispose();
                this.videoSource = null;
            }
            this.checkRenegoInternal();
        }
        if (this.isRemoteViewReady() && this.remoteRender == null) {
            sLogListener.onLog(loglevel, this.name + "::: checking remote renderer");
            this.checkAddRenddererInternal();
        }
        if (this.peerConnectionParameters.captureAudio && this.localAudioTrack == null) {
            sLogListener.onLog(loglevel, this.name + "::: create capture audio");
            this.audioSource = factory.createAudioSource(this.audioConstraints);
            this.localAudioTrack = factory.createAudioTrack(AUDIO_TRACK_ID, this.audioSource);
            if (this.localAudioTrack != null) {
                if (!this.enableaudio) {
                    this.localAudioTrack.setEnabled(this.enableaudio);
                }
                this.mediaStream.addTrack(this.localAudioTrack);
            }
            this.checkRenegoInternal();
        } else if (!this.peerConnectionParameters.captureAudio && this.localAudioTrack != null) {
            sLogListener.onLog(loglevel, this.name + "::: remove audio track");
            if (this.localAudioTrack != null) {
                this.mediaStream.removeTrack(this.localAudioTrack);
                this.localAudioTrack = null;
            }
            this.checkRenegoInternal();
        } else {
            sLogListener.onLog(loglevel, this.name + "::: do nothing for audio");
        }
    }

    public void setMute(final boolean bl) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setMute ::" + bl);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnection.this.enableaudio = !bl;
                if (RtcConnection.this.localAudioTrack != null) {
                    RtcConnection.this.localAudioTrack.setEnabled(RtcConnection.this.enableaudio);
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setMute");
            }
        });
    }

    public void addlocalstream() {
        String string = CameraEnumerationAndroid.getDeviceName(0);
        String string2 = CameraEnumerationAndroid.getNameOfFrontFacingDevice();
        if (this.numberOfCameras > 1 && string2 != null) {
            string = string2;
        }
        if (this.peerConnectionParameters.cameraIndex >= 0 && this.peerConnectionParameters.cameraIndex < this.numberOfCameras) {
            string = CameraEnumerationAndroid.getDeviceName(this.peerConnectionParameters.cameraIndex);
        }
        sLogListener.onLog(loglevel, this.name + "::: Opening camera: " + string);
    }

    public void TakePicture(String string) {
        this.peerConnection.TakePicture(string);
    }

    public void close() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ close");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnection.this.closeInternal();
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- close");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hangup() {
        if (this.ishangup) {
            sLogListener.onLog(loglevel, this.name + "::: peer ishangup : " + this.ishangup);
            return;
        }
        this.ishangup = true;
        JSONObject jSONObject = new JSONObject();
        Class<RtcConnection> clazz = RtcConnection.class;
        synchronized (RtcConnection.class) {
            try {
                jSONObject.put("conn", (Object)this.connectType);
                jSONObject.put("lvcodec", (Object)this.lusevcodectype);
                jSONObject.put("lacodec", (Object)this.luseacodectype);
                jSONObject.put("rvcodec", (Object)this.rusevcodectype);
                jSONObject.put("racodec", (Object)this.ruseacodectype);
                jSONObject.put("sentVPkts", this.videolastsendpackets);
                jSONObject.put("sentAPkts", this.audiolastsendpackets);
                jSONObject.put("recvVPkts", this.videolastrecvpackets);
                jSONObject.put("recvAPkts", this.audiolastrecvpackets);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            sLogListener.onLog(loglevel, this.name + "::: ReportString ::" + jSONObject.toString());
            sLogListener.onLog(loglevel, this.name + "::: [rapi]++ hangup");
            this.makeblack(true);
            this.statsTimer.cancel();
            this.isconnected = false;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (RtcConnection.this.peerConnection != null) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: RTC hangup close peerConnection");
                        RtcConnection.this.peerConnection.dispose();
                        RtcConnection.this.peerConnection = null;
                    }
                    if (RtcConnection.this.videoSource != null) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: RTC hangup close videosource");
                        RtcConnection.this.videoSource.dispose();
                        RtcConnection.this.videoSource = null;
                        if (RtcConnection.this.localGui != null) {
                            RtcConnection.this.localGui.remove(RtcConnection.this.localRender);
                            RtcConnection.this.localRender = null;
                            RtcConnection.this.localGui = null;
                        }
                        RtcConnection.this.localViewRender = null;
                    }
                    if (RtcConnection.this.remoteGui != null) {
                        RtcConnection.this.remoteGui.remove(RtcConnection.this.remoteRender);
                        RtcConnection.this.remoteRender = null;
                        RtcConnection.this.remoteGui = null;
                        RtcConnection.this.remoteViewRender = null;
                    }
                    if (RtcConnection.this.audioSource != null) {
                        RtcConnection.this.audioSource.dispose();
                        RtcConnection.this.audioSource = null;
                    }
                    RtcConnection.this.options = null;
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ onClosed");
                    if (!RtcConnection.this.ishangup) {
                        RtcConnection.this.listener.onClosed(RtcConnection.this);
                    }
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- hangup");
                }
            });
            return;
        }
    }

    private void closeInternal() {
        sLogListener.onLog(loglevel, this.name + "::: Closing peer connection.");
        this.statsTimer.cancel();
        if (this.peerConnection != null) {
            this.peerConnection.dispose();
            this.peerConnection = null;
        }
        this.log("Closing video source.");
        if (this.videoSource != null) {
            this.videoSource.dispose();
            this.videoSource = null;
        }
        sLogListener.onLog(loglevel, this.name + "::: Closing peer connection factory.");
        this.options = null;
        sLogListener.onLog(loglevel, this.name + "::: Closing peer connection done.");
        sLogListener.onLog(loglevel, this.name + ":::  onClosed");
        if (!this.ishangup) {
            this.listener.onClosed(this);
        }
        PeerConnectionFactory.stopInternalTracingCapture();
        PeerConnectionFactory.shutdownInternalTracer();
    }

    private static String setStartBitrate(String string, boolean bl, String string2, int n) {
        Matcher matcher;
        int n2;
        String[] stringArray = string2.split("\r\n");
        int n3 = -1;
        boolean bl2 = false;
        String string3 = null;
        String string4 = "^a=rtpmap:(\\d+) " + string + "(/\\d+)+[\r]?$";
        Pattern pattern = Pattern.compile(string4);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            matcher = pattern.matcher(stringArray[n2]);
            if (!matcher.matches()) continue;
            string3 = matcher.group(1);
            n3 = n2;
            break;
        }
        if (string3 == null) {
            sLogListener.onLog(loglevel, "::: No rtpmap for " + string + " codec");
            return string2;
        }
        sLogListener.onLog(loglevel, "::: Found " + string + " rtpmap " + string3 + " at " + stringArray[n3]);
        string4 = "^a=fmtp:" + string3 + " \\w+=\\d+.*[\r]?$";
        pattern = Pattern.compile(string4);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            matcher = pattern.matcher(stringArray[n2]);
            if (!matcher.matches()) continue;
            sLogListener.onLog(loglevel, "::: Found " + string + " " + stringArray[n2]);
            if (bl) {
                int n4 = n2;
                stringArray[n4] = stringArray[n4] + "; x-google-start-bitrate=" + n;
            } else {
                int n5 = n2;
                stringArray[n5] = stringArray[n5] + "; maxaveragebitrate=" + n * 1000;
            }
            sLogListener.onLog(loglevel, "::: Update remote SDP line: " + stringArray[n2]);
            bl2 = true;
            break;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int k = 0; k < stringArray.length; ++k) {
            stringBuilder.append(stringArray[k]).append("\r\n");
            if (bl2 || k != n3) continue;
            String string5 = bl ? "a=fmtp:" + string3 + " " + VIDEO_CODEC_PARAM_START_BITRATE + "=" + n : "a=fmtp:" + string3 + " " + AUDIO_CODEC_PARAM_BITRATE + "=" + n * 1000;
            sLogListener.onLog(loglevel, "::: Add remote SDP line: " + string5);
            stringBuilder.append(string5).append("\r\n");
        }
        return stringBuilder.toString();
    }

    private static String preferCodec(String string, String string2, boolean bl) {
        Object object;
        String[] stringArray = string.split("\r\n");
        int n = -1;
        String string3 = null;
        String string4 = "^a=rtpmap:(\\d+) " + string2 + "(/\\d+)+[\r]?$";
        Pattern pattern = Pattern.compile(string4);
        String string5 = "m=video ";
        if (bl) {
            string5 = "m=audio ";
        }
        for (int k = 0; k < stringArray.length && (n == -1 || string3 == null); ++k) {
            if (stringArray[k].startsWith(string5)) {
                n = k;
                continue;
            }
            object = pattern.matcher(stringArray[k]);
            if (!((Matcher)object).matches()) continue;
            string3 = ((Matcher)object).group(1);
        }
        if (n == -1) {
            sLogListener.onLog(loglevel, "::: No " + string5 + " line, so can't prefer " + string2);
            return string;
        }
        if (string3 == null) {
            sLogListener.onLog(loglevel, "::: No rtpmap for " + string2);
            return string;
        }
        sLogListener.onLog(loglevel, "::: Found " + string2 + " rtpmap " + string3 + ", prefer at " + stringArray[n]);
        String[] stringArray2 = stringArray[n].split(" ");
        if (stringArray2.length > 3) {
            object = new StringBuilder();
            int n2 = 0;
            ((StringBuilder)object).append(stringArray2[n2++]).append(" ");
            ((StringBuilder)object).append(stringArray2[n2++]).append(" ");
            ((StringBuilder)object).append(stringArray2[n2++]).append(" ");
            ((StringBuilder)object).append(string3);
            while (n2 < stringArray2.length) {
                if (!stringArray2[n2].equals(string3)) {
                    ((StringBuilder)object).append(" ").append(stringArray2[n2]);
                }
                ++n2;
            }
            stringArray[n] = ((StringBuilder)object).toString();
            sLogListener.onLog(loglevel, "::: Change media description: " + stringArray[n]);
        } else {
            sLogListener.onLog(loglevel, "::: Wrong SDP media description format: " + stringArray[n]);
        }
        object = new StringBuilder();
        for (String string6 : stringArray) {
            ((StringBuilder)object).append(string6).append("\r\n");
        }
        return ((StringBuilder)object).toString();
    }

    private void switchCameraInternal() {
        if (this.autoAddVideo) {
            if (!this.enableOpenCamera || this.numberOfCameras < 2 || this.videoCapturer == null) {
                sLogListener.onLog(loglevel, this.name + "::: Failed to switch camera. Video: " + this.enableOpenCamera + ". Number of cameras: " + this.numberOfCameras);
                return;
            }
        } else if (!this.videoCallEnabled || this.numberOfCameras < 2 || this.videoCapturer == null) {
            sLogListener.onLog(loglevel, this.name + "::: Failed to switch camera. Video: " + this.videoCallEnabled + ". Number of cameras: " + this.numberOfCameras);
            return;
        }
        sLogListener.onLog(loglevel, this.name + "::: Switch camera");
        this.videoCapturer.switchCamera(new VideoCapturerAndroid.CameraSwitchHandler(){

            @Override
            public void onCameraSwitchDone(boolean bl) {
                if (bl) {
                    enableLocalViewMirror = true;
                } else {
                    enableLocalViewMirror = false;
                }
                RtcConnection.this.updateVideoViewmirror(enableLocalViewMirror);
            }

            @Override
            public void onCameraSwitchError(String string) {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: switchCamera Error::" + string);
            }
        });
    }

    public void switchCamera() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ switchCamera");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.ishangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip switchCamera because of conn is already hangup!");
                    return;
                }
                RtcConnection.this.switchCameraInternal();
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- switchCamera");
            }
        });
    }

    private void checkoutenableCamera() {
        if (this.videoCapturer == null || this.enableOpenCamera || !this.autoAddVideo) {
            sLogListener.onLog(loglevel, this.name + "::: Failed to enableCamera. Video:" + this.enableOpenCamera + " autoAddVideo:" + this.autoAddVideo);
            return;
        }
        this.videoCapturer.enableCameraThread();
        this.enableOpenCamera = true;
    }

    public void startCapture() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ startCapture");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, "startCapture start -0- ");
                if (RtcConnection.this.videoCapturer == null || RtcConnection.this.enableOpenCamera) {
                    sLogListener.onLog(loglevel, "Failed to startCapture. OpenCamera:" + RtcConnection.this.enableOpenCamera);
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- startCapture");
                    return;
                }
                RtcConnection.this.checkoutenableCamera();
                RtcConnection.this.videoSource.restart();
                RtcConnection.this.enableOpenCamera = true;
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- startCapture");
            }
        });
    }

    public void stopCapture() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ stopCapture");
        this.isStopCapture = true;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!RtcConnection.this.enableOpenCamera || RtcConnection.this.videoCapturer == null) {
                    sLogListener.onLog(loglevel, "Failed to stopCapture. OpenCamera:" + RtcConnection.this.enableOpenCamera);
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- stopCapture");
                    return;
                }
                RtcConnection.this.videoSource.stop();
                RtcConnection.this.enableOpenCamera = false;
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- stopCapture");
            }
        });
    }

    private String preferCandidates(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("\r\n");
        for (int k = 0; k < stringArray.length; ++k) {
            String string2 = stringArray[k];
            stringBuilder.append(string2).append("\r\n");
        }
        return stringBuilder.toString();
    }

    @SuppressLint(value={"NewApi"})
    private void startAecDump() {
        try {
            if (this.aecDumpFilename == null) {
                return;
            }
            String string = this.aecDumpFilename;
            sLogListener.onLog(loglevel, this.name + "::: start aec dump " + string);
            this.aecDumpFileDescriptor = ParcelFileDescriptor.open((File)new File(string), (int)0x3C000000);
            sLogListener.onLog(loglevel, this.name + "::: aec dump fd " + this.aecDumpFileDescriptor.getFd());
            factory.startAecDump(this.aecDumpFileDescriptor.getFd(), -1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void stopAecDump() {
        if (this.aecDumpFileDescriptor != null) {
            sLogListener.onLog(loglevel, this.name + "::: stop aec dump " + this.aecDumpFileDescriptor.toString());
            factory.stopAecDump();
            try {
                this.aecDumpFileDescriptor.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.aecDumpFileDescriptor = null;
        }
    }

    public void takeCameraPicture(RTCCallback rTCCallback) {
        this.videoCapturer.takeCameraPicture(rTCCallback);
    }

    static {
        medialoglevel = Logging.Severity.LS_WARNING;
        disableResize = false;
        configfps = 0;
        configminkbps = 80;
        DEFAULT_CONFIG_MINKBPS = 80;
        useVideoCodecHw = false;
        iscreateConnectionFactory = false;
        cameraid = -1;
        enableLocalViewMirror = true;
        loglevel = 6;
        sLogListener = sLogListenerInternal = new LogListener(){

            @Override
            public void onLog(int n, String string) {
                Log.i((String)RtcConnection.TAG, (String)string);
            }
        };
    }

    private class SDPObserver
    implements SdpObserver {
        private SDPObserver() {
        }

        @Override
        public void onCreateSuccess(SessionDescription sessionDescription) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: sdp: onCreateSuccess");
            String string = sessionDescription.description;
            string = RtcConnection.preferCodec(string, RtcConnection.this.audioCodec, true);
            string = RtcConnection.preferCodec(string, RtcConnection.this.videoCodec, false);
            final SessionDescription sessionDescription2 = new SessionDescription(sessionDescription.type, string);
            RtcConnection.this.localSdp = sessionDescription2;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (RtcConnection.this.ishangup) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip set local because of conn is already hangup!");
                        return;
                    }
                    if (RtcConnection.this.peerConnection != null) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: Set local SDP from " + (Object)((Object)sessionDescription2.type));
                        RtcConnection.this.peerConnection.setLocalDescription(RtcConnection.this.localSDPObserver, sessionDescription2);
                    }
                }
            });
        }

        @Override
        public void onSetSuccess() {
            RtcConnection.this.log("sdp: onSetSuccess");
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (RtcConnection.this.peerConnection == null) {
                        return;
                    }
                    if (RtcConnection.this.isInitiator) {
                        if (RtcConnection.this.peerConnection.getRemoteDescription() == null) {
                            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi] onLocalSdp");
                            if (!RtcConnection.this.ishangup) {
                                RtcConnection.this.listener.onLocalSdp(RtcConnection.this, RtcContent.SDP2Json(RtcConnection.this.localSdp, RtcConnection.this.getLocalSeq(), "connectionId"));
                            }
                        } else {
                            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: Remote SDP set succesfully");
                            RtcConnection.this.drainCandidatesInteranl();
                        }
                    } else if (RtcConnection.this.peerConnection.getLocalDescription() != null) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: Local SDP set succesfully");
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi] onLocalSdp");
                        if (!RtcConnection.this.ishangup) {
                            RtcConnection.this.listener.onLocalSdp(RtcConnection.this, RtcContent.SDP2Json(RtcConnection.this.localSdp, RtcConnection.this.getLocalSeq(), "connectionId"));
                        }
                        RtcConnection.this.drainCandidatesInteranl();
                    } else {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: Remote SDP set succesfully");
                    }
                }
            });
        }

        @Override
        public void onCreateFailure(String string) {
            RtcConnection.this.reportError("sdp: onCreateFailure: " + string);
        }

        @Override
        public void onSetFailure(String string) {
            RtcConnection.this.reportError("sdp: onSetFailure: " + string);
        }
    }

    private class RemoteSDPObserver
    implements SdpObserver {
        private RemoteSDPObserver() {
        }

        @Override
        public void onCreateSuccess(SessionDescription sessionDescription) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: create remote sdp success??");
        }

        @Override
        public void onSetSuccess() {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: set remote sdp success");
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    sLogListener.onLog(loglevel, "set remote sdp success start -0-");
                    if (RtcConnection.this.peerConnection == null) {
                        return;
                    }
                    RtcConnection.this.drainCandidatesInteranl();
                    RtcConnection.this.printRemoteStream("after remote sdp: ");
                }
            });
        }

        @Override
        public void onCreateFailure(String string) {
            RtcConnection.this.reportError("create local sdp failure: " + string);
        }

        @Override
        public void onSetFailure(String string) {
            RtcConnection.this.reportError("set local sdp failure: " + string);
        }
    }

    private class LocalSDPObserver
    implements SdpObserver {
        private LocalSDPObserver() {
        }

        @Override
        public void onCreateSuccess(final SessionDescription sessionDescription) {
            sLogListener.onLog(loglevel, "create local sdp success");
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    sLogListener.onLog(loglevel, "create local sdp success start -0-");
                    if (RtcConnection.this.ishangup) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip set local because of conn is already hangup!");
                        return;
                    }
                    if (RtcConnection.this.peerConnection == null) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip set local because of null conn");
                        return;
                    }
                    String string = sessionDescription.description;
                    string = RtcConnection.preferCodec(string, RtcConnection.this.audioCodec, true);
                    string = RtcConnection.preferCodec(string, RtcConnection.this.videoCodec, false);
                    string = RtcConnection.this.preferCandidates(string);
                    string = RtcConnection.this.ssrcChanger.changeSSRC(string);
                    SessionDescription.Type type = sessionDescription.type;
                    if (RtcConnection.this.isPranswerState && !RtcConnection.this.disablePranswer) {
                        string = string.replaceAll("a=recvonly", "a=inactive");
                        string = RtcConnection.this.ssrcChanger.processPranswer(string);
                        type = SessionDescription.Type.PRANSWER;
                    }
                    SessionDescription sessionDescription2 = new SessionDescription(type, string);
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: Set local SDP " + (Object)((Object)sessionDescription2.type));
                    RtcConnection.this.localSdp = sessionDescription2;
                    RtcConnection.this.peerConnection.setLocalDescription(RtcConnection.this.localSDPObserver, sessionDescription2);
                }
            });
        }

        @Override
        public void onSetSuccess() {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: set local sdp success");
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    sLogListener.onLog(loglevel, "set local sdp success start -0-");
                    if (RtcConnection.this.ishangup) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip onSetSuccess because of conn is already hangup!");
                        return;
                    }
                    if (RtcConnection.this.peerConnection == null) {
                        return;
                    }
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi] onLocalSdp");
                    if (!RtcConnection.this.ishangup) {
                        RtcConnection.this.listener.onLocalSdp(RtcConnection.this, RtcContent.SDP2Json(RtcConnection.this.localSdp, RtcConnection.this.getLocalSeq(), "connectionId"));
                    }
                    RtcConnection.this.drainCandidatesInteranl();
                    RtcConnection.this.printRemoteStream("after local sdp: ");
                }
            });
        }

        @Override
        public void onCreateFailure(String string) {
            RtcConnection.this.reportError("create local sdp failure: " + string);
        }

        @Override
        public void onSetFailure(String string) {
            RtcConnection.this.reportError("set local sdp failure: " + string);
        }
    }

    private class PCObserver
    implements PeerConnection.Observer {
        private PCObserver() {
        }

        @Override
        public void onIceCandidate(final IceCandidate iceCandidate) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ onlocalIceCandidate::" + iceCandidate);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    RtcConnection.this.listener.onLocalCandidate(RtcConnection.this, RtcContent.candidate2Json(iceCandidate, RtcConnection.this.getLocalSeq(), "connectionId"));
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- onlocalIceCandidate");
                }
            });
        }

        @Override
        public void onSignalingChange(PeerConnection.SignalingState signalingState) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onSignalingChange: " + (Object)((Object)signalingState));
        }

        @Override
        public void onIceConnectionChange(final PeerConnection.IceConnectionState iceConnectionState) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + ":::  ++ onIceConnectionChange: " + (Object)((Object)iceConnectionState) + " (signalingState=" + (Object)((Object)RtcConnection.this.peerConnection.signalingState()) + ")");
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    sLogListener.onLog(loglevel, "onIceConnectionChange: start -0- " + (Object)((Object)iceConnectionState));
                    if (iceConnectionState == PeerConnection.IceConnectionState.CONNECTED) {
                        if (!RtcConnection.this.isconnected) {
                            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ onConnectionsetup");
                            if (!RtcConnection.this.ishangup) {
                                RtcConnection.this.listener.onConnectionsetup(RtcConnection.this);
                            }
                            RtcConnection.this.isconnected = true;
                            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ connectType ::" + RtcConnection.this.connectType);
                        } else {
                            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ onConnected");
                            if (!RtcConnection.this.ishangup) {
                                RtcConnection.this.listener.onConnected(RtcConnection.this);
                            }
                        }
                        RtcConnection.this.updateVideoViewInternal();
                        RtcConnection.this.iceConnectionState = PeerConnection.IceConnectionState.CONNECTED;
                    } else if (iceConnectionState == PeerConnection.IceConnectionState.DISCONNECTED) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ onDisconnected");
                        if (!RtcConnection.this.ishangup) {
                            RtcConnection.this.listener.onDisconnected(RtcConnection.this);
                        }
                    } else if (iceConnectionState == PeerConnection.IceConnectionState.FAILED) {
                        RtcConnection.this.reportError("ICE connection failed.");
                    }
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: -- onIceConnectionChange: ");
                }
            });
        }

        @Override
        public void onIceGatheringChange(PeerConnection.IceGatheringState iceGatheringState) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: IceGatheringState: " + (Object)((Object)iceGatheringState));
            if (iceGatheringState == PeerConnection.IceGatheringState.COMPLETE) {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ onCandidateCompleted");
                if (!RtcConnection.this.ishangup) {
                    RtcConnection.this.listener.onCandidateCompleted(RtcConnection.this);
                }
            }
        }

        @Override
        public void onIceConnectionReceivingChange(boolean bl) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: IceConnectionReceiving changed to " + bl);
        }

        @Override
        public void onAddStream(final MediaStream mediaStream) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onAddStream");
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    sLogListener.onLog(loglevel, "onAddStream start -0-");
                    if (RtcConnection.this.ishangup) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip onAddStream because of conn is already hangup!");
                        return;
                    }
                    if (RtcConnection.this.peerConnection == null) {
                        return;
                    }
                    if (mediaStream.audioTracks.size() > 1 || mediaStream.videoTracks.size() > 1) {
                        RtcConnection.this.reportError("Weird-looking stream: " + mediaStream);
                        return;
                    }
                    if (mediaStream.videoTracks.size() == 1) {
                        RtcConnection.this.remoteVideoTrack = mediaStream.videoTracks.get(0);
                        RtcConnection.this.remoteVideoTrack.setEnabled(true);
                        RtcConnection.this.checkAddRenddererInternal();
                        if (RtcConnection.this.remoteVideoTrack != null) {
                            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onAddStream: remoteVideoTrack state " + (Object)((Object)RtcConnection.this.remoteVideoTrack.state()));
                        }
                    }
                    RtcConnection.this.remoteStream = mediaStream;
                }
            });
        }

        @Override
        public void onRemoveStream(final MediaStream mediaStream) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onRemoveStream");
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (RtcConnection.this.peerConnection == null) {
                        return;
                    }
                    RtcConnection.this.remoteVideoTrack = null;
                    mediaStream.videoTracks.get(0).dispose();
                    if (mediaStream == RtcConnection.this.remoteStream) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: remove remote stream");
                        RtcConnection.this.remoteStream = null;
                    } else {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: warning: remove known stream");
                    }
                }
            });
        }

        @Override
        public void onDataChannel(DataChannel dataChannel) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onDataChannel");
            RtcConnection.this.reportError("AppRTC doesn't use data channels, but got: " + dataChannel.label() + " anyway!");
        }

        @Override
        public void onRenegotiationNeeded() {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onRenegotiationNeeded");
        }
    }

    public static class PeerConnectionParameters {
        public boolean videoCallEnabled;
        public boolean loopback;
        public int videoWidth;
        public int videoHeight;
        public int videoFps;
        public int videoStartBitrate;
        public String videoCodec;
        public boolean videoCodecHwAcceleration;
        public int audioStartBitrate;
        public String audioCodec;
        public boolean noAudioProcessing;
        public boolean cpuOveruseDetection;

        public PeerConnectionParameters(boolean bl, boolean bl2, int n, int n2, int n3, int n4, String string, boolean bl3, int n5, String string2, boolean bl4, boolean bl5) {
            this.videoCallEnabled = bl;
            this.loopback = bl2;
            this.videoWidth = n;
            this.videoHeight = n2;
            this.videoFps = n3;
            this.videoStartBitrate = n4;
            this.videoCodec = string;
            this.videoCodecHwAcceleration = bl3;
            this.audioStartBitrate = n5;
            this.audioCodec = string2;
            this.noAudioProcessing = bl4;
            this.cpuOveruseDetection = bl5;
        }

        public String toString() {
            return "[videoCallEnabled=" + this.videoCallEnabled + ", loopback=" + this.loopback + ", videoWidth=" + this.videoWidth + ", videoHeight=" + this.videoHeight + ", videoFps=" + this.videoFps + ", videoStartBitrate=" + this.videoStartBitrate + ", videoCodec=" + this.videoCodec + ", videoCodecHwAcceleration=" + this.videoCodecHwAcceleration + ", audioStartBitrate=" + this.audioStartBitrate + ", audioCodec=" + this.audioCodec + ", noAudioProcessing=" + this.noAudioProcessing + ", cpuOveruseDetection=" + this.cpuOveruseDetection + "]";
        }
    }

    public static class Parameters
    extends PeerConnectionParameters {
        public boolean renderLocal = true;
        public int cameraIndex = -1;
        public boolean receiveVideo = true;
        public boolean receiveAudio = true;
        public boolean captureVideo = true;
        public boolean captureAudio = true;

        public Parameters(boolean bl, boolean bl2, int n, int n2, int n3, int n4, String string, boolean bl3, int n5, String string2, boolean bl4, boolean bl5) {
            super(bl, bl2, n, n2, n3, n4, string, bl3, n5, string2, bl4, bl5);
        }

        public void enableVideo(boolean bl, boolean bl2) {
            this.captureVideo = bl;
            this.receiveVideo = bl2;
        }

        public void enableAudio(boolean bl, boolean bl2) {
            this.captureAudio = bl;
            this.receiveAudio = bl2;
        }
    }

    public class RtcStatistics {
        public String connectionType = "disconnect";
        public int localCaptureWidth = 0;
        public int localCaptureHeight = 0;
        public int localCaptureFps = 0;
        public int localEncodedWidth = 0;
        public int localEncodedHeight = 0;
        public int localEncodedFps = 0;
        public int localVideoActualBps = 0;
        public int localVideoTargetBps = 0;
        public int localVideoPacketsLost = 0;
        public int localVideoPacketsLostrate = 0;
        public int localVideoRtt = 0;
        public int localAudioPacketsLost = 0;
        public int localAudioPacketsLostrate = 0;
        public int localAudioBps = 0;
        public int localAudioRtt = 0;
        public int remoteWidth = 0;
        public int remoteHeight = 0;
        public int remoteFps = 0;
        public int remoteVideoPacketsLost = 0;
        public int remoteVideoPacketsLostrate = 0;
        public int remoteVideoBps = 0;
        public int remoteAudioPacketsLost = 0;
        public int remoteAudioPacketsLostrate = 0;
        public int remoteAudioBps = 0;
        public String fullStatsString = "fullStats";
    }

    public static class RenderRect {
        int x;
        int y;
        int width;
        int height;

        public RenderRect(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }
    }

    public static interface Listener {
        public void onLocalSdp(RtcConnection var1, String var2);

        public void onLocalCandidate(RtcConnection var1, String var2);

        public void onConnected(RtcConnection var1);

        public void onConnectionsetup(RtcConnection var1);

        public void onDisconnected(RtcConnection var1);

        public void onCandidateCompleted(RtcConnection var1);

        public void onClosed(RtcConnection var1);

        public void onStats(RtcConnection var1, RtcStatistics var2);

        public void onError(RtcConnection var1, String var2);
    }

    private static class RtcContent {
        private static final String TYPE_OFFER = SessionDescription.Type.OFFER.name();
        private static final String TYPE_ANSWER = SessionDescription.Type.ANSWER.name();
        private static final String TYPE_PRANSWER = SessionDescription.Type.PRANSWER.name();
        private static final String TYPE_CANDIDATE = "candidate";
        String type;
        int mlineindex;
        String candidate;
        String sdp;
        long seq;

        private RtcContent() {
        }

        public boolean isSdp() {
            if (this.type == null) {
                return false;
            }
            return this.type.equalsIgnoreCase(TYPE_OFFER) || this.type.equalsIgnoreCase(TYPE_ANSWER) || this.type.equalsIgnoreCase(TYPE_PRANSWER);
        }

        public static RtcContent fromJson(String string) throws JSONException {
            RtcContent rtcContent = new RtcContent();
            JSONTokener jSONTokener = new JSONTokener(string);
            JSONObject jSONObject = (JSONObject)jSONTokener.nextValue();
            rtcContent.type = jSONObject.optString("type");
            rtcContent.mlineindex = jSONObject.optInt("mlineindex", -1);
            rtcContent.candidate = jSONObject.optString(TYPE_CANDIDATE, null);
            rtcContent.sdp = jSONObject.optString("sdp", null);
            rtcContent.seq = jSONObject.optLong("seq", -1L);
            return rtcContent;
        }

        protected static String candidate2Json(IceCandidate iceCandidate, long l, String string) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("type", (Object)TYPE_CANDIDATE);
                jSONObject.put("mlineindex", iceCandidate.sdpMLineIndex);
                jSONObject.put("mid", (Object)iceCandidate.sdpMid);
                jSONObject.put(TYPE_CANDIDATE, (Object)iceCandidate.sdp);
                jSONObject.put("connId", (Object)string);
                jSONObject.put("seq", l);
                String string2 = jSONObject.toString();
                return string2;
            }
            catch (JSONException jSONException) {
                ALog.i(RtcConnection.TAG, "Exception: " + jSONException.getMessage());
                jSONException.printStackTrace();
                return null;
            }
        }

        protected static String SDP2Json(SessionDescription sessionDescription, long l, String string) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("type", (Object)sessionDescription.type.toString().toLowerCase());
                jSONObject.put("sdp", (Object)sessionDescription.description);
                jSONObject.put("seq", l);
                jSONObject.put("connId", (Object)string);
                String string2 = jSONObject.toString();
                return string2;
            }
            catch (JSONException jSONException) {
                ALog.i(RtcConnection.TAG, "Exception: " + jSONException.getMessage());
                jSONException.printStackTrace();
                return null;
            }
        }
    }

    public static enum AspectMode {
        AspectFit,
        AspectFill;

    }

    public static interface RtcGlTextureProcessor {
        public void onDrawFrame(int var1, int var2, int var3, float[] var4, int var5);
    }

    public static interface RtcCameraDataProcessor {
        public void onProcessData(byte[] var1, Camera var2, int var3, int var4, int var5);

        public void setResolution(int var1, int var2);
    }

    public static interface LogListener {
        public void onLog(int var1, String var2);
    }

    public static enum LoggingSeverity {
        LS_SENSITIVE,
        LS_VERBOSE,
        LS_INFO,
        LS_WARNING,
        LS_ERROR,
        LS_NONE;

    }

    public static enum Medialogmod {
        M_SENSITIVE,
        M_VERBOSE,
        M_INFO,
        M_WARNING,
        M_ERROR;

    }
}

