/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMContact;
import com.hyphenate.util.CryptoUtils;

class EMSessionManager {
    private static final String TAG = "Session";
    private Context appContext = null;
    private static final String PREF_KEY_LOGIN_USER = "easemob.chat.loginuser";
    private static final String PREF_KEY_LOGIN_PWD = "easemob.chat.loginpwd";
    private static final String PREF_KEY_LOGIN_TOKEN = "easemob.chat.login.token";
    private static final String PREF_KEY_LOGIN_WITH_TOKEN = "easemob.chat.login_with_token";
    public EMContact currentUser = null;
    private static EMSessionManager instance = new EMSessionManager();
    private String lastLoginUser = null;
    private String lastLoginPwd = null;
    private String lastLoginToken = null;

    EMSessionManager() {
    }

    static synchronized EMSessionManager getInstance() {
        if (EMSessionManager.instance.appContext == null) {
            EMSessionManager.instance.appContext = EMClient.getInstance().getContext();
        }
        return instance;
    }

    String getLastLoginUser() {
        if (this.lastLoginUser == null) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            this.lastLoginUser = sharedPreferences.getString(PREF_KEY_LOGIN_USER, "");
            this.currentUser = new EMContact(this.lastLoginUser);
        }
        return this.lastLoginUser;
    }

    void setLastLoginUser(String string) {
        if (string == null) {
            return;
        }
        this.currentUser = new EMContact(string);
        this.lastLoginUser = string;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(PREF_KEY_LOGIN_USER, string);
        editor.apply();
    }

    String getLastLoginPwd() {
        if (this.lastLoginPwd == null) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            String string = sharedPreferences.getString(PREF_KEY_LOGIN_PWD, "");
            if (string.equals("")) {
                this.lastLoginPwd = "";
                return this.lastLoginPwd;
            }
            try {
                CryptoUtils cryptoUtils = EMClient.getInstance().getCryptoUtils();
                this.lastLoginPwd = cryptoUtils.decryptBase64String(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.lastLoginPwd;
    }

    void setLastLoginPwd(String string) {
        if (string == null) {
            return;
        }
        this.lastLoginPwd = string;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        try {
            CryptoUtils cryptoUtils = EMClient.getInstance().getCryptoUtils();
            String string2 = cryptoUtils.encryptBase64String(string);
            editor.putString(PREF_KEY_LOGIN_PWD, string2);
            editor.apply();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    String getLastLoginToken() {
        if (this.lastLoginToken == null) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            String string = sharedPreferences.getString(PREF_KEY_LOGIN_TOKEN, "");
            if (string.equals("")) {
                this.lastLoginToken = "";
                return this.lastLoginToken;
            }
            try {
                CryptoUtils cryptoUtils = EMClient.getInstance().getCryptoUtils();
                this.lastLoginToken = cryptoUtils.decryptBase64String(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.lastLoginToken;
    }

    void setLastLoginToken(String string) {
        if (string == null) {
            return;
        }
        this.lastLoginToken = string;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        try {
            CryptoUtils cryptoUtils = EMClient.getInstance().getCryptoUtils();
            String string2 = cryptoUtils.encryptBase64String(string);
            editor.putString(PREF_KEY_LOGIN_TOKEN, string2);
            editor.apply();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void clearLastLoginUser() {
        try {
            this.lastLoginUser = "";
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(PREF_KEY_LOGIN_USER, this.lastLoginUser);
            editor.apply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void clearLastLoginPwd() {
        try {
            this.lastLoginPwd = "";
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(PREF_KEY_LOGIN_PWD, this.lastLoginPwd);
            editor.apply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void clearLastLoginToken() {
        try {
            this.lastLoginToken = "";
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(PREF_KEY_LOGIN_TOKEN, this.lastLoginToken);
            editor.apply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean isLastLoginWithToken() {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        return sharedPreferences.getBoolean(PREF_KEY_LOGIN_WITH_TOKEN, false);
    }

    void setLastLoginWithToken(boolean bl) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(PREF_KEY_LOGIN_WITH_TOKEN, bl);
        editor.apply();
    }

    public String getLoginUserName() {
        return this.currentUser.username;
    }
}

