/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.voiceengine;

import android.media.AudioRecord;
import android.os.Build;
import android.os.Process;
import com.superrtc.Logging;
import com.superrtc.ThreadUtils;
import com.superrtc.voiceengine.WebRtcAudioEffects;
import com.superrtc.voiceengine.WebRtcAudioUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;

public class WebRtcAudioRecord {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioRecord";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int DEFAULT_AUDIO_SOURCE;
    private static int audioSource;
    private final long nativeAudioRecord;
    @Nullable
    private WebRtcAudioEffects effects;
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioRecord audioRecord;
    @Nullable
    private AudioRecordThread audioThread;
    private static volatile boolean microphoneMute;
    private byte[] emptyBytes;
    @Nullable
    private static WebRtcAudioRecordErrorCallback errorCallback;
    @Nullable
    private static WebRtcAudioRecordSamplesReadyCallback audioSamplesReadyCallback;

    public static void setErrorCallback(WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = webRtcAudioRecordErrorCallback;
    }

    public static void setOnAudioSamplesReady(WebRtcAudioRecordSamplesReadyCallback webRtcAudioRecordSamplesReadyCallback) {
        audioSamplesReadyCallback = webRtcAudioRecordSamplesReadyCallback;
    }

    WebRtcAudioRecord(long l) {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.nativeAudioRecord = l;
        this.effects = WebRtcAudioEffects.create();
    }

    private boolean enableBuiltInAEC(boolean bl) {
        Logging.d(TAG, "enableBuiltInAEC(" + bl + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in AEC is not supported on this platform");
            return false;
        }
        return this.effects.setAEC(bl);
    }

    private boolean enableBuiltInNS(boolean bl) {
        Logging.d(TAG, "enableBuiltInNS(" + bl + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in NS is not supported on this platform");
            return false;
        }
        return this.effects.setNS(bl);
    }

    private int initRecording(int n, int n2) {
        Logging.e(TAG, "initRecording(sampleRate=" + n + ", channels=" + n2 + ")");
        if (this.audioRecord != null) {
            this.reportWebRtcAudioRecordInitError("InitRecording called twice without StopRecording.");
            return -1;
        }
        int n3 = n2 * 2;
        int n4 = n / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(n3 * n4);
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioRecord);
        int n5 = this.channelCountToConfiguration(n2);
        int n6 = AudioRecord.getMinBufferSize((int)n, (int)n5, (int)2);
        if (n6 == -1 || n6 == -2) {
            this.reportWebRtcAudioRecordInitError("AudioRecord.getMinBufferSize failed: " + n6);
            return -1;
        }
        Logging.d(TAG, "AudioRecord.getMinBufferSize: " + n6);
        int n7 = Math.max(2 * n6, this.byteBuffer.capacity());
        Logging.d(TAG, "bufferSizeInBytes: " + n7);
        try {
            this.audioRecord = new AudioRecord(audioSource, n, n5, 2, n7);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.reportWebRtcAudioRecordInitError("AudioRecord ctor error: " + illegalArgumentException.getMessage());
            this.releaseAudioResources();
            return -1;
        }
        if (this.audioRecord == null || this.audioRecord.getState() != 1) {
            this.reportWebRtcAudioRecordInitError("Failed to create a new AudioRecord instance");
            this.releaseAudioResources();
            return -1;
        }
        if (this.effects != null) {
            this.effects.enable(this.audioRecord.getAudioSessionId());
        }
        this.logMainParameters();
        this.logMainParametersExtended();
        return n4;
    }

    private boolean startRecording() {
        Logging.d(TAG, "startRecording");
        WebRtcAudioRecord.assertTrue(this.audioRecord != null);
        WebRtcAudioRecord.assertTrue(this.audioThread == null);
        try {
            this.audioRecord.startRecording();
        }
        catch (IllegalStateException illegalStateException) {
            this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, "AudioRecord.startRecording failed: " + illegalStateException.getMessage());
            return false;
        }
        if (this.audioRecord.getRecordingState() != 3) {
            this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, "AudioRecord.startRecording failed - incorrect state :" + this.audioRecord.getRecordingState());
            return false;
        }
        this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        WebRtcAudioRecord.assertTrue(this.audioThread != null);
        this.audioThread.stopThread();
        if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioRecordJavaThread timed out");
            WebRtcAudioUtils.logAudioState(TAG);
        }
        this.audioThread = null;
        if (this.effects != null) {
            this.effects.release();
        }
        this.releaseAudioResources();
        return true;
    }

    private void logMainParameters() {
        Logging.d(TAG, "AudioRecord: session ID: " + this.audioRecord.getAudioSessionId() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate());
    }

    private void logMainParametersExtended() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, "AudioRecord: buffer size in frames: " + this.audioRecord.getBufferSizeInFrames());
        }
    }

    private static void assertTrue(boolean bl) {
        if (!bl) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private int channelCountToConfiguration(int n) {
        return n == 1 ? 16 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2);

    public static synchronized void setAudioSource(int n) {
        Logging.w(TAG, "Audio source is changed from: " + audioSource + " to " + n);
        audioSource = n;
    }

    private static int getDefaultAudioSource() {
        return 7;
    }

    public static void setMicrophoneMute(boolean bl) {
        Logging.w(TAG, "setMicrophoneMute(" + bl + ")");
        microphoneMute = bl;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        if (this.audioRecord != null) {
            this.audioRecord.release();
            this.audioRecord = null;
        }
    }

    private void reportWebRtcAudioRecordInitError(String string) {
        Logging.e(TAG, "Init recording error: " + string);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallback != null) {
            errorCallback.onWebRtcAudioRecordInitError(string);
        }
    }

    private void reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode audioRecordStartErrorCode, String string) {
        Logging.e(TAG, "Start recording error: " + (Object)((Object)audioRecordStartErrorCode) + ". " + string);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallback != null) {
            errorCallback.onWebRtcAudioRecordStartError(audioRecordStartErrorCode, string);
        }
    }

    private void reportWebRtcAudioRecordError(String string) {
        Logging.e(TAG, "Run-time recording error: " + string);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallback != null) {
            errorCallback.onWebRtcAudioRecordError(string);
        }
    }

    static {
        audioSource = DEFAULT_AUDIO_SOURCE = WebRtcAudioRecord.getDefaultAudioSource();
    }

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String string) {
            super(string);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioRecord.TAG, "AudioRecordThread" + WebRtcAudioUtils.getThreadInfo());
            WebRtcAudioRecord.assertTrue(WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3);
            long l = System.nanoTime();
            while (this.keepAlive) {
                Object object;
                int n = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                if (n == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                    if (microphoneMute) {
                        WebRtcAudioRecord.this.byteBuffer.clear();
                        WebRtcAudioRecord.this.byteBuffer.put(WebRtcAudioRecord.this.emptyBytes);
                    }
                    if (this.keepAlive) {
                        WebRtcAudioRecord.this.nativeDataIsRecorded(n, WebRtcAudioRecord.this.nativeAudioRecord);
                    }
                    if (audioSamplesReadyCallback == null) continue;
                    object = Arrays.copyOf(WebRtcAudioRecord.this.byteBuffer.array(), WebRtcAudioRecord.this.byteBuffer.capacity());
                    audioSamplesReadyCallback.onWebRtcAudioRecordSamplesReady(new AudioSamples(WebRtcAudioRecord.this.audioRecord, (byte[])object));
                    continue;
                }
                object = "AudioRecord.read failed: " + n;
                Logging.e(WebRtcAudioRecord.TAG, (String)object);
                if (n != -3) continue;
                this.keepAlive = false;
                WebRtcAudioRecord.this.reportWebRtcAudioRecordError((String)object);
            }
            try {
                if (WebRtcAudioRecord.this.audioRecord != null) {
                    WebRtcAudioRecord.this.audioRecord.stop();
                }
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(WebRtcAudioRecord.TAG, "AudioRecord.stop failed: " + illegalStateException.getMessage());
            }
        }

        public void stopThread() {
            Logging.d(WebRtcAudioRecord.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface WebRtcAudioRecordSamplesReadyCallback {
        public void onWebRtcAudioRecordSamplesReady(AudioSamples var1);
    }

    public static class AudioSamples {
        private final int audioFormat;
        private final int channelCount;
        private final int sampleRate;
        private final byte[] data;

        private AudioSamples(AudioRecord audioRecord, byte[] byArray) {
            this.audioFormat = audioRecord.getAudioFormat();
            this.channelCount = audioRecord.getChannelCount();
            this.sampleRate = audioRecord.getSampleRate();
            this.data = byArray;
        }

        public int getAudioFormat() {
            return this.audioFormat;
        }

        public int getChannelCount() {
            return this.channelCount;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static interface WebRtcAudioRecordErrorCallback {
        public void onWebRtcAudioRecordInitError(String var1);

        public void onWebRtcAudioRecordStartError(AudioRecordStartErrorCode var1, String var2);

        public void onWebRtcAudioRecordError(String var1);
    }

    public static enum AudioRecordStartErrorCode {
        AUDIO_RECORD_START_EXCEPTION,
        AUDIO_RECORD_START_STATE_MISMATCH;

    }
}

